/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.math.mathml;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import nu.xom.Node;
import nu.xom.ParentNode;
import org.brailleblaster.math.mathml.MathSubject;
import org.brailleblaster.math.mathml.MathVerb;
import org.brailleblaster.util.Utils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001d"}, d2={"Lorg/brailleblaster/math/mathml/MathAction;", "", "subject", "Lorg/brailleblaster/math/mathml/MathSubject;", "verbName", "Lorg/brailleblaster/math/mathml/MathVerb$Verb;", "<init>", "(Lorg/brailleblaster/math/mathml/MathSubject;Lorg/brailleblaster/math/mathml/MathVerb$Verb;)V", "getSubject", "()Lorg/brailleblaster/math/mathml/MathSubject;", "setSubject", "(Lorg/brailleblaster/math/mathml/MathSubject;)V", "getVerbName", "()Lorg/brailleblaster/math/mathml/MathVerb$Verb;", "setVerbName", "(Lorg/brailleblaster/math/mathml/MathVerb$Verb;)V", "verb", "Lorg/brailleblaster/math/mathml/MathVerb;", "getVerb", "()Lorg/brailleblaster/math/mathml/MathVerb;", "setVerb", "(Lorg/brailleblaster/math/mathml/MathVerb;)V", "execute", "", "parent", "Lnu/xom/Node;", "index", "", "Companion", "brailleblaster-core"})
public final class MathAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private MathSubject subject;
    @NotNull
    private MathVerb.Verb verbName;
    @NotNull
    private MathVerb verb;

    public MathAction(@NotNull MathSubject subject, @NotNull MathVerb.Verb verbName) {
        Intrinsics.checkNotNullParameter((Object)subject, (String)"subject");
        Intrinsics.checkNotNullParameter((Object)((Object)verbName), (String)"verbName");
        this.subject = subject;
        this.verbName = verbName;
        this.verb = this.verbName == MathVerb.Verb.MakeMath ? MathVerb.Companion.getMakeMath() : MathVerb.Companion.getWrapInText();
    }

    @NotNull
    public final MathSubject getSubject() {
        return this.subject;
    }

    public final void setSubject(@NotNull MathSubject mathSubject) {
        Intrinsics.checkNotNullParameter((Object)mathSubject, (String)"<set-?>");
        this.subject = mathSubject;
    }

    @NotNull
    public final MathVerb.Verb getVerbName() {
        return this.verbName;
    }

    public final void setVerbName(@NotNull MathVerb.Verb verb) {
        Intrinsics.checkNotNullParameter((Object)((Object)verb), (String)"<set-?>");
        this.verbName = verb;
    }

    @NotNull
    public final MathVerb getVerb() {
        return this.verb;
    }

    public final void setVerb(@NotNull MathVerb mathVerb) {
        Intrinsics.checkNotNullParameter((Object)mathVerb, (String)"<set-?>");
        this.verb = mathVerb;
    }

    public final void execute(@Nullable Node parent, int index) {
        Node n = this.verb.transform(this.subject);
        if (parent != null) {
            Utils.insertChildCountSafe((ParentNode)parent, n, index);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010H\u0002\u00a8\u0006\u0013"}, d2={"Lorg/brailleblaster/math/mathml/MathAction$Companion;", "", "<init>", "()V", "execute", "", "actionList", "", "Lorg/brailleblaster/math/mathml/MathAction;", "parent", "Lnu/xom/Node;", "index", "", "combineAdjacent", "array", "combineSubject", "Lorg/brailleblaster/math/mathml/MathSubject;", "s1", "s2", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        public final void execute(@NotNull List<MathAction> actionList, @Nullable Node parent, int index) {
            Intrinsics.checkNotNullParameter(actionList, (String)"actionList");
            int i = index;
            if (actionList.isEmpty()) {
                return;
            }
            for (MathAction a : this.combineAdjacent(actionList)) {
                Node n = a.getVerb().transform(a.getSubject());
                if (parent == null) continue;
                Utils.insertChildCountSafe((ParentNode)parent, n, i++);
            }
        }

        private final List<MathAction> combineAdjacent(List<MathAction> array) {
            if (array.size() <= 1) {
                return array;
            }
            List newArray = new ArrayList();
            MathAction current = array.get(0);
            MathAction next = array.get(1);
            while (current != null) {
                if (next != null && MathVerb.Companion.sameAction(current, next)) {
                    current.setSubject(this.combineSubject(current.getSubject(), next.getSubject()));
                    array.remove(next);
                    next = array.size() > 1 ? array.get(1) : null;
                    continue;
                }
                newArray.add(current);
                array.remove(current);
                current = next;
                next = array.size() > 1 ? array.get(1) : null;
            }
            return newArray;
        }

        private final MathSubject combineSubject(MathSubject s1, MathSubject s2) {
            String s = s1.getString() + s2.getString();
            return new MathSubject(s);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

