/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.math.mathml;

import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import nu.xom.Text;
import org.brailleblaster.bbx.BBXUtils;
import org.brailleblaster.bbx.BBXUtilsKt;
import org.brailleblaster.math.mathml.MathModuleUtils;
import org.brailleblaster.math.mathml.MathSubject;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.perspectives.braille.mapping.elements.TextMapElement;
import org.brailleblaster.perspectives.braille.messages.Sender;
import org.brailleblaster.perspectives.braille.views.wp.MathEditHandler;
import org.brailleblaster.perspectives.mvc.XMLNodeCaret;
import org.brailleblaster.perspectives.mvc.XMLSelection;
import org.brailleblaster.perspectives.mvc.XMLTextCaret;
import org.brailleblaster.perspectives.mvc.events.ModifyEvent;
import org.brailleblaster.perspectives.mvc.modules.views.DebugModule;
import org.brailleblaster.utd.internal.xml.XMLHandler;
import org.brailleblaster.utd.properties.UTDElements;
import org.brailleblaster.util.Notify;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J(\u0010\n\u001a\u00020\u00072\u0016\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r0\fj\b\u0012\u0004\u0012\u00020\r`\u000e2\u0006\u0010\u000f\u001a\u00020\rH\u0002J(\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J(\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/brailleblaster/math/mathml/NumericSeries;", "", "<init>", "()V", "BRAILLE_DOT_5", "", "toggleNumeric", "", "m", "Lorg/brailleblaster/perspectives/braille/Manager;", "addNotAlreadyThere", "array", "Ljava/util/ArrayList;", "Lnu/xom/Node;", "Lkotlin/collections/ArrayList;", "n", "toggleMath", "start", "", "end", "on", "", "toggleText", "brailleblaster-core"})
public final class NumericSeries {
    @NotNull
    public static final NumericSeries INSTANCE = new NumericSeries();
    @NotNull
    public static final String BRAILLE_DOT_5 = "\u2810";

    private NumericSeries() {
    }

    @JvmStatic
    public static final void toggleNumeric(@NotNull Manager m) {
        int nodeLength;
        Node n;
        int i;
        TextMapElement mapElement;
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        String selectedText = m.getTextView().getSelectionText();
        Intrinsics.checkNotNull((Object)selectedText);
        if (((CharSequence)selectedText).length() == 0) {
            return;
        }
        XMLSelection selection = m.getSimpleManager().getCurrentSelection();
        Node start = selection.start.getNode();
        Node end = selection.end.getNode();
        boolean startIsUneditable = BBXUtils.INSTANCE.isUneditable(start);
        boolean endIsUneditable = BBXUtils.INSTANCE.isUneditable(end);
        if (startIsUneditable || endIsUneditable) {
            Notify.notify$default(Notify.INSTANCE, Notify.GENERIC_UNEDITABLE, Notify.ALERT_SHELL_NAME, false, 4, null);
            return;
        }
        boolean toggleOn = !StringsKt.contains$default((CharSequence)selectedText, (CharSequence)BRAILLE_DOT_5, (boolean)false, (int)2, null);
        ArrayList<Node> textArray = new ArrayList<Node>();
        ArrayList<Node> mathArray = new ArrayList<Node>();
        ParentNode parentNode = BBXUtilsKt.findBlock(start).getParent();
        Intrinsics.checkNotNullExpressionValue((Object)parentNode, (String)"getParent(...)");
        Node startParent = (Node)parentNode;
        ParentNode parentNode2 = BBXUtilsKt.findBlock(end).getParent();
        Intrinsics.checkNotNullExpressionValue((Object)parentNode2, (String)"getParent(...)");
        Node endParent = (Node)parentNode2;
        boolean startIsText = start instanceof Text;
        boolean endIsText = end instanceof Text;
        boolean startIsMath = MathModuleUtils.isMath(start);
        boolean endIsMath = MathModuleUtils.isMath(end);
        int mathStartIndex = 0;
        int mathEndIndex = 0;
        if (startIsText) {
            textArray.add(start);
        } else if (startIsMath) {
            mapElement = m.getMapList().getClosest(m.getTextView().getSelection().x, true);
            if (Intrinsics.areEqual((Object)mapElement.getNode(), (Object)start)) {
                mathStartIndex = m.getTextView().getSelection().x - mapElement.getStart(m.getMapList());
            }
            mathArray.add(start);
        }
        if (endIsText) {
            INSTANCE.addNotAlreadyThere(textArray, end);
        } else if (endIsMath) {
            mapElement = m.getMapList().getClosest(m.getTextView().getSelection().y, true);
            if (Intrinsics.areEqual((Object)mapElement.getNode(), (Object)end)) {
                mathEndIndex = m.getTextView().getSelection().y - mapElement.getStart(m.getMapList());
            }
            INSTANCE.addNotAlreadyThere(mathArray, end);
        }
        Node current = start;
        while (current != end) {
            if (MathModuleUtils.isMath(current)) {
                INSTANCE.addNotAlreadyThere(mathArray, MathModuleUtils.INSTANCE.getMathParent(current));
            } else {
                INSTANCE.addNotAlreadyThere(textArray, current);
            }
            Intrinsics.checkNotNull((Object)XMLHandler.Companion.followingVisitor(current, NumericSeries::toggleNumeric$lambda$0));
        }
        int n2 = ((Collection)textArray).size();
        for (i = 0; i < n2; ++i) {
            int currentEndIndex;
            int currentStartIndex;
            Intrinsics.checkNotNullExpressionValue((Object)textArray.get(i), (String)"get(...)");
            nodeLength = n.getValue().length();
            if (startIsText) {
                XMLNodeCaret xMLNodeCaret = selection.start;
                Intrinsics.checkNotNull((Object)xMLNodeCaret, (String)"null cannot be cast to non-null type org.brailleblaster.perspectives.mvc.XMLTextCaret");
                v3 = ((XMLTextCaret)xMLNodeCaret).getOffset();
            } else {
                v3 = currentStartIndex = 0;
            }
            if (endIsText) {
                XMLNodeCaret xMLNodeCaret = selection.end;
                Intrinsics.checkNotNull((Object)xMLNodeCaret, (String)"null cannot be cast to non-null type org.brailleblaster.perspectives.mvc.XMLTextCaret");
                v5 = ((XMLTextCaret)xMLNodeCaret).getOffset();
            } else {
                v5 = currentEndIndex = nodeLength;
            }
            if (Intrinsics.areEqual((Object)n, (Object)start)) {
                if (textArray.size() == 1) {
                    INSTANCE.toggleText(currentStartIndex, currentEndIndex, n, toggleOn);
                    continue;
                }
                INSTANCE.toggleText(currentStartIndex, nodeLength, n, toggleOn);
                continue;
            }
            if (Intrinsics.areEqual((Object)n, (Object)end)) {
                INSTANCE.toggleText(0, currentEndIndex, n, toggleOn);
                continue;
            }
            INSTANCE.toggleText(0, nodeLength, n, toggleOn);
        }
        n2 = ((Collection)mathArray).size();
        for (i = 0; i < n2; ++i) {
            Intrinsics.checkNotNullExpressionValue((Object)mathArray.get(i), (String)"get(...)");
            nodeLength = MathModuleUtils.getMathText(n).length();
            if (Intrinsics.areEqual((Object)n, (Object)start)) {
                if (mathArray.size() == 1) {
                    INSTANCE.toggleMath(mathStartIndex, mathEndIndex, n, toggleOn);
                    continue;
                }
                INSTANCE.toggleMath(mathStartIndex, nodeLength, n, toggleOn);
                continue;
            }
            if (Intrinsics.areEqual((Object)n, (Object)end)) {
                INSTANCE.toggleMath(0, mathEndIndex, n, toggleOn);
                continue;
            }
            INSTANCE.toggleMath(0, nodeLength, n, toggleOn);
        }
        Node[] nodeArray = new Node[]{startParent, endParent};
        m.getSimpleManager().dispatchEvent(new ModifyEvent(Sender.MATH, true, nodeArray));
    }

    private final void addNotAlreadyThere(ArrayList<Node> array, Node n) {
        if (!array.contains(n)) {
            array.add(n);
        }
    }

    private final void toggleMath(int start, int end, Node n, boolean on) {
        if (DebugModule.enabled) {
            String string;
            String asciiMath = MathModuleUtils.getMathText(n);
            String b = StringsKt.take((String)asciiMath, (int)start);
            String string2 = asciiMath.substring(start, end);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String s = string2;
            String a = StringsKt.drop((String)asciiMath, (int)end);
            if (on) {
                var9_9 = s;
                var10_10 = new Regex(" ");
                var11_11 = BRAILLE_DOT_5;
                string = var10_10.replace(var9_9, var11_11);
            } else {
                var9_9 = s;
                var10_10 = new Regex(BRAILLE_DOT_5);
                var11_11 = " ";
                string = var10_10.replace(var9_9, var11_11);
            }
            s = string;
            String newValue = b + s + a;
            MathEditHandler.INSTANCE.translateAndReplace(new MathSubject(newValue), n);
        }
    }

    private final void toggleText(int start, int end, Node n, boolean on) {
        String string;
        Intrinsics.checkNotNull((Object)n, (String)"null cannot be cast to non-null type nu.xom.Text");
        String string2 = ((Text)n).getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getValue(...)");
        String string3 = string2;
        int n2 = 0;
        String string4 = string3.substring(n2, start);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
        String b = string4;
        String string5 = ((Text)n).getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getValue(...)");
        String string6 = string5.substring(start, end);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
        String s = string6;
        String string7 = ((Text)n).getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getValue(...)");
        String string8 = string7.substring(end);
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"substring(...)");
        String a = string8;
        if (on) {
            var8_9 = s;
            var9_10 = new Regex(" ");
            var10_11 = BRAILLE_DOT_5;
            string = var9_10.replace(var8_9, var10_11);
        } else {
            var8_9 = s;
            var9_10 = new Regex(BRAILLE_DOT_5);
            var10_11 = " ";
            string = var9_10.replace(var8_9, var10_11);
        }
        s = string;
        ((Text)n).setValue(b + s + a);
    }

    private static final boolean toggleNumeric$lambda$0$0(Element n2) {
        return n2 != null && UTDElements.BRL.isA((Node)n2);
    }

    private static final boolean toggleNumeric$lambda$0(Node n) {
        Intrinsics.checkNotNullParameter((Object)n, (String)"n");
        return n instanceof Text && XMLHandler.Companion.ancestorElementNot(n, NumericSeries::toggleNumeric$lambda$0$0);
    }
}

