/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.math.numberLine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.apache.commons.lang3.math.Fraction;
import org.brailleblaster.math.numberLine.NumberLine;
import org.brailleblaster.math.numberLine.NumberLineComponent;
import org.brailleblaster.math.numberLine.NumberLineMathUtils;
import org.brailleblaster.math.spatial.MathFormattingException;
import org.brailleblaster.math.spatial.SpatialMathEnum;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0012\u0018\u0000 \u00182\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0018B%\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0000H\u0096\u0082\u0004R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0019"}, d2={"Lorg/brailleblaster/math/numberLine/NumberLineSegmentPoint;", "", "circle", "Lorg/brailleblaster/math/spatial/SpatialMathEnum$Fill;", "point", "Lorg/brailleblaster/math/numberLine/NumberLineComponent;", "interval", "", "<init>", "(Lorg/brailleblaster/math/spatial/SpatialMathEnum$Fill;Lorg/brailleblaster/math/numberLine/NumberLineComponent;I)V", "getCircle", "()Lorg/brailleblaster/math/spatial/SpatialMathEnum$Fill;", "setCircle", "(Lorg/brailleblaster/math/spatial/SpatialMathEnum$Fill;)V", "getPoint", "()Lorg/brailleblaster/math/numberLine/NumberLineComponent;", "setPoint", "(Lorg/brailleblaster/math/numberLine/NumberLineComponent;)V", "getInterval", "()I", "setInterval", "(I)V", "compareTo", "other", "Companion", "brailleblaster-core"})
public final class NumberLineSegmentPoint
implements Comparable<NumberLineSegmentPoint> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private SpatialMathEnum.Fill circle;
    @NotNull
    private NumberLineComponent point;
    private int interval;
    private static final Logger log = LoggerFactory.getLogger(NumberLineSegmentPoint.class);

    public NumberLineSegmentPoint(@NotNull SpatialMathEnum.Fill circle, @NotNull NumberLineComponent point, int interval) {
        Intrinsics.checkNotNullParameter((Object)((Object)circle), (String)"circle");
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        this.circle = circle;
        this.point = point;
        this.interval = interval;
    }

    public /* synthetic */ NumberLineSegmentPoint(SpatialMathEnum.Fill fill, NumberLineComponent numberLineComponent, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            fill = SpatialMathEnum.Fill.FULL;
        }
        if ((n2 & 2) != 0) {
            numberLineComponent = new NumberLineComponent(null, null, null, null, 15, null);
        }
        if ((n2 & 4) != 0) {
            n = 1;
        }
        this(fill, numberLineComponent, n);
    }

    @NotNull
    public final SpatialMathEnum.Fill getCircle() {
        return this.circle;
    }

    public final void setCircle(@NotNull SpatialMathEnum.Fill fill) {
        Intrinsics.checkNotNullParameter((Object)((Object)fill), (String)"<set-?>");
        this.circle = fill;
    }

    @NotNull
    public final NumberLineComponent getPoint() {
        return this.point;
    }

    public final void setPoint(@NotNull NumberLineComponent numberLineComponent) {
        Intrinsics.checkNotNullParameter((Object)numberLineComponent, (String)"<set-?>");
        this.point = numberLineComponent;
    }

    public final int getInterval() {
        return this.interval;
    }

    public final void setInterval(int n) {
        this.interval = n;
    }

    @Override
    public int compareTo(@NotNull NumberLineSegmentPoint other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.interval < other.interval ? -1 : (this.interval == other.interval ? 0 : 1);
    }

    public NumberLineSegmentPoint() {
        this(null, null, 0, 7, null);
    }

    @JvmStatic
    public static final boolean hasPoint(@NotNull NumberLine numberLine, int interval) {
        return Companion.hasPoint(numberLine, interval);
    }

    @JvmStatic
    @NotNull
    public static final ArrayList<NumberLineSegmentPoint> getPotentialPoints(@NotNull NumberLine numberLine) throws MathFormattingException {
        return Companion.getPotentialPoints(numberLine);
    }

    @JvmStatic
    @NotNull
    public static final String[] getPotentialPointsStringArray(@NotNull NumberLine numberLine) throws MathFormattingException {
        return Companion.getPotentialPointsStringArray(numberLine);
    }

    @JvmStatic
    @Nullable
    public static final NumberLineSegmentPoint getPointFromIndex(@NotNull NumberLine numberLine, int interval) {
        return Companion.getPointFromIndex(numberLine, interval);
    }

    @JvmStatic
    @NotNull
    public static final String getPrettyString(@NotNull NumberLine numberLine, @NotNull NumberLineComponent component) throws MathFormattingException {
        return Companion.getPrettyString(numberLine, component);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J \u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000f0\u000ej\b\u0012\u0004\u0012\u00020\u000f`\u00102\u0006\u0010\t\u001a\u00020\nH\u0007J\u001b\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\t\u001a\u00020\nH\u0007\u00a2\u0006\u0002\u0010\u0014J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0018\u0010\u0016\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0018H\u0007R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/brailleblaster/math/numberLine/NumberLineSegmentPoint$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "hasPoint", "", "numberLine", "Lorg/brailleblaster/math/numberLine/NumberLine;", "interval", "", "getPotentialPoints", "Ljava/util/ArrayList;", "Lorg/brailleblaster/math/numberLine/NumberLineSegmentPoint;", "Lkotlin/collections/ArrayList;", "getPotentialPointsStringArray", "", "", "(Lorg/brailleblaster/math/numberLine/NumberLine;)[Ljava/lang/String;", "getPointFromIndex", "getPrettyString", "component", "Lorg/brailleblaster/math/numberLine/NumberLineComponent;", "brailleblaster-core"})
    @SourceDebugExtension(value={"SMAP\nNumberLineSegmentPoint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NumberLineSegmentPoint.kt\norg/brailleblaster/math/numberLine/NumberLineSegmentPoint$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,126:1\n742#2,9:127\n1586#2:138\n1661#2,3:139\n37#3,2:136\n37#3,2:142\n*S KotlinDebug\n*F\n+ 1 NumberLineSegmentPoint.kt\norg/brailleblaster/math/numberLine/NumberLineSegmentPoint$Companion\n*L\n72#1:127,9\n103#1:138\n103#1:139,3\n72#1:136,2\n106#1:142,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final boolean hasPoint(@NotNull NumberLine numberLine, int interval) {
            Intrinsics.checkNotNullParameter((Object)numberLine, (String)"numberLine");
            int n = ((Collection)numberLine.getSegmentPoints()).size();
            for (int i = 0; i < n; ++i) {
                if (numberLine.getSegmentPoints().get(i).getInterval() != interval) continue;
                return true;
            }
            return false;
        }

        @JvmStatic
        @NotNull
        public final ArrayList<NumberLineSegmentPoint> getPotentialPoints(@NotNull NumberLine numberLine) throws MathFormattingException {
            Intrinsics.checkNotNullParameter((Object)numberLine, (String)"numberLine");
            ArrayList<NumberLineSegmentPoint> array = new ArrayList<NumberLineSegmentPoint>();
            if (numberLine.mathFormattingChecks(true)) {
                Fraction interval = numberLine.getNumberLineText().getInterval().getFraction();
                Fraction lineStart = numberLine.getNumberLineText().getLineStart().getFraction();
                Fraction lineEnd = numberLine.getNumberLineText().getLineEnd().getFraction();
                int totalUnits = (int)lineEnd.subtract(lineStart).divideBy(interval).doubleValue() + 1;
                for (int i = 0; i < totalUnits; ++i) {
                    Fraction fraction;
                    if (i != 0) {
                        Fraction additionalUnits = interval.multiplyBy(Fraction.getFraction((double)i));
                        Fraction fraction2 = lineStart.add(additionalUnits);
                        Intrinsics.checkNotNull((Object)fraction2);
                        fraction = fraction2;
                    } else {
                        fraction = lineStart;
                    }
                    Fraction fraction3 = fraction;
                    NumberLineComponent component = switch (WhenMappings.$EnumSwitchMapping$0[numberLine.getSettings().getIntervalType().ordinal()]) {
                        case 1 -> {
                            void $this$toTypedArray$iv;
                            List v1;
                            Collection $this$dropLastWhile$iv;
                            String doubleValue = String.valueOf(fraction3.doubleValue());
                            Object var13_13 = doubleValue;
                            Regex var14_15 = new Regex("\\.");
                            int var15_17 = 0;
                            var13_13 = var14_15.split((CharSequence)var13_13, var15_17);
                            boolean $i$f$dropLastWhile = false;
                            if (!$this$dropLastWhile$iv.isEmpty()) {
                                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                                while (iterator$iv.hasPrevious()) {
                                    String it = (String)iterator$iv.previous();
                                    boolean $i$a$-dropLastWhile-NumberLineSegmentPoint$Companion$getPotentialPoints$component$parts$1 = false;
                                    if (((CharSequence)it).length() == 0) continue;
                                    v1 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                                    break;
                                }
                            } else {
                                v1 = CollectionsKt.emptyList();
                            }
                            $this$dropLastWhile$iv = v1;
                            boolean $i$f$toTypedArray = false;
                            void thisCollection$iv = $this$toTypedArray$iv;
                            String[] parts = thisCollection$iv.toArray(new String[0]);
                            yield new NumberLineComponent(parts[0], parts[1], null, null, 12, null);
                        }
                        case 2 -> new NumberLineComponent(null, null, String.valueOf(fraction3.getNumerator()), String.valueOf(fraction3.getDenominator()), 3, null);
                        case 3 -> new NumberLineComponent(String.valueOf(fraction3.getProperWhole()), null, String.valueOf(fraction3.getProperNumerator()), String.valueOf(fraction3.getDenominator()), 2, null);
                        case 4 -> new NumberLineComponent(String.valueOf(fraction3.intValue()), null, null, null, 14, null);
                        default -> throw new NoWhenBranchMatchedException();
                    };
                    array.add(new NumberLineSegmentPoint(null, component, i + 1, 1, null));
                }
            } else {
                log.error("Get points called but math formatting checks failed");
            }
            return array;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final String[] getPotentialPointsStringArray(@NotNull NumberLine numberLine) throws MathFormattingException {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)numberLine, (String)"numberLine");
            Iterable $this$map$iv = this.getPotentialPoints(numberLine);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                NumberLineSegmentPoint numberLineSegmentPoint = (NumberLineSegmentPoint)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Fraction fraction = it.getPoint().getFraction();
                collection.add(NumberLineMathUtils.INSTANCE.getFractionString(numberLine, fraction));
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new String[0]);
        }

        @JvmStatic
        @Nullable
        public final NumberLineSegmentPoint getPointFromIndex(@NotNull NumberLine numberLine, int interval) {
            Intrinsics.checkNotNullParameter((Object)numberLine, (String)"numberLine");
            int n = ((Collection)numberLine.getSegmentPoints()).size();
            for (int i = 0; i < n; ++i) {
                if (numberLine.getSegmentPoints().get(i).getInterval() != interval) continue;
                return numberLine.getSegmentPoints().get(i);
            }
            return null;
        }

        @JvmStatic
        @NotNull
        public final String getPrettyString(@NotNull NumberLine numberLine, @NotNull NumberLineComponent component) throws MathFormattingException {
            Intrinsics.checkNotNullParameter((Object)numberLine, (String)"numberLine");
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            Fraction fraction = component.getFraction();
            return NumberLineMathUtils.INSTANCE.getFractionString(numberLine, fraction);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 3, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[SpatialMathEnum.IntervalType.values().length];
                try {
                    nArray[SpatialMathEnum.IntervalType.DECIMAL.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SpatialMathEnum.IntervalType.IMPROPER.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SpatialMathEnum.IntervalType.MIXED.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SpatialMathEnum.IntervalType.WHOLE.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

