/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.math.numberLine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.brailleblaster.math.numberLine.NumberLine;
import org.brailleblaster.math.numberLine.NumberLineConstants;
import org.brailleblaster.math.numberLine.NumberLineInterval;
import org.brailleblaster.math.numberLine.NumberLineSegmentPoint;
import org.brailleblaster.math.spatial.ISpatialMathWidget;
import org.brailleblaster.math.spatial.MathFormattingException;
import org.brailleblaster.math.spatial.MathText;
import org.brailleblaster.math.spatial.SpatialMathDispatcher;
import org.brailleblaster.math.spatial.SpatialMathEnum;
import org.brailleblaster.math.spatial.SpatialMathUtils;
import org.brailleblaster.utils.swt.EasySWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0004J\u001c\u0010\u0010\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0004J\u001c\u0010\u0011\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0004J\u001c\u0010\u0012\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0004J\b\u0010\u0013\u001a\u00020\u000bH\u0002J\b\u0010\u0014\u001a\u00020\u000bH\u0002J\u001c\u0010\u0015\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0004J\u001c\u0010\u0016\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0004J$\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0018\u001a\u0004\u0018\u00010\u000fH\u0004J\u0012\u0010\u0019\u001a\u00020\u000b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0004J\u0012\u0010\u001c\u001a\u00020\u000b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0004J\u001c\u0010\u001d\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0004R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u001f"}, d2={"Lorg/brailleblaster/math/numberLine/NumberLineWidget;", "Lorg/brailleblaster/math/spatial/ISpatialMathWidget;", "<init>", "()V", "numberLine", "Lorg/brailleblaster/math/numberLine/NumberLine;", "getNumberLine", "()Lorg/brailleblaster/math/numberLine/NumberLine;", "setNumberLine", "(Lorg/brailleblaster/math/numberLine/NumberLine;)V", "addAdditionalSegmentDropDown", "", "shell", "Lorg/eclipse/swt/widgets/Shell;", "menu", "Lorg/eclipse/swt/widgets/Menu;", "addSectionTypeMenu", "addPointsType", "addNumberLineType", "convertBlankEditToMath", "convertMathToBlankEdit", "addEndSegmentType", "addStartSegmentType", "addOptionsMenu", "settingsMenu", "addBlankAndLabels", "composite", "Lorg/eclipse/swt/widgets/Composite;", "addDoneButton", "addDebugMenu", "Companion", "brailleblaster-core"})
public abstract class NumberLineWidget
implements ISpatialMathWidget {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public NumberLine numberLine;
    private static final Logger logger = LoggerFactory.getLogger(NumberLineWidget.class);
    protected static final int MAX_SEGMENTS = 5;

    @NotNull
    public final NumberLine getNumberLine() {
        NumberLine numberLine = this.numberLine;
        if (numberLine != null) {
            return numberLine;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"numberLine");
        return null;
    }

    public final void setNumberLine(@NotNull NumberLine numberLine) {
        Intrinsics.checkNotNullParameter((Object)numberLine, (String)"<set-?>");
        this.numberLine = numberLine;
    }

    protected final void addAdditionalSegmentDropDown(@Nullable Shell shell, @Nullable Menu menu) {
        MenuItem cascadeMenu = new MenuItem(menu, 64);
        cascadeMenu.setText(NumberLineConstants.NUMBER_POINTS);
        Menu dropDownMenu = new Menu((Decorations)shell, 4);
        cascadeMenu.setMenu(dropDownMenu);
        for (int i = 1; i < 6; ++i) {
            MenuItem button = new MenuItem(dropDownMenu, 16);
            button.setText(String.valueOf(i));
            button.setSelection(this.getNumberLine().getNumberLineText().getPoints().size() == i);
            button.addListener(13, arg_0 -> NumberLineWidget.addAdditionalSegmentDropDown$lambda$0(button, this, i, arg_0));
        }
    }

    protected final void addSectionTypeMenu(@Nullable Shell shell, @Nullable Menu menu) {
        MenuItem cascadeMenu = new MenuItem(menu, 64);
        cascadeMenu.setText(NumberLineConstants.SECTION_TYPE);
        Menu dropDownMenu = new Menu((Decorations)shell, 4);
        cascadeMenu.setMenu(dropDownMenu);
        for (SpatialMathEnum.NumberLineSection type : SpatialMathEnum.NumberLineSection.getEntries()) {
            MenuItem menuItem = new MenuItem(dropDownMenu, 16);
            menuItem.setText(type.getPrettyName());
            menuItem.setSelection(type == this.getNumberLine().getSettings().getSectionType());
            menuItem.addListener(13, arg_0 -> NumberLineWidget.addSectionTypeMenu$lambda$0(menuItem, this, type, arg_0));
        }
    }

    protected final void addPointsType(@Nullable Shell shell, @Nullable Menu menu) {
        MenuItem cascadeMenu = new MenuItem(menu, 64);
        cascadeMenu.setText(NumberLineConstants.POINTS_CIRCLE_LABEL);
        Menu dropDownMenu = new Menu((Decorations)shell, 4);
        cascadeMenu.setMenu(dropDownMenu);
        int i = 1;
        int n = this.getNumberLine().getNumberLineText().getPoints().size();
        if (i <= n) {
            while (true) {
                int segmentNumber = i - 1;
                MenuItem segment = new MenuItem(dropDownMenu, 64);
                Menu segmentMenu = new Menu(dropDownMenu);
                segment.setMenu(segmentMenu);
                segment.setText(NumberLineConstants.POINT + " " + i);
                for (SpatialMathEnum.Fill fill : SpatialMathEnum.Fill.getEntries()) {
                    MenuItem button = new MenuItem(segmentMenu, 16);
                    button.setText(fill.getPrettyName());
                    boolean isSelected = this.getNumberLine().getSegmentPoints().size() > segmentNumber ? this.getNumberLine().getSegmentPoints().get(segmentNumber).getCircle() == fill : this.getNumberLine().getSettings().getStartSegmentCircle() == fill;
                    button.setSelection(isSelected);
                    button.addListener(13, arg_0 -> NumberLineWidget.addPointsType$lambda$0(this, segmentNumber, fill, arg_0));
                }
                if (i == n) break;
                ++i;
            }
        }
    }

    protected final void addNumberLineType(@Nullable Shell shell, @Nullable Menu menu) {
        MenuItem cascadeMenu = new MenuItem(menu, 64);
        cascadeMenu.setText(NumberLineConstants.NUMBER_LINE_TYPE);
        Menu dropDownMenu = new Menu((Decorations)shell, 4);
        cascadeMenu.setMenu(dropDownMenu);
        for (SpatialMathEnum.NumberLineType type : SpatialMathEnum.NumberLineType.getEntries()) {
            MenuItem button = new MenuItem(dropDownMenu, 16);
            button.setText(type.getPrettyName());
            button.setSelection(type == this.getNumberLine().getSettings().getType());
            button.addListener(13, arg_0 -> NumberLineWidget.addNumberLineType$lambda$0(button, this, type, arg_0));
        }
    }

    private final void convertBlankEditToMath() {
        this.getNumberLine().getNumberLineText().clear();
        this.getNumberLine().getSettings().getStringParser().clear();
    }

    private final void convertMathToBlankEdit() {
        List list;
        try {
            this.getNumberLine().setNumberLineText(this.getNumberLine().getSettings().getStringParser().parse());
        }
        catch (MathFormattingException e) {
            logger.warn("Problem setting number line text", (Throwable)e);
        }
        List newIntervals = new ArrayList();
        List<NumberLineInterval> oldIntervals = this.getNumberLine().getSettings().getUserDefinedArray();
        try {
            list = NumberLineSegmentPoint.Companion.getPotentialPoints(this.getNumberLine());
        }
        catch (MathFormattingException mathFormattingException) {
            return;
        }
        List intervals = list;
        if (!((Collection)intervals).isEmpty()) {
            int n = ((Collection)intervals).size();
            for (int i = 0; i < n; ++i) {
                NumberLineInterval interval = new NumberLineInterval(null, ((NumberLineSegmentPoint)intervals.get(i)).getPoint(), null, null, 13, null);
                if (oldIntervals.size() > i) {
                    interval.setBlankType(oldIntervals.get(i).getBlankType());
                    interval.setLabelText(oldIntervals.get(i).getLabelText());
                }
                try {
                    String print = NumberLineSegmentPoint.Companion.getPrettyString(this.getNumberLine(), ((NumberLineSegmentPoint)intervals.get(i)).getPoint());
                    String braille = SpatialMathUtils.translate(this.getNumberLine().getSettings().getTranslationUserDefined(), NumberLineSegmentPoint.Companion.getPrettyString(this.getNumberLine(), ((NumberLineSegmentPoint)intervals.get(i)).getPoint()));
                    interval.setUserText(new MathText(print, braille, false, 4, null));
                }
                catch (MathFormattingException mathFormattingException) {
                    return;
                }
                newIntervals.add(interval);
            }
            this.getNumberLine().getSettings().setNumUserDefinedIntervals(newIntervals.size());
            this.getNumberLine().getSettings().setUserDefinedArray(newIntervals);
            if (SpatialMathEnum.NumberLineSection.SEGMENT == this.getNumberLine().getSettings().getSectionType()) {
                try {
                    this.getNumberLine().setSegmentIntervals();
                }
                catch (MathFormattingException e) {
                    logger.warn("Problem when setting segment intervals", (Throwable)e);
                }
            }
        }
    }

    protected final void addEndSegmentType(@Nullable Shell shell, @Nullable Menu menu) {
        MenuItem cascadeMenu = new MenuItem(menu, 64);
        cascadeMenu.setText(NumberLineConstants.END_SEGMENT_SYMBOL_LABEL);
        Menu dropDownMenu = new Menu((Decorations)shell, 4);
        cascadeMenu.setMenu(dropDownMenu);
        for (SpatialMathEnum.Fill fill : SpatialMathEnum.Fill.getEntries()) {
            MenuItem button = new MenuItem(dropDownMenu, 16);
            button.setText(fill.getPrettyName());
            button.setSelection(this.getNumberLine().getSettings().getEndSegmentCircle() == fill);
            button.addListener(13, arg_0 -> NumberLineWidget.addEndSegmentType$lambda$0(this, fill, arg_0));
        }
    }

    protected final void addStartSegmentType(@Nullable Shell shell, @Nullable Menu menu) {
        MenuItem cascadeMenu = new MenuItem(menu, 64);
        cascadeMenu.setText(NumberLineConstants.START_SEGMENT_SYMBOL_LABEL);
        Menu dropDownMenu = new Menu((Decorations)shell, 4);
        cascadeMenu.setMenu(dropDownMenu);
        for (SpatialMathEnum.Fill fill : SpatialMathEnum.Fill.getEntries()) {
            MenuItem button = new MenuItem(dropDownMenu, 16);
            button.setText(fill.getPrettyName());
            button.setSelection(this.getNumberLine().getSettings().getStartSegmentCircle() == fill);
            button.addListener(13, arg_0 -> NumberLineWidget.addStartSegmentType$lambda$0(button, this, fill, arg_0));
        }
    }

    protected final void addOptionsMenu(@NotNull Shell shell, @Nullable Menu menu, @Nullable Menu settingsMenu) {
        MenuItem translation;
        Menu dropDownMenu;
        MenuItem cascadeMenu;
        Intrinsics.checkNotNullParameter((Object)shell, (String)"shell");
        MenuItem reducedFraction = new MenuItem(settingsMenu, 32);
        reducedFraction.setText(NumberLineConstants.REDUCE_FRACTION);
        reducedFraction.setSelection(this.getNumberLine().getSettings().isReduceFraction());
        reducedFraction.addListener(13, arg_0 -> NumberLineWidget.addOptionsMenu$lambda$0(this, reducedFraction, arg_0));
        MenuItem beveledFraction = new MenuItem(settingsMenu, 32);
        beveledFraction.setText(NumberLineConstants.BEVELED_FRACTION);
        beveledFraction.setSelection(this.getNumberLine().getSettings().isBeveledFraction());
        beveledFraction.addListener(13, arg_0 -> NumberLineWidget.addOptionsMenu$lambda$1(this, beveledFraction, arg_0));
        MenuItem arrow = new MenuItem(settingsMenu, 32);
        arrow.setText(NumberLineConstants.ARROW_LABEL);
        arrow.setSelection(this.getNumberLine().getSettings().isArrow());
        arrow.addListener(13, arg_0 -> NumberLineWidget.addOptionsMenu$lambda$2(this, arrow, arg_0));
        MenuItem stretchButton = new MenuItem(settingsMenu, 32);
        stretchButton.setText(NumberLineConstants.STRETCH_LABEL);
        stretchButton.setSelection(this.getNumberLine().getSettings().isStretch());
        stretchButton.addListener(13, arg_0 -> NumberLineWidget.addOptionsMenu$lambda$3(this, stretchButton, arg_0));
        MenuItem leadingZeros = new MenuItem(settingsMenu, 32);
        leadingZeros.setText(NumberLineConstants.REMOVE_LEADING_ZEROS_LABEL);
        leadingZeros.setSelection(this.getNumberLine().getSettings().isRemoveLeadingZeros());
        leadingZeros.addListener(13, arg_0 -> NumberLineWidget.addOptionsMenu$lambda$4(this, arg_0));
        if (SpatialMathEnum.NumberLineType.USER_DEFINED == this.getNumberLine().getSettings().getType()) {
            cascadeMenu = new MenuItem(settingsMenu, 64);
            cascadeMenu.setText(NumberLineConstants.TRANSLATION_TYPE);
            dropDownMenu = new Menu((Decorations)shell, 4);
            cascadeMenu.setMenu(dropDownMenu);
            for (SpatialMathEnum.Translation translationType : SpatialMathEnum.Translation.getEntries()) {
                translation = new MenuItem(dropDownMenu, 16);
                translation.setText(translationType.getPrettyName());
                translation.setSelection(translationType == this.getNumberLine().getSettings().getTranslationUserDefined());
                translation.addListener(13, arg_0 -> NumberLineWidget.addOptionsMenu$lambda$5(translation, this, translationType, arg_0));
            }
        }
        if (this.getNumberLine().getSettings().getOptions().contains((Object)SpatialMathEnum.NumberLineOptions.LABELS)) {
            cascadeMenu = new MenuItem(settingsMenu, 64);
            cascadeMenu.setText(NumberLineConstants.TRANSLATION_LABEL);
            dropDownMenu = new Menu((Decorations)shell, 4);
            cascadeMenu.setMenu(dropDownMenu);
            for (SpatialMathEnum.Translation translationType : SpatialMathEnum.Translation.getEntries()) {
                translation = new MenuItem(dropDownMenu, 16);
                translation.setText(translationType.getPrettyName());
                translation.setSelection(translationType == this.getNumberLine().getSettings().getTranslationLabel());
                translation.addListener(13, arg_0 -> NumberLineWidget.addOptionsMenu$lambda$6(translation, this, translationType, arg_0));
            }
        }
    }

    protected final void addBlankAndLabels(@Nullable Composite composite) {
        Group g = EasySWT.makeGroup((Composite)composite, (int)0, (int)2, (boolean)false);
        for (SpatialMathEnum.NumberLineOptions x : SpatialMathEnum.NumberLineOptions.getEntries()) {
            EasySWT.makePushButton((Composite)((Composite)g), (String)x.getPrettyName(), (int)1, arg_0 -> NumberLineWidget.addBlankAndLabels$lambda$0(this, x, arg_0));
        }
    }

    protected final void addDoneButton(@Nullable Composite composite) {
        EasySWT.makePushButton((Composite)composite, (String)NumberLineConstants.DONE_LABEL, (int)1, arg_0 -> NumberLineWidget.addDoneButton$lambda$0(this, arg_0));
    }

    protected final void addDebugMenu(@Nullable Shell shell, @Nullable Menu menu) {
        MenuItem cascadeMenu = new MenuItem(menu, 64);
        cascadeMenu.setText("Debug Number Line");
        Menu dropDownMenu = new Menu((Decorations)shell, 4);
        cascadeMenu.setMenu(dropDownMenu);
        MenuItem a = new MenuItem(dropDownMenu, 0);
        a.setText("Whole");
        a.addListener(13, arg_0 -> NumberLineWidget.addDebugMenu$lambda$0(this, arg_0));
        MenuItem b = new MenuItem(dropDownMenu, 0);
        b.setText("Decimal");
        b.addListener(13, arg_0 -> NumberLineWidget.addDebugMenu$lambda$1(this, arg_0));
        MenuItem c = new MenuItem(dropDownMenu, 0);
        c.setText("Improper");
        c.addListener(13, arg_0 -> NumberLineWidget.addDebugMenu$lambda$2(this, arg_0));
        MenuItem d = new MenuItem(dropDownMenu, 0);
        d.setText("Mixed");
        d.addListener(13, arg_0 -> NumberLineWidget.addDebugMenu$lambda$3(this, arg_0));
    }

    private static final void addAdditionalSegmentDropDown$lambda$0(MenuItem $button, NumberLineWidget this$0, int $i, Event it) {
        if ($button.getSelection()) {
            this$0.getNumberLine().rebuildPoints($i);
            SpatialMathDispatcher.INSTANCE.dispatch();
        }
    }

    private static final void addSectionTypeMenu$lambda$0(MenuItem $menuItem, NumberLineWidget this$0, SpatialMathEnum.NumberLineSection $type, Event it) {
        if (!$menuItem.getSelection()) {
            return;
        }
        this$0.getNumberLine().getSettings().setSectionType($type);
        $menuItem.setSelection($type == this$0.getNumberLine().getSettings().getSectionType());
        try {
            this$0.getNumberLine().parse();
            SpatialMathDispatcher.INSTANCE.dispatch();
        }
        catch (MathFormattingException e) {
            logger.warn("Problem parsing number line", (Throwable)e);
        }
    }

    private static final void addPointsType$lambda$0(NumberLineWidget this$0, int $segmentNumber, SpatialMathEnum.Fill $fill, Event it) {
        this$0.getNumberLine().getSegmentPoints().get($segmentNumber).setCircle($fill);
    }

    private static final void addNumberLineType$lambda$0(MenuItem $button, NumberLineWidget this$0, SpatialMathEnum.NumberLineType $type, Event it) {
        if ($button.getSelection()) {
            this$0.getNumberLine().getSettings().setType($type);
            if ($type == SpatialMathEnum.NumberLineType.AUTOMATIC_MATH) {
                this$0.getNumberLine().getSettings().setView(SpatialMathEnum.NumberLineViews.AUTOMATIC_MATH);
                this$0.getNumberLine().setWidget(this$0.getNumberLine().createWidgetForType$brailleblaster_core(SpatialMathEnum.NumberLineViews.AUTOMATIC_MATH));
                this$0.convertBlankEditToMath();
            } else {
                this$0.getNumberLine().getSettings().setView(SpatialMathEnum.NumberLineViews.USER_DEFINED);
                this$0.getNumberLine().setWidget(this$0.getNumberLine().createWidgetForType$brailleblaster_core(SpatialMathEnum.NumberLineViews.USER_DEFINED));
                this$0.convertMathToBlankEdit();
            }
            $button.setSelection($type == this$0.getNumberLine().getSettings().getType());
            SpatialMathDispatcher.INSTANCE.dispatch();
        }
    }

    private static final void addEndSegmentType$lambda$0(NumberLineWidget this$0, SpatialMathEnum.Fill $fill, Event it) {
        this$0.getNumberLine().getSettings().setEndSegmentCircle($fill);
        this$0.getNumberLine().getSegment().setEndSegmentCircle($fill);
    }

    private static final void addStartSegmentType$lambda$0(MenuItem $button, NumberLineWidget this$0, SpatialMathEnum.Fill $fill, Event it) {
        if (!$button.getSelection()) {
            return;
        }
        this$0.getNumberLine().getSettings().setStartSegmentCircle($fill);
        this$0.getNumberLine().getSegment().setStartSegmentCircle($fill);
    }

    private static final void addOptionsMenu$lambda$0(NumberLineWidget this$0, MenuItem $reducedFraction, Event it) {
        this$0.getNumberLine().getSettings().setReduceFraction(!this$0.getNumberLine().getSettings().isReduceFraction());
        $reducedFraction.setSelection(this$0.getNumberLine().getSettings().isReduceFraction());
    }

    private static final void addOptionsMenu$lambda$1(NumberLineWidget this$0, MenuItem $beveledFraction, Event it) {
        this$0.getNumberLine().getSettings().setBeveledFraction(!this$0.getNumberLine().getSettings().isBeveledFraction());
        $beveledFraction.setSelection(this$0.getNumberLine().getSettings().isBeveledFraction());
    }

    private static final void addOptionsMenu$lambda$2(NumberLineWidget this$0, MenuItem $arrow, Event it) {
        this$0.getNumberLine().getSettings().setArrow(!this$0.getNumberLine().getSettings().isArrow());
        $arrow.setSelection(this$0.getNumberLine().getSettings().isArrow());
    }

    private static final void addOptionsMenu$lambda$3(NumberLineWidget this$0, MenuItem $stretchButton, Event it) {
        this$0.getNumberLine().getSettings().setStretch(!this$0.getNumberLine().getSettings().isStretch());
        $stretchButton.setSelection(this$0.getNumberLine().getSettings().isStretch());
    }

    private static final void addOptionsMenu$lambda$4(NumberLineWidget this$0, Event it) {
        this$0.getNumberLine().getSettings().setRemoveLeadingZeros(!this$0.getNumberLine().getSettings().isRemoveLeadingZeros());
    }

    private static final void addOptionsMenu$lambda$5(MenuItem $translation, NumberLineWidget this$0, SpatialMathEnum.Translation $translationType, Event it) {
        if ($translation.getSelection()) {
            this$0.getNumberLine().getSettings().setTranslationUserDefined($translationType);
            $translation.setSelection($translationType == this$0.getNumberLine().getSettings().getTranslationUserDefined());
            this$0.getNumberLine().retranslateUserText();
        }
    }

    private static final void addOptionsMenu$lambda$6(MenuItem $translation, NumberLineWidget this$0, SpatialMathEnum.Translation $translationType, Event it) {
        if ($translation.getSelection()) {
            this$0.getNumberLine().getSettings().setTranslationLabel($translationType);
            $translation.setSelection($translationType == this$0.getNumberLine().getSettings().getTranslationLabel());
            this$0.getNumberLine().retranslateLabels();
        }
    }

    private static final void addBlankAndLabels$lambda$0(NumberLineWidget this$0, SpatialMathEnum.NumberLineOptions $x, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.getNumberLine().getSettings().getOptions().add($x);
        if ($x == SpatialMathEnum.NumberLineOptions.BLANKS) {
            this$0.getNumberLine().getSettings().setView(SpatialMathEnum.NumberLineViews.BLANKS);
            this$0.getNumberLine().setWidget(this$0.getNumberLine().createWidgetForType$brailleblaster_core(SpatialMathEnum.NumberLineViews.BLANKS));
        } else {
            this$0.getNumberLine().getSettings().setView(SpatialMathEnum.NumberLineViews.LABELS);
            this$0.getNumberLine().setWidget(this$0.getNumberLine().createWidgetForType$brailleblaster_core(SpatialMathEnum.NumberLineViews.LABELS));
        }
        SpatialMathDispatcher.INSTANCE.dispatch();
    }

    private static final void addDoneButton$lambda$0(NumberLineWidget this$0, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (SpatialMathEnum.NumberLineType.AUTOMATIC_MATH == this$0.getNumberLine().getSettings().getType()) {
            this$0.getNumberLine().getSettings().setView(SpatialMathEnum.NumberLineViews.AUTOMATIC_MATH);
            this$0.getNumberLine().setWidget(this$0.getNumberLine().createWidgetForType$brailleblaster_core(SpatialMathEnum.NumberLineViews.AUTOMATIC_MATH));
        } else {
            this$0.getNumberLine().getSettings().setView(SpatialMathEnum.NumberLineViews.USER_DEFINED);
            this$0.getNumberLine().setWidget(this$0.getNumberLine().createWidgetForType$brailleblaster_core(SpatialMathEnum.NumberLineViews.USER_DEFINED));
        }
        SpatialMathDispatcher.INSTANCE.dispatch();
    }

    private static final void addDebugMenu$lambda$0(NumberLineWidget this$0, Event it) {
        this$0.getNumberLine().getSettings().setIntervalType(SpatialMathEnum.IntervalType.WHOLE);
        this$0.fillDebug(this$0.getNumberLine());
        SpatialMathDispatcher.INSTANCE.dispatch();
    }

    private static final void addDebugMenu$lambda$1(NumberLineWidget this$0, Event it) {
        this$0.getNumberLine().getSettings().setIntervalType(SpatialMathEnum.IntervalType.DECIMAL);
        this$0.fillDebug(this$0.getNumberLine());
        SpatialMathDispatcher.INSTANCE.dispatch();
    }

    private static final void addDebugMenu$lambda$2(NumberLineWidget this$0, Event it) {
        this$0.getNumberLine().getSettings().setIntervalType(SpatialMathEnum.IntervalType.IMPROPER);
        this$0.fillDebug(this$0.getNumberLine());
        SpatialMathDispatcher.INSTANCE.dispatch();
    }

    private static final void addDebugMenu$lambda$3(NumberLineWidget this$0, Event it) {
        this$0.getNumberLine().getSettings().setIntervalType(SpatialMathEnum.IntervalType.MIXED);
        this$0.fillDebug(this$0.getNumberLine());
        SpatialMathDispatcher.INSTANCE.dispatch();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0084T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/brailleblaster/math/numberLine/NumberLineWidget$Companion;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "MAX_SEGMENTS", "", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

