/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.math.numberLine;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.brailleblaster.math.numberLine.NumberLine;
import org.brailleblaster.math.numberLine.NumberLineConstants;
import org.brailleblaster.math.numberLine.NumberLineInterval;
import org.brailleblaster.math.numberLine.NumberLineMathUtils;
import org.brailleblaster.math.numberLine.NumberLinePoint;
import org.brailleblaster.math.numberLine.NumberLineWidget;
import org.brailleblaster.math.spatial.ISpatialMathContainer;
import org.brailleblaster.math.spatial.MathFormattingException;
import org.brailleblaster.math.spatial.MathText;
import org.brailleblaster.math.spatial.SpatialMathDispatcher;
import org.brailleblaster.math.spatial.SpatialMathEnum;
import org.brailleblaster.math.spatial.SpatialMathUtils;
import org.brailleblaster.utils.swt.EasySWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J\b\u0010\f\u001a\u00020\nH\u0016J\b\u0010\r\u001a\u00020\nH\u0016J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\bH\u0016J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0011H\u0016J\u0018\u0010\u0015\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0011H\u0002\u00a8\u0006\u0016"}, d2={"Lorg/brailleblaster/math/numberLine/NumberLineWidgetAddLabels;", "Lorg/brailleblaster/math/numberLine/NumberLineWidget;", "<init>", "()V", "getWidget", "Lorg/eclipse/swt/widgets/Composite;", "parent", "container", "Lorg/brailleblaster/math/spatial/ISpatialMathContainer;", "makeLabelEditBoxes", "", "shell", "onOpen", "extractText", "fillDebug", "t", "addMenuItems", "Lorg/eclipse/swt/widgets/Menu;", "Lorg/eclipse/swt/widgets/Shell;", "menu", "settingsMenu", "addPositionOptions", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nNumberLineWidgetAddLabels.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NumberLineWidgetAddLabels.kt\norg/brailleblaster/math/numberLine/NumberLineWidgetAddLabels\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,126:1\n37#2,2:127\n*S KotlinDebug\n*F\n+ 1 NumberLineWidgetAddLabels.kt\norg/brailleblaster/math/numberLine/NumberLineWidgetAddLabels\n*L\n109#1:127,2\n*E\n"})
public final class NumberLineWidgetAddLabels
extends NumberLineWidget {
    @Override
    @NotNull
    public Composite getWidget(@NotNull Composite parent, @NotNull ISpatialMathContainer container) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        this.setNumberLine((NumberLine)container);
        this.makeLabelEditBoxes(parent);
        this.addDoneButton(parent);
        return parent;
    }

    private final void makeLabelEditBoxes(Composite shell) {
        Group g = EasySWT.makeGroup((Composite)shell, (int)0, (int)3, (boolean)false);
        int n = ((Collection)this.getNumberLine().getSettings().getUserDefinedArray()).size();
        for (int i = 0; i < n; ++i) {
            NumberLineInterval interval = this.getNumberLine().getSettings().getUserDefinedArray().get(i);
            EasySWT.makeLabel((Composite)((Composite)g), (String)(NumberLineConstants.MARKER_LABEL + " " + (i + 1)), (int)1);
            Text t = EasySWT.makeText((Composite)((Composite)g), (int)50, (int)1);
            t.setEditable(false);
            if (!interval.getMathText().isEmpty()) {
                try {
                    t.setText(NumberLineMathUtils.INSTANCE.getFractionString(this.getNumberLine(), interval.getMathText().getFraction()));
                }
                catch (MathFormattingException e1) {
                    e1.printStackTrace();
                }
            } else {
                t.setText(interval.getUserText().print);
            }
            Text t2 = EasySWT.makeText((Composite)((Composite)g), (int)50, (int)1);
            EasySWT.INSTANCE.addModifyListener(t2, arg_0 -> NumberLineWidgetAddLabels.makeLabelEditBoxes$lambda$0(interval, t2, this, arg_0));
            t2.setText(interval.getLabelText().getMathText().print);
        }
    }

    @Override
    public void onOpen() {
    }

    @Override
    public void extractText() {
    }

    @Override
    public void fillDebug(@NotNull ISpatialMathContainer t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
    }

    @Override
    @NotNull
    public Menu addMenuItems(@NotNull Shell shell, @NotNull Menu menu, @NotNull Menu settingsMenu) {
        Intrinsics.checkNotNullParameter((Object)shell, (String)"shell");
        Intrinsics.checkNotNullParameter((Object)menu, (String)"menu");
        Intrinsics.checkNotNullParameter((Object)settingsMenu, (String)"settingsMenu");
        this.addNumberLineType(shell, menu);
        this.addOptionsMenu(shell, menu, settingsMenu);
        this.addPositionOptions(shell, menu);
        this.addSectionTypeMenu(shell, menu);
        if (SpatialMathEnum.NumberLineSection.SEGMENT == this.getNumberLine().getSettings().getSectionType()) {
            this.addStartSegmentType(shell, menu);
            this.addEndSegmentType(shell, menu);
        } else {
            this.addAdditionalSegmentDropDown(shell, menu);
            this.addPointsType(shell, menu);
        }
        return menu;
    }

    private final void addPositionOptions(Shell shell, Menu menu) {
        MenuItem cascadeMenu = new MenuItem(menu, 64);
        cascadeMenu.setText(NumberLineConstants.LABEL_POSITION);
        Menu dropDownMenu = new Menu((Decorations)shell, 4);
        cascadeMenu.setMenu(dropDownMenu);
        Collection $this$toTypedArray$iv = (Collection)SpatialMathEnum.LabelPosition.getEntries();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        int n = thisCollection$iv.toArray(new SpatialMathEnum.LabelPosition[0]).length;
        for (int i = 0; i < n; ++i) {
            SpatialMathEnum.LabelPosition position = (SpatialMathEnum.LabelPosition)((Object)SpatialMathEnum.LabelPosition.getEntries().get(i));
            MenuItem b = new MenuItem(dropDownMenu, 16);
            b.setText(position.getPrettyName());
            b.setSelection(position == this.getNumberLine().getSettings().getLabelPosition());
            b.addListener(13, arg_0 -> NumberLineWidgetAddLabels.addPositionOptions$lambda$0(b, this, position, arg_0));
        }
    }

    private static final void makeLabelEditBoxes$lambda$0(NumberLineInterval $interval, Text $t2, NumberLineWidgetAddLabels this$0, ModifyEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = $t2.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        SpatialMathEnum.Translation translation = this$0.getNumberLine().getSettings().getTranslationLabel();
        String string2 = $t2.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        MathText mathText = new MathText(string, SpatialMathUtils.translate(translation, string2), false, 4, null);
        $interval.setLabelText(new NumberLinePoint(false, null, mathText, false, 3, null));
    }

    private static final void addPositionOptions$lambda$0(MenuItem $b, NumberLineWidgetAddLabels this$0, SpatialMathEnum.LabelPosition $position, Event it) {
        if (!$b.getSelection()) {
            return;
        }
        this$0.getNumberLine().getSettings().setLabelPosition($position);
        SpatialMathDispatcher.INSTANCE.dispatch();
    }
}

