/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.math.numberLine;

import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.brailleblaster.math.numberLine.NumberLine;
import org.brailleblaster.math.numberLine.NumberLineFormatter;
import org.brailleblaster.math.numberLine.NumberLinePoint;
import org.brailleblaster.math.numberLine.UebNumberLineFormatter;
import org.brailleblaster.math.spatial.MathFormattingException;
import org.brailleblaster.math.spatial.SpatialMathEnum;
import org.brailleblaster.settings.UTDManager;
import org.brailleblaster.wordprocessor.WPManager;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\r"}, d2={"Lorg/brailleblaster/math/numberLine/UebUserDefinedFormatter;", "Lorg/brailleblaster/math/numberLine/UebNumberLineFormatter;", "<init>", "()V", "formatPoints", "", "numberLine", "Lorg/brailleblaster/math/numberLine/NumberLine;", "cellsPerLine", "", "formatPoints$brailleblaster_core", "format", "", "brailleblaster-core"})
public final class UebUserDefinedFormatter
extends UebNumberLineFormatter {
    @NotNull
    public static final UebUserDefinedFormatter INSTANCE = new UebUserDefinedFormatter();

    private UebUserDefinedFormatter() {
    }

    public final void formatPoints$brailleblaster_core(@NotNull NumberLine numberLine, int cellsPerLine) throws MathFormattingException {
        int addedCells;
        Intrinsics.checkNotNullParameter((Object)numberLine, (String)"numberLine");
        ArrayList<NumberLinePoint> points = new ArrayList<NumberLinePoint>();
        int n = ((Collection)numberLine.getSettings().getUserDefinedArray()).size();
        for (int i = 0; i < n; ++i) {
            points.add(new NumberLinePoint(false, null, numberLine.getSettings().getUserDefinedArray().get(i).getUserText(), false, 11, null));
        }
        numberLine.setPoints(points);
        NumberLineFormatter.Companion.dealWithBlanks(numberLine);
        NumberLinePoint.Companion.makeColumnsEqualWidth(points);
        if (numberLine.getSettings().isStretch() && (addedCells = UebNumberLineFormatter.Companion.getStretchCells(numberLine, cellsPerLine)) > 0) {
            int n2 = ((Collection)numberLine.getPoints()).size();
            for (int i = 0; i < n2; ++i) {
                NumberLinePoint numberLinePoint = numberLine.getPoints().get(i);
                numberLinePoint.setRightPadding(numberLinePoint.getRightPadding() + addedCells);
            }
        }
    }

    public final boolean format(@NotNull NumberLine numberLine) throws MathFormattingException {
        Intrinsics.checkNotNullParameter((Object)numberLine, (String)"numberLine");
        int cellsPerLine = UTDManager.Companion.getCellsPerLine(WPManager.Companion.getInstance().getController());
        this.formatPoints$brailleblaster_core(numberLine, cellsPerLine);
        NumberLineFormatter.Companion.verticallyAlignLabelsAndPoints(numberLine);
        UebNumberLineFormatter.Companion.formatLine(numberLine);
        NumberLineFormatter.Companion.addLine(numberLine);
        if (!NumberLineFormatter.Companion.addPoints(numberLine)) {
            return false;
        }
        SpatialMathEnum.NumberLineSection numberLineSection = numberLine.getSettings().getSectionType();
        switch (numberLineSection == null ? -1 : WhenMappings.$EnumSwitchMapping$0[numberLineSection.ordinal()]) {
            case 1: {
                UebNumberLineFormatter.Companion.formatMultiplePoints(numberLine);
                break;
            }
            case 2: {
                UebNumberLineFormatter.Companion.formatSegment(numberLine);
            }
        }
        NumberLineFormatter.Companion.addLabels(numberLine);
        return true;
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SpatialMathEnum.NumberLineSection.values().length];
            try {
                nArray[SpatialMathEnum.NumberLineSection.POINTS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpatialMathEnum.NumberLineSection.SEGMENT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

