/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.math.spatial;

import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.brailleblaster.math.mathml.MathModuleUtils;
import org.brailleblaster.math.spatial.GridConstants;
import org.brailleblaster.math.spatial.ISpatialMathSettings;
import org.brailleblaster.math.spatial.SpatialMathEnum;
import org.brailleblaster.math.template.TemplateConstants;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\b\u0010\u0004\u001a\u00020\u0003H&J\b\u0010\u0005\u001a\u00020\u0003H&J\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0016J.\u0010\u000f\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0015\u00c0\u0006\u0001"}, d2={"Lorg/brailleblaster/math/spatial/ISpatialMathDialog;", "", "open", "", "safeClose", "register", "settingsMenu", "Lorg/eclipse/swt/widgets/Menu;", "getSettingsMenu", "()Lorg/eclipse/swt/widgets/Menu;", "createSettingsMenu", "menu", "shell", "Lorg/eclipse/swt/widgets/Shell;", "createMenu", "addPassages", "settings", "Lorg/brailleblaster/math/spatial/ISpatialMathSettings;", "callback", "Ljava/util/function/Consumer;", "Lorg/brailleblaster/math/spatial/SpatialMathEnum$Passage;", "brailleblaster-core"})
public interface ISpatialMathDialog {
    public void open();

    public void safeClose();

    public void register();

    @NotNull
    public Menu getSettingsMenu();

    @NotNull
    default public Menu createSettingsMenu(@NotNull Menu menu, @NotNull Shell shell) {
        Intrinsics.checkNotNullParameter((Object)menu, (String)"menu");
        Intrinsics.checkNotNullParameter((Object)shell, (String)"shell");
        MenuItem cascadeMenu = new MenuItem(menu, 64);
        cascadeMenu.setText(TemplateConstants.SETTINGS);
        Menu dropDownMenu = new Menu((Decorations)shell, 4);
        cascadeMenu.setMenu(dropDownMenu);
        return dropDownMenu;
    }

    @NotNull
    default public Menu createMenu(@NotNull Shell shell) {
        Intrinsics.checkNotNullParameter((Object)shell, (String)"shell");
        Menu menu = new Menu((Decorations)shell, 2);
        shell.setMenuBar(menu);
        return menu;
    }

    default public void addPassages(@NotNull Shell shell, @NotNull Menu menu, @NotNull ISpatialMathSettings settings, @NotNull Consumer<SpatialMathEnum.Passage> callback) {
        Intrinsics.checkNotNullParameter((Object)shell, (String)"shell");
        Intrinsics.checkNotNullParameter((Object)menu, (String)"menu");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        if (MathModuleUtils.isNemeth()) {
            MenuItem nemethButton = new MenuItem(menu, 32);
            nemethButton.setText(SpatialMathEnum.Passage.NEMETH.getPrettyName());
            nemethButton.setSelection(settings.getPassage() == SpatialMathEnum.Passage.NEMETH);
            nemethButton.addListener(13, arg_0 -> ISpatialMathDialog.addPassages$lambda$0(nemethButton, callback, settings, arg_0));
        } else {
            MenuItem cascadeMenu = new MenuItem(menu, 64);
            cascadeMenu.setText(GridConstants.PASSAGE_TYPE);
            Menu dropDownMenu = new Menu((Decorations)shell, 4);
            cascadeMenu.setMenu(dropDownMenu);
            MenuItem grade1Button = new MenuItem(dropDownMenu, 16);
            grade1Button.setText(SpatialMathEnum.Passage.GRADE1.getPrettyName());
            grade1Button.setSelection(settings.getPassage() == SpatialMathEnum.Passage.GRADE1);
            grade1Button.addListener(13, arg_0 -> ISpatialMathDialog.addPassages$lambda$1(grade1Button, callback, settings, arg_0));
            MenuItem numericButton = new MenuItem(dropDownMenu, 16);
            numericButton.setText(SpatialMathEnum.Passage.NUMERIC.getPrettyName());
            numericButton.setSelection(settings.getPassage() == SpatialMathEnum.Passage.NUMERIC);
            numericButton.addListener(13, arg_0 -> ISpatialMathDialog.addPassages$lambda$2(numericButton, callback, settings, arg_0));
            MenuItem noneButton = new MenuItem(dropDownMenu, 16);
            noneButton.setText(SpatialMathEnum.Passage.NONE.getPrettyName());
            noneButton.setSelection(settings.getPassage() == SpatialMathEnum.Passage.NONE);
            noneButton.addListener(13, arg_0 -> ISpatialMathDialog.addPassages$lambda$3(noneButton, callback, settings, arg_0));
        }
    }

    private static void addPassages$lambda$0(MenuItem $nemethButton, Consumer $callback, ISpatialMathSettings $settings, Event it) {
        if ($nemethButton.getSelection()) {
            $callback.accept(SpatialMathEnum.Passage.NEMETH);
        } else {
            $callback.accept(SpatialMathEnum.Passage.NONE);
        }
        $nemethButton.setSelection($settings.getPassage() == SpatialMathEnum.Passage.NEMETH);
    }

    private static void addPassages$lambda$1(MenuItem $grade1Button, Consumer $callback, ISpatialMathSettings $settings, Event it) {
        if ($grade1Button.getSelection()) {
            $callback.accept(SpatialMathEnum.Passage.GRADE1);
            $grade1Button.setSelection($settings.getPassage() == SpatialMathEnum.Passage.GRADE1);
        }
    }

    private static void addPassages$lambda$2(MenuItem $numericButton, Consumer $callback, ISpatialMathSettings $settings, Event it) {
        if ($numericButton.getSelection()) {
            $callback.accept(SpatialMathEnum.Passage.NUMERIC);
            $numericButton.setSelection($settings.getPassage() == SpatialMathEnum.Passage.NUMERIC);
        }
    }

    private static void addPassages$lambda$3(MenuItem $noneButton, Consumer $callback, ISpatialMathSettings $settings, Event it) {
        if ($noneButton.getSelection()) {
            $callback.accept(SpatialMathEnum.Passage.NONE);
            $noneButton.setSelection($settings.getPassage() == SpatialMathEnum.Passage.NONE);
        }
    }
}

