/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.math.spatial;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import org.brailleblaster.BBIni;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.math.mathml.MathModuleUtils;
import org.brailleblaster.math.spatial.ISpatialMathContainer;
import org.brailleblaster.math.spatial.ISpatialMathContainerJson;
import org.brailleblaster.math.spatial.Line;
import org.brailleblaster.math.spatial.MathFormattingException;
import org.brailleblaster.math.spatial.MathText;
import org.brailleblaster.math.spatial.MatrixConstants;
import org.brailleblaster.math.spatial.MatrixJson;
import org.brailleblaster.math.spatial.MatrixSettings;
import org.brailleblaster.math.spatial.MatrixWidget;
import org.brailleblaster.math.spatial.SpatialMathBlock;
import org.brailleblaster.math.spatial.SpatialMathEnum;
import org.brailleblaster.math.spatial.VersionConverter;
import org.brailleblaster.perspectives.braille.mapping.elements.LineBreakElement;
import org.brailleblaster.perspectives.braille.mapping.elements.TextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.WhiteSpaceElement;
import org.brailleblaster.perspectives.braille.messages.Sender;
import org.brailleblaster.perspectives.mvc.BBSimpleManager;
import org.brailleblaster.perspectives.mvc.XMLNodeCaret;
import org.brailleblaster.perspectives.mvc.events.ModifyEvent;
import org.brailleblaster.perspectives.mvc.events.XMLCaretEvent;
import org.brailleblaster.perspectives.mvc.modules.views.DebugModule;
import org.brailleblaster.settings.UTDManager;
import org.brailleblaster.utd.internal.xml.XMLHandler;
import org.brailleblaster.util.Notify;
import org.brailleblaster.wordprocessor.WPManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 ?2\u00020\u0001:\u0001?B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010!\u001a\u00020\"H\u0016J\u0016\u0010*\u001a\u00020\"2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020%0$H\u0002J\u0016\u0010,\u001a\u00020\"2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020%0$H\u0002J\u0016\u0010-\u001a\u00020\"2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020%0$H\u0002J\u001e\u0010.\u001a\u00020\u00162\f\u0010+\u001a\b\u0012\u0004\u0012\u00020%0$2\u0006\u0010/\u001a\u00020\u0016H\u0002J\u0016\u00100\u001a\u00020\u001c2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020%0$H\u0002J\u0016\u00101\u001a\u00020\"2\u000e\u00102\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010%0$J\u0006\u00103\u001a\u00020\"J\b\u00104\u001a\u00020\"H\u0016J\b\u00105\u001a\u00020\"H\u0016J\b\u0010>\u001a\u00020\u001cH\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u0017\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0017\u0010(\u001a\b\u0012\u0004\u0012\u00020%0$8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010'R\u0014\u00106\u001a\u0002078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b8\u00109R\u0014\u0010:\u001a\u00020;8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b<\u0010=\u00a8\u0006@"}, d2={"Lorg/brailleblaster/math/spatial/Matrix;", "Lorg/brailleblaster/math/spatial/ISpatialMathContainer;", "<init>", "()V", "settings", "Lorg/brailleblaster/math/spatial/MatrixSettings;", "getSettings", "()Lorg/brailleblaster/math/spatial/MatrixSettings;", "setSettings", "(Lorg/brailleblaster/math/spatial/MatrixSettings;)V", "lines", "", "Lorg/brailleblaster/math/spatial/Line;", "getLines", "()Ljava/util/List;", "cells", "Lorg/brailleblaster/math/spatial/MathText;", "widget", "Lorg/brailleblaster/math/spatial/MatrixWidget;", "getWidget", "()Lorg/brailleblaster/math/spatial/MatrixWidget;", "widestLine", "", "getWidestLine", "()I", "setWidestLine", "(I)V", "blank", "", "getBlank", "()Z", "setBlank", "(Z)V", "format", "", "brailleCells", "Ljava/util/ArrayList;", "", "getBrailleCells", "()Ljava/util/ArrayList;", "asciiCells", "getAsciiCells", "formatSkinny", "asciiMath", "formatIndent", "formatBlankBlock", "getLongestSegmentInColumn", "column", "needWide", "setPrintCells", "array", "setPrintCellsFromModel", "saveSettings", "loadSettingsFromFile", "typeEnum", "Lorg/brailleblaster/math/spatial/SpatialMathEnum$SpatialMathContainers;", "getTypeEnum", "()Lorg/brailleblaster/math/spatial/SpatialMathEnum$SpatialMathContainers;", "json", "Lorg/brailleblaster/math/spatial/ISpatialMathContainerJson;", "getJson", "()Lorg/brailleblaster/math/spatial/ISpatialMathContainerJson;", "preFormatChecks", "Companion", "brailleblaster-core"})
public final class Matrix
implements ISpatialMathContainer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private MatrixSettings settings = new MatrixSettings();
    @NotNull
    private final List<Line> lines = new ArrayList();
    @NotNull
    private final List<MathText> cells = new ArrayList();
    @NotNull
    private final MatrixWidget widget = new MatrixWidget();
    private int widestLine;
    private boolean blank;
    @NotNull
    private static final String USER_SETTINGS_COLUMN = "mx.column";
    @NotNull
    private static final String USER_SETTINGS_ROW = "mx.row";
    @NotNull
    private static final String USER_SETTINGS_OVERFLOW = "mx.overflow";
    @NotNull
    private static final String USER_SETTINGS_GROUPING = "mx.grouping";
    @NotNull
    private static final String USER_SETTINGS_ELLIPSIS = "mx.ellipsis";
    @NotNull
    private static final Logger log;

    public Matrix() {
        this.loadSettingsFromFile();
    }

    @Override
    @NotNull
    public MatrixSettings getSettings() {
        return this.settings;
    }

    public void setSettings(@NotNull MatrixSettings matrixSettings) {
        Intrinsics.checkNotNullParameter((Object)matrixSettings, (String)"<set-?>");
        this.settings = matrixSettings;
    }

    @Override
    @NotNull
    public List<Line> getLines() {
        return this.lines;
    }

    @Override
    @NotNull
    public MatrixWidget getWidget() {
        return this.widget;
    }

    @Override
    public int getWidestLine() {
        return this.widestLine;
    }

    @Override
    public void setWidestLine(int n) {
        this.widestLine = n;
    }

    @Override
    public boolean getBlank() {
        return this.blank;
    }

    @Override
    public void setBlank(boolean bl) {
        this.blank = bl;
    }

    @Override
    public void format() {
        this.getLines().clear();
        this.setPrintCellsFromModel();
        ArrayList<String> brailleCells = this.getBrailleCells();
        if (this.needWide(brailleCells)) {
            if (MatrixConstants.Wide.BLOCK_BLANK == this.getSettings().getWideType()) {
                Companion.matrixLog("Formatting wide matrix, block blank");
                this.formatBlankBlock(brailleCells);
            } else {
                Companion.matrixLog("Formatting wide matrix, indent");
                try {
                    this.formatIndent(brailleCells);
                }
                catch (RuntimeException runtimeException) {
                    Notify.notify$default(Notify.INSTANCE, MatrixConstants.FORMAT_INDENT_TOO_WIDE_WARNING, Notify.ALERT_SHELL_NAME, false, 4, null);
                }
            }
        } else {
            Companion.matrixLog("Formatting skinny matrix");
            this.formatSkinny(brailleCells);
        }
    }

    @NotNull
    public final ArrayList<String> getBrailleCells() {
        ArrayList<String> brailleCells = new ArrayList<String>();
        for (MathText cell : this.cells) {
            brailleCells.add(cell.braille);
        }
        return brailleCells;
    }

    @NotNull
    public final ArrayList<String> getAsciiCells() {
        ArrayList<String> asciiCells = new ArrayList<String>();
        for (MathText cell : this.cells) {
            asciiCells.add(cell.print);
        }
        return asciiCells;
    }

    private final void formatSkinny(ArrayList<String> asciiMath) {
        int n = this.getSettings().getRows();
        for (int i = 0; i < n; ++i) {
            Line l = new Line();
            l.getElements().add(l.getTextSegment(MatrixConstants.BracketType.Companion.getLeft(this.getSettings().getBracketType())));
            int n2 = this.getSettings().getCols();
            for (int j = 0; j < n2; ++j) {
                String s;
                Intrinsics.checkNotNullExpressionValue((Object)asciiMath.get(i * this.getSettings().getCols() + j), (String)"get(...)");
                l.getElements().add(l.getTextSegment(s));
                if (j == this.getSettings().getCols() - 1) continue;
                l.getElements().add(l.getWhitespaceSegment(Matrix.Companion.calculateWhitespace(s.length(), this.getLongestSegmentInColumn(asciiMath, j))));
            }
            l.getElements().add(l.getTextSegment(MatrixConstants.BracketType.Companion.getRight(this.getSettings().getBracketType())));
            this.getLines().add(l);
        }
    }

    private final void formatIndent(ArrayList<String> asciiMath) {
        int cellsAllowed = UTDManager.Companion.getCellsPerLine(WPManager.Companion.getInstance().getController());
        int n = this.getSettings().getCols();
        for (int i = 0; i < n; ++i) {
            int n2 = this.getSettings().getRows();
            for (int j = 0; j < n2; ++j) {
                String s;
                Line l = new Line();
                l.getElements().add(l.getWhitespaceSegment(2 * i));
                if (i == 0) {
                    l.getElements().add(l.getTextSegment(MatrixConstants.BracketType.Companion.getLeft(this.getSettings().getBracketType())));
                }
                Intrinsics.checkNotNullExpressionValue((Object)asciiMath.get(i + this.getSettings().getCols() * j), (String)"get(...)");
                l.getElements().add(l.getTextSegment(s));
                if (i == this.getSettings().getCols() - 1) {
                    l.getElements().add(l.getTextSegment(MatrixConstants.BracketType.Companion.getRight(this.getSettings().getBracketType())));
                }
                if (l.length() > cellsAllowed) {
                    throw new RuntimeException("Matrix formatting indentation failed");
                }
                this.getLines().add(l);
            }
        }
    }

    private final void formatBlankBlock(ArrayList<String> asciiMath) {
        int columns = this.getSettings().getCols();
        int bracketWidth = this.getSettings().getBracketType().getLabel().length();
        int cellsAllowed = UTDManager.Companion.getCellsPerLine(WPManager.Companion.getInstance().getController());
        int cellWidth = (cellsAllowed - (bracketWidth - 2) - (columns - 1)) / columns;
        int n = this.getSettings().getRows();
        for (int i = 0; i < n; ++i) {
            ArrayList<String> rowElements = new ArrayList<String>();
            int n2 = this.getSettings().getCols();
            for (int j = 0; j < n2; ++j) {
                String s;
                Intrinsics.checkNotNullExpressionValue((Object)asciiMath.get(i * this.getSettings().getCols() + j), (String)"get(...)");
                rowElements.add(s);
            }
            while (!Matrix.Companion.doneRenderingRow(rowElements)) {
                Line l = new Line();
                l.getElements().add(l.getTextSegment(MatrixConstants.BracketType.Companion.getLeft(this.getSettings().getBracketType())));
                String s = Matrix.Companion.makeLine(rowElements, cellWidth);
                l.getElements().add(l.getTextSegment(s));
                l.getElements().add(l.getTextSegment(MatrixConstants.BracketType.Companion.getRight(this.getSettings().getBracketType())));
                this.getLines().add(l);
            }
            if (MathModuleUtils.isNemeth() || i + 1 >= this.getSettings().getRows()) continue;
            Line l = new Line();
            l.getElements().add(l.getTextSegment(MatrixConstants.BracketType.Companion.getLeft(this.getSettings().getBracketType())));
            String s = Matrix.Companion.makeLine(rowElements, cellWidth);
            l.getElements().add(l.getTextSegment(s));
            l.getElements().add(l.getTextSegment(MatrixConstants.BracketType.Companion.getRight(this.getSettings().getBracketType())));
            this.getLines().add(l);
        }
    }

    private final int getLongestSegmentInColumn(ArrayList<String> asciiMath, int column) {
        int longest = 0;
        int n = this.getSettings().getRows();
        for (int i = 0; i < n; ++i) {
            String s;
            Intrinsics.checkNotNullExpressionValue((Object)asciiMath.get(this.getSettings().getCols() * i + column), (String)"get(...)");
            if (s.length() <= longest) continue;
            longest = s.length();
        }
        return longest;
    }

    private final boolean needWide(ArrayList<String> asciiMath) {
        int startingWidth;
        int columns = this.getSettings().getCols();
        int rows = this.getSettings().getRows();
        int bracketWidth = this.getSettings().getBracketType().getLabel().length();
        int cellsAllowed = UTDManager.Companion.getCellsPerLine(WPManager.Companion.getInstance().getController());
        int thisWidth = startingWidth = bracketWidth * 2;
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                String colString;
                Intrinsics.checkNotNullExpressionValue((Object)asciiMath.get(columns * i + j), (String)"get(...)");
                thisWidth += colString.length();
            }
            if (thisWidth > cellsAllowed) {
                Companion.matrixLog("Too wide, cells are " + thisWidth);
                return true;
            }
            thisWidth = startingWidth;
        }
        Companion.matrixLog("Cells are appropriate width, cells are " + thisWidth);
        return false;
    }

    public final void setPrintCells(@NotNull ArrayList<String> array) {
        Intrinsics.checkNotNullParameter(array, (String)"array");
        this.cells.clear();
        Iterator<String> iterator = array.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<String> iterator2 = iterator;
        while (iterator2.hasNext()) {
            String s;
            String string = s = iterator2.next();
            Intrinsics.checkNotNull((Object)string);
            MathText mt = new MathText(string, MathModuleUtils.INSTANCE.translateMathPrint(s), false);
            this.cells.add(mt);
        }
    }

    public final void setPrintCellsFromModel() {
        this.cells.clear();
        int n = ((Collection)this.getSettings().getModel()).size();
        for (int i = 0; i < n; ++i) {
            int n2 = ((Collection)this.getSettings().getModel().get(i)).size();
            for (int j = 0; j < n2; ++j) {
                String s = this.getSettings().getModel().get((int)i).get((int)j).text;
                boolean ellipsis = this.getSettings().getModel().get(i).get(j).isEllipsis();
                MathText mt = null;
                if (SpatialMathEnum.Translation.ASCII_MATH == this.getSettings().getTranslation()) {
                    if (StringsKt.isBlank((CharSequence)s) && this.getSettings().isAddEllipses()) {
                        this.getSettings().getModel().get(i).get(j).setEllipsis(true);
                        mt = MathModuleUtils.isNemeth() ? new MathText("cdots", MathModuleUtils.INSTANCE.translateAsciiMath("'''"), false) : new MathText("...", MathModuleUtils.INSTANCE.translateAsciiMath("..."), false);
                    } else {
                        mt = new MathText(s, MathModuleUtils.INSTANCE.translateAsciiMath(s), false);
                    }
                } else if (SpatialMathEnum.Translation.DIRECT == this.getSettings().getTranslation()) {
                    if (StringsKt.isBlank((CharSequence)s) && this.getSettings().isAddEllipses()) {
                        this.getSettings().getModel().get(i).get(j).setEllipsis(true);
                        mt = MathModuleUtils.isNemeth() ? new MathText("cdots", MathModuleUtils.INSTANCE.translateAsciiMath("'''"), false) : new MathText("...", MathModuleUtils.INSTANCE.translateAsciiMath("..."), false);
                    } else {
                        mt = new MathText(s, s, false);
                    }
                } else if (StringsKt.isBlank((CharSequence)s) && this.getSettings().isAddEllipses()) {
                    this.getSettings().getModel().get(i).get(j).setEllipsis(true);
                    mt = MathModuleUtils.isNemeth() ? new MathText("cdots", MathModuleUtils.INSTANCE.translateMathPrint("'''"), false) : new MathText("...", MathModuleUtils.INSTANCE.translateMainPrint("..."), false);
                } else {
                    mt = MathModuleUtils.isNemeth() || this.getSettings().getPassage() == SpatialMathEnum.Passage.NUMERIC ? (ellipsis ? new MathText("cdots", MathModuleUtils.INSTANCE.translateMathPrint("'''"), false) : new MathText(s, MathModuleUtils.INSTANCE.translateMathPrint(s), false)) : new MathText(s, MathModuleUtils.INSTANCE.translateMainPrint(s), false);
                }
                this.cells.add(mt);
            }
        }
    }

    @Override
    public void saveSettings() {
        BBIni.getPropertyFileManager().saveAsInt(USER_SETTINGS_COLUMN, this.getSettings().getCols());
        BBIni.getPropertyFileManager().saveAsInt(USER_SETTINGS_ROW, this.getSettings().getRows());
        BBIni.getPropertyFileManager().saveAsEnum(USER_SETTINGS_OVERFLOW, (Enum)this.getSettings().getWideType());
        BBIni.getPropertyFileManager().saveAsEnum(USER_SETTINGS_GROUPING, (Enum)this.getSettings().getBracketType());
        BBIni.getPropertyFileManager().saveAsBoolean(USER_SETTINGS_ELLIPSIS, this.getSettings().isAddEllipses());
    }

    @Override
    public void loadSettingsFromFile() {
        String colString = BBIni.getPropertyFileManager().getProperty(USER_SETTINGS_COLUMN, "3");
        this.getSettings().setCols(Integer.parseInt(colString));
        String rowString = BBIni.getPropertyFileManager().getProperty(USER_SETTINGS_ROW, "3");
        this.getSettings().setRows(Integer.parseInt(rowString));
        String wideString = BBIni.getPropertyFileManager().getProperty(USER_SETTINGS_OVERFLOW, MatrixSettings.DEFAULT_WIDE.name());
        MatrixConstants.Wide wide = MatrixConstants.Wide.valueOf(wideString);
        this.getSettings().setWideType(wide);
        String bracketString = BBIni.getPropertyFileManager().getProperty(USER_SETTINGS_GROUPING, MatrixSettings.DEFAULT_BRACKET.name());
        MatrixConstants.BracketType bracket = MatrixConstants.BracketType.valueOf(bracketString);
        this.getSettings().setBracketType(bracket);
        String ellipsis = BBIni.getPropertyFileManager().getProperty(USER_SETTINGS_ELLIPSIS, "false");
        this.getSettings().setAddEllipses(Boolean.parseBoolean(ellipsis));
    }

    @Override
    @NotNull
    public SpatialMathEnum.SpatialMathContainers getTypeEnum() {
        return SpatialMathEnum.SpatialMathContainers.MATRIX;
    }

    @Override
    @NotNull
    public ISpatialMathContainerJson getJson() {
        return new MatrixJson().containerToJson(this);
    }

    @Override
    public boolean preFormatChecks() {
        return true;
    }

    @JvmStatic
    public static final void matrixLog(@Nullable String s) {
        Companion.matrixLog(s);
    }

    @JvmStatic
    public static final boolean middleMatrix(@NotNull TextMapElement currentElement) {
        return Companion.middleMatrix(currentElement);
    }

    @JvmStatic
    public static final boolean currentIsMatrix() {
        return Companion.currentIsMatrix();
    }

    @JvmStatic
    @NotNull
    public static final Element initialize(@NotNull Node n) {
        return Companion.initialize(n);
    }

    static {
        Logger logger = LoggerFactory.getLogger(Matrix.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        log = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0005H\u0007J\u001e\u0010\u000f\u001a\u00020\u00052\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0016\u0010\u0014\u001a\u00020\u00152\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u0011H\u0002J\u0018\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0013H\u0002J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0010\u0010 \u001a\u00020\u00152\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fJ\b\u0010!\u001a\u00020\u0015H\u0007J\u0010\u0010\"\u001a\u00020#2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001dJ\u0010\u0010$\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020\u001fH\u0007J\u0006\u0010&\u001a\u00020\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/brailleblaster/math/spatial/Matrix$Companion;", "", "<init>", "()V", "USER_SETTINGS_COLUMN", "", "USER_SETTINGS_ROW", "USER_SETTINGS_OVERFLOW", "USER_SETTINGS_GROUPING", "USER_SETTINGS_ELLIPSIS", "log", "Lorg/slf4j/Logger;", "matrixLog", "", "s", "makeLine", "rowElements", "Ljava/util/ArrayList;", "cellWidth", "", "doneRenderingRow", "", "calculateWhitespace", "length", "longestSegmentInColumn", "middleMatrix", "currentElement", "Lorg/brailleblaster/perspectives/braille/mapping/elements/TextMapElement;", "getMatrixParent", "Lnu/xom/Element;", "node", "Lnu/xom/Node;", "isMatrix", "currentIsMatrix", "getContainerFromElement", "Lorg/brailleblaster/math/spatial/Matrix;", "initialize", "n", "deleteMatrix", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void matrixLog(@Nullable String s) {
            if (DebugModule.enabled) {
                log.error(s);
            } else {
                log.debug(s);
            }
        }

        private final String makeLine(ArrayList<String> rowElements, int cellWidth) {
            StringBuilder s = new StringBuilder();
            int n = ((Collection)rowElements).size();
            for (int i = 0; i < n; ++i) {
                String string;
                Intrinsics.checkNotNullExpressionValue((Object)rowElements.get(i), (String)"get(...)");
                int length = string.length();
                if (length > cellWidth) {
                    String start = StringsKt.take((String)string, (int)cellWidth);
                    String end = StringsKt.drop((String)string, (int)cellWidth);
                    s.append(start);
                    rowElements.set(i, end);
                } else {
                    s.append(string).append(StringsKt.repeat((CharSequence)" ", (int)(cellWidth - string.length())));
                    rowElements.set(i, "");
                }
                if (i == rowElements.size() - 1) continue;
                s.append(" ");
            }
            String string = s.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        private final boolean doneRenderingRow(ArrayList<String> rowElements) {
            Iterator<String> iterator = rowElements.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator<String> iterator2 = iterator;
            while (iterator2.hasNext()) {
                String s;
                Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
                if (!(((CharSequence)s).length() > 0)) continue;
                return false;
            }
            return true;
        }

        private final int calculateWhitespace(int length, int longestSegmentInColumn) {
            return longestSegmentInColumn + 1 - length;
        }

        @JvmStatic
        public final boolean middleMatrix(@NotNull TextMapElement currentElement) {
            Intrinsics.checkNotNullParameter((Object)currentElement, (String)"currentElement");
            if (currentElement.getNode() == null || currentElement instanceof LineBreakElement) {
                return false;
            }
            Node node = currentElement.getNode();
            Intrinsics.checkNotNullExpressionValue((Object)node, (String)"getNode(...)");
            Element matrix = XMLHandler.Companion.ancestorVisitorElement(node, Companion::middleMatrix$lambda$0);
            return matrix != null;
        }

        @Nullable
        public final Element getMatrixParent(@NotNull Node node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            return XMLHandler.Companion.ancestorVisitorElement(node, Companion::getMatrixParent$lambda$0);
        }

        public final boolean isMatrix(@Nullable Node node) {
            if (node == null || node.getDocument() == null) {
                return false;
            }
            return XMLHandler.Companion.ancestorElementIs(node, Companion::isMatrix$lambda$0);
        }

        @JvmStatic
        public final boolean currentIsMatrix() {
            Node current = (Node)XMLHandler.Companion.ancestorVisitorElement(WPManager.Companion.getInstance().getController().getSimpleManager().getCurrentCaret().getNode(), Companion::currentIsMatrix$lambda$0);
            boolean isWhitespace = WPManager.Companion.getInstance().getController().getMapList().getCurrent() instanceof WhiteSpaceElement;
            return !isWhitespace && current != null;
        }

        @NotNull
        public final Matrix getContainerFromElement(@Nullable Element currentElement) {
            Element current = currentElement;
            Matrix matrix = new Matrix();
            if (BBX.CONTAINER.MATRIX.isA((Node)current)) {
                if (!BBX.CONTAINER.MATRIX.ATTRIB_VERSION.has((Node)current)) {
                    current = VersionConverter.convertMatrix(current);
                }
                Object t = BBX.CONTAINER.MATRIX.JSON_MATRIX.get(current);
                Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type org.brailleblaster.math.spatial.MatrixJson");
                MatrixJson json = (MatrixJson)t;
                ISpatialMathContainer iSpatialMathContainer = json.jsonToContainer();
                Intrinsics.checkNotNull((Object)iSpatialMathContainer, (String)"null cannot be cast to non-null type org.brailleblaster.math.spatial.Matrix");
                matrix = (Matrix)iSpatialMathContainer;
            }
            return matrix;
        }

        @JvmStatic
        @NotNull
        public final Element initialize(@NotNull Node n) {
            Intrinsics.checkNotNullParameter((Object)n, (String)"n");
            Element e = (Element)n;
            Matrix t = this.getContainerFromElement(e);
            t.format();
            Element newElement = BBX.CONTAINER.MATRIX.create(t);
            try {
                Intrinsics.checkNotNull((Object)newElement);
                SpatialMathBlock.INSTANCE.format(newElement, t.getLines());
            }
            catch (MathFormattingException e1) {
                log.warn("Problem formatting spatial block when initialising node", (Throwable)e1);
            }
            e.getParent().replaceChild((Node)e, (Node)newElement);
            Intrinsics.checkNotNull((Object)newElement);
            return newElement;
        }

        public final void deleteMatrix() {
            Element current;
            Element element = current = XMLHandler.Companion.ancestorVisitorElement(WPManager.Companion.getInstance().getController().getSimpleManager().getCurrentCaret().getNode(), Companion::deleteMatrix$lambda$0);
            Intrinsics.checkNotNull((Object)element);
            Node previous = XMLHandler.Companion.previousSiblingNode((Node)element);
            ParentNode parent = current.getParent();
            parent.removeChild((Node)current);
            BBSimpleManager bBSimpleManager = WPManager.Companion.getInstance().getController().getSimpleManager();
            Node[] nodeArray = new Node[1];
            Intrinsics.checkNotNull((Object)parent);
            nodeArray[0] = parent;
            bBSimpleManager.dispatchEvent(new ModifyEvent(Sender.TEXT, true, nodeArray));
            if (previous != null) {
                WPManager.Companion.getInstance().getController().getSimpleManager().dispatchEvent(new XMLCaretEvent(Sender.TEXT, new XMLNodeCaret(previous, null, 2, null), null, 4, null));
            }
        }

        private static final boolean middleMatrix$lambda$0(Element node) {
            return BBX.CONTAINER.MATRIX.isA((Node)node);
        }

        private static final boolean getMatrixParent$lambda$0(Element e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            return BBX.CONTAINER.MATRIX.isA((Node)e);
        }

        private static final boolean isMatrix$lambda$0(Element e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            return BBX.CONTAINER.MATRIX.isA((Node)e);
        }

        private static final boolean currentIsMatrix$lambda$0(Element node) {
            return BBX.CONTAINER.MATRIX.isA((Node)node);
        }

        private static final boolean deleteMatrix$lambda$0(Element node) {
            return BBX.CONTAINER.MATRIX.isA((Node)node);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

