/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.math.spatial;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.brailleblaster.math.spatial.ISpatialMathContainer;
import org.brailleblaster.math.spatial.ISpatialMathWidget;
import org.brailleblaster.math.spatial.Matrix;
import org.brailleblaster.math.spatial.MatrixCell;
import org.brailleblaster.math.spatial.MatrixConstants;
import org.brailleblaster.math.spatial.MatrixSettings;
import org.brailleblaster.math.spatial.SpatialMathDispatcher;
import org.brailleblaster.math.spatial.SpatialMathEnum;
import org.brailleblaster.perspectives.mvc.modules.views.DebugModule;
import org.brailleblaster.utils.swt.EasySWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 -2\u00020\u0001:\u0001-B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001a\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\b\u0010\u0019\u001a\u00020\u0013H\u0002J\b\u0010\u001a\u001a\u00020\u0013H\u0016J\b\u0010\u001b\u001a\u00020\u0013H\u0002J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u0015H\u0016J\b\u0010 \u001a\u00020\u0013H\u0016J \u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\"2\u0006\u0010&\u001a\u00020\"H\u0016J\u0018\u0010'\u001a\u00020\u00132\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\"H\u0002J\u0018\u0010(\u001a\u00020\u00132\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\"H\u0002J\u0018\u0010)\u001a\u00020\u00132\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\"H\u0002J\u001a\u0010*\u001a\u00020\u00132\b\u0010#\u001a\u0004\u0018\u00010$2\b\u0010&\u001a\u0004\u0018\u00010\"J\u001a\u0010+\u001a\u00020\u00132\b\u0010#\u001a\u0004\u0018\u00010$2\b\u0010%\u001a\u0004\u0018\u00010\"J\u001a\u0010,\u001a\u00020\u00132\b\u0010#\u001a\u0004\u0018\u00010$2\b\u0010%\u001a\u0004\u0018\u00010\"RJ\u0010\u0004\u001a2\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u00070\u0005j\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007`\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006."}, d2={"Lorg/brailleblaster/math/spatial/MatrixWidget;", "Lorg/brailleblaster/math/spatial/ISpatialMathWidget;", "<init>", "()V", "entries", "Ljava/util/ArrayList;", "Lorg/eclipse/swt/custom/StyledText;", "Lkotlin/collections/ArrayList;", "getEntries", "()Ljava/util/ArrayList;", "setEntries", "(Ljava/util/ArrayList;)V", "matrix", "Lorg/brailleblaster/math/spatial/Matrix;", "getMatrix", "()Lorg/brailleblaster/math/spatial/Matrix;", "setMatrix", "(Lorg/brailleblaster/math/spatial/Matrix;)V", "fillDebug", "", "t", "Lorg/brailleblaster/math/spatial/ISpatialMathContainer;", "makeRowsAndColumns", "g3", "Lorg/eclipse/swt/widgets/Group;", "defaultDebug", "onOpen", "loadMathDataIntoTextBoxes", "getWidget", "Lorg/eclipse/swt/widgets/Composite;", "parent", "container", "extractText", "addMenuItems", "Lorg/eclipse/swt/widgets/Menu;", "shell", "Lorg/eclipse/swt/widgets/Shell;", "menu", "settingsMenu", "addDebugMenu", "addColumnMenu", "addRowMenu", "addSettingsMenu", "addGroupingsMenu", "addOverflowMenu", "Companion", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nMatrixWidget.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MatrixWidget.kt\norg/brailleblaster/math/spatial/MatrixWidget\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,239:1\n1596#2:240\n1629#2,3:241\n1586#2:244\n1661#2,3:245\n1632#2:248\n1391#2:249\n1480#2,5:250\n1915#2,2:255\n*S KotlinDebug\n*F\n+ 1 MatrixWidget.kt\norg/brailleblaster/math/spatial/MatrixWidget\n*L\n55#1:240\n55#1:241,3\n56#1:244\n56#1:245,3\n55#1:248\n66#1:249\n66#1:250,5\n67#1:255,2\n*E\n"})
public final class MatrixWidget
implements ISpatialMathWidget {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private ArrayList<ArrayList<StyledText>> entries = new ArrayList();
    @Nullable
    private Matrix matrix;
    @NotNull
    private static final String[] AVAIL_ROWS_COLS;

    @NotNull
    public final ArrayList<ArrayList<StyledText>> getEntries() {
        return this.entries;
    }

    public final void setEntries(@NotNull ArrayList<ArrayList<StyledText>> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, (String)"<set-?>");
        this.entries = arrayList;
    }

    @Nullable
    public final Matrix getMatrix() {
        return this.matrix;
    }

    public final void setMatrix(@Nullable Matrix matrix) {
        this.matrix = matrix;
    }

    @Override
    public void fillDebug(@NotNull ISpatialMathContainer t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        this.matrix = (Matrix)t;
        this.defaultDebug();
    }

    private final void makeRowsAndColumns(Group g3, Matrix matrix) {
        Matrix matrix2 = matrix;
        Intrinsics.checkNotNull((Object)matrix2);
        int n = matrix2.getSettings().getRows();
        for (int i = 0; i < n; ++i) {
            Group g = EasySWT.makeGroup((Composite)((Composite)g3), (int)0, (int)matrix.getSettings().getCols(), (boolean)false);
            ArrayList array = new ArrayList();
            this.entries.add(array);
            int n2 = matrix.getSettings().getCols();
            for (int j = 0; j < n2; ++j) {
                StyledText st = new StyledText((Composite)g, 832);
                st.setData((Object)new GridData(4, 4, true, true));
                st.setText(StringsKt.repeat((CharSequence)" ", (int)50) + "\n\n");
                this.entries.get(i).add(st);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void defaultDebug() {
        void $this$mapIndexedTo$iv$iv;
        void $this$mapIndexed$iv;
        Matrix matrix = this.matrix;
        Intrinsics.checkNotNull((Object)matrix);
        Iterable iterable = this.entries;
        MatrixSettings matrixSettings = matrix.getSettings();
        boolean $i$f$mapIndexed = false;
        void var3_4 = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void $this$mapTo$iv$iv;
            void r;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ArrayList arrayList = (ArrayList)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = (Iterable)CollectionsKt.getIndices((Collection)((Collection)r));
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void j;
                void i;
                int item$iv$iv2;
                int n3 = item$iv$iv2 = ((IntIterator)iterator).nextInt();
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                Matrix matrix2 = this.matrix;
                Intrinsics.checkNotNull((Object)matrix2);
                collection2.add(new MatrixCell(String.valueOf((int)(i * matrix2.getSettings().getCols() + j + true)), false));
            }
            collection.add(CollectionsKt.toMutableList((Collection)((List)destination$iv$iv2)));
        }
        matrixSettings.setModel(CollectionsKt.toMutableList((Collection)((List)destination$iv$iv)));
    }

    @Override
    public void onOpen() {
        this.loadMathDataIntoTextBoxes();
    }

    /*
     * WARNING - void declaration
     */
    private final void loadMathDataIntoTextBoxes() {
        void $this$flatMapTo$iv$iv;
        Matrix matrix = this.matrix;
        Intrinsics.checkNotNull((Object)matrix);
        Iterable iterable = matrix.getSettings().getModel();
        Matrix matrix2 = this.matrix;
        Intrinsics.checkNotNull((Object)matrix2);
        Iterable $this$flatMap$iv = CollectionsKt.zip((Iterable)iterable, (Iterable)matrix2.getWidget().entries);
        boolean $i$f$flatMap = false;
        Iterable iterable2 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Pair pair = (Pair)element$iv$iv;
            boolean bl = false;
            List s = (List)pair.component1();
            ArrayList e = (ArrayList)pair.component2();
            Iterable list$iv$iv = CollectionsKt.zip((Iterable)s, (Iterable)e);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            MatrixCell s = (MatrixCell)pair.component1();
            StyledText e = (StyledText)pair.component2();
            e.setText(s.isEllipsis() ? "" : s.text);
        }
    }

    @Override
    @NotNull
    public Composite getWidget(@NotNull Composite parent, @NotNull ISpatialMathContainer container) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        this.entries.clear();
        this.matrix = (Matrix)container;
        Group g3 = EasySWT.makeGroup((Composite)parent, (int)0, (int)1, (boolean)false);
        this.makeRowsAndColumns(g3, this.matrix);
        return parent;
    }

    @Override
    public void extractText() {
        Matrix matrix = this.matrix;
        Intrinsics.checkNotNull((Object)matrix);
        matrix.getSettings().getModel().clear();
        List array = new ArrayList();
        int n = ((Collection)this.entries).size();
        for (int i = 0; i < n; ++i) {
            ArrayList row = new ArrayList();
            array.add(row);
            int n2 = ((Collection)this.entries.get(i)).size();
            for (int j = 0; j < n2; ++j) {
                List list = (List)array.get(i);
                String string = this.entries.get(i).get(j).getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                list.add(new MatrixCell(string, false));
            }
        }
        Matrix matrix2 = this.matrix;
        Intrinsics.checkNotNull((Object)matrix2);
        matrix2.getSettings().setModel(array);
    }

    @Override
    @NotNull
    public Menu addMenuItems(@NotNull Shell shell, @NotNull Menu menu, @NotNull Menu settingsMenu) {
        Intrinsics.checkNotNullParameter((Object)shell, (String)"shell");
        Intrinsics.checkNotNullParameter((Object)menu, (String)"menu");
        Intrinsics.checkNotNullParameter((Object)settingsMenu, (String)"settingsMenu");
        this.addSettingsMenu(shell, settingsMenu);
        this.addGroupingsMenu(shell, menu);
        this.addOverflowMenu(shell, menu);
        this.addRowMenu(shell, menu);
        this.addColumnMenu(shell, menu);
        if (DebugModule.enabled) {
            this.addDebugMenu(shell, menu);
        }
        return menu;
    }

    private final void addDebugMenu(Shell shell, Menu menu) {
        MenuItem cascadeMenu = new MenuItem(menu, 64);
        cascadeMenu.setText("Debug Matrix");
        Menu dropDownMenu = new Menu((Decorations)shell, 4);
        cascadeMenu.setMenu(dropDownMenu);
        MenuItem numericPassage = new MenuItem(dropDownMenu, 0);
        numericPassage.setText("Fill Overflow");
        numericPassage.addListener(13, arg_0 -> MatrixWidget.addDebugMenu$lambda$0(this, arg_0));
        MenuItem ellipsesButton = new MenuItem(dropDownMenu, 0);
        ellipsesButton.setText("Fill Skinny");
        ellipsesButton.addListener(13, arg_0 -> MatrixWidget.addDebugMenu$lambda$1(this, arg_0));
    }

    private final void addColumnMenu(Shell shell, Menu menu) {
        MenuItem cascadeMenu = new MenuItem(menu, 64);
        cascadeMenu.setText(MatrixConstants.INSTANCE.getCOL_LABEL());
        Menu dropDownMenu = new Menu((Decorations)shell, 4);
        cascadeMenu.setMenu(dropDownMenu);
        for (String s : AVAIL_ROWS_COLS) {
            MenuItem blankBlock = new MenuItem(dropDownMenu, 16);
            blankBlock.setText(s);
            Matrix matrix = this.matrix;
            Intrinsics.checkNotNull((Object)matrix);
            blankBlock.setSelection(matrix.getSettings().getCols() == Integer.parseInt(s));
            blankBlock.addListener(13, arg_0 -> MatrixWidget.addColumnMenu$lambda$0(blankBlock, this, s, arg_0));
        }
    }

    private final void addRowMenu(Shell shell, Menu menu) {
        MenuItem cascadeMenu = new MenuItem(menu, 64);
        cascadeMenu.setText(MatrixConstants.INSTANCE.getROW_LABEL());
        Menu dropDownMenu = new Menu((Decorations)shell, 4);
        cascadeMenu.setMenu(dropDownMenu);
        for (String s : AVAIL_ROWS_COLS) {
            MenuItem blankBlock = new MenuItem(dropDownMenu, 16);
            blankBlock.setText(s);
            Matrix matrix = this.matrix;
            Intrinsics.checkNotNull((Object)matrix);
            blankBlock.setSelection(matrix.getSettings().getRows() == Integer.parseInt(s));
            blankBlock.addListener(13, arg_0 -> MatrixWidget.addRowMenu$lambda$0(blankBlock, this, s, arg_0));
        }
    }

    public final void addSettingsMenu(@Nullable Shell shell, @Nullable Menu settingsMenu) {
        MenuItem cascadeMenu = new MenuItem(settingsMenu, 64);
        cascadeMenu.setText(MatrixConstants.INSTANCE.getMATRIX_TRANSLATION());
        Menu dropDownMenu = new Menu((Decorations)shell, 4);
        cascadeMenu.setMenu(dropDownMenu);
        for (SpatialMathEnum.Translation bt : SpatialMathEnum.Translation.getEntries()) {
            MenuItem blankBlock = new MenuItem(dropDownMenu, 16);
            blankBlock.setText(bt.getPrettyName());
            Matrix matrix = this.matrix;
            Intrinsics.checkNotNull((Object)matrix);
            blankBlock.setSelection(bt == matrix.getSettings().getTranslation());
            Matrix matrix2 = this.matrix;
            Intrinsics.checkNotNull((Object)matrix2);
            blankBlock.setSelection(bt == matrix2.getSettings().getTranslation());
            blankBlock.addListener(13, arg_0 -> MatrixWidget.addSettingsMenu$lambda$0(this, bt, arg_0));
        }
        MenuItem ellipsesButton = new MenuItem(settingsMenu, 32);
        ellipsesButton.setText(MatrixConstants.ELLIPSIS_LABEL);
        Matrix matrix = this.matrix;
        Intrinsics.checkNotNull((Object)matrix);
        ellipsesButton.setSelection(matrix.getSettings().isAddEllipses());
        ellipsesButton.addListener(13, arg_0 -> MatrixWidget.addSettingsMenu$lambda$1(this, ellipsesButton, arg_0));
    }

    public final void addGroupingsMenu(@Nullable Shell shell, @Nullable Menu menu) {
        MenuItem cascadeMenu = new MenuItem(menu, 64);
        cascadeMenu.setText(MatrixConstants.INSTANCE.getBRACKET_TYPE_LABEL());
        Menu dropDownMenu = new Menu((Decorations)shell, 4);
        cascadeMenu.setMenu(dropDownMenu);
        for (MatrixConstants.BracketType bt : MatrixConstants.BracketType.getEntries()) {
            MenuItem blankBlock = new MenuItem(dropDownMenu, 16);
            blankBlock.setText(bt.getLabel());
            Matrix matrix = this.matrix;
            Intrinsics.checkNotNull((Object)matrix);
            blankBlock.setSelection(bt == matrix.getSettings().getBracketType());
            blankBlock.addListener(13, arg_0 -> MatrixWidget.addGroupingsMenu$lambda$0(this, bt, arg_0));
        }
    }

    public final void addOverflowMenu(@Nullable Shell shell, @Nullable Menu menu) {
        MenuItem cascadeMenu = new MenuItem(menu, 64);
        cascadeMenu.setText(MatrixConstants.WIDE_LABEL);
        Menu dropDownMenu = new Menu((Decorations)shell, 4);
        cascadeMenu.setMenu(dropDownMenu);
        MenuItem blankBlock = new MenuItem(dropDownMenu, 16);
        blankBlock.setText(MatrixConstants.INSTANCE.getBLOCK_BLANK_LABEL());
        Matrix matrix = this.matrix;
        Intrinsics.checkNotNull((Object)matrix);
        blankBlock.setSelection(MatrixConstants.Wide.BLOCK_BLANK == matrix.getSettings().getWideType());
        blankBlock.addListener(13, arg_0 -> MatrixWidget.addOverflowMenu$lambda$0(this, blankBlock, arg_0));
        MenuItem indentColumn = new MenuItem(dropDownMenu, 16);
        indentColumn.setText(MatrixConstants.INSTANCE.getINDENT_COLUMN_LABEL());
        Matrix matrix2 = this.matrix;
        Intrinsics.checkNotNull((Object)matrix2);
        indentColumn.setSelection(MatrixConstants.Wide.INDENT_COLUMN == matrix2.getSettings().getWideType());
        indentColumn.addListener(13, arg_0 -> MatrixWidget.addOverflowMenu$lambda$1(this, indentColumn, arg_0));
    }

    private static final void addDebugMenu$lambda$0(MatrixWidget this$0, Event it) {
        int testLength = 12;
        int n = ((Collection)this$0.entries).size();
        for (int i = 0; i < n; ++i) {
            int n2 = ((Collection)this$0.entries.get(i)).size();
            for (int j = 0; j < n2; ++j) {
                Matrix matrix = this$0.matrix;
                Intrinsics.checkNotNull((Object)matrix);
                this$0.entries.get(i).get(j).setText(StringsKt.repeat((CharSequence)String.valueOf(i * matrix.getSettings().getCols() + j), (int)testLength));
            }
        }
    }

    private static final void addDebugMenu$lambda$1(MatrixWidget this$0, Event it) {
        int n = ((Collection)this$0.entries).size();
        for (int i = 0; i < n; ++i) {
            int n2 = ((Collection)this$0.entries.get(i)).size();
            for (int j = 0; j < n2; ++j) {
                Matrix matrix = this$0.matrix;
                Intrinsics.checkNotNull((Object)matrix);
                this$0.entries.get(i).get(j).setText(String.valueOf(i * matrix.getSettings().getCols() + j));
            }
        }
    }

    private static final void addColumnMenu$lambda$0(MenuItem $blankBlock, MatrixWidget this$0, String $s, Event it) {
        if (!$blankBlock.getSelection()) {
            return;
        }
        this$0.extractText();
        Matrix matrix = this$0.matrix;
        Intrinsics.checkNotNull((Object)matrix);
        matrix.getSettings().setCols(Integer.parseInt($s));
        SpatialMathDispatcher.INSTANCE.dispatch();
    }

    private static final void addRowMenu$lambda$0(MenuItem $blankBlock, MatrixWidget this$0, String $s, Event it) {
        if (!$blankBlock.getSelection()) {
            return;
        }
        this$0.extractText();
        Matrix matrix = this$0.matrix;
        Intrinsics.checkNotNull((Object)matrix);
        matrix.getSettings().setRows(Integer.parseInt($s));
        SpatialMathDispatcher.INSTANCE.dispatch();
    }

    private static final void addSettingsMenu$lambda$0(MatrixWidget this$0, SpatialMathEnum.Translation $bt, Event it) {
        Matrix matrix = this$0.matrix;
        Intrinsics.checkNotNull((Object)matrix);
        matrix.getSettings().setTranslation($bt);
        this$0.extractText();
        SpatialMathDispatcher.INSTANCE.dispatch();
    }

    private static final void addSettingsMenu$lambda$1(MatrixWidget this$0, MenuItem $ellipsesButton, Event it) {
        Matrix matrix = this$0.matrix;
        Intrinsics.checkNotNull((Object)matrix);
        MatrixSettings matrixSettings = matrix.getSettings();
        Matrix matrix2 = this$0.matrix;
        Intrinsics.checkNotNull((Object)matrix2);
        matrixSettings.setAddEllipses(!matrix2.getSettings().isAddEllipses());
        Matrix matrix3 = this$0.matrix;
        Intrinsics.checkNotNull((Object)matrix3);
        $ellipsesButton.setSelection(matrix3.getSettings().isAddEllipses());
    }

    private static final void addGroupingsMenu$lambda$0(MatrixWidget this$0, MatrixConstants.BracketType $bt, Event it) {
        Matrix matrix = this$0.matrix;
        Intrinsics.checkNotNull((Object)matrix);
        matrix.getSettings().setBracketType($bt);
        this$0.extractText();
        SpatialMathDispatcher.INSTANCE.dispatch();
    }

    private static final void addOverflowMenu$lambda$0(MatrixWidget this$0, MenuItem $blankBlock, Event it) {
        Matrix matrix = this$0.matrix;
        Intrinsics.checkNotNull((Object)matrix);
        MatrixSettings matrixSettings = matrix.getSettings();
        String string = $blankBlock.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        matrixSettings.setWideType(MatrixSettings.Companion.enumifyWide(string));
        this$0.extractText();
        SpatialMathDispatcher.INSTANCE.dispatch();
    }

    private static final void addOverflowMenu$lambda$1(MatrixWidget this$0, MenuItem $indentColumn, Event it) {
        Matrix matrix = this$0.matrix;
        Intrinsics.checkNotNull((Object)matrix);
        MatrixSettings matrixSettings = matrix.getSettings();
        String string = $indentColumn.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        matrixSettings.setWideType(MatrixSettings.Companion.enumifyWide(string));
        this$0.extractText();
        SpatialMathDispatcher.INSTANCE.dispatch();
    }

    static {
        String[] stringArray = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9"};
        AVAIL_ROWS_COLS = stringArray;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/brailleblaster/math/spatial/MatrixWidget$Companion;", "", "<init>", "()V", "AVAIL_ROWS_COLS", "", "", "[Ljava/lang/String;", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

