/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.math.template;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.brailleblaster.math.spatial.Line;
import org.brailleblaster.math.spatial.SpatialMathEnum;
import org.brailleblaster.math.template.Template;
import org.brailleblaster.math.template.TemplateFraction;
import org.brailleblaster.math.template.TemplateNumber;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u000bH\u0002R\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/brailleblaster/math/template/UebFractionTemplate;", "", "<init>", "()V", "templateLine", "Ljava/util/ArrayList;", "Lorg/brailleblaster/math/template/TemplateFraction;", "Lkotlin/collections/ArrayList;", "longestLine", "", "format", "Lorg/brailleblaster/math/template/Template;", "template", "addLine", "", "brailleblaster-core"})
public final class UebFractionTemplate {
    @NotNull
    private final ArrayList<TemplateFraction> templateLine = new ArrayList();
    private int longestLine;

    @NotNull
    public final Template format(@NotNull Template template) {
        SpatialMathEnum.Passage passage;
        TemplateNumber denTn;
        TemplateNumber numTn;
        TemplateNumber wholeTn;
        String denString;
        String numString;
        String wholeString;
        int i;
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        if (Template.Companion.operandsBlank(template)) {
            return template;
        }
        int components = 3;
        UebFractionTemplate $this$format_u24lambda_u240 = this;
        boolean bl = false;
        for (i = 0; i < template.getBrailleOperands().size(); i += components) {
            wholeString = template.getBrailleOperands().get(i);
            numString = template.getBrailleOperands().get(i + 1);
            denString = template.getBrailleOperands().get(i + 2);
            wholeTn = new TemplateNumber.TemplateNumberBuilder().wholeNum(wholeString).build();
            numTn = new TemplateNumber.TemplateNumberBuilder().wholeNum(numString).build();
            denTn = new TemplateNumber.TemplateNumberBuilder().wholeNum(denString).build();
            passage = template.getSettings().getPassage();
            $this$format_u24lambda_u240.templateLine.add(new TemplateFraction(wholeTn, numTn, denTn, null, passage, 8, null));
        }
        Object $this$format_u24lambda_u241 = this;
        boolean bl2 = false;
        for (i = 0; i < template.getBrailleSolutions().size(); i += components) {
            wholeString = template.getBrailleSolutions().get(i);
            numString = template.getBrailleSolutions().get(i + 1);
            denString = template.getBrailleSolutions().get(i + 2);
            wholeTn = new TemplateNumber.TemplateNumberBuilder().wholeNum(wholeString).build();
            numTn = new TemplateNumber.TemplateNumberBuilder().wholeNum(numString).build();
            denTn = new TemplateNumber.TemplateNumberBuilder().wholeNum(denString).build();
            passage = template.getSettings().getPassage();
            ((UebFractionTemplate)$this$format_u24lambda_u241).templateLine.add(new TemplateFraction(wholeTn, numTn, denTn, null, passage, 8, null));
        }
        TemplateNumber.Companion.makeColumnsEqualWidth(TemplateFraction.Companion.getWhole((List<TemplateFraction>)this.templateLine));
        TemplateNumber.Companion.makeColumnsEqualWidth(TemplateFraction.Companion.getNumerators((List<TemplateFraction>)this.templateLine));
        TemplateNumber.Companion.makeColumnsEqualWidth(TemplateFraction.Companion.getDenominators((List<TemplateFraction>)this.templateLine));
        TemplateFraction.Companion.makeColumnsEqualWidth(this.templateLine);
        String operator = template.getBrailleOperator();
        Iterator<TemplateFraction> iterator = this.templateLine.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        $this$format_u24lambda_u241 = iterator;
        while ($this$format_u24lambda_u241.hasNext()) {
            Object e = $this$format_u24lambda_u241.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            TemplateFraction fraction = (TemplateFraction)e;
            if (fraction.toString().length() <= this.longestLine) continue;
            this.longestLine = fraction.toString().length();
        }
        String operatorLine = this.templateLine.get(template.getBrailleOperands().size() / components - 1).toString();
        if (operator.length() + operatorLine.length() > this.longestLine) {
            this.longestLine = operatorLine.length();
        }
        int n = ((Collection)this.templateLine).size();
        for (int i2 = 0; i2 < n; ++i2) {
            Intrinsics.checkNotNullExpressionValue((Object)this.templateLine.get(i2), (String)"get(...)");
            Line line = new Line();
            if (i2 == template.getBrailleOperands().size() / components - 1) {
                line.getElements().add(line.getTextSegment(operator));
                v2 = fraction.addToLine(line);
            } else {
                line.getElements().add(line.getWhitespaceSegment(operator.length()));
                v2 = fraction.addToLine(line);
            }
            ((ArrayList)template.getLines()).add(line);
            if (i2 != template.getBrailleOperands().size() / components - 1) continue;
            this.addLine(template);
        }
        return template;
    }

    private final void addLine(Template template) {
        Line line = new Line();
        line.setSeparatorLine(true);
        if (template.getSettings().getPassage() == SpatialMathEnum.Passage.NUMERIC) {
            line.getElements().add(line.getWhitespaceSegment(template.getBrailleOperator().length()));
            int lineChars = this.longestLine;
            if (lineChars < 1) {
                lineChars = 1;
            }
            v0 = line.getElements().add(line.getTextSegment("\"" + StringsKt.repeat((CharSequence)"3", (int)lineChars)));
        } else {
            line.getElements().add(line.getWhitespaceSegment(template.getBrailleOperator().length()));
            int lineChars = this.longestLine - 1;
            if (lineChars < 1) {
                lineChars = 1;
            }
            v0 = line.getElements().add(line.getTextSegment("\"" + StringsKt.repeat((CharSequence)"3", (int)lineChars)));
        }
        ((ArrayList)template.getLines()).add(line);
    }
}

