/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.pandoc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import org.brailleblaster.pandoc.FixerInf;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0018J\u0006\u0010 \u001a\u00020\u001bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001e\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u00180\u0017j\b\u0012\u0004\u0012\u00020\u0018`\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\u00020\u0003X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006!"}, d2={"Lorg/brailleblaster/pandoc/Fixer;", "", "filename", "", "<init>", "(Ljava/lang/String;)V", "file", "Ljava/io/File;", "document", "Lnu/xom/Document;", "getDocument", "()Lnu/xom/Document;", "setDocument", "(Lnu/xom/Document;)V", "rootElement", "Lnu/xom/Element;", "getRootElement", "()Lnu/xom/Element;", "topNode", "Lnu/xom/Node;", "getTopNode", "()Lnu/xom/Node;", "fixers", "Ljava/util/ArrayList;", "Lorg/brailleblaster/pandoc/FixerInf;", "Lkotlin/collections/ArrayList;", "addFixer", "", "f", "bbUri", "getBbUri", "()Ljava/lang/String;", "processFixers", "brailleblaster-core"})
public final class Fixer {
    @NotNull
    private final File file;
    @NotNull
    private Document document;
    @NotNull
    private final Element rootElement;
    @NotNull
    private final Node topNode;
    @NotNull
    private final ArrayList<FixerInf> fixers;
    @NotNull
    private final String bbUri;

    public Fixer(@NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        this.file = new File(filename);
        this.fixers = new ArrayList();
        FileInputStream fis = new FileInputStream(filename);
        InputStreamReader isr = new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8);
        Builder bldr = new Builder();
        Document document = bldr.build((Reader)isr);
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"build(...)");
        this.document = document;
        Element element = this.document.getRootElement();
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"getRootElement(...)");
        this.rootElement = element;
        this.topNode = (Node)this.rootElement;
        isr.close();
        this.bbUri = "http://brailleblaster.org/ns/bb";
    }

    @NotNull
    public final Document getDocument() {
        return this.document;
    }

    public final void setDocument(@NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"<set-?>");
        this.document = document;
    }

    @NotNull
    public final Element getRootElement() {
        return this.rootElement;
    }

    @NotNull
    public final Node getTopNode() {
        return this.topNode;
    }

    public final void addFixer(@NotNull FixerInf f) {
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        f.setFixer(this);
        this.fixers.add(f);
    }

    @NotNull
    public final String getBbUri() {
        return this.bbUri;
    }

    public final void processFixers() throws Exception {
        Iterator<FixerInf> iterator = this.fixers.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<FixerInf> iterator2 = iterator;
        while (iterator2.hasNext()) {
            FixerInf f;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            f.process();
        }
        FileOutputStream fos = new FileOutputStream(this.file);
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);
        osw.write(this.document.toXML());
        osw.close();
    }
}

