/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.perspectives.braille;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;
import kotlin.Pair;
import kotlin.sequences.Sequence;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import org.apache.commons.lang3.time.StopWatch;
import org.brailleblaster.BBIni;
import org.brailleblaster.Main;
import org.brailleblaster.archiver2.Archiver2;
import org.brailleblaster.archiver2.ArchiverFactory;
import org.brailleblaster.archiver2.ArchiverRecoverThread;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.bbx.fixers2.LiveFixer;
import org.brailleblaster.embossers.EmbossingUtils;
import org.brailleblaster.exceptions.BBNotifyException;
import org.brailleblaster.exceptions.EditingException;
import org.brailleblaster.exceptions.FormatterException;
import org.brailleblaster.exceptions.OutdatedMapListException;
import org.brailleblaster.exceptions.TranslationException;
import org.brailleblaster.frontmatter.VolumeUtils;
import org.brailleblaster.math.mathml.MathModuleUtils;
import org.brailleblaster.perspectives.Controller;
import org.brailleblaster.perspectives.braille.document.BrailleDocument;
import org.brailleblaster.perspectives.braille.eventQueue.EventFrame;
import org.brailleblaster.perspectives.braille.mapping.elements.BrailleMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.BraillePageBrlMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.NewPageBrlMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.PageIndicator;
import org.brailleblaster.perspectives.braille.mapping.elements.PageIndicatorTextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.PrintPageBrlMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.Range;
import org.brailleblaster.perspectives.braille.mapping.elements.ReadOnlyFormattingWhiteSpace;
import org.brailleblaster.perspectives.braille.mapping.elements.SectionElement;
import org.brailleblaster.perspectives.braille.mapping.elements.TableCellTextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.TextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.WhiteSpaceElement;
import org.brailleblaster.perspectives.braille.mapping.maps.MapList;
import org.brailleblaster.perspectives.braille.messages.AdjustLocalStyleMessage;
import org.brailleblaster.perspectives.braille.messages.AdjustRangeMessage;
import org.brailleblaster.perspectives.braille.messages.BBEvent;
import org.brailleblaster.perspectives.braille.messages.GetCurrentMessage;
import org.brailleblaster.perspectives.braille.messages.GetTextMapElementsMessage;
import org.brailleblaster.perspectives.braille.messages.InsertNodeMessage;
import org.brailleblaster.perspectives.braille.messages.Message;
import org.brailleblaster.perspectives.braille.messages.RemoveNodeMessage;
import org.brailleblaster.perspectives.braille.messages.SelectionMessage;
import org.brailleblaster.perspectives.braille.messages.Sender;
import org.brailleblaster.perspectives.braille.messages.TabInsertionMessage;
import org.brailleblaster.perspectives.braille.messages.UpdateMessage;
import org.brailleblaster.perspectives.braille.messages.UpdateScrollbarMessage;
import org.brailleblaster.perspectives.braille.messages.UpdateStatusbarMessage;
import org.brailleblaster.perspectives.braille.messages.UpdateStyleMessage;
import org.brailleblaster.perspectives.braille.messages.WhitespaceMessage;
import org.brailleblaster.perspectives.braille.searcher.Searcher;
import org.brailleblaster.perspectives.braille.stylers.HideActionHandler;
import org.brailleblaster.perspectives.braille.stylers.InsertElementHandler;
import org.brailleblaster.perspectives.braille.stylers.RemoveElementHandler;
import org.brailleblaster.perspectives.braille.stylers.SelectionHandler;
import org.brailleblaster.perspectives.braille.stylers.StyleHandler;
import org.brailleblaster.perspectives.braille.stylers.TabInsertionHandler;
import org.brailleblaster.perspectives.braille.stylers.TextUpdateHandler;
import org.brailleblaster.perspectives.braille.stylers.WhitespaceTransformer;
import org.brailleblaster.perspectives.braille.viewInitializer.NimasInitializer;
import org.brailleblaster.perspectives.braille.viewInitializer.ViewFactory;
import org.brailleblaster.perspectives.braille.viewInitializer.ViewInitializer;
import org.brailleblaster.perspectives.braille.views.style.StylePane;
import org.brailleblaster.perspectives.braille.views.tree.BookTreeDialog;
import org.brailleblaster.perspectives.braille.views.wp.BrailleView;
import org.brailleblaster.perspectives.braille.views.wp.TextView;
import org.brailleblaster.perspectives.mvc.BBSimpleManager;
import org.brailleblaster.perspectives.mvc.ViewManager;
import org.brailleblaster.perspectives.mvc.events.ModifyEvent;
import org.brailleblaster.perspectives.mvc.events.XMLCaretEvent;
import org.brailleblaster.perspectives.mvc.modules.misc.FileModule;
import org.brailleblaster.perspectives.mvc.modules.misc.SplitElementModule;
import org.brailleblaster.perspectives.mvc.modules.misc.TableSelectionModule;
import org.brailleblaster.perspectives.mvc.modules.misc.ToggleViewsModule;
import org.brailleblaster.perspectives.mvc.modules.misc.UndoRedoModule;
import org.brailleblaster.printers.PrintPreview;
import org.brailleblaster.printers.PrintersManager;
import org.brailleblaster.search.SearchDialog;
import org.brailleblaster.settings.UTDManager;
import org.brailleblaster.settings.ui.BrailleSettingsDialog;
import org.brailleblaster.settings.ui.EmbosserSettingsTab;
import org.brailleblaster.settings.ui.SettingsUITab;
import org.brailleblaster.utd.IStyle;
import org.brailleblaster.utd.UTDTranslationEngineCallback;
import org.brailleblaster.utd.actions.IAction;
import org.brailleblaster.utd.exceptions.NodeException;
import org.brailleblaster.utd.exceptions.UTDInterruption;
import org.brailleblaster.utd.internal.DocumentOrderComparator;
import org.brailleblaster.utd.internal.xml.FastXPath;
import org.brailleblaster.utd.internal.xml.XMLHandler;
import org.brailleblaster.utd.properties.UTDElements;
import org.brailleblaster.utd.utils.TableUtils;
import org.brailleblaster.utd.utils.UTDHelper;
import org.brailleblaster.util.ColorManager;
import org.brailleblaster.util.ModuleService;
import org.brailleblaster.util.Notify;
import org.brailleblaster.util.Utils;
import org.brailleblaster.util.WorkingDialog;
import org.brailleblaster.util.YesNoChoice;
import org.brailleblaster.utils.localization.LocaleHandler;
import org.brailleblaster.utils.swt.EasySWT;
import org.brailleblaster.wordprocessor.BBStatusBar;
import org.brailleblaster.wordprocessor.FontManager;
import org.brailleblaster.wordprocessor.RecentDocs;
import org.brailleblaster.wordprocessor.WPManager;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Manager
extends Controller {
    private static final LocaleHandler localeHandler = LocaleHandler.getDefault();
    private static final ModuleService moduleService = new ModuleService();
    public static final Path DEFAULT_FILE = BBIni.getProgramDataPath().resolve(Paths.get("xmlTemplates", "blankTemplate.bbz"));
    private static final AtomicInteger INSTANCE_COUNTER = new AtomicInteger(0);
    public final int instanceId = INSTANCE_COUNTER.getAndIncrement();
    private final ViewManager viewManager;
    private final SashForm containerSash;
    private final TextView text;
    private final BrailleView braille;
    private Archiver2 archiver;
    private ViewInitializer viewInitializer;
    private static final Logger logger = LoggerFactory.getLogger(Manager.class);
    private BrailleDocument document;
    private final FontManager fontManager;
    private MapList list;
    private final List<String> ignoreList = new Vector<String>();
    private final Reformatter reformatter;
    private CountDownLatch finishFormattingLatch;
    private CountDownLatch rebuiltSectionLatch;
    private CountDownLatch rebuiltSectionMapLatch;
    private Integer pages;
    private int extraPages;
    private boolean xmlEdited = false;
    private boolean restartFormatFlag = false;
    private boolean pressNo = true;
    private final ArchiverRecoverThread myArchiverRecoverThread = new ArchiverRecoverThread(this);
    private final BBSimpleManager simpleManager;
    private boolean isDocumentEdited = false;
    private Document lastCopiedDoc = null;
    private static RuntimeException formatterException = null;
    @NotNull
    private final Path _initFile;

    public Manager(WPManager wp, @Nullable Path file) {
        super(wp);
        Path iFile;
        if (file == null) {
            iFile = DEFAULT_FILE;
            logger.info("No input file given, opening template {}", (Object)iFile);
        } else {
            iFile = file;
        }
        this._initFile = iFile;
        this.simpleManager = new BBSimpleManager(){

            @Override
            @NotNull
            public UTDManager getUtdManager() {
                return Manager.this.getDocument().getSettingsManager();
            }

            @Override
            @NotNull
            public Document getDoc() {
                return Manager.this.getDoc();
            }

            @Override
            @NotNull
            public Manager getManager() {
                return Manager.this;
            }
        };
        this.fontManager = new FontManager(this);
        this.viewManager = new ViewManager(wp.getFolder(), this);
        this.getFontManager().initViews();
        this.containerSash = this.viewManager.containerSash;
        this.text = this.viewManager.getTextView();
        this.braille = this.viewManager.getBrailleView();
        Thread.currentThread().setName("main-" + this.instanceId);
        this.reformatter = new Reformatter(this);
        Thread formatThread = new Thread(this.reformatter);
        formatThread.setDaemon(true);
        formatThread.setName("reformatter-" + this.instanceId);
        formatThread.start();
        this.simpleManager.registerModule(event -> {
            block18: {
                ModifyEvent mEvent;
                block19: {
                    if (!(event instanceof ModifyEvent)) break block18;
                    mEvent = (ModifyEvent)event;
                    this.stopFormatting();
                    mEvent.changedNodes.removeIf(n -> n.getDocument() == null);
                    if (!mEvent.translate) break block19;
                    ArrayList<Element> changedNodes = new ArrayList<Element>();
                    StreamSupport.stream(((Iterable)() -> ((Sequence)FastXPath.descendant((Node)this.getDoc())).iterator()).spliterator(), false).filter(Searcher.Filters::isElement).map(Searcher.Mappers::toElement).filter(BBX.PreFormatterMarker.ATTRIB_PRE_FORMATTER_MARKER::has).forEach(BBX.PreFormatterMarker.ATTRIB_PRE_FORMATTER_MARKER::detach);
                    HashSet<Element> liveFixedSections = new HashSet<Element>();
                    for (Node node : mEvent.changedNodes) {
                        block21: {
                            block20: {
                                Element tableParent;
                                if (node.getDocument() == null) continue;
                                if (node instanceof Document || node.getDocument().getRootElement() == node) {
                                    LiveFixer.fix(Objects.requireNonNull(XMLHandler.nodeToElementOrParentOrDocRoot((Node)node)));
                                    this.refresh(false);
                                    changedNodes.clear();
                                    continue;
                                }
                                Element section = XMLHandler.Companion.ancestorVisitorElement(node, BBX.SECTION::isA);
                                if (section != null && !liveFixedSections.contains(section)) {
                                    LiveFixer.fix(section);
                                    liveFixedSections.add(section);
                                    if (node.getDocument() == null) continue;
                                }
                                if ((tableParent = XMLHandler.Companion.ancestorVisitorElement(node, BBX.CONTAINER.TABLE::isA)) != null) {
                                    changedNodes.add(tableParent);
                                    continue;
                                }
                                if (BBX.SECTION.isA(node)) break block20;
                                if (!BBX.CONTAINER.isA(node) || BBX.CONTAINER.TABLE.isA(node)) break block21;
                            }
                            for (Node child : () -> ((Sequence)FastXPath.descendantOrSelf((Node)node)).iterator()) {
                                if (BBX.CONTAINER.TABLE.isA(child) && ((Element)child).getAttribute("tableCopy") == null && !changedNodes.contains(child)) {
                                    changedNodes.add((Element)child.getParent());
                                    continue;
                                }
                                if (BBX.BLOCK.TABLE_CELL.isA(child) || !BBX.BLOCK.isA(child) || changedNodes.contains((Element)child)) continue;
                                changedNodes.add((Element)child);
                            }
                            continue;
                        }
                        if (BBX.CONTAINER.TABLE.isA(node)) {
                            changedNodes.add((Element)node.getParent());
                            continue;
                        }
                        if (!BBX.BLOCK.isA(node)) {
                            void var6_7;
                            while (!BBX.BLOCK.isA((Node)var6_7)) {
                                ParentNode parentNode = var6_7.getParent();
                            }
                            if (!(var6_7 instanceof Element) || changedNodes.contains(var6_7)) continue;
                            changedNodes.add((Element)var6_7);
                            continue;
                        }
                        if (!(node instanceof Element) || changedNodes.contains(node)) continue;
                        changedNodes.add((Element)node);
                    }
                    mEvent.changedNodes.clear();
                    if (!changedNodes.isEmpty()) {
                        for (Node node : changedNodes) {
                            logger.debug("Changed node {}", (Object)node.toXML());
                        }
                        this.getDocument().getSettingsManager().getEngine().expectedTranslate = true;
                        try {
                            List newChangedNodes = this.getDocument().getSettingsManager().getEngine().translateAndReplace(changedNodes);
                            this.getDocument().getSettingsManager().getEngine().expectedTranslate = false;
                            for (Element newChangedNode : newChangedNodes) {
                                logger.debug("Retranslated block: {}", (Object)newChangedNode.toXML());
                            }
                            mEvent.changedNodes.addAll(newChangedNodes);
                        }
                        catch (RuntimeException e) {
                            this.getDocument().getSettingsManager().getEngine().expectedTranslate = false;
                            throw new TranslationException("An exception occurred while translating", (Throwable)e);
                        }
                    } else {
                        logger.debug("No blocks found to be translated");
                    }
                }
                this.lastCopiedDoc = this.document.doc.copy();
                mEvent.changedNodes.sort((Comparator<Node>)new DocumentOrderComparator());
                if (!mEvent.changedNodes.isEmpty() && this.list.findNode(mEvent.changedNodes.getFirst()) == null) {
                    this.reformat(mEvent.changedNodes.getFirst());
                } else {
                    this.reformat();
                }
            }
        });
        this.simpleManager.registerModules(moduleService.modules(this));
    }

    public void open() {
        Path file = this._initFile;
        if (!Files.exists(file, new LinkOption[0])) {
            throw new RuntimeException("File " + String.valueOf(file.toUri()) + " does not exist");
        }
        this.openDocument(file);
        this.addTabItem(this.getWpManager().getFolder()).setControl((Control)this.containerSash);
        this.initializeDocumentTab();
        if (this.getArchiver().isImported()) {
            this.setDocumentEdited(true);
        }
        Archiver2 archiver2 = this.getArchiver();
        String newName = Optional.ofNullable(archiver2.getNewPath()).orElse(file).getFileName().toString();
        this.setTabTitle(newName);
        this.lineUpViews();
    }

    private void initializeDocumentTab() {
        this.viewManager.setTabList();
        this.getWpManager().getShell().layout();
    }

    public void repeatLastSearch() {
        SearchDialog search = Objects.requireNonNull(this.simpleManager.getModule(SearchDialog.class));
        search.repeatLastSearch();
    }

    public boolean isTableSelected() {
        return Objects.requireNonNull(this.simpleManager.getModule(TableSelectionModule.class)).isTableSelected();
    }

    public boolean isValidPageBreak() {
        return !(this.getMapList().getCurrent() instanceof ReadOnlyFormattingWhiteSpace);
    }

    public static Element getTableParent(Node n) {
        if (n == null) {
            throw new NullPointerException("n");
        }
        if (n.getDocument() == null) {
            throw new NodeException("node not attached to document", n);
        }
        Element parent = n instanceof Element ? (Element)n : (Element)n.getParent();
        Element root = parent.getDocument().getRootElement();
        List<String> tableFormats = Arrays.asList("simple", "listed", "stairstep", "linear");
        while (!tableFormats.contains(parent.getAttributeValue("format")) && parent.getParent() != parent.getDocument()) {
            if (parent.getParent() == root) {
                return null;
            }
            parent = (Element)parent.getParent();
        }
        if (parent.getAttribute("class") != null && parent.getAttributeValue("class").contains("utd:table")) {
            return (Element)parent.getParent().getChild(parent.getParent().indexOf((Node)parent) - 1);
        }
        return parent;
    }

    public static Element getTableBrlCopy(Node node) {
        Element table = Manager.getTableParent(node);
        if (table == null) {
            return null;
        }
        if (TableUtils.isTableCopy((Element)table)) {
            return table;
        }
        ParentNode parent = table.getParent();
        int index = parent.indexOf((Node)table);
        if (index != parent.getChildCount() - 1 && BBX.CONTAINER.TABLE.isA(parent.getChild(index + 1)) && TableUtils.isTableCopy((Element)((Element)parent.getChild(index + 1)))) {
            return (Element)parent.getChild(index + 1);
        }
        return null;
    }

    public void closeThreads() {
        UndoRedoModule undoRedo;
        this.myArchiverRecoverThread.autoSave(false);
        if (this.reformatter != null) {
            this.reformatter.close();
        }
        if ((undoRedo = this.getSimpleManager().getModule(UndoRedoModule.class)) != null) {
            undoRedo.closeUndoThread();
        }
    }

    @Override
    public boolean close() {
        if (this.archiver == null) {
            return true;
        }
        boolean cancel = false;
        if (!(BBIni.getDebugging() || !this.isDocumentEdited() && Files.exists(this.getArchiver().getPath(), new LinkOption[0]))) {
            YesNoChoice ync = new YesNoChoice(localeHandler.get("hasChanged"), true);
            if (ync.getResult() == 64) {
                cancel = !FileModule.Companion.fileSave(this);
                this.pressNo = false;
            } else if (ync.getResult() == 256) {
                cancel = true;
                this.pressNo = false;
            }
            if (this.pressNo) {
                this.text.hasChanged = false;
                this.getBraille().hasChanged = false;
                this.isDocumentEdited = false;
                this.myArchiverRecoverThread.removeFile();
            }
        }
        if (!cancel) {
            this.closeThreads();
            this.viewManager.saveScreenProperties();
            if (this.getWpManager().getCurrentPerspective().getKeyListener() != null) {
                this.text.getView().removeVerifyKeyListener(this.getWpManager().getCurrentPerspective().getKeyListener());
                this.getWpManager().getCurrentPerspective().setKeyListener(null);
            }
            this.dispose();
            CTabItem tab = this.getTab();
            if (tab != null) {
                tab.dispose();
            }
            if (this.archiver == null & docCount > 0) {
                --docCount;
            }
            this.getWpManager().removeController(this);
            try {
                this.getArchiver().close();
            }
            catch (IOException e) {
                logger.error("Error closing Archiver", (Throwable)e);
            }
            if (this.getWpManager().getList().isEmpty()) {
                this.getWpManager().getStatusBar().setText("");
            }
        }
        return !cancel;
    }

    public void openDocument(Path file) {
        try (WorkingDialog ignored = new WorkingDialog("Opening book " + String.valueOf(file));){
            this.archiver = ArchiverFactory.INSTANCE.load(file);
        }
        catch (Exception e) {
            logger.error("Problem loading file", (Throwable)e);
        }
        if (file != DEFAULT_FILE) {
            RecentDocs.Companion.getDefaultRecentDocs().addRecentDoc(file);
        }
        try {
            this.document = new BrailleDocument(this, this.getArchiver().getBbxDocument());
        }
        catch (NullPointerException npe) {
            throw new BBNotifyException("Cannot open " + String.valueOf(file) + " - file is corrupt or invalid.");
        }
        this.initializeAllViews();
        if (!this.list.isEmpty()) {
            this.text.setCurrentElement(0);
        }
        if (!BBIni.getDebugging() && !file.toString().contains(BBIni.getAutoSavePath().toString())) {
            this.myArchiverRecoverThread.autoSave(true);
        }
    }

    private void initializeAllViews() {
        WorkingDialog ignored;
        MathModuleUtils.retranslateSpatial(this.document);
        try {
            ignored = new WorkingDialog((String)(this.archiver != null ? "Parsing book " + String.valueOf(this.getArchiver().getPath()) : "Starting BrailleBlaster"));
            try {
                this.document.translateDocument();
            }
            finally {
                ignored.close();
            }
        }
        catch (RuntimeException e) {
            FormatterException newException = new FormatterException("An error occurred while opening the book", (Throwable)e);
            newException.setCurFallback(FormatterException.Fallback.REFRESH);
            this.countDownAllLatches();
            throw newException;
        }
        try {
            ignored = new WorkingDialog((String)(this.archiver != null ? "Parsing book " + String.valueOf(this.getArchiver().getPath()) : "Starting BrailleBlaster"));
            try {
                Objects.requireNonNull(this.getSimpleManager().getModule(UndoRedoModule.class)).copyDocument(this.document.doc);
                this.containerSash.setRedraw(false);
                this.getWpManager().getStatusBar().resetLocation(6, 75, 100);
                this.getWpManager().getStatusBar().setText("Loading...");
                this.viewInitializer = ViewFactory.createUpdater(this.getArchiver(), this.document, this.text, this.braille);
                this.updateMapList(0);
                this.initializeListeners();
                this.text.hasChanged = false;
                this.braille.hasChanged = false;
                this.getWpManager().getStatusBar().resetLocation(0, 75, 100);
                this.getText().createNodeCaret(this.list.getCurrent(), this.text.getView().getCaretOffset());
                this.containerSash.setRedraw(true);
            }
            finally {
                ignored.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unforeseen exception", e);
        }
    }

    public void onPostBuffer(MapList mapList) {
        this.getViewManager().stylePane.generate(mapList);
        this.lineUpViews();
    }

    public void lineUpViews() {
        this.getTextView().addListener(9, new Listener(){

            public void handleEvent(Event event) {
                Manager.this.getFontManager().lineUpStylePaneWithTextView();
                Manager.this.getFontManager().lineUpBrailleViewWithTextView();
                Manager.this.getTextView().removeListener(9, (Listener)this);
            }
        });
    }

    public void dispatch(Message message) {
        switch (message.eventType) {
            case GET_CURRENT: {
                this.handleGetCurrent((GetCurrentMessage)message);
                break;
            }
            case WHITESPACE_TRANSFORM: {
                this.handleWhitespaceTransform((WhitespaceMessage)message);
                break;
            }
            case UPDATE: {
                this.handleUpdate((UpdateMessage)message);
                break;
            }
            case SELECTION: {
                this.handleSelection((SelectionMessage)message);
                break;
            }
            case INSERT_NODE: {
                this.handleInsertNode((InsertNodeMessage)message);
                break;
            }
            case REMOVE_NODE: {
                this.handleRemoveNode((RemoveNodeMessage)message);
                break;
            }
            case UPDATE_STATUSBAR: {
                this.handleUpdateStatusBar((UpdateStatusbarMessage)message);
                break;
            }
            case ADJUST_LOCAL_STYLE: {
                this.handleAdjustLocalStyle((AdjustLocalStyleMessage)message);
                break;
            }
            case ADJUST_RANGE: {
                this.handleAdjustRange((AdjustRangeMessage)message);
                break;
            }
            case GET_TEXT_MAP_ELEMENTS: {
                this.findTextMapElements((GetTextMapElementsMessage)message);
                break;
            }
            case UPDATE_SCROLLBAR: {
                this.handleUpdateScrollbar((UpdateScrollbarMessage)message);
                break;
            }
            case UPDATE_STYLE: {
                this.handleUpdateStyle((UpdateStyleMessage)message);
                break;
            }
            case TAB_INSERTION: 
            case TAB_ADJUSTMENT: 
            case TAB_DELETION: {
                this.handleTabInsertion((TabInsertionMessage)message);
                break;
            }
        }
    }

    public void checkView(TextMapElement t) {
        if (!this.list.contains(t)) {
            this.list = this.viewInitializer.bufferViews(this, this.getSection(t));
        }
    }

    public void decrementView() {
        int section;
        if (this.viewInitializer.getSectionList().size() == 1) {
            return;
        }
        if (this.text.hasChanged) {
            this.text.update(false);
        }
        this.waitForFormatting(true);
        TextMapElement t = (TextMapElement)this.list.getFirst();
        if (t instanceof WhiteSpaceElement) {
            t = this.list.findClosestNonWhitespace((WhiteSpaceElement)t);
        }
        if ((section = this.getSection(t)) != 0) {
            this.list = this.viewInitializer.bufferViews(this, section - 1, false);
            this.list.setCurrent(this.list.indexOf(t) - 1);
            this.text.resetOffsets();
        }
    }

    public void incrementView() {
        int section;
        if (this.viewInitializer.getSectionList().size() == 1) {
            return;
        }
        this.waitForFormatting(true);
        TextMapElement t = (TextMapElement)this.list.getLast();
        if (t instanceof WhiteSpaceElement) {
            t = this.list.findClosestNonWhitespace((WhiteSpaceElement)t);
        }
        if ((section = this.getSection(t)) != this.viewInitializer.getSectionList().size() - 1) {
            this.list = this.viewInitializer.bufferViews(this, section + 1, true);
            this.list.setCurrent(this.list.indexOf(t) + 1);
            this.text.resetOffsets();
        }
    }

    public void incrementCurrent() {
        this.waitForFormatting(true);
        int index = this.list.getCurrentIndex();
        if (index < this.list.size() - 1) {
            TextMapElement t = (TextMapElement)this.list.get(++index);
            this.getSimpleManager().dispatchEvent(new XMLCaretEvent(Sender.SIMPLEMANAGER, this.text.createNodeCaret(t, 0)));
        }
    }

    public void waitForFormatting(boolean updateMapList) {
        logger.debug("Enter waitForFormatting. Busy? {}", (Object)this.reformatter.busy);
        try {
            if (this.reformatter.busy) {
                this.text.removeFocusListener();
                Shell working = new Shell(Display.getCurrent(), 18464);
                working.setLayout((Layout)new GridLayout(1, false));
                working.setText("Formatting...");
                Text workingText = new Text((Composite)working, 0);
                workingText.setText("Formatting, please wait...");
                EasySWT.INSTANCE.setLargeDialogSize(working);
                working.open();
                this.finishFormattingLatch.await();
                this.finishFormattingLatch = new CountDownLatch(1);
                working.dispose();
                this.text.addFocusListener();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (updateMapList && this.needsMapListUpdate()) {
            logger.debug("MapList needs update");
            this.updateFormatting();
        }
        logger.debug("Exit WaitForFormatting");
    }

    public boolean needsMapListUpdate() {
        return this.xmlEdited;
    }

    public void handleEditingException(Exception e) {
        if (BBIni.getDebugging()) {
            throw new RuntimeException(e);
        }
        logger.error("Handling editing exception", (Throwable)e);
        if (this.getLastCopiedDoc() != null) {
            this.document.doc.replaceChild((Node)this.document.doc.getRootElement(), (Node)this.getLastCopiedDoc().getRootElement().copy());
        } else {
            logger.error("Last copied doc is null");
        }
        try {
            this.refresh(false);
            Notify.showException("An error occurred. BrailleBlaster has attempted to repair the document.", e);
        }
        catch (Exception e2) {
            Main.handleFatalException(e2);
        }
    }

    private void findTextMapElements(GetTextMapElementsMessage message) {
        ArrayList<SectionElement> secList = this.viewInitializer.getSectionList();
        ArrayList<TextMapElement> itemList = message.itemList;
        ArrayList<Node> textList = message.getNodeList();
        if (secList.size() > 1) {
            for (SectionElement sectionElement : secList) {
                int size = itemList.size();
                if (sectionElement.isVisible()) {
                    this.list.findTextMapElements(textList, itemList);
                } else {
                    sectionElement.list.findTextMapElements(textList, itemList);
                }
                if (size <= 0 || size != itemList.size()) continue;
                break;
            }
        } else {
            this.list.findTextMapElements(textList, itemList);
        }
    }

    private void handleGetCurrent(GetCurrentMessage message) {
        this.list.getCurrentNodeData(message, message.offset, this.list.getCurrent(), message.sender);
    }

    private void handleWhitespaceTransform(WhitespaceMessage message) {
        this.stopFormatting();
        WhitespaceTransformer wst = new WhitespaceTransformer(this);
        try {
            wst.transformWhiteSpace(message);
        }
        catch (RuntimeException e) {
            throw new EditingException("Exception while transforming whitespace", (Throwable)e);
        }
    }

    private void handleUpdate(UpdateMessage message) {
        this.stopFormatting();
        TextUpdateHandler tuh = new TextUpdateHandler(this, this.viewInitializer, this.list);
        tuh.updateText(message);
    }

    private void handleSelection(SelectionMessage message) {
        this.stopFormatting();
        SelectionHandler sh = new SelectionHandler(this, this.viewInitializer, this.list);
        try {
            sh.removeSelection(message);
        }
        catch (RuntimeException e) {
            throw new EditingException("Exception while deleting selection", (Throwable)e);
        }
    }

    private void handleInsertNode(InsertNodeMessage m) {
        this.stopFormatting();
        InsertElementHandler inserter = new InsertElementHandler(this, this.viewInitializer, this.list);
        inserter.insertElement(m);
    }

    public boolean splitElement() {
        this.stopFormatting();
        return SplitElementModule.splitElement(this.getSimpleManager());
    }

    private void handleRemoveNode(RemoveNodeMessage message) {
        this.stopFormatting();
        RemoveElementHandler er = new RemoveElementHandler(this, this.viewInitializer, this.list);
        er.removeNode(message);
    }

    private void handleUpdateStatusBar(UpdateStatusbarMessage message) {
        this.getWpManager().getStatusBar().setColor(ColorManager.Colors.BLACK);
        this.getWpManager().getStatusBar().setText(message.getStatus());
    }

    public void setTemporaryStatusBarMessage(String message, boolean redHighlight) {
        if (redHighlight) {
            this.getWpManager().getStatusBar().setColor(ColorManager.Colors.RED);
        } else {
            this.getWpManager().getStatusBar().setColor(ColorManager.Colors.BLACK);
        }
        this.getWpManager().getStatusBar().setText(message);
    }

    private void handleAdjustLocalStyle(AdjustLocalStyleMessage message) {
        this.stopFormatting();
        this.text.update(false);
        StyleHandler sh = new StyleHandler(this, this.viewInitializer, this.list);
        try {
            sh.createAndApplyStyle(this.list.getCurrent(), message);
        }
        catch (RuntimeException e) {
            throw new EditingException("An error occurred while adjusting a style", (Throwable)e);
        }
    }

    public void handleAdjustRange(AdjustRangeMessage message) {
        this.list.adjustOffsets(message.type, this.list.getCurrentIndex(), message.position);
    }

    private void handleUpdateScrollbar(UpdateScrollbarMessage message) {
        this.text.setListenerLock(true);
        if (message.sender.equals((Object)Sender.BRAILLE)) {
            this.text.getView().setTopPixel(this.getBrailleView().getTopPixel());
        } else {
            this.braille.getView().setTopPixel(this.getTextView().getTopPixel());
        }
        this.viewManager.stylePane.widget.setTopPixel(this.getTextView().getTopPixel());
        this.text.setListenerLock(false);
    }

    private void handleUpdateStyle(UpdateStyleMessage message) {
        this.stopFormatting();
        if (!this.text.getView().getText().isEmpty()) {
            this.containerSash.setRedraw(false);
            StyleHandler sh = new StyleHandler(this, this.viewInitializer, this.list);
            sh.updateStyle(message);
            BBIni.getPropertyFileManager().save("currentStyleId", message.style.getId());
            this.containerSash.setRedraw(true);
        } else {
            this.notify(localeHandler.get("nothingToApply"));
        }
    }

    private void handleTabInsertion(TabInsertionMessage m) {
        TabInsertionHandler th = new TabInsertionHandler(this, this.viewInitializer, this.list);
        if (m.eventType.equals((Object)BBEvent.TAB_INSERTION)) {
            th.insertTab(m);
        } else if (m.eventType.equals((Object)BBEvent.TAB_ADJUSTMENT)) {
            th.adjustTab(m);
        } else {
            th.removeTab(m);
        }
    }

    public void home() {
        this.text.update(false);
        if (this.getSectionList().size() > 1) {
            this.useResetSectionMethod(0);
        }
        this.text.setListenerLock(true);
        this.text.getView().setTopIndex(0);
        this.setTextCaret(0);
        this.text.setListenerLock(false);
    }

    public void end() {
        this.text.update(false);
        this.waitForFormatting(true);
        this.useResetSectionMethod(this.getSectionList().size() - 1);
        this.text.setListenerLock(true);
        this.text.getView().setTopIndex(this.text.getView().getLineCount() - 1);
        SectionElement lastSection = this.getSectionList().getLast();
        if (this.getSectionList().size() > 1 || !lastSection.list.isEmpty()) {
            this.setTextCaret(((TextMapElement)lastSection.list.getLast()).getEnd(this.getMapList()));
        }
        this.text.setListenerLock(false);
    }

    public void textPrint() {
        PrintersManager pn = new PrintersManager(this.getWpManager().getShell(), this.text.getView());
        pn.beginPrintJob();
    }

    public void fileEmbossNow() {
        EmbossingUtils.emboss(this.document, this.document.getEngine(), Display.getCurrent().getActiveShell(), s -> new BrailleSettingsDialog((Shell)s, this, (Class<? extends SettingsUITab>)EmbosserSettingsTab.class));
    }

    public void printPreview() {
        this.waitForFormatting(true);
        new PrintPreview(this.getWpManager().getShell(), this.getFontManager(), this.getDocument().getSettingsManager(), this.getDoc(), this);
    }

    private void setCurrentOnRefresh(Sender sender) {
        this.simpleManager.dispatchEvent(new XMLCaretEvent(sender, this.text.createNodeCaret(Objects.requireNonNull(this.text.getCurrentElement()), 0)));
    }

    private void reformat() {
        Node firstNonWhitespace = this.getFirstReformattableNode();
        if (firstNonWhitespace != null && firstNonWhitespace.getDocument() != null) {
            Node firstNode;
            if (this.viewInitializer.getSectionList().size() > 1 && this.getSection((TextMapElement)this.list.getFirst()) != 0) {
                this.reformat(firstNonWhitespace);
                return;
            }
            Node firstBrl = XMLHandler.Companion.followingVisitor(firstNonWhitespace, arg_0 -> ((UTDElements)UTDElements.BRL).isA(arg_0));
            if (firstBrl != null && !((firstNode = XMLHandler.Companion.childrenRecursiveNodeVisitor(firstBrl, n -> UTDElements.NEW_PAGE.isA(n) || n instanceof nu.xom.Text)) instanceof nu.xom.Text) && firstNode != null) {
                this.reformat(firstNode);
                return;
            }
        }
        this.reformatDocument(this.getDoc());
    }

    private void reformat(@NotNull Node node) {
        if (this.reformatter.busy) {
            throw new IllegalStateException("Format Thread already running. Use manager.stopFormatting() before making changes to the xml.");
        }
        if (node instanceof Document) {
            logger.debug("Node is the document");
            this.reformatDocument((Document)node);
        } else {
            Element prevNewPage = null;
            if (UTDElements.NEW_PAGE.isA(node)) {
                prevNewPage = (Element)node;
            } else if (node.getParent() != null && !(node.getParent() instanceof Document)) {
                prevNewPage = (Element)this.searchForPreviousNode(node, n -> UTDElements.NEW_PAGE.isA(n) && !"formatting".equals(((Element)n.getParent()).getAttributeValue("type")));
            }
            if (prevNewPage == null) {
                logger.debug("NewPage element not found after searching from {}", (Object)node);
                this.reformatDocument(node.getDocument());
            } else {
                Element prevPrintPageNum = (Element)this.searchForPreviousNode(node, arg_0 -> ((UTDElements)UTDElements.PRINT_PAGE_NUM).isA(arg_0));
                this._reformat(prevNewPage, prevPrintPageNum);
            }
        }
    }

    private void _reformat(Element newPage, Element printPageNum) {
        long startTime = System.currentTimeMillis();
        if (this.getSectionList().size() == 1) {
            logger.debug("Reformatting whole document");
            this.reformatDocument(newPage.getDocument());
            return;
        }
        this.pages = 0;
        this.extraPages = 0;
        this.initializeReformattingCallback(newPage);
        this.text.setUiLock(true);
        if (this.finishFormattingLatch == null) {
            this.finishFormattingLatch = new CountDownLatch(1);
        }
        this.rebuiltSectionLatch = new CountDownLatch(1);
        this.reformatter.startFormat(newPage, printPageNum);
        try {
            this.rebuiltSectionLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (formatterException != null) {
            RuntimeException prevException = formatterException;
            formatterException = null;
            this.countDownAllLatches();
            throw new FormatterException("Error occurred while reformatting", (Throwable)prevException);
        }
        try {
            this.updateFormatting();
        }
        catch (RuntimeException e) {
            this.countDownAllLatches();
            throw new FormatterException("Error occurred while rebuilding view after formatting", (Throwable)e);
        }
        this.xmlEdited = this.viewInitializer.getSectionList().size() != 1;
        this.text.setUiLock(false);
        if (this.rebuiltSectionMapLatch != null) {
            this.rebuiltSectionMapLatch.countDown();
        }
        logger.debug("Leaving _reformat in {}", (Object)Utils.runtimeToString(startTime));
    }

    private Node getFirstReformattableNode() {
        int curIndex = this.viewInitializer.getStartIndex();
        TextMapElement curTME = this.getSectionList().get((int)curIndex).list.getClosest(0, true);
        while (curTME == null || !this.isNodeReformattable(curTME.getNode())) {
            if (--curIndex < 0) {
                return null;
            }
            MapList curList = this.getSectionList().get((int)curIndex).list;
            curTME = curList.getPrevious(curList.size(), true);
            while (curTME != null && !this.isNodeReformattable(curTME.getNode())) {
                curTME = curList.getPrevious(curList.indexOf(curTME), true);
            }
        }
        return curTME.getNode();
    }

    private boolean isNodeReformattable(Node n) {
        return n != null && n.getDocument() != null && Manager.getTableParent(n) == null;
    }

    private void initializeReformattingCallback(final Element startingNewPage) {
        final int maxPages = this.calculateReformattingPages(startingNewPage) + 1;
        final Consumer<Integer> onComplete = i -> {
            this.rebuiltSectionMapLatch = new CountDownLatch(1);
            this.rebuiltSectionLatch.countDown();
            try {
                this.rebuiltSectionMapLatch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        };
        int REFORMATTER_BUG_BUFFER = 2;
        this.document.getEngine().setCallback(new UTDTranslationEngineCallback(){
            final /* synthetic */ Manager this$0;
            {
                this.this$0 = this$0;
            }

            public void onUpdateNode(@NotNull Node n) {
                if (this.this$0.restartFormatFlag) {
                    throw new UTDInterruption();
                }
                this.this$0.incrementPages();
                if (startingNewPage.getDocument() != null) {
                    this.this$0.extraPages = this.this$0.extraPages + (this.this$0.extraPages == 0 ? 2 : 1);
                }
                if (this.this$0.pages != null && this.this$0.pages == maxPages + this.this$0.extraPages + 2) {
                    logger.debug("Max pages {} reached. Rebuilding mapList", (Object)maxPages);
                    onComplete.accept(this.this$0.pages);
                }
            }

            public void onFormatComplete(@NotNull Node root) {
                logger.debug("Formatting completed");
                if (this.this$0.pages != null && this.this$0.pages < maxPages + this.this$0.extraPages + 2) {
                    logger.debug("MaxPages never reached.");
                    onComplete.accept(this.this$0.pages);
                }
            }
        });
    }

    private void removeReformattingCallback() {
        this.document.getEngine().setCallback(new UTDTranslationEngineCallback(this){

            public void onUpdateNode(@NotNull Node n) {
            }

            public void onFormatComplete(@NotNull Node root) {
            }
        });
    }

    private int calculateReformattingPages(Element startPoint) {
        int totalPages = this.getTotalPagesInView();
        for (int i = this.viewInitializer.getStartIndex() - 1; i >= 0; --i) {
            MapList curList = this.viewInitializer.getSectionList().get((int)i).list;
            TextMapElement firstNonWhitespace = curList.getClosest(0, true);
            if (firstNonWhitespace == null || firstNonWhitespace.getNode() == null || firstNonWhitespace.getNode().getDocument() == null) {
                logger.error("sectionList index {} consists only of whitespace?", (Object)i);
                totalPages += this.viewInitializer.getSectionList().get((int)i).pages;
                continue;
            }
            totalPages += this.viewInitializer.getSectionList().get((int)i).pages;
            int compare = new DocumentOrderComparator().compare((Node)startPoint, curList.getClosest(0, true).getNode());
            if (compare > 0) break;
        }
        return totalPages;
    }

    public void reformatDocument(Document doc) {
        this.stopFormatting();
        this.removeReformattingCallback();
        try {
            this.document.getEngine().format((Node)doc.getRootElement());
            this.updateFormatting();
        }
        catch (RuntimeException e) {
            FormatterException newException = new FormatterException("An error occurred while reformatting", (Throwable)e);
            newException.setCurFallback(FormatterException.Fallback.FORMAT_DOCUMENT);
            this.countDownAllLatches();
            throw newException;
        }
    }

    private Node searchForPreviousNode(Node startPoint, Predicate<Node> test) {
        int startIndex;
        if (startPoint.getParent() instanceof Document) {
            throw new IllegalArgumentException("Expected child node, received root element");
        }
        if (startPoint.getParent() == null) {
            throw new IllegalArgumentException("Node " + startPoint.toXML() + " has no parent");
        }
        Element curElement = (Element)startPoint.getParent();
        Node searchResult = this.searchDescendantsForNodeBackwards(curElement, startIndex = curElement.indexOf(startPoint) - 1, test);
        if (searchResult != null) {
            return searchResult;
        }
        ParentNode parent = curElement.getParent();
        if (parent == null || parent instanceof Document) {
            return null;
        }
        return this.searchForPreviousNode((Node)curElement, test);
    }

    private Node searchForPreviousTextMapElement(PageIndicator pageIndicator, Predicate<Node> test) {
        int startIndex = this.list.getCurrentIndex();
        while (this.list.getPrevious(startIndex, true) != null) {
            TextMapElement prev = this.list.getPrevious(startIndex, true);
            if (prev.getEnd(this.getMapList()) < 0) {
                throw new OutdatedMapListException("TME " + String.valueOf(prev) + " has negative end");
            }
            if (pageIndicator.getLine() >= this.text.getView().getLineAtOffset(this.list.getPrevious(startIndex, true).getEnd(this.getMapList()))) break;
            if (test.test((Node)this.list.getPrevious(startIndex, true).getNodeParent())) {
                return this.list.getPrevious(startIndex, true).getNodeParent();
            }
            --startIndex;
        }
        return null;
    }

    private Node searchDescendantsForNodeBackwards(Element parent, Predicate<Node> test) {
        return this.searchDescendantsForNodeBackwards(parent, parent.getChildCount() - 1, test);
    }

    private Node searchDescendantsForNodeBackwards(Element parent, int startIndex, Predicate<Node> test) {
        for (int i = startIndex; i >= 0; --i) {
            Node searchElement;
            Node child = parent.getChild(i);
            if (test.test(child)) {
                return child;
            }
            if (!(child instanceof Element) || (searchElement = this.searchDescendantsForNodeBackwards((Element)child, test)) == null) continue;
            return searchElement;
        }
        return null;
    }

    private void incrementPages() {
        if (this.pages != null) {
            Integer n = this.pages;
            this.pages = this.pages + 1;
        }
    }

    public void stopFormatting() {
        logger.debug("Requesting to stop formatting. Busy? {}", (Object)this.reformatter.busy);
        if (this.reformatter.busy) {
            this.reformatter.stopFormat();
            try {
                this.finishFormattingLatch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        logger.debug("Exit stopFormatting.");
    }

    public synchronized void updateFormatting() {
        int pos;
        logger.debug("Begin updateFormatting");
        StopWatch sw = new StopWatch();
        sw.start();
        this.text.setListenerLock(true);
        int sectionIndex = this.viewInitializer.getStartIndex();
        if (this.text.getView().getSelectionRanges()[1] > 0) {
            pos = this.text.getView().getSelectionRanges()[0];
            this.text.getView().setSelection(pos);
        } else {
            pos = this.text.getView().getCaretOffset();
        }
        int topIndex = this.text.getView().getTopIndex();
        this.list.clearList();
        this.containerSash.setRedraw(false);
        this.text.removeAllPaintedElements(this.text);
        this.braille.removeAllPaintedElements(this.braille);
        this.braille.clearPageRange();
        this.viewInitializer = ViewFactory.createUpdater(this.getArchiver(), this.document, this.text, this.braille);
        this.text.replaceTextRange(0, this.text.getView().getCharCount(), "");
        this.braille.replaceTextRange(0, this.braille.getView().getCharCount(), "");
        this.updateMapList(sectionIndex);
        this.xmlEdited = false;
        this.text.setTopIndex(topIndex);
        this.braille.setTopIndex(topIndex);
        int newPos = pos;
        this.list.setCurrent(this.list.findClosest(newPos, this.list.getCurrent(), 0, this.list.size() - 1));
        this.text.setListenerLock(true);
        this.setTextCaret(newPos);
        this.text.setListenerLock(false);
        this.text.setListenerLock(false);
        this.containerSash.setRedraw(true);
        sw.stop();
        logger.debug("Completed refreshFormat in: {}", (Object)sw);
    }

    private void updateMapList(int sectionIndex) {
        this.viewInitializer.initializeMap(this);
        this.viewInitializer.getSectionList().get(sectionIndex).setInView(true);
        this.list = this.viewInitializer.reformatViews(this, sectionIndex);
        if (this.list.isEmpty() && this.viewInitializer instanceof NimasInitializer) {
            this.list = ((NimasInitializer)this.viewInitializer).formatTemplateDocument(this);
        }
        this.onPostBuffer(this.list);
    }

    public void refresh() {
        this.refresh(true);
    }

    public void refresh(boolean update) {
        this.stopFormatting();
        this.removeReformattingCallback();
        this.containerSash.setRedraw(true);
        if (update) {
            this.text.update(false);
        }
        if (this.text.getView().isFocusControl()) {
            int currentOffset = this.text.getView().getCaretOffset();
            this.resetViews();
            if (currentOffset < this.text.getView().getCharCount() && currentOffset > 0) {
                this.setTextCaret(currentOffset);
            } else {
                this.setTextCaret(0);
            }
            this.setCurrentOnRefresh(Sender.TEXT);
            this.text.getView().setFocus();
            this.text.getView().setTopIndex(this.text.getView().getLineAtOffset(currentOffset));
        } else if (this.braille.getView().isFocusControl()) {
            int currentOffset = this.braille.getView().getCaretOffset();
            int textOffset = this.text.getView().getCaretOffset();
            this.resetViews();
            this.braille.getView().setCaretOffset(currentOffset);
            this.braille.setPositionFromStart();
            this.setCurrentOnRefresh(Sender.BRAILLE);
            this.braille.getView().setFocus();
            this.text.getView().setTopIndex(this.text.getView().getLineAtOffset(textOffset));
        } else {
            int currentOffset = this.text.getView().getCaretOffset();
            this.resetViews();
            this.setTextCaret(currentOffset);
            this.text.getView().setTopIndex(this.text.getView().getLineAtOffset(currentOffset));
            this.setCurrentOnRefresh(Sender.TEXT);
            this.text.getView().setFocus();
        }
        this.containerSash.setRedraw(true);
    }

    private void resetViews() {
        boolean textChanged = this.text.hasChanged;
        boolean brailleChanged = this.braille.hasChanged;
        int index = this.list.isEmpty() ? 0 : this.getSection(this.list.getCurrent());
        this.list.clearList();
        this.text.removeListeners();
        this.text.resetView((Composite)this.containerSash);
        this.braille.removeListeners();
        this.braille.resetView((Composite)this.containerSash);
        this.initializeDocumentTab();
        this.initializeAllViews();
        this.text.hasChanged = textChanged;
        this.braille.hasChanged = brailleChanged;
        if (index != -1) {
            this.viewInitializer.bufferViews(this, index);
        }
        this.onPostBuffer(this.getMapList());
        Objects.requireNonNull(this.getSimpleManager().getModule(ToggleViewsModule.class)).checkViews();
        this.getFontManager().initViews();
        SelectionAdapter lineUpScrollListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Manager.this.lineUpViews();
                Manager.this.getTextView().getVerticalBar().removeSelectionListener((SelectionListener)this);
                Manager.this.getBrailleView().getVerticalBar().removeSelectionListener((SelectionListener)this);
            }
        };
        this.getTextView().getVerticalBar().addSelectionListener((SelectionListener)lineUpScrollListener);
        this.getBrailleView().getVerticalBar().addSelectionListener((SelectionListener)lineUpScrollListener);
    }

    public void hide() {
        this.stopFormatting();
        HideActionHandler h = new HideActionHandler(this, this.viewInitializer, this.list);
        h.hideText();
    }

    public void closeUntitledTab() {
        this.text.removeListeners();
        this.text.clearText();
        this.braille.removeListeners();
        this.braille.clearText();
        this.list.clearList();
    }

    public void buffer(int index) {
        this.viewInitializer.bufferViews(this, index);
    }

    public void bufferForward() {
        this.waitForFormatting(true);
        int sectionIndex = this.viewInitializer.getStartIndex();
        while (this.viewInitializer.getSectionList().get(sectionIndex).isVisible()) {
            ++sectionIndex;
        }
        this.viewInitializer.bufferViews(this, sectionIndex, true);
    }

    public void checkForUpdatedViews() {
        if (this.text.hasChanged) {
            this.text.update(false);
        }
    }

    public int indexOf(int section, TextMapElement t) {
        if (this.viewInitializer.getSectionList().size() > 1 && !(t instanceof WhiteSpaceElement)) {
            return this.viewInitializer.getSectionList().get((int)section).list.indexOf(t);
        }
        return this.list.indexOf(t);
    }

    public int getSectionSize(int index) {
        return this.viewInitializer.getSectionList().get((int)index).list.size();
    }

    public int getSection(TextMapElement t) {
        if (t instanceof TableCellTextMapElement) {
            t = ((TableCellTextMapElement)t).getParentTableMapElement();
        }
        for (int i = 0; i < this.viewInitializer.getSectionList().size(); ++i) {
            if (!this.viewInitializer.getSectionList().get((int)i).list.contains(t)) continue;
            return i;
        }
        return -1;
    }

    public int getSection(Node n) {
        for (int i = 0; i < this.viewInitializer.getSectionList().size(); ++i) {
            if (!this.viewInitializer.getSectionList().get((int)i).list.containsNode(n)) continue;
            return i;
        }
        return -1;
    }

    public Range getRange(int section, int listIndex, Node n) {
        for (int i = section; i < this.viewInitializer.getSectionList().size(); ++i) {
            int index = this.viewInitializer.getSectionList().get((int)i).list.findNodeIndex(n, listIndex);
            if (index != -1) {
                return new Range(i, index);
            }
            listIndex = 0;
        }
        return null;
    }

    public int findNodeIndex(Node n, int section, int startIndex) {
        return this.viewInitializer.getSectionList().get((int)section).list.findNodeIndex(n, startIndex);
    }

    public TextMapElement getTextMapElement(int section, int index) {
        return (TextMapElement)this.viewInitializer.getSectionList().get((int)section).list.get(index);
    }

    public List<TextMapElement> findNodeText(Node nodeToFind) {
        int index = this.list.findNodeIndex(nodeToFind, 0);
        if (index == -1) {
            return null;
        }
        logger.debug("findNodeIndex {}", (Object)index);
        return this.list.findTextMapElements(index, (Element)nodeToFind.getParent());
    }

    public String getCurrentPrintPage(int line) {
        String returnValue = null;
        PageIndicator pageIndicator = this.findPrintPage(line);
        if (pageIndicator != null) {
            Element prevPrintPageNum = (Element)this.searchForPreviousTextMapElement(pageIndicator, n -> n instanceof Element && (UTDElements.PRINT_PAGE_NUM.isA(n) || BBX.BLOCK.PAGE_NUM.isA((Node)n) || BBX.SPAN.PAGE_NUM.isA((Node)n)));
            returnValue = prevPrintPageNum != null ? UTDHelper.getFirstTextDescendant((Element)prevPrintPageNum).getValue() : pageIndicator.getPrintPageNum();
        }
        return returnValue;
    }

    public Node getCurrentPrintPageMapElement(int line) {
        PageIndicator printPageIndicator = this.findPrintPage(line);
        Element returnValue = null;
        if (printPageIndicator != null && printPageIndicator.getPrintPageElement() != null && !printPageIndicator.getBraillePageNum().isEmpty()) {
            if (this.findPreviousPrintPageIndicator() != null) {
                try {
                    returnValue = Integer.parseInt(((Element)printPageIndicator.getPrintPageElement()).getAttributeValue("printPage")) < Integer.parseInt(this.findPreviousPrintPageIndicator().getChild(0).getValue()) ? UTDHelper.getAssociatedBrlElement((Node)this.findPreviousPrintPageIndicator().getChild(0)) : null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            returnValue = printPageIndicator.getPrintPageElement();
        } else if (this.findPreviousPrintPageIndicator() != null) {
            returnValue = UTDHelper.getAssociatedBrlElement((Node)this.findPreviousPrintPageIndicator().getChild(0));
        }
        return returnValue;
    }

    public Element findPreviousPrintPageIndicator() {
        Node node;
        Node node2 = this.list.getCurrent().getNode() != null ? this.list.getCurrent().getNode() : (node = this.list.getNext(true) != null ? this.list.getNext(true).getNode() : this.list.getPrevious(true).getNode());
        if (node instanceof Element && "PageAction".equals(((Element)node).getAttributeValue("utd-action"))) {
            return (Element)node;
        }
        return (Element)this.searchForPreviousNode(node, n -> n instanceof Element && "PageAction".equals(((Element)n).getAttributeValue("utd-action")));
    }

    public String getCurrentBraillePage(int line) {
        PageIndicator braillePageIndicator = this.findBraillePage(line);
        if (braillePageIndicator != null) {
            return braillePageIndicator.getBraillePageNum();
        }
        return null;
    }

    public Node getCurrentBraillePageMapElement(int line) {
        PageIndicator braillePageIndicator = this.findBraillePage(line);
        if (braillePageIndicator != null) {
            return braillePageIndicator.getBraillePageElement();
        }
        return null;
    }

    @Nullable
    private PageIndicator findPrintPage(int line) {
        List<PageIndicator> pages = this.text.paintedElements.getPageIndicators();
        if (!pages.isEmpty()) {
            int index = -1;
            int i = 0;
            while (i < pages.size() && line > pages.get(i).getLine()) {
                index = i++;
            }
            if (index > -1 && pages.get(index).getPrintPageNum() != null) {
                return pages.get(index);
            }
        }
        return null;
    }

    @Nullable
    private PageIndicator findBraillePage(int line) {
        List<PageIndicator> pages = this.text.paintedElements.getPageIndicators();
        if (!pages.isEmpty()) {
            int index = -1;
            int i = 0;
            while (i < pages.size() && line > pages.get(i).getLine()) {
                index = i++;
            }
            if (++index < pages.size() && pages.get(index).getBraillePageNum() != null) {
                return pages.get(index);
            }
        }
        return null;
    }

    public boolean isEmptyDocument() {
        return this.list.size() == 1 && ((TextMapElement)this.list.getFirst()).getText().isEmpty();
    }

    public boolean documentIsOnlyNewlines() {
        for (int i = 1; i < this.list.size(); ++i) {
            TextMapElement tme = (TextMapElement)this.list.get(i);
            if (tme.getNode() == null) continue;
            return false;
        }
        return true;
    }

    public FontManager getFontManager() {
        return this.fontManager;
    }

    @Nullable
    public TextMapElement getCurrentTextMapElement() {
        return this.text.getCurrentElement();
    }

    public StyledText getTextView() {
        return this.text.getView();
    }

    public StyledText getBrailleView() {
        return this.braille.getView();
    }

    public Display getDisplay() {
        return this.getWpManager().getShell().getDisplay();
    }

    public BrailleDocument getDocument() {
        return this.document;
    }

    public ViewInitializer getViewInitializer() {
        return this.viewInitializer;
    }

    public TextView getText() {
        return this.viewManager.getTextView();
    }

    public BrailleView getBraille() {
        return this.viewManager.getBrailleView();
    }

    public StylePane getStylePane() {
        return this.viewManager.stylePane;
    }

    public List<String> getIgnoreList() {
        return this.ignoreList;
    }

    public void newIgnore(String newWord) {
        this.ignoreList.add(newWord);
    }

    @Override
    public void dispose() {
        this.text.update(false);
        this.list.clearList();
        this.containerSash.dispose();
        this.reformatter.close();
    }

    @Override
    @NotNull
    public Document getDoc() {
        return this.document.doc;
    }

    @Override
    public void setStatusBarText(BBStatusBar statusBar) {
        statusBar.setText("");
    }

    public boolean isDefaultFile() {
        return this.getArchiver().getPath().equals(DEFAULT_FILE);
    }

    @Override
    public boolean canReuseTab() {
        return !this.isDocumentEdited() && !this.isDefaultFile();
    }

    @Override
    public void reuseTab(String file) {
        this.closeUntitledTab();
        this.openDocument(Paths.get(file, new String[0]));
        if (docCount > 0) {
            --docCount;
        }
    }

    public boolean isDocumentEdited() {
        return this.text.hasChanged || this.braille.hasChanged || this.isDocumentEdited;
    }

    public void setDocumentEdited(boolean documentEdited) {
        this.isDocumentEdited = documentEdited;
    }

    public Set<TextMapElement> getAllTextMapElementsInRange(int start, int end) {
        LinkedHashSet<TextMapElement> elementSelectedSet = new LinkedHashSet<TextMapElement>();
        int j = start;
        while (j < end) {
            TextMapElement t = this.list.getElementInRange(j);
            if (t != null) {
                elementSelectedSet.add(t);
                j = t.getEnd(this.getMapList()) + 1;
                continue;
            }
            ++j;
        }
        return elementSelectedSet;
    }

    public Pair<Integer, Integer> getNodeIndexAllSections(Node n) {
        int startIndex = 0;
        for (int i = 0; i < this.viewInitializer.getSectionList().size(); ++i) {
            int nodeBySection = this.viewInitializer.getSectionList().get((int)i).list.findNodeIndex(n, startIndex);
            if (nodeBySection == -1) continue;
            return new Pair((Object)i, (Object)nodeBySection);
        }
        return null;
    }

    @Nullable
    public Pair<Integer, TextMapElement> getPrintPageElement(String printPageNumber) {
        for (SectionElement curSection : this.viewInitializer.getSectionList()) {
            for (TextMapElement curElement : curSection.list) {
                if (!(curElement instanceof PageIndicatorTextMapElement)) continue;
                Node brl = curElement.brailleList.getFirst().getNode();
                while (!UTDElements.BRL.isA(brl)) {
                    brl = brl.getParent();
                }
                String brlPageNum = ((Element)brl).getAttributeValue("printPage");
                if (!Manager.pageNumberEquals(brlPageNum, printPageNumber)) continue;
                return new Pair((Object)this.viewInitializer.getSectionList().indexOf(curSection), (Object)curElement);
            }
        }
        for (SectionElement curSection : this.viewInitializer.getSectionList()) {
            for (TextMapElement curElement : curSection.list) {
                for (BrailleMapElement curBrailleElement : curElement.brailleList) {
                    if (!(curBrailleElement instanceof PrintPageBrlMapElement)) continue;
                    String origPage = ((Element)curBrailleElement.getNode()).getAttributeValue("printPage");
                    String braillePage = curBrailleElement.getNode().getValue();
                    if (!Manager.pageNumberEquals(origPage, printPageNumber) && !Manager.pageNumberEquals(braillePage, printPageNumber)) continue;
                    return new Pair((Object)this.viewInitializer.getSectionList().indexOf(curSection), (Object)curElement);
                }
            }
        }
        return null;
    }

    private static boolean pageNumberEquals(String orig, String compareTo) {
        if (orig.equalsIgnoreCase(compareTo)) {
            return true;
        }
        if (orig.contains("-")) {
            String[] parts = orig.split("-", 2);
            return parts[0].equals(compareTo) || parts[1].equals(compareTo);
        }
        return false;
    }

    @Nullable
    public Pair<Integer, TextMapElement> getBraillePageElementByUntranslatedPage(String untranslatedBraillePage, @Nullable nu.xom.Text startNode) {
        boolean afterStartNode = false;
        for (SectionElement curSection : this.viewInitializer.getSectionList()) {
            for (TextMapElement curElement : curSection.list) {
                if (startNode != null && !afterStartNode) {
                    if (curElement.getNode() != startNode) continue;
                    afterStartNode = true;
                }
                for (BrailleMapElement curBrailleElement : curElement.brailleList) {
                    String page;
                    if (!(curBrailleElement instanceof NewPageBrlMapElement) || !untranslatedBraillePage.equalsIgnoreCase(page = ((Element)curBrailleElement.getNode()).getAttributeValue("untranslated"))) continue;
                    return new Pair((Object)this.viewInitializer.getSectionList().indexOf(curSection), (Object)curElement);
                }
            }
        }
        return null;
    }

    @Nullable
    public Pair<Integer, TextMapElement> getBraillePageElement(int rawPageIndex) {
        int counter = 0;
        for (SectionElement curSection : this.viewInitializer.getSectionList()) {
            for (TextMapElement curElement : curSection.list) {
                for (BrailleMapElement curBrailleElement : curElement.brailleList) {
                    if (!(curBrailleElement instanceof BraillePageBrlMapElement)) continue;
                    if (counter == rawPageIndex) {
                        return new Pair((Object)this.viewInitializer.getSectionList().indexOf(curSection), (Object)curElement);
                    }
                    ++counter;
                }
            }
        }
        return null;
    }

    public Element getVolumeAtCursor() {
        Node currentNode = this.list.getCurrentNonWhitespace(this.getTextView().getCaretOffset()).getNode();
        return VolumeUtils.getVolumeAfterNode(this.getDoc(), currentNode);
    }

    public void setTextCaret(int offset) {
        int lineLength;
        if (offset > this.text.getView().getCharCount()) {
            offset = this.text.getView().getCharCount();
        }
        int currentLine = this.text.getView().getLineAtOffset(offset);
        int offsetAtLine = this.text.getView().getOffsetAtLine(currentLine);
        int positionInLine = offset - offsetAtLine;
        if (positionInLine > (lineLength = this.text.getView().getLine(currentLine).length())) {
            offset = offsetAtLine + lineLength;
        }
        this.text.setCurrentElement(offset);
        if (this.getStylePane().getUpdateStylePane() && !this.getTextView().isDisposed()) {
            this.getStylePane().updateCursor(this.getTextView().getLineAtOffset(this.getTextView().getCaretOffset()));
        }
    }

    public Document getLastCopiedDoc() {
        return this.lastCopiedDoc;
    }

    public void openBookTree() {
        this.checkForUpdatedViews();
        this.waitForFormatting(true);
        new BookTreeDialog(this);
    }

    public void initializeListeners() {
        this.viewManager.initializeListeners();
    }

    public void removeListeners() {
        this.viewManager.removeListeners();
    }

    public int getFirstSection() {
        return this.viewInitializer.findFirst();
    }

    public int getLastSection() {
        return this.viewInitializer.findLast();
    }

    public MapList resetSection(int sectionNumber) {
        return this.viewInitializer.bufferViews(this, sectionNumber);
    }

    public MapList useResetSectionMethod(int sectionNumber) {
        return this.viewInitializer.resetViews(this, sectionNumber);
    }

    public ArrayList<SectionElement> getSectionList() {
        return this.viewInitializer.getSectionList();
    }

    public void addUndoEvent(EventFrame f) {
        Objects.requireNonNull(this.getSimpleManager().getModule(UndoRedoModule.class)).addUndoEvent(f);
    }

    public void addRedoEvent(EventFrame f) {
        Objects.requireNonNull(this.getSimpleManager().getModule(UndoRedoModule.class)).addRedoEvent(f);
    }

    @Nullable
    public EventFrame peekUndoEvent() {
        return Objects.requireNonNull(this.getSimpleManager().getModule(UndoRedoModule.class)).peekUndoEvent();
    }

    public EventFrame popUndo() {
        return Objects.requireNonNull(this.getSimpleManager().getModule(UndoRedoModule.class)).popUndoEvent();
    }

    public IAction getAction(Node n) {
        return (IAction)this.document.getEngine().getActionMap().findValueOrDefault(n);
    }

    @Nullable
    public IStyle getStyle(@NotNull Node n) {
        return this.document.getEngine().getStyle(n);
    }

    public Node getBlock(Node n) {
        return this.document.getEngine().findTranslationBlock(n);
    }

    public MapList getMapList() {
        return this.list;
    }

    public ViewManager getViewManager() {
        return this.viewManager;
    }

    public int getTotalPagesInView() {
        int totalPages = 0;
        for (int i = 0; i < this.viewInitializer.getSectionList().size(); ++i) {
            if (!this.viewInitializer.getSectionList().get(i).isVisible()) continue;
            totalPages += this.viewInitializer.getSectionList().get((int)i).pages;
        }
        return totalPages;
    }

    public BBSimpleManager getSimpleManager() {
        return this.simpleManager;
    }

    private void countDownAllLatches() {
        if (this.rebuiltSectionLatch != null) {
            this.rebuiltSectionLatch.countDown();
        }
        if (this.rebuiltSectionMapLatch != null) {
            this.rebuiltSectionMapLatch.countDown();
        }
        if (this.finishFormattingLatch != null) {
            this.finishFormattingLatch.countDown();
        }
    }

    @Override
    @NotNull
    public Archiver2 getArchiver() {
        return Objects.requireNonNull(this.archiver, "Manager not open");
    }

    class Reformatter
    implements Runnable {
        Element newPage;
        Element printPageBrl;
        public final boolean finished;
        public boolean busy;
        volatile boolean close = false;
        final Manager manager;
        CountDownLatch workLatch = new CountDownLatch(1);

        public Reformatter(Manager manager) {
            logger.debug("Reformatter initialized");
            this.finished = false;
            this.manager = manager;
        }

        @Override
        public void run() {
            boolean running = true;
            while (running) {
                try {
                    while (this.newPage == null) {
                        this.workLatch.await(10L, TimeUnit.SECONDS);
                        if (this.newPage == null && this.manager.getWpManager().getShell().isDisposed()) {
                            return;
                        }
                        if (!this.close) continue;
                        return;
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.close) {
                    return;
                }
                try {
                    Manager.this.finishFormattingLatch = new CountDownLatch(1);
                    Manager.this.restartFormatFlag = false;
                    logger.debug("Sending newPage: {} and printPageBrl: {} to partialFormat", (Object)this.newPage.toXML(), (Object)this.printPageBrl);
                    Manager.this.document.getEngine().partialFormat(this.newPage, this.printPageBrl);
                }
                catch (UTDInterruption e) {
                    logger.debug("Reformatter was interrupted");
                }
                catch (RuntimeException e) {
                    formatterException = e;
                }
                finally {
                    this.busy = false;
                    this.workLatch = new CountDownLatch(1);
                    this.newPage = null;
                    this.printPageBrl = null;
                    Manager.this.finishFormattingLatch.countDown();
                    if (formatterException != null && Manager.this.rebuiltSectionLatch != null) {
                        Manager.this.rebuiltSectionLatch.countDown();
                    }
                    if (!this.close) continue;
                    running = false;
                }
            }
        }

        public void startFormat(Element newPage, Element printPageBrl) {
            logger.debug("StartFormat received newPage: {} PrintPageBrl: {}", (Object)newPage.toXML(), (Object)printPageBrl);
            this.newPage = newPage;
            this.printPageBrl = printPageBrl;
            if (this.busy) {
                throw new IllegalStateException("StartFormat called while busy");
            }
            this.busy = true;
            this.workLatch.countDown();
        }

        public void stopFormat() {
            logger.debug("StopFormat called. Reformatter busy? {}", (Object)this.busy);
            this.newPage = null;
            this.printPageBrl = null;
            Manager.this.restartFormatFlag = true;
            this.workLatch = new CountDownLatch(1);
        }

        public void close() {
            logger.debug("Closing reformatter thread");
            this.close = true;
            if (this.busy) {
                this.stopFormat();
            }
            this.workLatch.countDown();
        }
    }
}

