/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.perspectives.braille.stylers;

import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import nu.xom.Element;
import nu.xom.Node;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.perspectives.braille.document.BrailleDocument;
import org.brailleblaster.perspectives.braille.mapping.elements.AbstractMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.BoxLineTextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.PageIndicatorTextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.TextMapElement;
import org.brailleblaster.perspectives.braille.mapping.maps.MapList;
import org.brailleblaster.perspectives.braille.messages.AdjustLocalStyleMessage;
import org.brailleblaster.perspectives.braille.messages.UpdateStyleMessage;
import org.brailleblaster.perspectives.braille.stylers.Handler;
import org.brailleblaster.perspectives.braille.viewInitializer.ViewInitializer;
import org.brailleblaster.settings.UTDManager;
import org.brailleblaster.utd.IStyle;
import org.brailleblaster.utd.Style;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\r2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u000e\u001a\u00020\u0018R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/brailleblaster/perspectives/braille/stylers/StyleHandler;", "Lorg/brailleblaster/perspectives/braille/stylers/Handler;", "manager", "Lorg/brailleblaster/perspectives/braille/Manager;", "vi", "Lorg/brailleblaster/perspectives/braille/viewInitializer/ViewInitializer;", "list", "Lorg/brailleblaster/perspectives/braille/mapping/maps/MapList;", "<init>", "(Lorg/brailleblaster/perspectives/braille/Manager;Lorg/brailleblaster/perspectives/braille/viewInitializer/ViewInitializer;Lorg/brailleblaster/perspectives/braille/mapping/maps/MapList;)V", "document", "Lorg/brailleblaster/perspectives/braille/document/BrailleDocument;", "updateStyle", "", "message", "Lorg/brailleblaster/perspectives/braille/messages/UpdateStyleMessage;", "handleStyleSingleSelected", "Lnu/xom/Element;", "handleStyleMultiSelected", "parentStyle", "current", "Lorg/brailleblaster/perspectives/braille/mapping/elements/TextMapElement;", "createAndApplyStyle", "t", "Lorg/brailleblaster/perspectives/braille/messages/AdjustLocalStyleMessage;", "Companion", "brailleblaster-core"})
public final class StyleHandler
extends Handler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BrailleDocument document;

    public StyleHandler(@NotNull Manager manager, @Nullable ViewInitializer vi, @Nullable MapList list) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        ViewInitializer viewInitializer = vi;
        Intrinsics.checkNotNull((Object)viewInitializer);
        MapList mapList = list;
        Intrinsics.checkNotNull((Object)mapList);
        super(manager, viewInitializer, mapList);
        BrailleDocument brailleDocument = manager.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)brailleDocument, (String)"getDocument(...)");
        this.document = brailleDocument;
    }

    public final void updateStyle(@NotNull UpdateStyleMessage message) {
        Element e;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Element element = e = !message.multiSelect() ? this.handleStyleSingleSelected(message) : this.handleStyleMultiSelected(message);
        if (e != null) {
            this.reformat((Node)e, false);
        }
    }

    private final Element handleStyleSingleSelected(UpdateStyleMessage message) {
        TextMapElement textMapElement = this.list.getCurrent();
        Intrinsics.checkNotNullExpressionValue((Object)textMapElement, (String)"getCurrent(...)");
        Element parent = this.parentStyle(textMapElement);
        if (!this.readOnly(parent)) {
            IStyle style = message.style;
            this.document.changeStyle(style, parent);
            return parent;
        }
        return null;
    }

    private final Element handleStyleMultiSelected(UpdateStyleMessage message) {
        int start = this.text.getSelectedText()[0];
        int end = this.text.getSelectedText()[0] + this.text.getSelectedText()[1];
        Set<TextMapElement> itemSet = this.manager.getMapList().getElementInSelectedRange(start, end);
        Iterator<TextMapElement> itr = itemSet.iterator();
        Element firstEl = null;
        while (itr.hasNext()) {
            TextMapElement tempElement = itr.next();
            if (tempElement instanceof BoxLineTextMapElement || tempElement instanceof PageIndicatorTextMapElement) continue;
            Element parent = this.parentStyle(tempElement);
            if (firstEl == null) {
                firstEl = parent;
            }
            IStyle style = message.style;
            this.document.changeStyle(style, parent);
        }
        this.text.setCurrentSelection(this.text.getView().getCaretOffset(), this.text.getView().getCaretOffset());
        return firstEl;
    }

    private final Element parentStyle(TextMapElement current) {
        Element element;
        if (current instanceof PageIndicatorTextMapElement || current instanceof BoxLineTextMapElement) {
            element = ((AbstractMapElement)current).getNodeParent();
        } else {
            Node node = current.getNode();
            Intrinsics.checkNotNullExpressionValue((Object)node, (String)"getNode(...)");
            element = this.document.getParent(node);
        }
        Element parent = element;
        Intrinsics.checkNotNull((Object)parent);
        return parent;
    }

    public final void createAndApplyStyle(@Nullable TextMapElement t, @NotNull AdjustLocalStyleMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Element element = message.getElement(this.manager);
        if (element == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        Element e = element;
        Object object = this.manager.getDocument().getEngine().getStyleMap().findValueOrDefault((Node)e);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.brailleblaster.utd.Style");
        Style style = (Style)object;
        if (message instanceof AdjustLocalStyleMessage.AdjustIndentMessage) {
            style = this.manager.getDocument().getSettingsManager().applyStyleWithOption(style, Style.StyleOption.FIRST_LINE_INDENT, ((AdjustLocalStyleMessage.AdjustIndentMessage)message).getIndent(), e);
        } else if (message instanceof AdjustLocalStyleMessage.AdjustMarginMessage) {
            style = this.manager.getDocument().getSettingsManager().applyStyleWithOption(style, Style.StyleOption.INDENT, ((AdjustLocalStyleMessage.AdjustMarginMessage)message).getMargin(), e);
        } else if (message instanceof AdjustLocalStyleMessage.AdjustAlignmentMessage) {
            style = this.manager.getDocument().getSettingsManager().applyStyleWithOption(style, Style.StyleOption.ALIGN, ((AdjustLocalStyleMessage.AdjustAlignmentMessage)message).getAlignment(), e);
        } else if (message instanceof AdjustLocalStyleMessage.AdjustLinesMessage) {
            int lines = ((AdjustLocalStyleMessage.AdjustLinesMessage)message).getLines();
            style = ((AdjustLocalStyleMessage.AdjustLinesMessage)message).getLinesBefore() ? this.manager.getDocument().getSettingsManager().applyStyleWithOption(style, Style.StyleOption.LINES_BEFORE, lines, e) : this.manager.getDocument().getSettingsManager().applyStyleWithOption(style, Style.StyleOption.LINES_AFTER, lines, e);
        } else if (message instanceof AdjustLocalStyleMessage.AdjustPageMessage) {
            int newPagesBefore = ((AdjustLocalStyleMessage.AdjustPageMessage)message).getNewPagesBefore();
            if (style.getNewPagesBefore() != newPagesBefore) {
                style = this.manager.getDocument().getSettingsManager().applyStyleWithOption(style, Style.StyleOption.NEW_PAGES_BEFORE, newPagesBefore, e);
            }
            int newPagesAfter = ((AdjustLocalStyleMessage.AdjustPageMessage)message).getNewPagesAfter();
            if (style.getNewPagesAfter() != newPagesAfter) {
                style = this.manager.getDocument().getSettingsManager().applyStyleWithOption(style, Style.StyleOption.NEW_PAGES_AFTER, newPagesAfter, e);
            }
        } else {
            throw new UnsupportedOperationException("Not implemented: " + message.getClass().getName());
        }
        this.reformat((Node)e, false);
    }

    @JvmStatic
    public static final void addStyle(@NotNull Element element, @Nullable String style, @NotNull Manager man) {
        Companion.addStyle(element, style, man);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007\u00a8\u0006\f"}, d2={"Lorg/brailleblaster/perspectives/braille/stylers/StyleHandler$Companion;", "", "<init>", "()V", "addStyle", "", "element", "Lnu/xom/Element;", "style", "", "man", "Lorg/brailleblaster/perspectives/braille/Manager;", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void addStyle(@NotNull Element element, @Nullable String style, @NotNull Manager man) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)man, (String)"man");
            Style replaceStyle = man.getDocument().getEngine().getStyleDefinitions().getStyleByName(style);
            if (style != null) {
                UTDManager utd = man.getSimpleManager().getUtdManager();
                UTDManager.applyStyle$default(utd, replaceStyle, element, element.getDocument(), false, 8, null);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

