/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.perspectives.braille.stylers;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.perspectives.braille.document.BrailleDocument;
import org.brailleblaster.perspectives.braille.eventQueue.Event;
import org.brailleblaster.perspectives.braille.eventQueue.EventFrame;
import org.brailleblaster.perspectives.braille.eventQueue.EventTypes;
import org.brailleblaster.perspectives.braille.eventQueue.ViewEvent;
import org.brailleblaster.perspectives.braille.mapping.elements.LineNumberTextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.TextMapElement;
import org.brailleblaster.perspectives.braille.mapping.maps.MapList;
import org.brailleblaster.perspectives.braille.messages.UpdateMessage;
import org.brailleblaster.perspectives.braille.stylers.Handler;
import org.brailleblaster.perspectives.braille.viewInitializer.ViewInitializer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u000fH\u0002J\u000e\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001c"}, d2={"Lorg/brailleblaster/perspectives/braille/stylers/TextUpdateHandler;", "Lorg/brailleblaster/perspectives/braille/stylers/Handler;", "manager", "Lorg/brailleblaster/perspectives/braille/Manager;", "vi", "Lorg/brailleblaster/perspectives/braille/viewInitializer/ViewInitializer;", "list", "Lorg/brailleblaster/perspectives/braille/mapping/maps/MapList;", "<init>", "(Lorg/brailleblaster/perspectives/braille/Manager;Lorg/brailleblaster/perspectives/braille/viewInitializer/ViewInitializer;Lorg/brailleblaster/perspectives/braille/mapping/maps/MapList;)V", "document", "Lorg/brailleblaster/perspectives/braille/document/BrailleDocument;", "getDocument", "()Lorg/brailleblaster/perspectives/braille/document/BrailleDocument;", "updateText", "", "message", "Lorg/brailleblaster/perspectives/braille/messages/UpdateMessage;", "resetText", "textStr", "", "clearEditEvents", "undoEdit", "f", "Lorg/brailleblaster/perspectives/braille/eventQueue/EventFrame;", "redoEdit", "recreateEditEvent", "Companion", "brailleblaster-core"})
public final class TextUpdateHandler
extends Handler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BrailleDocument document;

    public TextUpdateHandler(@NotNull Manager manager, @NotNull ViewInitializer vi, @NotNull MapList list) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)vi, (String)"vi");
        Intrinsics.checkNotNullParameter((Object)list, (String)"list");
        super(manager, vi, list);
        BrailleDocument brailleDocument = manager.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)brailleDocument, (String)"getDocument(...)");
        this.document = brailleDocument;
    }

    @NotNull
    public final BrailleDocument getDocument() {
        return this.document;
    }

    public final void updateText(@NotNull UpdateMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.clearEditEvents();
        this.resetText(message.newText);
        this.manager.setDocumentEdited(true);
    }

    private final void resetText(String textStr) {
        String text = textStr;
        if (this.list.getCurrentIndex() < this.list.size() - 1) {
            Object e = this.list.get(this.list.getCurrentIndex() + 1);
            Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
            TextMapElement t = (TextMapElement)e;
            if (t instanceof LineNumberTextMapElement) {
                CharSequence charSequence = text;
                Regex regex = new Regex("\\s+$");
                String string = "";
                text = regex.replace(charSequence, string);
            }
        }
        this.document.updateNode(this.manager, this.list, text);
    }

    private final void clearEditEvents() {
        while (TextUpdateHandler.Companion.isEditEvent(this.manager.peekUndoEvent())) {
            this.manager.popUndo();
        }
    }

    public final void undoEdit(@NotNull EventFrame f) {
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        EventFrame frame = this.recreateEditEvent(f);
        this.manager.addRedoEvent(frame);
    }

    public final void redoEdit(@NotNull EventFrame f) {
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        EventFrame frame = this.recreateEditEvent(f);
        this.manager.addUndoEvent(frame);
    }

    private final EventFrame recreateEditEvent(EventFrame f) {
        EventFrame frame = new EventFrame();
        while (!f.empty()) {
            Event event = f.peek();
            Intrinsics.checkNotNull((Object)event);
            if (event.getEventType() != EventTypes.Edit) break;
            this.manager.removeListeners();
            Event event2 = f.pop();
            Intrinsics.checkNotNull((Object)event2, (String)"null cannot be cast to non-null type org.brailleblaster.perspectives.braille.eventQueue.ViewEvent");
            ViewEvent ev = (ViewEvent)event2;
            if (ev.getTextOffset() >= this.text.getCurrentStart() && ev.getTextOffset() <= this.text.getCurrentEnd()) {
                this.text.getView().setCaretOffset(ev.getTextOffset());
            } else {
                this.text.setCurrentElement(ev.getTextOffset());
            }
            int start = ev.getTextOffset();
            int end = ev.getTextOffset() + ev.getTextEnd();
            String replacedText = this.text.getView().getTextRange(ev.getTextOffset(), end - start);
            int n = ev.getText().length();
            Intrinsics.checkNotNull((Object)replacedText);
            frame.addEvent(new ViewEvent(EventTypes.Edit, start, n, 0, 0, replacedText));
            this.text.undoEdit(ev.getTextOffset(), ev.getTextEnd(), ev.getText());
            this.manager.initializeListeners();
        }
        return frame;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002\u00a8\u0006\b"}, d2={"Lorg/brailleblaster/perspectives/braille/stylers/TextUpdateHandler$Companion;", "", "<init>", "()V", "isEditEvent", "", "eventFrame", "Lorg/brailleblaster/perspectives/braille/eventQueue/EventFrame;", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isEditEvent(EventFrame eventFrame) {
            return eventFrame != null && !eventFrame.empty() && eventFrame.get(0).getEventType() == EventTypes.Edit;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

