/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.perspectives.braille.toolbar;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.lang3.StringUtils;
import org.brailleblaster.math.mathml.MathModuleUtils;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.perspectives.braille.toolbar.CustomToolBarBuilder;
import org.brailleblaster.perspectives.braille.toolbar.IToolBarElement;
import org.brailleblaster.perspectives.braille.toolbar.ToolBarCustomSection;
import org.brailleblaster.perspectives.braille.toolbar.ToolBarNewLine;
import org.brailleblaster.perspectives.braille.toolbar.ToolBarSection;
import org.brailleblaster.perspectives.braille.toolbar.ToolBarSettings;
import org.brailleblaster.perspectives.mvc.ViewManager;
import org.brailleblaster.perspectives.mvc.menu.BBSelectionData;
import org.brailleblaster.perspectives.mvc.menu.EmphasisItem;
import org.brailleblaster.perspectives.mvc.menu.MenuManager;
import org.brailleblaster.perspectives.mvc.menu.SharedItem;
import org.brailleblaster.perspectives.mvc.modules.misc.ToggleViewsModule;
import org.brailleblaster.perspectives.mvc.modules.views.DebugModule;
import org.brailleblaster.util.ImageHelper;
import org.brailleblaster.utils.localization.LocaleHandler;
import org.brailleblaster.wordprocessor.WPManager;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00c0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 ]2\u00020\u0001:\u0003[\\]B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J\b\u0010\"\u001a\u00020#H\u0002J\u000e\u0010$\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020&J\b\u0010'\u001a\u00020#H\u0002J\b\u0010(\u001a\u00020#H\u0002J\b\u0010)\u001a\u00020#H\u0002J\u0018\u0010*\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0002J\b\u0010/\u001a\u00020#H\u0002J\b\u00100\u001a\u00020#H\u0002J\b\u00101\u001a\u00020#H\u0002J\b\u00102\u001a\u000203H\u0002J\u0018\u00104\u001a\u00020\u001f2\u0006\u00105\u001a\u0002062\u0006\u0010-\u001a\u00020.H\u0002J\u0006\u00107\u001a\u00020\u0006J\b\u00108\u001a\u00020\u001fH\u0002J\b\u00109\u001a\u00020\u001fH\u0002J&\u0010:\u001a\u00020\u001f2\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020\u00062\f\u0010>\u001a\b\u0012\u0004\u0012\u00020@0?H\u0002J\u0016\u0010A\u001a\u00020B2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020@0?H\u0002J&\u0010C\u001a\u00020\u001f2\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020\u00062\f\u0010>\u001a\b\u0012\u0004\u0012\u00020@0?H\u0002J\u0018\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020\u00062\u0006\u0010G\u001a\u00020EH\u0002J\u001c\u0010H\u001a\b\u0012\u0004\u0012\u00020@0?2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020@0?H\u0002J\u0016\u0010I\u001a\b\u0012\u0004\u0012\u00020\u000f0?2\u0006\u0010=\u001a\u00020\u0006H\u0002J\u0010\u0010J\u001a\u00020K2\u0006\u0010=\u001a\u00020\u0006H\u0002J.\u0010L\u001a\u00020E2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020@0?2\u0006\u0010M\u001a\u00020E2\u0006\u0010G\u001a\u00020E2\u0006\u0010N\u001a\u00020\u0006H\u0002J\b\u0010O\u001a\u00020\u001fH\u0002J4\u0010P\u001a\u00020\u00142\u0006\u0010M\u001a\u00020E2\u0006\u0010G\u001a\u00020E2\u0006\u0010Q\u001a\u00020K2\b\b\u0002\u0010R\u001a\u00020E2\b\b\u0002\u0010S\u001a\u00020EH\u0002J\u0010\u0010T\u001a\u00020U2\u0006\u0010V\u001a\u00020,H\u0002J\u0006\u0010W\u001a\u00020\u001fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010X\u001a\u00020E8F\u00a2\u0006\u0006\u001a\u0004\bY\u0010Z\u00a8\u0006^"}, d2={"Lorg/brailleblaster/perspectives/braille/toolbar/ToolBarBuilder;", "", "parent", "Lorg/eclipse/swt/widgets/Shell;", "onRebuild", "Ljava/util/function/Consumer;", "Lorg/eclipse/swt/widgets/ToolBar;", "onExpand", "onCondense", "<init>", "(Lorg/eclipse/swt/widgets/Shell;Ljava/util/function/Consumer;Ljava/util/function/Consumer;Ljava/util/function/Consumer;)V", "disposeables", "", "Lorg/eclipse/swt/graphics/Resource;", "sections", "Lorg/brailleblaster/perspectives/braille/toolbar/IToolBarElement;", "customToolbars", "Lorg/brailleblaster/perspectives/braille/toolbar/ToolBarCustomSection;", "widgets", "expanded", "", "arrowCursor", "Lorg/eclipse/swt/graphics/Cursor;", "moveCursor", "state", "Lorg/brailleblaster/perspectives/braille/toolbar/ToolBarBuilder$MouseState;", "toolBarHolder", "Lorg/eclipse/swt/widgets/Composite;", "userScale", "Lorg/brailleblaster/perspectives/braille/toolbar/ToolBarSettings$Scale;", "createSection", "", "setting", "Lorg/brailleblaster/perspectives/braille/toolbar/ToolBarSettings$Settings;", "createMath", "Lorg/brailleblaster/perspectives/braille/toolbar/ToolBarSection;", "createCustomToolBar", "custTB", "Lorg/brailleblaster/perspectives/braille/toolbar/CustomToolBarBuilder;", "createFileSection", "createDocumentSection", "createStyleSection", "openStyleMenu", "category", "", "event", "Lorg/brailleblaster/perspectives/mvc/menu/BBSelectionData;", "createViewSection", "createToolsSection", "createEmphasisSection", "createNewLine", "Lorg/brailleblaster/perspectives/braille/toolbar/ToolBarNewLine;", "setMenuLocation", "menu", "Lorg/eclipse/swt/widgets/Menu;", "build", "calculateLineWrap", "addListeners", "handleStartDrag", "e", "Lorg/eclipse/swt/events/MouseEvent;", "toolBar", "relocBounds", "", "Lorg/brailleblaster/perspectives/braille/toolbar/ToolBarBuilder$RelocatorRectangle;", "handleDragging", "Lorg/eclipse/swt/events/MouseMoveListener;", "handleEndDrag", "findToolBar", "", "startingToolBar", "y", "getEndOfLineBounds", "getSectionsInToolBar", "findBottomDockPoint", "Lorg/eclipse/swt/graphics/Rectangle;", "overRelocator", "x", "source", "removeLineWrapNewLines", "rectangleCollision", "rect", "horizPadding", "vertPadding", "getImage", "Lorg/eclipse/swt/graphics/Image;", "imgName", "dispose", "height", "getHeight", "()I", "MouseState", "RelocatorRectangle", "Companion", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nToolBarBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToolBarBuilder.kt\norg/brailleblaster/perspectives/braille/toolbar/ToolBarBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,603:1\n812#2,12:604\n777#2:616\n873#2,2:617\n777#2:619\n873#2,2:620\n777#2:622\n873#2,2:623\n777#2:625\n873#2,2:626\n*S KotlinDebug\n*F\n+ 1 ToolBarBuilder.kt\norg/brailleblaster/perspectives/braille/toolbar/ToolBarBuilder\n*L\n296#1:604,12\n297#1:616\n297#1:617,2\n502#1:619\n502#1:620,2\n513#1:622\n513#1:623,2\n542#1:625\n542#1:626,2\n*E\n"})
public final class ToolBarBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Shell parent;
    @NotNull
    private final Consumer<ToolBar> onRebuild;
    @NotNull
    private final Consumer<ToolBar> onExpand;
    @NotNull
    private final Consumer<ToolBar> onCondense;
    @NotNull
    private final List<Resource> disposeables;
    @NotNull
    private List<IToolBarElement> sections;
    @NotNull
    private final List<ToolBarCustomSection> customToolbars;
    @NotNull
    private final List<ToolBar> widgets;
    private boolean expanded;
    @NotNull
    private final Cursor arrowCursor;
    @NotNull
    private final Cursor moveCursor;
    @NotNull
    private MouseState state;
    @NotNull
    private final Composite toolBarHolder;
    @NotNull
    private final ToolBarSettings.Scale userScale;
    @NotNull
    private static final LocaleHandler LOCALE_HANDLER = LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null);
    @NotNull
    public static final String TOOLBAR_FOLDER = "toolbar/";
    private static final int DRAG_PADDING = 30;
    private static final int EXTENDED_RELOCATOR = 21;

    public ToolBarBuilder(@NotNull Shell parent, @NotNull Consumer<ToolBar> onRebuild, @NotNull Consumer<ToolBar> onExpand, @NotNull Consumer<ToolBar> onCondense) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter(onRebuild, (String)"onRebuild");
        Intrinsics.checkNotNullParameter(onExpand, (String)"onExpand");
        Intrinsics.checkNotNullParameter(onCondense, (String)"onCondense");
        this.parent = parent;
        this.onRebuild = onRebuild;
        this.onExpand = onExpand;
        this.onCondense = onCondense;
        this.state = new MouseState();
        this.sections = new ArrayList();
        this.customToolbars = new ArrayList();
        this.widgets = new ArrayList();
        this.arrowCursor = new Cursor((Device)Display.getCurrent(), 0);
        this.moveCursor = new Cursor((Device)Display.getCurrent(), 5);
        this.toolBarHolder = new Composite((Composite)this.parent, 0);
        this.toolBarHolder.setLayout((Layout)new GridLayout(1, false));
        ViewManager.Companion.colorizeToolbarHolder(this.toolBarHolder);
        this.disposeables = new ArrayList();
        ((ArrayList)this.disposeables).add(this.arrowCursor);
        ((ArrayList)this.disposeables).add(this.moveCursor);
        this.userScale = ToolBarSettings.INSTANCE.getScale();
    }

    public final void createSection(@NotNull ToolBarSettings.Settings setting) {
        Intrinsics.checkNotNullParameter((Object)((Object)setting), (String)"setting");
        IToolBarElement section = switch (WhenMappings.$EnumSwitchMapping$0[setting.ordinal()]) {
            case 1 -> this.createDocumentSection();
            case 2 -> this.createFileSection();
            case 3 -> this.createStyleSection();
            case 4 -> this.createToolsSection();
            case 5 -> this.createViewSection();
            case 6 -> this.createEmphasisSection();
            case 7 -> this.createNewLine();
            case 8 -> this.createMath();
            default -> throw new NoWhenBranchMatchedException();
        };
        this.sections.add(section);
        if (section instanceof ToolBarSection) {
            this.calculateLineWrap();
        }
    }

    private final ToolBarSection createMath() {
        ToolBarSection section = new ToolBarSection(ToolBarSettings.Settings.MATH);
        section.addItem(this.getImage("math"), MathModuleUtils.MATH_TOGGLE, SharedItem.MATH_TOGGLE);
        section.addItem(this.getImage("numericSeries"), MathModuleUtils.NUMERIC_SERIES, SharedItem.NUMERIC_SERIES);
        section.addItem(this.getImage("asciiEditor"), MathModuleUtils.ASCII_EDITOR, SharedItem.ASCII_EDITOR);
        section.addItem(this.getImage("spatialMath"), MathModuleUtils.SPATIAL_COMBO, SharedItem.SPATIAL_COMBO);
        section.addItem(this.getImage("nemethBlock"), MathModuleUtils.NEMETH_BLOCK, SharedItem.NEMETH_BLOCK);
        section.addItem(this.getImage("nemethInline"), MathModuleUtils.NEMETH_INLINE, SharedItem.NEMETH_INLINE);
        section.addItem(this.getImage("numericBlock"), MathModuleUtils.NUMERIC_BLOCK, SharedItem.NUMERIC_BLOCK);
        section.addItem(this.getImage("numericInline"), MathModuleUtils.NUMERIC_INLINE, SharedItem.NUMERIC_INLINE);
        section.addItem(this.getImage("mathHelp"), MathModuleUtils.MATH_HELP, SharedItem.ABOUT_MATH);
        if (DebugModule.enabled) {
            section.addItem(this.getImage("mathTable"), MathModuleUtils.MATH_TABLE, SharedItem.MATH_TABLE);
        }
        return section;
    }

    public final void createCustomToolBar(@NotNull CustomToolBarBuilder custTB) {
        Intrinsics.checkNotNullParameter((Object)custTB, (String)"custTB");
        ToolBarCustomSection section = new ToolBarCustomSection(custTB, this.toolBarHolder);
        this.sections.add(section);
        this.customToolbars.add(section);
    }

    private final ToolBarSection createFileSection() {
        ToolBarSection section = new ToolBarSection(ToolBarSettings.Settings.FILE);
        section.addItem(this.getImage("open"), "Open", SharedItem.OPEN);
        section.addItem(this.getImage("save"), "Save", SharedItem.SAVE);
        section.addItem(this.getImage("print"), "Print", SharedItem.PRINT);
        section.addItem(this.getImage("emboss"), "Emboss", SharedItem.EMBOSS);
        return section;
    }

    private final ToolBarSection createDocumentSection() {
        ToolBarSection section = new ToolBarSection(ToolBarSettings.Settings.DOCUMENT);
        section.addItem(this.getImage("undo"), "Undo", SharedItem.UNDO);
        section.addItem(this.getImage("redo"), "Redo", SharedItem.REDO);
        section.addItem(this.getImage("braillePreview"), "Braille Preview", SharedItem.BRAILLE_PREVIEW);
        return section;
    }

    private final ToolBarSection createStyleSection() {
        ToolBarSection section = new ToolBarSection(ToolBarSettings.Settings.STYLE);
        Set<String> categories = MenuManager.getStyleMenuCategories();
        for (String category : categories) {
            Image image = this.getImage(category);
            String string = category;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            section.addItem(image, StringUtils.capitalize((String)string2), arg_0 -> ToolBarBuilder.createStyleSection$lambda$0(this, category, arg_0));
        }
        section.addItem(this.getImage("repeatStyle"), "Repeat Last Style", SharedItem.REPEAT_LAST_STYLE);
        return section;
    }

    private final void openStyleMenu(String category, BBSelectionData event) {
        Menu testMenu;
        Menu menu = testMenu = MenuManager.getFromStyleMenu(category, this.toolBarHolder);
        Intrinsics.checkNotNull((Object)menu);
        this.setMenuLocation(menu, event);
    }

    private final ToolBarSection createViewSection() {
        ToolBarSection section = new ToolBarSection(ToolBarSettings.Settings.VIEW);
        List<ToggleViewsModule.Views> activeViews = ToggleViewsModule.Companion.loadSettings();
        section.addCheckItem(this.getImage("view_S"), "Style View", activeViews.contains((Object)ToggleViewsModule.Views.STYLE), SharedItem.STYLE_VIEW);
        section.addCheckItem(this.getImage("view_P"), "Print View", activeViews.contains((Object)ToggleViewsModule.Views.PRINT), SharedItem.PRINT_VIEW);
        section.addCheckItem(this.getImage("view_B"), "Braille View", activeViews.contains((Object)ToggleViewsModule.Views.BRAILLE), SharedItem.BRAILLE_VIEW);
        return section;
    }

    private final ToolBarSection createToolsSection() {
        ToolBarSection section = new ToolBarSection(ToolBarSettings.Settings.TOOLS);
        section.addItem(this.getImage("editTable"), "Edit Table", SharedItem.EDIT_TABLE);
        Manager currentManager = WPManager.Companion.getInstance().getController();
        section.addCheckItem(this.getImage("sixKey"), LOCALE_HANDLER.get("SixKeyMode.toolbarItem"), currentManager.getText().getSixKeyMode(), SharedItem.SIX_KEY);
        section.addItem(this.getImage("findReplace"), "Find/Replace", SharedItem.SEARCH);
        section.addItem(this.getImage("changeTranslation"), "Change Translation", arg_0 -> ToolBarBuilder.createToolsSection$lambda$0(this, arg_0));
        return section;
    }

    private final ToolBarSection createEmphasisSection() {
        ToolBarSection section = new ToolBarSection(ToolBarSettings.Settings.EMPHASIS);
        section.addItem(this.getImage("bold"), EmphasisItem.BOLD.longName, MenuManager.getEmphasisSelection(EmphasisItem.BOLD));
        section.addItem(this.getImage("italic"), EmphasisItem.ITALIC.longName, MenuManager.getEmphasisSelection(EmphasisItem.ITALIC));
        section.addItem(this.getImage("underline"), EmphasisItem.UNDERLINE.longName, MenuManager.getEmphasisSelection(EmphasisItem.UNDERLINE));
        section.addItem(this.getImage("script"), EmphasisItem.SCRIPT.longName, MenuManager.getEmphasisSelection(EmphasisItem.SCRIPT));
        section.addItem(this.getImage("tnNote"), EmphasisItem.TNSYMBOLS.longName, MenuManager.getEmphasisSelection(EmphasisItem.TNSYMBOLS));
        section.addItem(this.getImage("tdTypeform"), "Transcriber-Defined Typeforms", arg_0 -> ToolBarBuilder.createEmphasisSection$lambda$0(this, arg_0));
        return section;
    }

    private final ToolBarNewLine createNewLine() {
        return new ToolBarNewLine(true);
    }

    private final void setMenuLocation(Menu menu, BBSelectionData event) {
        Rectangle cursorLoc = null;
        Control cursorControl = Display.getCurrent().getCursorControl();
        if (cursorControl != null) {
            cursorLoc = cursorControl.getBounds();
        }
        if (cursorLoc == null) {
            cursorLoc = (Rectangle)new Rectangle.WithMonitor(0, 0, 0, 0, Display.getCurrent().getPrimaryMonitor());
        }
        Widget widget = event.getWidget();
        Intrinsics.checkNotNull((Object)widget, (String)"null cannot be cast to non-null type org.eclipse.swt.widgets.ToolItem");
        Rectangle toolItem = ((ToolItem)widget).getBounds();
        menu.setLocation(this.toolBarHolder.toDisplay(cursorLoc.x + toolItem.x, cursorLoc.y + toolItem.height));
        menu.setVisible(true);
    }

    @NotNull
    public final ToolBar build() {
        ToolBar newToolBar = new ToolBar(this.toolBarHolder, 256);
        ViewManager.Companion.colorizeIconToolbars(newToolBar);
        this.widgets.add(newToolBar);
        newToolBar.setLayoutData((Object)new GridData(16384, 16384, false, true, 1, 1));
        for (IToolBarElement section : this.sections) {
            ToolBar tempToolBar = section.createSection(newToolBar, (Map<SharedItem, ToolItem>)MenuManager.INSTANCE.getSharedToolBars());
            ViewManager.Companion.colorizeIconToolbars(tempToolBar);
            if (tempToolBar == newToolBar) continue;
            this.widgets.add(tempToolBar);
            newToolBar = tempToolBar;
        }
        this.addListeners();
        return newToolBar;
    }

    private final void calculateLineWrap() {
        int lineWidth = 0;
        int shellWidth = this.parent.getClientArea().width;
        int n = ((Collection)this.sections).size();
        for (int i = 0; i < n; ++i) {
            IToolBarElement section = this.sections.get(i);
            if (section instanceof ToolBarNewLine) {
                lineWidth = 0;
                continue;
            }
            boolean beginningOfLine = lineWidth == 0;
            Intrinsics.checkNotNull((Object)section, (String)"null cannot be cast to non-null type org.brailleblaster.perspectives.braille.toolbar.ToolBarSection");
            ToolBarSection tbSection = (ToolBarSection)section;
            Layout layout = this.toolBarHolder.getLayout();
            Intrinsics.checkNotNull((Object)layout, (String)"null cannot be cast to non-null type org.eclipse.swt.layout.GridLayout");
            int horizPadding = ((GridLayout)layout).horizontalSpacing;
            if ((lineWidth += tbSection.getImageWidth(horizPadding) + 11 + horizPadding) <= shellWidth || beginningOfLine) continue;
            this.sections.add(i, new ToolBarNewLine(false));
            lineWidth = 0;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addListeners() {
        List relocBounds = new ArrayList();
        for (ToolBar toolBar : this.widgets) {
            void $this$filterTo$iv$iv;
            Iterator $this$filter$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv;
            Iterable iterable = this.sections;
            boolean $i$f$filterIsInstance = false;
            void var7_8 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof ToolBarSection)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ToolBarSection tb = (ToolBarSection)element$iv$iv;
                boolean bl = false;
                if (!(tb.getParent() == toolBar)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List sectionsInToolBar = (List)destination$iv$iv;
            $this$filter$iv = sectionsInToolBar.iterator();
            while ($this$filter$iv.hasNext()) {
                ToolBarSection iToolBarElement = (ToolBarSection)$this$filter$iv.next();
                Rectangle rectangle = iToolBarElement.getRelocator().getBounds();
                Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getBounds(...)");
                relocBounds.add(new RelocatorRectangle(rectangle, toolBar));
            }
            if (!(!((Collection)sectionsInToolBar).isEmpty())) continue;
            ToolBarSection lastSection = (ToolBarSection)sectionsInToolBar.get(sectionsInToolBar.size() - 1);
            int endOfToolbar = lastSection.getX() + lastSection.getWidth();
            relocBounds.add(new RelocatorRectangle((Rectangle)new Rectangle.WithMonitor(endOfToolbar, lastSection.getY(), lastSection.getDockPoint().width, lastSection.getHeight(), Display.getCurrent().getPrimaryMonitor()), toolBar));
        }
        MouseMoveListener mml = this.handleDragging(relocBounds);
        for (ToolBar toolBar : this.widgets) {
            toolBar.addMouseMoveListener(mml);
            toolBar.addMouseListener((MouseListener)new MouseAdapter(this, toolBar, relocBounds){
                final /* synthetic */ ToolBarBuilder this$0;
                final /* synthetic */ ToolBar $toolBar;
                final /* synthetic */ List<RelocatorRectangle> $relocBounds;
                {
                    this.this$0 = $receiver;
                    this.$toolBar = $toolBar;
                    this.$relocBounds = $relocBounds;
                }

                public void mouseDown(MouseEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    ToolBarBuilder.access$handleStartDrag(this.this$0, e, this.$toolBar, this.$relocBounds);
                }

                public void mouseUp(MouseEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    ToolBarBuilder.access$handleEndDrag(this.this$0, e, this.$toolBar, this.$relocBounds);
                }
            });
        }
    }

    private final void handleStartDrag(MouseEvent e, ToolBar toolBar, List<RelocatorRectangle> relocBounds) {
        int reloc = this.overRelocator(relocBounds, e.x, e.y, toolBar);
        if (reloc >= 0) {
            ToolBarSection section = null;
            for (IToolBarElement iToolBarElement : this.sections) {
                if (!(iToolBarElement instanceof ToolBarSection) || ((ToolBarSection)iToolBarElement).getParent() != toolBar || !Intrinsics.areEqual((Object)((ToolBarSection)iToolBarElement).getRelocator().getBounds(), (Object)relocBounds.get(reloc).rectangle())) continue;
                section = (ToolBarSection)iToolBarElement;
                break;
            }
            if (section != null) {
                this.state.setDraggingSection(section);
            }
            Image draggingImage = ImageHelper.createScaledImage$default(ImageHelper.INSTANCE, "draggingcursor.png", 1.0f, null, 4, null);
            toolBar.setCursor(new Cursor((Device)Display.getCurrent(), draggingImage.getImageData(), draggingImage.getBounds().width / 2, draggingImage.getBounds().height / 2));
        }
    }

    private final MouseMoveListener handleDragging(List<RelocatorRectangle> relocBounds) {
        return arg_0 -> ToolBarBuilder.handleDragging$lambda$0(this, relocBounds, arg_0);
    }

    private final void handleEndDrag(MouseEvent e, ToolBar toolBar, List<RelocatorRectangle> relocBounds) {
        if (this.state.getDraggingSection() != null) {
            if (this.state.getCollidingSection() != null) {
                List<ToolBarSettings.Settings> settings = ToolBarSettings.INSTANCE.getUserSettings();
                this.removeLineWrapNewLines();
                ToolBarSection toolBarSection = this.state.getDraggingSection();
                Intrinsics.checkNotNull((Object)toolBarSection);
                settings.remove(this.sections.indexOf(toolBarSection));
                ToolBarSection toolBarSection2 = this.state.getDraggingSection();
                Intrinsics.checkNotNull((Object)toolBarSection2);
                this.sections.remove(toolBarSection2);
                ToolBarSection toolBarSection3 = this.state.getCollidingSection();
                Intrinsics.checkNotNull((Object)toolBarSection3);
                int n = this.sections.indexOf(toolBarSection3);
                ToolBarSection toolBarSection4 = this.state.getDraggingSection();
                Intrinsics.checkNotNull((Object)toolBarSection4);
                settings.add(n, toolBarSection4.getName());
                ToolBarSettings.INSTANCE.saveUserSettings(settings);
                this.onRebuild.accept(toolBar);
            } else {
                int collidingToolBar = this.findToolBar(toolBar, e.y);
                if (collidingToolBar >= 0) {
                    List<RelocatorRectangle> endOfLineBounds = this.getEndOfLineBounds(relocBounds);
                    RelocatorRectangle endOfToolBar = endOfLineBounds.get(collidingToolBar);
                    if (this.rectangleCollision(e.x, 0, endOfToolBar.rectangle(), 30, 0)) {
                        ToolBar finalToolBar = this.widgets.get(collidingToolBar);
                        List<IToolBarElement> sectionsInToolbar = this.getSectionsInToolBar(finalToolBar);
                        IToolBarElement iToolBarElement = sectionsInToolbar.get(sectionsInToolbar.size() - 1);
                        Intrinsics.checkNotNull((Object)iToolBarElement, (String)"null cannot be cast to non-null type org.brailleblaster.perspectives.braille.toolbar.ToolBarSection");
                        ToolBarSection lastElement = (ToolBarSection)iToolBarElement;
                        if (!Intrinsics.areEqual((Object)this.state.getDraggingSection(), (Object)lastElement)) {
                            List<ToolBarSettings.Settings> settings = ToolBarSettings.INSTANCE.getUserSettings();
                            this.removeLineWrapNewLines();
                            ToolBarSection toolBarSection = this.state.getDraggingSection();
                            Intrinsics.checkNotNull((Object)toolBarSection);
                            settings.remove(this.sections.indexOf(toolBarSection));
                            ToolBarSection toolBarSection5 = this.state.getDraggingSection();
                            Intrinsics.checkNotNull((Object)toolBarSection5);
                            this.sections.remove(toolBarSection5);
                            int n = this.sections.indexOf(lastElement) + 1;
                            ToolBarSection toolBarSection6 = this.state.getDraggingSection();
                            Intrinsics.checkNotNull((Object)toolBarSection6);
                            settings.add(n, toolBarSection6.getName());
                            ToolBarSettings.INSTANCE.saveUserSettings(settings);
                            this.onRebuild.accept(toolBar);
                        }
                    }
                } else {
                    Rectangle bottomDockPoint = this.findBottomDockPoint(toolBar);
                    if (ToolBarBuilder.rectangleCollision$default(this, e.x, e.y, bottomDockPoint, 0, 0, 24, null)) {
                        List<ToolBarSettings.Settings> settings = ToolBarSettings.INSTANCE.getUserSettings();
                        this.removeLineWrapNewLines();
                        ToolBarSection toolBarSection = this.state.getDraggingSection();
                        Intrinsics.checkNotNull((Object)toolBarSection);
                        settings.remove(this.sections.indexOf(toolBarSection));
                        settings.add(ToolBarSettings.Settings.NEWLINE);
                        ToolBarSection toolBarSection7 = this.state.getDraggingSection();
                        Intrinsics.checkNotNull((Object)toolBarSection7);
                        settings.add(toolBarSection7.getName());
                        ToolBarSettings.INSTANCE.saveUserSettings(settings);
                        this.onRebuild.accept(toolBar);
                    }
                }
            }
            if (!toolBar.isDisposed()) {
                toolBar.setCursor(this.arrowCursor);
            }
            this.state.setDraggingSection(null);
        }
    }

    private final int findToolBar(ToolBar startingToolBar, int y) {
        int dist;
        int toolBarHeight = startingToolBar.getBounds().height;
        int toolBarIndex = this.widgets.indexOf(startingToolBar);
        boolean bl = 0 <= y ? y <= toolBarHeight : false;
        if (bl) {
            return toolBarIndex;
        }
        int n = dist = y > 0 ? y / toolBarHeight : (int)(Math.abs((double)(y / toolBarHeight)) + 1.0);
        if (y < 0 && toolBarIndex - dist >= 0) {
            return toolBarIndex - dist;
        }
        if (y > 0 && toolBarIndex + dist < this.widgets.size()) {
            return toolBarIndex + dist;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    private final List<RelocatorRectangle> getEndOfLineBounds(List<RelocatorRectangle> relocBounds) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = relocBounds;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            RelocatorRectangle r = (RelocatorRectangle)element$iv$iv;
            boolean bl = false;
            int index = relocBounds.indexOf(r);
            boolean bl2 = index == relocBounds.size() - 1 ? true : (index > 0 ? relocBounds.get((int)(index - 1)).rectangle().x < r.rectangle().x && relocBounds.get((int)(index + 1)).rectangle().x < r.rectangle().x : false);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<IToolBarElement> getSectionsInToolBar(ToolBar toolBar) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.sections;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IToolBarElement tbe = (IToolBarElement)element$iv$iv;
            boolean bl = false;
            if (!(tbe instanceof ToolBarSection && ((ToolBarSection)tbe).getParent() == toolBar)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final Rectangle findBottomDockPoint(ToolBar toolBar) {
        ToolBar lastToolBar = this.widgets.get(this.widgets.size() - 1);
        Rectangle bottomDockPoint = null;
        if (lastToolBar == toolBar) {
            bottomDockPoint = (Rectangle)new Rectangle.WithMonitor(0, toolBar.getBounds().height, toolBar.getShell().getClientArea().width, toolBar.getBounds().height / 2, Display.getCurrent().getPrimaryMonitor());
        } else {
            int bottomStart = (this.widgets.size() - this.widgets.indexOf(toolBar)) * toolBar.getBounds().height;
            if (toolBar.getParent().getLayout() instanceof GridLayout) {
                Layout layout = toolBar.getParent().getLayout();
                Intrinsics.checkNotNull((Object)layout, (String)"null cannot be cast to non-null type org.eclipse.swt.layout.GridLayout");
                bottomStart += ((GridLayout)layout).verticalSpacing * (this.widgets.size() - this.widgets.indexOf(toolBar));
            }
            bottomDockPoint = (Rectangle)new Rectangle.WithMonitor(0, bottomStart, toolBar.getShell().getClientArea().width, toolBar.getBounds().height / 2, Display.getCurrent().getPrimaryMonitor());
        }
        return bottomDockPoint;
    }

    private final int overRelocator(List<RelocatorRectangle> relocBounds, int x, int y, ToolBar source) {
        for (RelocatorRectangle rect : relocBounds) {
            if (rect.source() != source || !ToolBarBuilder.rectangleCollision$default(this, x, y, rect.rectangle(), 0, 0, 24, null)) continue;
            return relocBounds.indexOf(rect);
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    private final void removeLineWrapNewLines() {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Iterable iterable = this.sections;
        ToolBarBuilder toolBarBuilder = this;
        boolean $i$f$filter = false;
        void var3_4 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IToolBarElement s = (IToolBarElement)element$iv$iv;
            boolean bl = false;
            if (!(!(s instanceof ToolBarNewLine) || ((ToolBarNewLine)s).getSaveInSettings())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        toolBarBuilder.sections = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
    }

    private final boolean rectangleCollision(int x, int y, Rectangle rect, int horizPadding, int vertPadding) {
        return x >= rect.x - horizPadding && x <= rect.x + rect.width + horizPadding && y >= rect.y - vertPadding && y <= rect.y + rect.height + vertPadding;
    }

    static /* synthetic */ boolean rectangleCollision$default(ToolBarBuilder toolBarBuilder, int n, int n2, Rectangle rectangle, int n3, int n4, int n5, Object object) {
        if ((n5 & 8) != 0) {
            n3 = 0;
        }
        if ((n5 & 0x10) != 0) {
            n4 = 0;
        }
        return toolBarBuilder.rectangleCollision(n, n2, rectangle, n3, n4);
    }

    private final Image getImage(String imgName) {
        String fileName = TOOLBAR_FOLDER + this.userScale.getScale() + "/" + imgName + ".png";
        Image scaledImage = ImageHelper.createScaledImage$default(ImageHelper.INSTANCE, fileName, 1.0f, null, 4, null);
        this.disposeables.add((Resource)scaledImage);
        return scaledImage;
    }

    public final void dispose() {
        for (ToolBar widget : this.widgets) {
            widget.dispose();
        }
        this.customToolbars.forEach(ToolBarBuilder::dispose$lambda$0);
        this.disposeables.forEach(ToolBarBuilder::dispose$lambda$1);
    }

    public final int getHeight() {
        int height = 0;
        for (ToolBar widget : this.widgets) {
            if (widget.getItemCount() > 0) {
                height += widget.getItem((int)0).getBounds().height;
            }
            if (!(widget.getParent().getLayout() instanceof GridLayout)) continue;
            Layout layout = widget.getParent().getLayout();
            Intrinsics.checkNotNull((Object)layout, (String)"null cannot be cast to non-null type org.eclipse.swt.layout.GridLayout");
            height += ((GridLayout)layout).verticalSpacing;
        }
        for (ToolBarCustomSection section : this.customToolbars) {
            height += 35;
        }
        return height;
    }

    private static final void createStyleSection$lambda$0(ToolBarBuilder this$0, String $category, BBSelectionData e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this$0.openStyleMenu($category, e);
    }

    private static final void createToolsSection$lambda$0(ToolBarBuilder this$0, BBSelectionData e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Menu newMenu = MenuManager.createSharedSubMenu(SharedItem.CHANGE_TRANSLATION, this$0.parent, true);
        newMenu.setVisible(true);
        this$0.setMenuLocation(newMenu, e);
    }

    private static final void createEmphasisSection$lambda$0(ToolBarBuilder this$0, BBSelectionData e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Menu newMenu = MenuManager.createSharedSubMenu(SharedItem.TYPEFORMS, this$0.parent, true);
        newMenu.setVisible(true);
        this$0.setMenuLocation(newMenu, e);
    }

    private static final void handleDragging$lambda$0(ToolBarBuilder this$0, List $relocBounds, MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Object object = e.getSource();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.eclipse.swt.widgets.ToolBar");
        ToolBar toolBar = (ToolBar)object;
        if (e.data == null) {
            for (ToolBar widget : this$0.widgets) {
                int n;
                if (widget == e.getSource()) continue;
                int n2 = widget.getBounds().height;
                if (widget.getParent().getLayout() instanceof GridLayout) {
                    Layout layout = widget.getParent().getLayout();
                    Intrinsics.checkNotNull((Object)layout, (String)"null cannot be cast to non-null type org.eclipse.swt.layout.GridLayout");
                    n = ((GridLayout)layout).verticalSpacing;
                } else {
                    n = 0;
                }
                int toolBarHeight = n2 + n;
                int relativeToolBarPos = toolBarHeight * (this$0.widgets.indexOf(widget) - this$0.widgets.indexOf(toolBar)) * -1;
                Event event = new Event();
                event.type = 5;
                event.data = -1;
                event.x = e.x;
                event.y = e.y + relativeToolBarPos;
                widget.notifyListeners(5, event);
            }
        }
        if (this$0.state.getDraggingSection() != null) {
            int n = ((Collection)this$0.sections).size();
            for (int i = 0; i < n; ++i) {
                if (!(this$0.sections.get(i) instanceof ToolBarSection) || this$0.sections.get(i) == this$0.state.getDraggingSection()) continue;
                IToolBarElement iToolBarElement = this$0.sections.get(i);
                Intrinsics.checkNotNull((Object)iToolBarElement, (String)"null cannot be cast to non-null type org.brailleblaster.perspectives.braille.toolbar.ToolBarSection");
                if (((ToolBarSection)iToolBarElement).getParent() != toolBar) continue;
                IToolBarElement iToolBarElement2 = this$0.sections.get(i);
                Intrinsics.checkNotNull((Object)iToolBarElement2, (String)"null cannot be cast to non-null type org.brailleblaster.perspectives.braille.toolbar.ToolBarSection");
                ToolBarSection sect = (ToolBarSection)iToolBarElement2;
                boolean changedWidth = false;
                if (this$0.rectangleCollision(e.x, e.y, sect.getDockPoint(), 30, 0)) {
                    if (sect.getRelocator().getWidth() != 21) {
                        this$0.state.setCollidingSection(sect);
                        changedWidth = true;
                        sect.getRelocator().setWidth(21);
                    }
                } else if (sect.getRelocator().getWidth() != 11) {
                    this$0.state.setCollidingSection(null);
                    changedWidth = true;
                    sect.getRelocator().setWidth(11);
                }
                if (!changedWidth) continue;
                int n3 = this$0.sections.size();
                for (int j = i; j < n3; ++j) {
                    if (!(this$0.sections.get(j) instanceof ToolBarSection)) continue;
                    IToolBarElement iToolBarElement3 = this$0.sections.get(j);
                    Intrinsics.checkNotNull((Object)iToolBarElement3, (String)"null cannot be cast to non-null type org.brailleblaster.perspectives.braille.toolbar.ToolBarSection");
                    if (((ToolBarSection)iToolBarElement3).getParent() != toolBar) continue;
                    IToolBarElement iToolBarElement4 = this$0.sections.get(j);
                    Intrinsics.checkNotNull((Object)iToolBarElement4, (String)"null cannot be cast to non-null type org.brailleblaster.perspectives.braille.toolbar.ToolBarSection");
                    ((ToolBarSection)iToolBarElement4).draw(toolBar);
                    IToolBarElement iToolBarElement5 = this$0.sections.get(j);
                    Intrinsics.checkNotNull((Object)iToolBarElement5, (String)"null cannot be cast to non-null type org.brailleblaster.perspectives.braille.toolbar.ToolBarSection");
                    ((ToolBarSection)iToolBarElement5).drawRelocator(toolBar);
                }
                toolBar.setSize(toolBar.computeSize((int)-1, (int)-1).x + 20, toolBar.computeSize((int)-1, (int)-1).y);
                toolBar.getParent().setSize(toolBar.getParent().computeSize(-1, -1));
            }
            if (ToolBarBuilder.rectangleCollision$default(this$0, e.x, e.y, this$0.findBottomDockPoint(toolBar), 0, 0, 24, null)) {
                if (!this$0.expanded) {
                    this$0.onExpand.accept(toolBar);
                    this$0.expanded = true;
                }
            } else if (this$0.expanded) {
                this$0.onCondense.accept(toolBar);
                this$0.expanded = false;
            }
        } else {
            toolBar.setCursor(this$0.overRelocator($relocBounds, e.x, e.y, toolBar) >= 0 ? this$0.moveCursor : this$0.arrowCursor);
        }
    }

    private static final void dispose$lambda$0(ToolBarCustomSection obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        obj.dispose();
    }

    private static final void dispose$lambda$1(Resource obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        obj.dispose();
    }

    public static final /* synthetic */ void access$handleStartDrag(ToolBarBuilder $this, MouseEvent e, ToolBar toolBar, List relocBounds) {
        $this.handleStartDrag(e, toolBar, relocBounds);
    }

    public static final /* synthetic */ void access$handleEndDrag(ToolBarBuilder $this, MouseEvent e, ToolBar toolBar, List relocBounds) {
        $this.handleEndDrag(e, toolBar, relocBounds);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/brailleblaster/perspectives/braille/toolbar/ToolBarBuilder$Companion;", "", "<init>", "()V", "LOCALE_HANDLER", "Lorg/brailleblaster/utils/localization/LocaleHandler;", "getLOCALE_HANDLER", "()Lorg/brailleblaster/utils/localization/LocaleHandler;", "TOOLBAR_FOLDER", "", "DRAG_PADDING", "", "EXTENDED_RELOCATOR", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LocaleHandler getLOCALE_HANDLER() {
            return LOCALE_HANDLER;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\t\u00a8\u0006\r"}, d2={"Lorg/brailleblaster/perspectives/braille/toolbar/ToolBarBuilder$MouseState;", "", "<init>", "()V", "draggingSection", "Lorg/brailleblaster/perspectives/braille/toolbar/ToolBarSection;", "getDraggingSection", "()Lorg/brailleblaster/perspectives/braille/toolbar/ToolBarSection;", "setDraggingSection", "(Lorg/brailleblaster/perspectives/braille/toolbar/ToolBarSection;)V", "collidingSection", "getCollidingSection", "setCollidingSection", "brailleblaster-core"})
    private static final class MouseState {
        @Nullable
        private ToolBarSection draggingSection;
        @Nullable
        private ToolBarSection collidingSection;

        @Nullable
        public final ToolBarSection getDraggingSection() {
            return this.draggingSection;
        }

        public final void setDraggingSection(@Nullable ToolBarSection toolBarSection) {
            this.draggingSection = toolBarSection;
        }

        @Nullable
        public final ToolBarSection getCollidingSection() {
            return this.collidingSection;
        }

        public final void setCollidingSection(@Nullable ToolBarSection toolBarSection) {
            this.collidingSection = toolBarSection;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0083\u0004J\n\u0010\u0011\u001a\u00020\u0012H\u00d6\u0081\u0004J\n\u0010\u0013\u001a\u00020\u0014H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\t\u00a8\u0006\u0015"}, d2={"Lorg/brailleblaster/perspectives/braille/toolbar/ToolBarBuilder$RelocatorRectangle;", "Ljava/lang/Record;", "rectangle", "Lorg/eclipse/swt/graphics/Rectangle;", "source", "Lorg/eclipse/swt/widgets/ToolBar;", "<init>", "(Lorg/eclipse/swt/graphics/Rectangle;Lorg/eclipse/swt/widgets/ToolBar;)V", "()Lorg/eclipse/swt/graphics/Rectangle;", "()Lorg/eclipse/swt/widgets/ToolBar;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "brailleblaster-core"})
    private static final class RelocatorRectangle
    extends Record {
        @NotNull
        private final Rectangle rectangle;
        @NotNull
        private final ToolBar source;

        public RelocatorRectangle(@NotNull Rectangle rectangle, @NotNull ToolBar source) {
            Intrinsics.checkNotNullParameter((Object)rectangle, (String)"rectangle");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            this.rectangle = rectangle;
            this.source = source;
        }

        @NotNull
        public final Rectangle rectangle() {
            return this.rectangle;
        }

        @NotNull
        public final ToolBar source() {
            return this.source;
        }

        @NotNull
        public final Rectangle component1() {
            return this.rectangle;
        }

        @NotNull
        public final ToolBar component2() {
            return this.source;
        }

        @NotNull
        public final RelocatorRectangle copy(@NotNull Rectangle rectangle, @NotNull ToolBar source) {
            Intrinsics.checkNotNullParameter((Object)rectangle, (String)"rectangle");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            return new RelocatorRectangle(rectangle, source);
        }

        public static /* synthetic */ RelocatorRectangle copy$default(RelocatorRectangle relocatorRectangle, Rectangle rectangle, ToolBar toolBar, int n, Object object) {
            if ((n & 1) != 0) {
                rectangle = relocatorRectangle.rectangle;
            }
            if ((n & 2) != 0) {
                toolBar = relocatorRectangle.source;
            }
            return relocatorRectangle.copy(rectangle, toolBar);
        }

        @Override
        @NotNull
        public String toString() {
            return "RelocatorRectangle(rectangle=" + this.rectangle + ", source=" + this.source + ")";
        }

        @Override
        public int hashCode() {
            int result = this.rectangle.hashCode();
            result = result * 31 + this.source.hashCode();
            return result;
        }

        @Override
        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RelocatorRectangle)) {
                return false;
            }
            RelocatorRectangle relocatorRectangle = (RelocatorRectangle)other;
            if (!Intrinsics.areEqual((Object)this.rectangle, (Object)relocatorRectangle.rectangle)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.source, (Object)relocatorRectangle.source);
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ToolBarSettings.Settings.values().length];
            try {
                nArray[ToolBarSettings.Settings.DOCUMENT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolBarSettings.Settings.FILE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolBarSettings.Settings.STYLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolBarSettings.Settings.TOOLS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolBarSettings.Settings.VIEW.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolBarSettings.Settings.EMPHASIS.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolBarSettings.Settings.NEWLINE.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolBarSettings.Settings.MATH.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

