/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.perspectives.braille.ui;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import nu.xom.Text;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.bbx.BBXUtilsKt;
import org.brailleblaster.math.mathml.MathModuleUtils;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.perspectives.braille.mapping.elements.TextMapElement;
import org.brailleblaster.perspectives.braille.ui.WrapSelectionInTextSymbols;
import org.brailleblaster.utd.internal.xml.XMLHandler;
import org.brailleblaster.utd.properties.EmphasisType;
import org.brailleblaster.util.Utils;
import org.eclipse.swt.graphics.Point;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J4\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a8\u0006\u000e"}, d2={"Lorg/brailleblaster/perspectives/braille/ui/BlockSelectionInTextSymbols;", "", "<init>", "()V", "block", "", "Lnu/xom/Node;", "m", "Lorg/brailleblaster/perspectives/braille/Manager;", "startText", "", "endText", "callback", "Lorg/brailleblaster/perspectives/braille/ui/WrapSelectionInTextSymbols$TextWrapCallBack;", "brailleblaster-core"})
public final class BlockSelectionInTextSymbols {
    @NotNull
    public static final BlockSelectionInTextSymbols INSTANCE = new BlockSelectionInTextSymbols();

    private BlockSelectionInTextSymbols() {
    }

    @Nullable
    public final List<Node> block(@NotNull Manager m, @Nullable String startText, @Nullable String endText, @Nullable WrapSelectionInTextSymbols.TextWrapCallBack callback) {
        EmphasisType[] emphasisTypeArray;
        ParentNode mathParent;
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        if (m.getSimpleManager().getCurrentSelection().isTextNoSelection()) {
            return null;
        }
        List array = new ArrayList();
        Point selection = m.getTextView().getSelection();
        int startIndex = selection.x;
        int endIndex = selection.y;
        TextMapElement start = m.getMapList().getClosest(startIndex, true);
        TextMapElement end = m.getMapList().getClosest(endIndex, true);
        Node node = start.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)node, (String)"getNode(...)");
        Node startblock = (Node)BBXUtilsKt.findBlock(node);
        ParentNode startparent = startblock.getParent();
        int startb = startparent.indexOf(startblock);
        Element startnewBlock = BBX.BLOCK.DEFAULT.create();
        Node startbegInd = (Node)new Text(startText);
        startnewBlock.appendChild(startbegInd);
        if (MathModuleUtils.isSpatialMath((Node)startparent)) {
            ParentNode parentNode = startparent;
            Intrinsics.checkNotNull((Object)parentNode);
            mathParent = MathModuleUtils.INSTANCE.getSpatialMathParent((Node)parentNode);
            startparent = mathParent.getParent();
            startb = mathParent.getParent().indexOf((Node)mathParent);
        }
        mathParent = startparent;
        Intrinsics.checkNotNull((Object)mathParent);
        Utils.insertChildCountSafe(mathParent, (Node)startnewBlock, startb);
        if (callback != null) {
            startbegInd = callback.wrap(startbegInd);
        }
        Intrinsics.checkNotNull((Object)startnewBlock);
        array.add(startnewBlock);
        Node node2 = end.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)node2, (String)"getNode(...)");
        Node endblock = (Node)BBXUtilsKt.findBlock(node2);
        EmphasisType[] endparent = endblock.getParent();
        int endb = endparent.indexOf(endblock);
        Element endnewBlock = BBX.BLOCK.DEFAULT.create();
        Node endbegInd = (Node)new Text(endText);
        endnewBlock.appendChild(endbegInd);
        if (MathModuleUtils.isSpatialMath((Node)endparent)) {
            emphasisTypeArray = endparent;
            Intrinsics.checkNotNull((Object)emphasisTypeArray);
            Element mathParent2 = MathModuleUtils.INSTANCE.getSpatialMathParent((Node)emphasisTypeArray);
            endparent = mathParent2.getParent();
            endb = mathParent2.getParent().indexOf((Node)mathParent2);
        }
        EmphasisType[] emphasisTypeArray2 = endparent;
        Intrinsics.checkNotNull((Object)emphasisTypeArray2);
        Utils.insertChildCountSafe((ParentNode)emphasisTypeArray2, (Node)endnewBlock, endb + 1);
        emphasisTypeArray = new EmphasisType[]{EmphasisType.NO_TRANSLATE};
        Element element = BBX.INLINE.EMPHASIS.create(emphasisTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"create(...)");
        XMLHandler.Companion.wrapNodeWithElement(endbegInd, element);
        if (callback != null) {
            endbegInd = callback.wrap(endbegInd);
        }
        Intrinsics.checkNotNull((Object)endnewBlock);
        array.add(endnewBlock);
        return array;
    }
}

