/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.perspectives.braille.ui;

import java.util.ArrayList;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.brailleblaster.BBIni;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.utils.OS;
import org.brailleblaster.utils.Platform;
import org.brailleblaster.utils.swt.EasyListeners;
import org.brailleblaster.utils.swt.EasySWT;
import org.brailleblaster.wordprocessor.WPManager;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B;\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012 \u0010\u0006\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0006\u0012\u0004\u0018\u00010\t0\bj\n\u0012\u0006\u0012\u0004\u0018\u00010\t`\n0\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010A\u001a\u00020BH\u0002J\b\u0010\u001e\u001a\u00020BH\u0002J\b\u0010C\u001a\u00020BH\u0002R(\u0010\u0006\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0006\u0012\u0004\u0018\u00010\t0\bj\n\u0012\u0006\u0012\u0004\u0018\u00010\t`\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u001b\"\u0004\b \u0010\u001dR\u001a\u0010!\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001b\"\u0004\b#\u0010\u001dR\u001a\u0010$\u001a\u00020%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u001e\u0010*\u001a\u0004\u0018\u00010+X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u00100\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u001c\u00101\u001a\u0004\u0018\u000102X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u00104\"\u0004\b5\u00106R\u001a\u00107\u001a\u00020+X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u00109\"\u0004\b:\u0010;R\u001c\u0010<\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010>\"\u0004\b?\u0010@\u00a8\u0006D"}, d2={"Lorg/brailleblaster/perspectives/braille/ui/ImagePlaceholder;", "", "parent", "Lorg/eclipse/swt/widgets/Shell;", "manager", "Lorg/brailleblaster/perspectives/braille/Manager;", "callback", "Ljava/util/function/Consumer;", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "<init>", "(Lorg/eclipse/swt/widgets/Shell;Lorg/brailleblaster/perspectives/braille/Manager;Ljava/util/function/Consumer;)V", "shell", "getShell", "()Lorg/eclipse/swt/widgets/Shell;", "setShell", "(Lorg/eclipse/swt/widgets/Shell;)V", "text", "Lorg/eclipse/swt/widgets/Text;", "getText", "()Lorg/eclipse/swt/widgets/Text;", "setText", "(Lorg/eclipse/swt/widgets/Text;)V", "cancel", "Lorg/eclipse/swt/widgets/Button;", "getCancel", "()Lorg/eclipse/swt/widgets/Button;", "setCancel", "(Lorg/eclipse/swt/widgets/Button;)V", "submit", "getSubmit", "setSubmit", "insertImageButton", "getInsertImageButton", "setInsertImageButton", "path", "Lorg/eclipse/swt/widgets/Label;", "getPath", "()Lorg/eclipse/swt/widgets/Label;", "setPath", "(Lorg/eclipse/swt/widgets/Label;)V", "lines", "", "getLines", "()Ljava/lang/Integer;", "setLines", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "closeListener", "Lorg/eclipse/swt/widgets/Listener;", "getCloseListener", "()Lorg/eclipse/swt/widgets/Listener;", "setCloseListener", "(Lorg/eclipse/swt/widgets/Listener;)V", "linesPerPage", "getLinesPerPage", "()I", "setLinesPerPage", "(I)V", "imagePath", "getImagePath", "()Ljava/lang/String;", "setImagePath", "(Ljava/lang/String;)V", "addListeners", "", "retrieveImagePath", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nImagePlaceholder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImagePlaceholder.kt\norg/brailleblaster/perspectives/braille/ui/ImagePlaceholder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,164:1\n1#2:165\n*E\n"})
public final class ImagePlaceholder {
    @NotNull
    private final Consumer<ArrayList<String>> callback;
    @NotNull
    private Shell shell;
    @NotNull
    private Text text;
    @NotNull
    private Button cancel;
    @NotNull
    private Button submit;
    @NotNull
    private Button insertImageButton;
    @NotNull
    private Label path;
    @Nullable
    private Integer lines;
    @Nullable
    private Listener closeListener;
    private int linesPerPage;
    @Nullable
    private String imagePath;

    public ImagePlaceholder(@Nullable Shell parent, @NotNull Manager manager, @NotNull Consumer<ArrayList<String>> callback) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.callback = callback;
        this.linesPerPage = (int)Math.floor(manager.getDocument().getEngine().getPageSettings().getDrawableHeight() / manager.getDocument().getEngine().getBrailleSettings().getCellType().getHeight().doubleValue());
        this.lines = null;
        this.shell = new Shell(parent, 65616);
        this.shell.setText("Insert Image Placeholder");
        EasySWT.INSTANCE.addEscapeCloseListener(this.shell);
        GridLayout layout = new GridLayout(2, false);
        this.shell.setLayout((Layout)layout);
        Label label = new Label((Composite)this.shell, 0);
        label.setText("Number of lines (<" + this.linesPerPage + "):");
        label.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        this.text = new Text((Composite)this.shell, 2052);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.text.setLayoutData((Object)gd);
        this.insertImageButton = new Button((Composite)this.shell, 8);
        this.insertImageButton.setText("Insert Image Location");
        this.insertImageButton.setLayoutData((Object)gd);
        this.path = new Label((Composite)this.shell, 0);
        this.path.setText("Location: ");
        this.path.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        this.submit = new Button((Composite)this.shell, 8);
        this.submit.setText("Submit");
        this.cancel = new Button((Composite)this.shell, 8);
        this.cancel.setText("Cancel");
        this.addListeners();
        this.shell.pack();
        this.shell.open();
    }

    @NotNull
    public final Shell getShell() {
        return this.shell;
    }

    public final void setShell(@NotNull Shell shell) {
        Intrinsics.checkNotNullParameter((Object)shell, (String)"<set-?>");
        this.shell = shell;
    }

    @NotNull
    public final Text getText() {
        return this.text;
    }

    public final void setText(@NotNull Text text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"<set-?>");
        this.text = text;
    }

    @NotNull
    public final Button getCancel() {
        return this.cancel;
    }

    public final void setCancel(@NotNull Button button) {
        Intrinsics.checkNotNullParameter((Object)button, (String)"<set-?>");
        this.cancel = button;
    }

    @NotNull
    public final Button getSubmit() {
        return this.submit;
    }

    public final void setSubmit(@NotNull Button button) {
        Intrinsics.checkNotNullParameter((Object)button, (String)"<set-?>");
        this.submit = button;
    }

    @NotNull
    public final Button getInsertImageButton() {
        return this.insertImageButton;
    }

    public final void setInsertImageButton(@NotNull Button button) {
        Intrinsics.checkNotNullParameter((Object)button, (String)"<set-?>");
        this.insertImageButton = button;
    }

    @NotNull
    public final Label getPath() {
        return this.path;
    }

    public final void setPath(@NotNull Label label) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"<set-?>");
        this.path = label;
    }

    @Nullable
    public final Integer getLines() {
        return this.lines;
    }

    public final void setLines(@Nullable Integer n) {
        this.lines = n;
    }

    @Nullable
    public final Listener getCloseListener() {
        return this.closeListener;
    }

    public final void setCloseListener(@Nullable Listener listener) {
        this.closeListener = listener;
    }

    public final int getLinesPerPage() {
        return this.linesPerPage;
    }

    public final void setLinesPerPage(int n) {
        this.linesPerPage = n;
    }

    @Nullable
    public final String getImagePath() {
        return this.imagePath;
    }

    public final void setImagePath(@Nullable String string) {
        this.imagePath = string;
    }

    /*
     * WARNING - void declaration
     */
    private final void addListeners() {
        void it;
        Listener listener;
        Listener listener2 = listener = arg_0 -> ImagePlaceholder.addListeners$lambda$0(this, arg_0);
        int n = 21;
        Shell shell = this.shell;
        boolean bl = false;
        this.closeListener = it;
        Unit unit = Unit.INSTANCE;
        shell.addListener(n, listener);
        this.cancel.addSelectionListener((SelectionListener)new SelectionAdapter(this){
            final /* synthetic */ ImagePlaceholder this$0;
            {
                this.this$0 = $receiver;
            }

            public void widgetSelected(SelectionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.this$0.setLines(null);
                this.this$0.setImagePath(null);
                this.this$0.getShell().close();
            }
        });
        this.submit.addSelectionListener((SelectionListener)new SelectionAdapter(this){
            final /* synthetic */ ImagePlaceholder this$0;
            {
                this.this$0 = $receiver;
            }

            public void widgetSelected(SelectionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ImagePlaceholder.access$submit(this.this$0);
            }
        });
        this.text.addListener(25, ImagePlaceholder::addListeners$lambda$2);
        this.insertImageButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
            final /* synthetic */ ImagePlaceholder this$0;
            {
                this.this$0 = $receiver;
            }

            public void widgetSelected(SelectionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ImagePlaceholder.access$retrieveImagePath(this.this$0);
            }
        });
        EasyListeners.keyPress((Control)((Control)this.text), arg_0 -> ImagePlaceholder.addListeners$lambda$3(this, arg_0));
    }

    private final void submit() {
        String string = this.text.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        if (((CharSequence)string).length() > 0) {
            String string2 = this.text.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            int input = Integer.parseInt(string2);
            if (input > this.linesPerPage) {
                MessageBox message = new MessageBox(WPManager.Companion.getInstance().getShell());
                message.setMessage("Please enter a number below " + this.linesPerPage + ".");
                message.open();
                this.shell.forceActive();
                return;
            }
            this.lines = input;
        } else {
            this.lines = null;
        }
        this.shell.removeListener(21, this.closeListener);
        this.shell.close();
        if (this.imagePath != null || this.lines != null) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(this.lines != null ? String.valueOf(this.lines) : null);
            list.add(this.imagePath);
            this.callback.accept(list);
        }
    }

    private final void retrieveImagePath() {
        FileDialog dialog = new FileDialog(this.shell, 4096);
        String[] stringArray = new String[]{"*.jpg;*.jpeg;*.pdf;*.png;*.svg"};
        dialog.setFilterExtensions(stringArray);
        String filterPath = "/";
        String updates = BBIni.getPropertyFileManager().getProperty("lastFileLocation");
        if (updates != null) {
            filterPath = updates;
        }
        if (OS.Windows == Platform.getOs()) {
            filterPath = System.getProperty("user.home", "c:\\");
        }
        dialog.setFilterPath(filterPath);
        String imagePath = dialog.open();
        if (imagePath != null) {
            Label label = this.path;
            label.setText(label.getText() + imagePath);
            this.imagePath = imagePath;
        }
    }

    private static final void addListeners$lambda$0(ImagePlaceholder this$0, Event it) {
        this$0.imagePath = null;
        this$0.lines = null;
    }

    private static final void addListeners$lambda$2(Event e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        String string = e.text;
        char[] chars = new char[string.length()];
        Intrinsics.checkNotNull((Object)string);
        String string2 = string;
        int n = 0;
        int n2 = 0;
        int n3 = chars.length;
        string2.getChars(n2, n3, chars, n);
        for (char aChar : chars) {
            if (('0' <= aChar ? aChar < ':' : false) || e.keyCode == 13) continue;
            e.doit = false;
            return;
        }
    }

    private static final void addListeners$lambda$3(ImagePlaceholder this$0, KeyEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e.keyCode == 13 || e.keyCode == 0x1000050) {
            this$0.submit();
        }
    }

    public static final /* synthetic */ void access$submit(ImagePlaceholder $this) {
        $this.submit();
    }

    public static final /* synthetic */ void access$retrieveImagePath(ImagePlaceholder $this) {
        $this.retrieveImagePath();
    }
}

