/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.perspectives.braille.viewInitializer;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import nu.xom.Element;
import nu.xom.Node;
import org.brailleblaster.math.mathml.MathMLTableElement;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.perspectives.braille.document.BrailleDocument;
import org.brailleblaster.perspectives.braille.mapping.elements.BrailleMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.BrailleWhiteSpaceElement;
import org.brailleblaster.perspectives.braille.mapping.elements.FormattingWhiteSpaceElement;
import org.brailleblaster.perspectives.braille.mapping.elements.HorizontalFormattingWhiteSpaceElement;
import org.brailleblaster.perspectives.braille.mapping.elements.ImagePlaceholderTextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.LineBreakElement;
import org.brailleblaster.perspectives.braille.mapping.elements.NewPageBrlMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.ReadOnlyFormattingWhiteSpace;
import org.brailleblaster.perspectives.braille.mapping.elements.ReadOnlyTableTNTextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.ReadOnlyTableTextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.SectionElement;
import org.brailleblaster.perspectives.braille.mapping.elements.TableCellTextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.TableTextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.TextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.WhiteSpaceElement;
import org.brailleblaster.perspectives.braille.mapping.maps.MapList;
import org.brailleblaster.perspectives.braille.viewInitializer.Initializer;
import org.brailleblaster.perspectives.braille.viewInitializer.SectionMapSearcher;
import org.brailleblaster.perspectives.braille.views.wp.BrailleRenderer;
import org.brailleblaster.perspectives.braille.views.wp.BrailleView;
import org.brailleblaster.perspectives.braille.views.wp.TextRenderer;
import org.brailleblaster.perspectives.braille.views.wp.TextView;
import org.brailleblaster.utd.exceptions.NodeException;
import org.brailleblaster.util.ConstantsKt;
import org.brailleblaster.util.WhitespaceUtils;
import org.eclipse.swt.custom.StyledText;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH&J\u0010\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001bH\u0004J*\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u00112\u0006\u0010#\u001a\u00020$H\u0004J\u0016\u0010%\u001a\u00020\u00112\u0006\u0010&\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020$J\u001e\u0010%\u001a\u00020\u00112\u0006\u0010&\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020$2\u0006\u0010'\u001a\u00020\u0017J\u0016\u0010(\u001a\u00020\u00112\u0006\u0010&\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020$J\u0016\u0010)\u001a\u00020\u00112\u0006\u0010&\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020$J\u0014\u0010*\u001a\u0004\u0018\u00010+2\b\u0010\"\u001a\u0004\u0018\u00010\u0011H\u0002J\u0014\u0010,\u001a\u0004\u0018\u00010+2\b\u0010\"\u001a\u0004\u0018\u00010\u0011H\u0002J \u0010-\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u001b2\u0006\u0010.\u001a\u00020/2\u0006\u0010#\u001a\u00020$H\u0002J\u0012\u00100\u001a\u00020\u00192\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u0018\u00101\u001a\u00020\u00192\u0006\u00102\u001a\u00020$2\u0006\u00103\u001a\u00020$H\u0002J\b\u00104\u001a\u00020\u0019H\u0002J(\u00105\u001a\u00020\u00192\u0006\u00106\u001a\u00020$2\u0006\u00107\u001a\u00020$2\u0006\u00108\u001a\u00020$2\u0006\u00109\u001a\u00020$H\u0002J\b\u0010:\u001a\u00020\u0019H\u0002J\b\u0010;\u001a\u00020\u0019H\u0002J\u0006\u0010?\u001a\u00020$J\u0006\u0010@\u001a\u00020$J\u0016\u0010A\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u00112\u0006\u0010B\u001a\u00020$J\u0018\u0010C\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u0011H\u0002J\u0010\u0010D\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u0011H\u0002J\u0010\u0010E\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u0011H\u0002J\u0010\u0010F\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u0011H\u0002J\u001a\u0010G\u001a\u00020$2\b\u0010\"\u001a\u0004\u0018\u00010\u00112\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010H\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u0011H\u0002J(\u0010I\u001a\u00020\u00192\u0006\u0010#\u001a\u00020$2\u0006\u0010J\u001a\u00020$2\u0006\u0010K\u001a\u00020$2\u0006\u00108\u001a\u00020$H\u0002J\u0010\u0010L\u001a\u00020\u00172\u0006\u0010M\u001a\u00020$H\u0002J\u0018\u0010N\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010O\u001a\u00020PH\u0014J\u000e\u0010Q\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u001e\u0010R\u001a\u0010\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020$\u0018\u00010S2\b\u0010T\u001a\u0004\u0018\u00010UR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010<\u001a\u00020$8F\u00a2\u0006\u0006\u001a\u0004\b=\u0010>\u00a8\u0006V"}, d2={"Lorg/brailleblaster/perspectives/braille/viewInitializer/ViewInitializer;", "Lorg/brailleblaster/perspectives/braille/viewInitializer/Initializer;", "document", "Lorg/brailleblaster/perspectives/braille/document/BrailleDocument;", "text", "Lorg/brailleblaster/perspectives/braille/views/wp/TextView;", "braille", "Lorg/brailleblaster/perspectives/braille/views/wp/BrailleView;", "<init>", "(Lorg/brailleblaster/perspectives/braille/document/BrailleDocument;Lorg/brailleblaster/perspectives/braille/views/wp/TextView;Lorg/brailleblaster/perspectives/braille/views/wp/BrailleView;)V", "getDocument", "()Lorg/brailleblaster/perspectives/braille/document/BrailleDocument;", "getText", "()Lorg/brailleblaster/perspectives/braille/views/wp/TextView;", "getBraille", "()Lorg/brailleblaster/perspectives/braille/views/wp/BrailleView;", "viewList", "Lorg/brailleblaster/perspectives/braille/mapping/maps/MapList;", "getViewList", "()Lorg/brailleblaster/perspectives/braille/mapping/maps/MapList;", "setViewList", "(Lorg/brailleblaster/perspectives/braille/mapping/maps/MapList;)V", "atEndOfDocument", "", "initializeViews", "", "m", "Lorg/brailleblaster/perspectives/braille/Manager;", "makeList", "appendToViews", "tr", "Lorg/brailleblaster/perspectives/braille/views/wp/TextRenderer;", "br", "Lorg/brailleblaster/perspectives/braille/views/wp/BrailleRenderer;", "list", "index", "", "bufferViews", "manager", "forward", "reformatViews", "resetViews", "findFirstNewPage", "Lorg/brailleblaster/perspectives/braille/mapping/elements/NewPageBrlMapElement;", "findLastNewPage", "setViews", "t", "Lorg/brailleblaster/perspectives/braille/mapping/elements/TextMapElement;", "resetMapListVisibility", "clearViewList", "startPos", "endPos", "clearViews", "replaceTextRange", "textStart", "textLength", "brailleStart", "brailleLength", "removeListeners", "initializeListeners", "startIndex", "getStartIndex", "()I", "findFirst", "findLast", "remove", "pos", "setWhiteSpace", "checkContractions", "setImagePlaceholder", "setBlankLines", "getBrailleEnd", "removeWhitespace", "addWhiteSpaceElements", "start", "end", "checkUneditableWhiteSpace", "tmeIndex", "findSections", "e", "Lnu/xom/Element;", "initializeMap", "findSection", "Lkotlin/Pair;", "n", "Lnu/xom/Node;", "brailleblaster-core"})
public abstract class ViewInitializer
extends Initializer {
    @NotNull
    private final BrailleDocument document;
    @NotNull
    private final TextView text;
    @NotNull
    private final BrailleView braille;
    public MapList viewList;
    private boolean atEndOfDocument;

    public ViewInitializer(@NotNull BrailleDocument document, @NotNull TextView text, @NotNull BrailleView braille) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)braille, (String)"braille");
        this.document = document;
        this.text = text;
        this.braille = braille;
    }

    @NotNull
    public final BrailleDocument getDocument() {
        return this.document;
    }

    @NotNull
    public final TextView getText() {
        return this.text;
    }

    @NotNull
    public final BrailleView getBraille() {
        return this.braille;
    }

    @NotNull
    public final MapList getViewList() {
        MapList mapList = this.viewList;
        if (mapList != null) {
            return mapList;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"viewList");
        return null;
    }

    public final void setViewList(@NotNull MapList mapList) {
        Intrinsics.checkNotNullParameter((Object)mapList, (String)"<set-?>");
        this.viewList = mapList;
    }

    public abstract void initializeViews(@NotNull Manager var1);

    @NotNull
    protected final MapList makeList(@NotNull Manager m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        this.setViewList(new MapList(m));
        Iterator<SectionElement> iterator = this.getSectionList().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<SectionElement> iterator2 = iterator;
        while (iterator2.hasNext()) {
            SectionElement sectionElement;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            if (!sectionElement.isVisible()) continue;
            this.getViewList().addAll(sectionElement.list);
            this.getViewList().setCurrent(this.getViewList().indexOf(this.getViewList().getCurrent()));
        }
        this.setWhiteSpace(m, this.getViewList());
        return this.getViewList();
    }

    protected final void appendToViews(@NotNull TextRenderer tr, @NotNull BrailleRenderer br, @Nullable MapList list, int index) {
        Intrinsics.checkNotNullParameter((Object)tr, (String)"tr");
        Intrinsics.checkNotNullParameter((Object)br, (String)"br");
        NewPageBrlMapElement firstNewPage = this.findFirstNewPage(list);
        NewPageBrlMapElement lastNewPage = this.findLastNewPage(list);
        tr.setPageBounds(firstNewPage, lastNewPage);
        br.setPageBounds(firstNewPage, lastNewPage);
        MapList mapList = list;
        Intrinsics.checkNotNull((Object)mapList);
        int count = mapList.size();
        for (int i = index; i < count; ++i) {
            Object e = list.get(i);
            Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
            tr.add((TextMapElement)e, list);
            Object e2 = list.get(i);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"get(...)");
            br.add((TextMapElement)e2);
        }
    }

    @NotNull
    public final MapList bufferViews(@NotNull Manager manager, int index) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        int index2 = index;
        this.braille.clearPageRange();
        if (this.getSectionList().size() > 1) {
            this.removeListeners();
            this.removeWhitespace(this.getViewList());
            TextMapElement t = this.getSectionList().get((int)index2).list.getFirstUsable();
            if (index2 != 0) {
                --index2;
            }
            Intrinsics.checkNotNull((Object)t);
            this.setViews(manager, t, index2);
            this.initializeListeners();
            if (this.getViewList().contains(t)) {
                this.getViewList().setCurrent(this.getViewList().indexOf(t));
            }
        }
        this.setWhiteSpace(manager, this.getViewList());
        return this.getViewList();
    }

    @NotNull
    public final MapList bufferViews(@NotNull Manager manager, int index, boolean forward) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        int index2 = index;
        this.braille.clearPageRange();
        if (this.getSectionList().size() > 1) {
            this.removeListeners();
            this.removeWhitespace(this.getViewList());
            TextMapElement t = this.getSectionList().get((int)index2).list.getFirstUsable();
            if (forward) {
                list = this.getSectionList().get((int)(index2 - 1)).list;
                Iterator iterator = list.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
                Iterator iterator2 = iterator;
                while (iterator2.hasNext()) {
                    TextMapElement tme = (TextMapElement)iterator2.next();
                    if (tme.isFullyVisible()) continue;
                    t = tme;
                    break;
                }
                if (index2 != 0) {
                    --index2;
                }
            } else {
                list = this.getSectionList().get((int)(index2 + 1)).list;
                Iterator iterator = list.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
                Iterator iterator3 = iterator;
                while (iterator3.hasNext()) {
                    TextMapElement tme = (TextMapElement)iterator3.next();
                    if (tme.isFullyVisible()) continue;
                    t = tme;
                }
            }
            TextMapElement textMapElement = t;
            Intrinsics.checkNotNull((Object)textMapElement);
            this.setViews(manager, textMapElement, index2);
            this.initializeListeners();
            if (this.getViewList().contains(t)) {
                this.getViewList().setCurrent(this.getViewList().indexOf(t));
            }
        }
        this.setWhiteSpace(manager, this.getViewList());
        return this.getViewList();
    }

    @NotNull
    public final MapList reformatViews(@NotNull Manager manager, int index) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        MapList textMapElements = this.getSectionList().get((int)0).list;
        if (this.getSectionList().size() > 1 || this.getSectionList().size() == 1 && !textMapElements.isEmpty()) {
            Object object = CollectionsKt.first((List)this.getSectionList().get((int)index).list);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first(...)");
            TextMapElement t = (TextMapElement)object;
            this.removeWhitespace(this.getViewList());
            this.setViews(manager, t, index);
            this.setWhiteSpace(manager, this.getViewList());
        }
        return this.getViewList();
    }

    @NotNull
    public final MapList resetViews(@NotNull Manager manager, int index) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        if (this.getSectionList().size() > 1) {
            this.removeListeners();
            Object object = CollectionsKt.first((List)this.getSectionList().get((int)index).list);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first(...)");
            TextMapElement t = (TextMapElement)object;
            this.removeWhitespace(this.getViewList());
            this.setViews(manager, t, index);
            this.setWhiteSpace(manager, this.getViewList());
            this.initializeListeners();
        }
        return this.getViewList();
    }

    private final NewPageBrlMapElement findFirstNewPage(MapList list) {
        MapList mapList = list;
        Intrinsics.checkNotNull((Object)mapList);
        Iterator iterator = mapList.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Iterator<TableCellTextMapElement> iterator3;
            TextMapElement tme = (TextMapElement)iterator2.next();
            if (tme instanceof TableTextMapElement) {
                iterator3 = ((TableTextMapElement)tme).tableElements.iterator();
                while (iterator3.hasNext()) {
                    Iterator iterator4;
                    TableCellTextMapElement tableElement = iterator3.next();
                    Intrinsics.checkNotNullExpressionValue(tableElement.brailleList.iterator(), (String)"iterator(...)");
                    while (iterator4.hasNext()) {
                        BrailleMapElement bme = (BrailleMapElement)iterator4.next();
                        if (!(bme instanceof NewPageBrlMapElement)) continue;
                        return (NewPageBrlMapElement)bme;
                    }
                }
                continue;
            }
            Intrinsics.checkNotNullExpressionValue(tme.brailleList.iterator(), (String)"iterator(...)");
            while (iterator3.hasNext()) {
                BrailleMapElement bme = (BrailleMapElement)((Object)iterator3.next());
                if (!(bme instanceof NewPageBrlMapElement)) continue;
                return (NewPageBrlMapElement)bme;
            }
        }
        return null;
    }

    private final NewPageBrlMapElement findLastNewPage(MapList list) {
        if (this.atEndOfDocument) {
            return null;
        }
        NewPageBrlMapElement prevElement = null;
        MapList mapList = list;
        Intrinsics.checkNotNull((Object)mapList);
        Iterator iterator = mapList.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Iterator<TableCellTextMapElement> iterator3;
            TextMapElement tme = (TextMapElement)iterator2.next();
            if (tme instanceof TableTextMapElement) {
                iterator3 = ((TableTextMapElement)tme).tableElements.iterator();
                while (iterator3.hasNext()) {
                    Iterator iterator4;
                    TableCellTextMapElement tableElement = iterator3.next();
                    Intrinsics.checkNotNullExpressionValue(tableElement.brailleList.iterator(), (String)"iterator(...)");
                    while (iterator4.hasNext()) {
                        BrailleMapElement bme = (BrailleMapElement)iterator4.next();
                        if (!(bme instanceof NewPageBrlMapElement)) continue;
                        prevElement = (NewPageBrlMapElement)bme;
                    }
                }
                continue;
            }
            Intrinsics.checkNotNullExpressionValue(tme.brailleList.iterator(), (String)"iterator(...)");
            while (iterator3.hasNext()) {
                BrailleMapElement bme = (BrailleMapElement)((Object)iterator3.next());
                if (!(bme instanceof NewPageBrlMapElement)) continue;
                prevElement = (NewPageBrlMapElement)bme;
            }
        }
        return prevElement;
    }

    private final void setViews(Manager manager, TextMapElement t, int index) {
        double vPos;
        int startPos = this.findFirst();
        int endPos = this.findLast();
        if (startPos != -1 || endPos != -1) {
            this.clearViewList(startPos, endPos);
        }
        this.clearViews();
        int i = index;
        for (int totalChars = 0; i < this.getSectionList().size() && (i < index + 2 || totalChars < 20000); totalChars += this.getSectionList().get(i).getCharCount(), ++i) {
            this.getViewList().addAll(this.getSectionList().get((int)i).list);
            this.getSectionList().get(i).setInView(true);
        }
        this.resetMapListVisibility(this.getViewList());
        this.atEndOfDocument = i == this.getSectionList().size();
        TextRenderer tr = new TextRenderer(manager, this.text);
        BrailleRenderer br = new BrailleRenderer(manager, this.braille);
        tr.vPos = vPos = tr.findVPos(this.getViewList(), 0);
        br.vPos = vPos;
        this.appendToViews(tr, br, this.getViewList(), 0);
        tr.finishRendering(this.getViewList());
        br.finishRendering(this.getViewList());
        if (!Intrinsics.areEqual((Object)CollectionsKt.first((List)this.getViewList()), (Object)t)) {
            int textLine = this.text.getView().getLineAtOffset(t.getStart(this.getViewList()));
            this.text.positionScrollbar(textLine);
            if (t instanceof TableTextMapElement) {
                StyledText styledText = this.braille.getView();
                LinkedList linkedList = ((TableTextMapElement)t).tableElements.get((int)0).brailleList;
                Intrinsics.checkNotNullExpressionValue((Object)linkedList, (String)"brailleList");
                this.braille.positionScrollbar(styledText.getLineAtOffset(((BrailleMapElement)CollectionsKt.first((List)linkedList)).getStart(this.getViewList())));
            } else {
                this.braille.positionScrollbar(textLine);
            }
        }
        manager.onPostBuffer(this.getViewList());
    }

    private final void resetMapListVisibility(MapList viewList) {
        MapList mapList = viewList;
        Intrinsics.checkNotNull((Object)mapList);
        Iterator iterator = mapList.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            TextMapElement tme = (TextMapElement)iterator2.next();
            tme.setFullyVisible(true);
        }
    }

    private final void clearViewList(int startPos, int endPos) {
        int i = startPos;
        if (i <= endPos) {
            while (true) {
                this.getViewList().removeAll(this.getSectionList().get((int)i).list);
                this.getSectionList().get(i).resetList();
                if (i == endPos) break;
                ++i;
            }
        }
    }

    private final void clearViews() {
        this.replaceTextRange(0, this.text.getView().getCharCount(), 0, this.braille.getView().getCharCount());
    }

    private final void replaceTextRange(int textStart, int textLength, int brailleStart, int brailleLength) {
        this.text.getView().replaceTextRange(textStart, textLength, "");
        this.braille.getView().replaceTextRange(brailleStart, brailleLength, "");
    }

    private final void removeListeners() {
        this.text.removeListeners();
        this.braille.removeListeners();
    }

    private final void initializeListeners() {
        this.text.initializeListeners();
        this.braille.initializeListeners();
    }

    public final int getStartIndex() {
        return this.findFirst();
    }

    public final int findFirst() {
        int n = ((Collection)this.getSectionList()).size();
        for (int i = 0; i < n; ++i) {
            if (!this.getSectionList().get(i).isVisible()) continue;
            return i;
        }
        return -1;
    }

    public final int findLast() {
        int position = -1;
        int n = ((Collection)this.getSectionList()).size();
        for (int i = 0; i < n; ++i) {
            if (!this.getSectionList().get(i).isVisible()) continue;
            position = i;
        }
        return position;
    }

    public final void remove(@NotNull MapList list, int pos) {
        Intrinsics.checkNotNullParameter((Object)list, (String)"list");
        int start = this.findFirst();
        Object e = list.get(pos);
        Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
        TextMapElement t = (TextMapElement)e;
        int n = this.getSectionList().size();
        for (int i = start; i < n; ++i) {
            if (!this.getSectionList().get((int)i).list.contains(t)) continue;
            this.getSectionList().get((int)i).list.remove(t);
            break;
        }
        list.remove(pos);
    }

    private final void setWhiteSpace(Manager m, MapList list) {
        this.checkContractions(list);
        this.setImagePlaceholder(list);
        this.setBlankLines(list);
    }

    private final void checkContractions(MapList list) {
        int n = ((Collection)list).size();
        for (int i = 0; i < n; ++i) {
            Object e = list.get(i);
            Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
            TextMapElement t = (TextMapElement)e;
            if (!t.brailleList.isEmpty() || t.getNode() == null) continue;
            String string = t.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            if (!(((CharSequence)string).length() > 0)) continue;
            int index = i;
            while (index > 0 && t.brailleList.isEmpty()) {
                Object e2 = list.get(--index);
                Intrinsics.checkNotNullExpressionValue(e2, (String)"get(...)");
                TextMapElement ref = (TextMapElement)e2;
                if (ref.brailleList.isEmpty()) continue;
                LinkedList<BrailleMapElement> linkedList = t.brailleList;
                LinkedList<BrailleMapElement> linkedList2 = ref.brailleList;
                Intrinsics.checkNotNullExpressionValue(linkedList2, (String)"brailleList");
                linkedList.add((BrailleMapElement)CollectionsKt.last((List)linkedList2));
            }
        }
    }

    private final void setImagePlaceholder(MapList list) {
        int n = ((Collection)list).size();
        for (int i = 0; i < n; ++i) {
            int end;
            Object e = list.get(i);
            Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
            TextMapElement t = (TextMapElement)e;
            if (!(t instanceof ImagePlaceholderTextMapElement)) continue;
            TextMapElement prev = list.getPrevious(i, false);
            while (prev != null && prev.getEnd(list) < 0) {
                prev = list.getPrevious(list.indexOf(prev), false);
            }
            TextMapElement next = list.getNext(i, true);
            while (next != null && next.getStart(list) < 0) {
                next = list.getNext(list.indexOf(next), true);
            }
            TextMapElement textMapElement = prev;
            int start = textMapElement == null ? 0 : textMapElement.getEnd(list) + ConstantsKt.getLINE_BREAK().length();
            TextMapElement textMapElement2 = next;
            int n2 = end = textMapElement2 == null ? this.text.getView().getCharCount() : textMapElement2.getStart(list) - ConstantsKt.getLINE_BREAK().length();
            if (next != null) {
                end -= WhitespaceUtils.countLineBreaks(t, next, list, false) * ConstantsKt.getLINE_BREAK().length();
            }
            if (start > end) {
                start = end;
            }
            t.setOffsets(start, end);
        }
    }

    private final void setBlankLines(MapList list) {
        int brailleStart;
        if (!list.isEmpty() && ((TextMapElement)list.get(0)).getStart(this.getViewList()) > 0) {
            int end = ((TextMapElement)list.get(0)).getStart(list);
            brailleStart = 0;
            this.addWhiteSpaceElements(0, 0, end, brailleStart);
        }
        brailleStart = list.size() - 1;
        for (int i = 0; i < brailleStart; ++i) {
            int start = ((TextMapElement)list.get(i)).getEnd(list);
            int end = ((TextMapElement)list.get(i + 1)).getStart(list);
            int brailleStart2 = this.getBrailleEnd(list, i) + ConstantsKt.getLINE_BREAK().length();
            if (end - start <= 1) continue;
            if (start < end && end > 0 && start > 0 && end < this.text.getView().getCharCount()) {
                String string = this.text.getView().getText(start, end);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                if (!StringsKt.contains$default((CharSequence)string, (CharSequence)ConstantsKt.getLINE_BREAK(), (boolean)false, (int)2, null)) {
                    HorizontalFormattingWhiteSpaceElement hwse = new HorizontalFormattingWhiteSpaceElement(start, end);
                    list.add(i + 1, hwse);
                    continue;
                }
            }
            this.addWhiteSpaceElements(i + 1, start + ConstantsKt.getLINE_BREAK().length(), end, brailleStart2);
        }
        Object object = CollectionsKt.last((List)list);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"last(...)");
        TextMapElement t = (TextMapElement)object;
        for (int i = t.getEnd(list) + ConstantsKt.getLINE_BREAK().length(); i <= this.text.getView().getCharCount(); i += ConstantsKt.getLINE_BREAK().length()) {
            FormattingWhiteSpaceElement wse = new FormattingWhiteSpaceElement(i, i);
            wse.brailleList.add(new BrailleWhiteSpaceElement(this.braille.getView().getCharCount(), this.braille.getView().getCharCount()));
            list.add(wse);
        }
    }

    private final int getBrailleEnd(MapList list, int index) {
        int index2 = index;
        MapList mapList = list;
        Intrinsics.checkNotNull((Object)mapList);
        Object e = mapList.get(index2);
        Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
        TextMapElement t = (TextMapElement)e;
        if (t instanceof TableTextMapElement && !(t instanceof MathMLTableElement)) {
            if (t.brailleList.isEmpty()) {
                if (index2 == 0) {
                    return 0;
                }
                return this.getBrailleEnd(list, index2 - 1);
            }
            LinkedList linkedList = ((TableTextMapElement)t).tableElements.get((int)(((TableTextMapElement)t).tableElements.size() - 1)).brailleList;
            Intrinsics.checkNotNullExpressionValue((Object)linkedList, (String)"brailleList");
            return ((BrailleMapElement)CollectionsKt.last((List)linkedList)).getEnd(list);
        }
        while (t.brailleList.isEmpty()) {
            if (--index2 < 0) {
                return 0;
            }
            Object e2 = list.get(index2);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"get(...)");
            t = (TextMapElement)e2;
        }
        try {
            LinkedList<BrailleMapElement> linkedList = t.brailleList;
            Intrinsics.checkNotNullExpressionValue(linkedList, (String)"brailleList");
            return ((BrailleMapElement)CollectionsKt.last((List)linkedList)).getEnd(list);
        }
        catch (Exception e3) {
            throw new NodeException("Failed to get braille from brailleList, tme node: ", t.getNode(), (Throwable)e3);
        }
    }

    private final void removeWhitespace(MapList list) {
        for (int i = 0; i < list.size(); ++i) {
            if (!(list.get(i) instanceof WhiteSpaceElement)) continue;
            list.remove(i);
            --i;
        }
    }

    private final void addWhiteSpaceElements(int index, int start, int end, int brailleStart) {
        int index2 = index;
        int start2 = start;
        int brailleStart2 = brailleStart;
        while (start2 < end) {
            TextMapElement curElement;
            TextMapElement textMapElement = curElement = index2 < this.getViewList().size() ? (TextMapElement)this.getViewList().get(index2) : null;
            if (!(curElement instanceof LineBreakElement)) {
                if (this.checkUneditableWhiteSpace(index2)) {
                    wse = new ReadOnlyFormattingWhiteSpace(start2, start2);
                    wse.brailleList.add(new BrailleWhiteSpaceElement(brailleStart2, brailleStart2));
                    this.getViewList().add(index2, wse);
                } else {
                    wse = new FormattingWhiteSpaceElement(start2, start2);
                    wse.brailleList.add(new BrailleWhiteSpaceElement(brailleStart2, brailleStart2));
                    this.getViewList().add(index2, wse);
                }
            }
            start2 += ConstantsKt.getLINE_BREAK().length();
            ++index2;
            brailleStart2 += ConstantsKt.getLINE_BREAK().length();
        }
    }

    private final boolean checkUneditableWhiteSpace(int tmeIndex) {
        if (tmeIndex >= this.getViewList().size() || this.getViewList().getPrevious(tmeIndex, true) == null) {
            return false;
        }
        TextMapElement prevTME = this.getViewList().getPrevious(tmeIndex, true);
        Object e = this.getViewList().get(tmeIndex);
        Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
        TextMapElement curTME = (TextMapElement)e;
        return prevTME instanceof ReadOnlyTableTNTextMapElement && curTME instanceof ReadOnlyTableTextMapElement;
    }

    protected void findSections(@NotNull Manager m, @NotNull Element e) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        MapList list = new MapList(m);
        this.getSectionList().add(new SectionElement(list, 0));
        this.initializeViews((Node)e, m, 0);
    }

    public final void initializeMap(@NotNull Manager m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        this.findSections(m, this.document.getRootElement());
        this.setViewList(new MapList(m));
    }

    @Nullable
    public final Pair<Integer, Integer> findSection(@Nullable Node n) {
        SectionMapSearcher searcher = new SectionMapSearcher(this.getSectionList());
        return searcher.search(n);
    }
}

