/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.perspectives.braille.views.style;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import org.brailleblaster.abstractClasses.BBEditorView;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.easierxml.ImageUtils;
import org.brailleblaster.math.mathml.MathModuleUtils;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.perspectives.braille.mapping.elements.BrailleMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.BraillePageBrlMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.PageIndicator;
import org.brailleblaster.perspectives.braille.mapping.elements.PaintedElement;
import org.brailleblaster.perspectives.braille.mapping.elements.TextMapElement;
import org.brailleblaster.perspectives.braille.mapping.maps.MapList;
import org.brailleblaster.perspectives.braille.mapping.maps.PaintedElementsList;
import org.brailleblaster.perspectives.braille.views.wp.WPView;
import org.brailleblaster.settings.UTDManager;
import org.brailleblaster.utd.internal.xml.FastXPath;
import org.brailleblaster.utd.internal.xml.XMLHandler;
import org.brailleblaster.util.ConstantsKt;
import org.brailleblaster.util.Utils;
import org.brailleblaster.utils.localization.LocaleHandler;
import org.brailleblaster.utils.swt.AccessibilityUtils;
import org.brailleblaster.utils.swt.DebugStyledText;
import org.brailleblaster.utils.swt.EasySWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u0000 .2\u00020\u0001:\u0001.B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0014\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0002J\u0010\u0010#\u001a\u00020\u001a2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\b\u0010$\u001a\u00020\u001aH\u0016J\b\u0010%\u001a\u00020\u001aH\u0016J\b\u0010&\u001a\u00020\u001aH\u0002J\u0006\u0010*\u001a\u00020\u001aJ\u000e\u0010*\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020\fJ\b\u0010,\u001a\u00020\u001aH\u0002J\b\u0010-\u001a\u00020\u001aH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\u000eX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0015@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010!\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0010R\u0014\u0010'\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)\u00a8\u0006/"}, d2={"Lorg/brailleblaster/perspectives/braille/views/style/StylePane;", "Lorg/brailleblaster/abstractClasses/BBEditorView;", "parent", "Lorg/eclipse/swt/widgets/Composite;", "m", "Lorg/brailleblaster/perspectives/braille/Manager;", "<init>", "(Lorg/eclipse/swt/widgets/Composite;Lorg/brailleblaster/perspectives/braille/Manager;)V", "paintedElements", "Lorg/brailleblaster/perspectives/braille/mapping/maps/PaintedElementsList;", "pageIndicatorLines", "", "", "widget", "Lorg/eclipse/swt/custom/StyledText;", "getWidget", "()Lorg/eclipse/swt/custom/StyledText;", "setWidget", "(Lorg/eclipse/swt/custom/StyledText;)V", "currentLine", "value", "", "updateStylePane", "getUpdateStylePane", "()Z", "generate", "", "mapList", "Lorg/brailleblaster/perspectives/braille/mapping/maps/MapList;", "findStyle", "", "ancestorBlock", "Lnu/xom/Element;", "view", "getView", "resetView", "initializeListeners", "removeListeners", "removeAllPaintedElements", "charWidth", "getCharWidth", "()I", "updateCursor", "line", "setCurrent", "updateTextView", "Companion", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nStylePane.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StylePane.kt\norg/brailleblaster/perspectives/braille/views/style/StylePane\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,393:1\n1#2:394\n812#3,12:395\n296#3,2:407\n*S KotlinDebug\n*F\n+ 1 StylePane.kt\norg/brailleblaster/perspectives/braille/views/style/StylePane\n*L\n220#1:395,12\n221#1:407,2\n*E\n"})
public final class StylePane
implements BBEditorView {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Manager m;
    @NotNull
    private final PaintedElementsList paintedElements;
    @NotNull
    private final Set<Integer> pageIndicatorLines;
    public StyledText widget;
    private int currentLine;
    private boolean updateStylePane;
    @NotNull
    private static final Logger log;
    @NotNull
    private static final String NAME = "Style Pane";

    public StylePane(@NotNull Composite parent, @NotNull Manager m) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        this.m = m;
        this.paintedElements = new PaintedElementsList();
        this.pageIndicatorLines = new HashSet();
        this.updateStylePane = true;
        this.resetView(parent);
        AccessibilityUtils.setName((Control)((Control)this.getWidget()), (String)NAME);
    }

    @NotNull
    public final StyledText getWidget() {
        StyledText styledText = this.widget;
        if (styledText != null) {
            return styledText;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"widget");
        return null;
    }

    public final void setWidget(@NotNull StyledText styledText) {
        Intrinsics.checkNotNullParameter((Object)styledText, (String)"<set-?>");
        this.widget = styledText;
    }

    public final boolean getUpdateStylePane() {
        return this.updateStylePane;
    }

    /*
     * WARNING - void declaration
     */
    public final void generate(@NotNull MapList mapList) {
        Intrinsics.checkNotNullParameter((Object)mapList, (String)"mapList");
        long startTime = System.currentTimeMillis();
        this.removeAllPaintedElements();
        StyledText textViewWidget = this.m.getTextView();
        StringBuilder sb = new StringBuilder();
        Iterator blockStart = null;
        Iterator blockEnd = null;
        HashMap processedBlocks = new HashMap();
        TreeMap lines = new TreeMap();
        Iterator iterator = mapList.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            String string;
            TextMapElement textMapElement = (TextMapElement)iterator2.next();
            Object[] objectArray = textMapElement.brailleList.iterator();
            Intrinsics.checkNotNullExpressionValue(objectArray, (String)"iterator(...)");
            Object[] objectArray2 = objectArray;
            while (objectArray2.hasNext()) {
                int pageLine;
                BrailleMapElement curBraille = (BrailleMapElement)objectArray2.next();
                if (!(curBraille instanceof BraillePageBrlMapElement) || this.pageIndicatorLines.contains(pageLine = this.m.getBrailleView().getLineAtOffset(((BraillePageBrlMapElement)curBraille).getStart(mapList)))) continue;
                this.pageIndicatorLines.add(pageLine);
                PageIndicator newPage = new PageIndicator(this.m);
                newPage.setLine(pageLine);
                newPage.startListener(this);
            }
            objectArray2 = new Object[3];
            objectArray2[0] = textMapElement.getStart(mapList);
            objectArray2[1] = textMapElement.getEnd(mapList);
            if (textMapElement.getNode() == null) {
                string = null;
            } else {
                Node node = textMapElement.getNode();
                Intrinsics.checkNotNullExpressionValue((Object)node, (String)"getNode(...)");
                string = XMLHandler.Companion.toXMLSimple(node);
            }
            objectArray2[2] = string;
            log.debug("tme start {} end {} text {}", objectArray2);
            if (textMapElement.getNode() == null) {
                log.trace("skipping null node");
                continue;
            }
            Node node = textMapElement.getNode();
            Intrinsics.checkNotNullExpressionValue((Object)node, (String)"getNode(...)");
            if (XMLHandler.Companion.ancestorElementIs(node, StylePane::generate$lambda$0)) {
                log.trace("skipping tab");
                continue;
            }
            if (textMapElement.getStart(mapList) < 0 || textMapElement.getEnd(mapList) > textViewWidget.getCharCount()) {
                log.trace("skipping negative start");
                continue;
            }
            int lineAtOffset = textViewWidget.getLineAtOffset(textMapElement.getStart(mapList));
            Iterator styledElement = null;
            if (BBX.CONTAINER.isA(textMapElement.getNode())) {
                Node node2 = textMapElement.getNode();
                Intrinsics.checkNotNull((Object)node2, (String)"null cannot be cast to non-null type nu.xom.Element");
                styledElement = (Element)node2;
            } else {
                Node node3 = textMapElement.getNode();
                Intrinsics.checkNotNullExpressionValue((Object)node3, (String)"getNode(...)");
                if (XMLHandler.Companion.ancestorElementIs(node3, StylePane::generate$lambda$1)) {
                    Node node4 = textMapElement.getNode();
                    Intrinsics.checkNotNullExpressionValue((Object)node4, (String)"getNode(...)");
                    styledElement = XMLHandler.Companion.ancestorVisitorElement(node4, StylePane::generate$lambda$2);
                } else {
                    Node node5 = textMapElement.getNode();
                    Intrinsics.checkNotNullExpressionValue((Object)node5, (String)"getNode(...)");
                    if (XMLHandler.Companion.ancestorElementIs(node5, StylePane::generate$lambda$3)) {
                        Node node6 = textMapElement.getNode();
                        Intrinsics.checkNotNullExpressionValue((Object)node6, (String)"getNode(...)");
                        styledElement = XMLHandler.Companion.ancestorVisitorElement(node6, StylePane::generate$lambda$4);
                    } else {
                        Node node7 = textMapElement.getNode();
                        Intrinsics.checkNotNullExpressionValue((Object)node7, (String)"getNode(...)");
                        if (XMLHandler.Companion.ancestorElementIs(node7, StylePane::generate$lambda$5)) {
                            Node node8 = textMapElement.getNode();
                            Intrinsics.checkNotNullExpressionValue((Object)node8, (String)"getNode(...)");
                            styledElement = XMLHandler.Companion.ancestorVisitorElement(node8, StylePane::generate$lambda$6);
                        } else {
                            Node node9 = textMapElement.getNode();
                            Intrinsics.checkNotNullExpressionValue((Object)node9, (String)"getNode(...)");
                            if (XMLHandler.Companion.ancestorElementIs(node9, StylePane::generate$lambda$7)) {
                                Node node10 = textMapElement.getNode();
                                Intrinsics.checkNotNullExpressionValue((Object)node10, (String)"getNode(...)");
                                styledElement = XMLHandler.Companion.ancestorVisitorElement(node10, StylePane::generate$lambda$8);
                            } else {
                                Element pageLine;
                                Element it = pageLine = Manager.getTableParent(textMapElement.getNode());
                                boolean bl = false;
                                styledElement = it;
                                if (pageLine == null) {
                                    Node node11 = textMapElement.getNode();
                                    Intrinsics.checkNotNullExpressionValue((Object)node11, (String)"getNode(...)");
                                    Element ancestorBlock = XMLHandler.Companion.ancestorVisitorElement(node11, StylePane::generate$lambda$10);
                                    if (ancestorBlock == null) {
                                        log.trace("skipping no ancestor block");
                                        continue;
                                    }
                                    styledElement = ancestorBlock;
                                }
                            }
                        }
                    }
                }
            }
            if (processedBlocks.containsKey(styledElement)) {
                log.trace("skipping already processed element");
                continue;
            }
            ((Map)processedBlocks).put(Objects.requireNonNull(styledElement), lineAtOffset);
            String styleName = this.findStyle((Element)styledElement);
            if (styleName == null) {
                processedBlocks.remove(styledElement);
                log.trace("skipping null style");
                continue;
            }
            if (lines.containsKey(lineAtOffset)) {
                log.trace("skipping already used line {}", (Object)lineAtOffset);
                continue;
            }
            log.debug("line {} style {}", (Object)lineAtOffset, (Object)styleName);
            ((Map)lines).put(lineAtOffset, styleName);
            if (blockStart == null) {
                blockStart = styledElement;
            }
            blockEnd = styledElement;
        }
        Iterator blockEndActual = blockEnd;
        boolean blockStartReached = false;
        boolean blockEndReached = false;
        for (Node imageNode : FastXPath.descendant((Node)((Node)BBX.getRoot(this.m.getDoc())))) {
            String blockStylePaneText;
            Element element;
            Element element2;
            if (!blockStartReached) {
                if (imageNode != blockStart) continue;
                blockStartReached = true;
            }
            if (!blockEndReached && imageNode == blockEnd) {
                blockEndReached = true;
            } else if (blockEndReached && XMLHandler.Companion.ancestorElementNot(imageNode, arg_0 -> StylePane.generate$lambda$11(blockEndActual, arg_0))) break;
            if ((element2 = ImageUtils.getImageNavigateBlock(imageNode)) == null) continue;
            Element block = element2;
            boolean bl = false;
            if (!processedBlocks.containsKey(block) || lines.get(processedBlocks.get(block)) == null) {
                Object v16;
                block34: {
                    void $this$firstOrNull$iv;
                    void $this$filterIsInstanceTo$iv$iv;
                    Iterable $this$filterIsInstance$iv;
                    Iterable iterable = FastXPath.INSTANCE.preceding((Node)block);
                    boolean $i$f$filterIsInstance = false;
                    Iterator iterator3 = $this$filterIsInstance$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof Element)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filterIsInstance$iv = (List)destination$iv$iv;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        Element node = (Element)element$iv;
                        boolean bl2 = false;
                        if (!(BBX.BLOCK.isA((Node)node) && processedBlocks.containsKey(node) && lines.get(processedBlocks.get(node)) != null)) continue;
                        v16 = element$iv;
                        break block34;
                    }
                    v16 = null;
                }
                element = v16;
            } else {
                element = block;
            }
            element2 = element;
            if (element == null) {
                continue;
            }
            Element block2 = element2;
            Integer lineOfBlock = (Integer)processedBlocks.get(block2);
            String string = blockStylePaneText = (String)lines.get(lineOfBlock);
            Intrinsics.checkNotNull((Object)string);
            if (StringsKt.endsWith$default((String)string, (String)"*", (boolean)false, (int)2, null)) continue;
            ((Map)lines).put(lineOfBlock, blockStylePaneText + "*");
        }
        int curLine = 0;
        for (Map.Entry entry : ((Map)lines).entrySet()) {
            Integer key = (Integer)entry.getKey();
            String value = (String)entry.getValue();
            CharSequence charSequence = ConstantsKt.getLINE_BREAK();
            Integer n = key;
            Intrinsics.checkNotNull((Object)n);
            sb.append(StringsKt.repeat((CharSequence)charSequence, (int)((int)Math.max(0.0, (double)(n - curLine))))).append(value).append(ConstantsKt.getLINE_BREAK());
            curLine = key + 1;
        }
        while (curLine - 1 != textViewWidget.getLineCount()) {
            sb.append(ConstantsKt.getLINE_BREAK());
            ++curLine;
        }
        this.getWidget().setText(sb.toString());
        log.info("Building stylePane took {}", (Object)Utils.runtimeToString(startTime));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String findStyle(Element ancestorBlock) {
        Element element = ancestorBlock;
        Intrinsics.checkNotNull((Object)element);
        Object styleName = element.getAttributeValue("utd-style");
        if (styleName == null) {
            if (ancestorBlock.getParent() == null) return null;
            if (!BBX.CONTAINER.PROSE.isA((Node)ancestorBlock.getParent())) return null;
            ParentNode parentNode = ancestorBlock.getParent();
            Intrinsics.checkNotNull((Object)parentNode, (String)"null cannot be cast to non-null type nu.xom.Element");
            if (((Element)parentNode).getAttribute("utd-style") == null) return null;
            ParentNode parentNode2 = ancestorBlock.getParent();
            Intrinsics.checkNotNull((Object)parentNode2, (String)"null cannot be cast to non-null type nu.xom.Element");
            styleName = ((Element)parentNode2).getAttributeValue("utd-style");
        }
        LocaleHandler localeHandler = LocaleHandler.Companion.getBanaStyles$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null);
        UTDManager uTDManager = this.m.getDocument().getSettingsManager();
        String string = styleName;
        Intrinsics.checkNotNull((Object)string);
        styleName = localeHandler.get(uTDManager.getBaseStyle(string, (Node)ancestorBlock));
        if (BBX.BLOCK.PAGE_NUM.isA((Node)ancestorBlock)) {
            styleName = "Print Page";
        }
        if (BBX.BLOCK.IMAGE_PLACEHOLDER.isA((Node)ancestorBlock)) {
            styleName = (String)styleName + " " + BBX.BLOCK.IMAGE_PLACEHOLDER.ATTRIB_SKIP_LINES.get(ancestorBlock);
        }
        if (!BBX.BLOCK.SPATIAL_MATH.isA((Node)ancestorBlock)) return styleName;
        return MathModuleUtils.INSTANCE.getSPATIAL_MATH();
    }

    @Override
    @NotNull
    public StyledText getView() {
        return this.getWidget();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void resetView(@NotNull Composite parent) {
        void $this$resetView_u24lambda_u240;
        DebugStyledText debugStyledText;
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        DebugStyledText debugStyledText2 = debugStyledText = new DebugStyledText(parent, 2304);
        StylePane stylePane = this;
        boolean bl = false;
        $this$resetView_u24lambda_u240.setAlignment(131072);
        $this$resetView_u24lambda_u240.setEditable(false);
        EasySWT.INSTANCE.setGridData((Control)$this$resetView_u24lambda_u240);
        Intrinsics.checkNotNull((Object)$this$resetView_u24lambda_u240.getLayoutData(), (String)"null cannot be cast to non-null type org.eclipse.swt.layout.GridData");
        ((GridData)$this$resetView_u24lambda_u240.getLayoutData()).grabExcessVerticalSpace = true;
        stylePane.setWidget((StyledText)debugStyledText);
    }

    @Override
    public void initializeListeners() {
        this.getWidget().addFocusListener(new FocusListener(this){
            final /* synthetic */ StylePane this$0;
            {
                this.this$0 = $receiver;
            }

            public void focusLost(FocusEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                StylePane.access$setCurrent(this.this$0);
            }

            public void focusGained(FocusEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                StylePane.access$setCurrent(this.this$0);
            }
        });
        this.getWidget().addKeyListener(new KeyListener(this){
            final /* synthetic */ StylePane this$0;
            {
                this.this$0 = $receiver;
            }

            public void keyReleased(KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                StylePane.access$updateTextView(this.this$0);
            }

            public void keyPressed(KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                StylePane.access$getM$p(this.this$0).getViewManager().getTextView().getView().setTopPixel(this.this$0.getWidget().getTopPixel());
            }
        });
        this.getWidget().addMouseListener(new MouseListener(this){
            final /* synthetic */ StylePane this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseUp(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                StylePane.access$updateTextView(this.this$0);
            }

            public void mouseDown(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }

            public void mouseDoubleClick(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }
        });
    }

    @Override
    public void removeListeners() {
        this.removeAllPaintedElements();
    }

    private final void removeAllPaintedElements() {
        Iterator iterator = this.paintedElements.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Object e = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            PaintedElement paintedElement = (PaintedElement)e;
            paintedElement.removeListener(this);
        }
        this.paintedElements.clear();
    }

    @Override
    public int getCharWidth() {
        GC gc = new GC((Drawable)this.getWidget());
        FontMetrics fm = gc.getFontMetrics();
        gc.dispose();
        return (int)fm.getAverageCharacterWidth();
    }

    public final void updateCursor() {
        this.getView().setCaretOffset(this.getView().getOffsetAtLine(WPView.currentLine));
    }

    public final void updateCursor(int line) {
        this.m.getStylePane().getView().setCaretOffset(this.getView().getOffsetAtLine(line));
    }

    private final void setCurrent() {
        StyledText brailleView;
        StyledText textView;
        int pos = this.getWidget().getCaretOffset();
        int line = this.getWidget().getLineAtOffset(pos);
        if (line < (textView = this.m.getTextView()).getContent().getLineCount()) {
            textView.setCaretOffset(textView.getOffsetAtLine(line));
        }
        if (line < (brailleView = this.m.getBrailleView()).getContent().getLineCount()) {
            brailleView.setCaretOffset(brailleView.getOffsetAtLine(line));
        }
    }

    private final void updateTextView() {
        int pos = this.getWidget().getCaretOffset();
        int line = this.getWidget().getLineAtOffset(pos);
        if (line < this.m.getTextView().getContent().getLineCount() && this.currentLine != this.getWidget().getLineAtOffset(pos)) {
            this.updateStylePane = false;
            this.m.getViewManager().getTextView().setCurrentElement(this.m.getTextView().getOffsetAtLine(line));
            this.updateStylePane = true;
            this.currentLine = this.getWidget().getLineAtOffset(pos);
        }
    }

    private static final boolean generate$lambda$0(Element node) {
        return BBX.SPAN.TAB.isA((Node)node);
    }

    private static final boolean generate$lambda$1(Element node) {
        return BBX.CONTAINER.NUMBER_LINE.isA((Node)node);
    }

    private static final boolean generate$lambda$2(Element node) {
        return BBX.CONTAINER.NUMBER_LINE.isA((Node)node);
    }

    private static final boolean generate$lambda$3(Element node) {
        return BBX.CONTAINER.MATRIX.isA((Node)node);
    }

    private static final boolean generate$lambda$4(Element node) {
        return BBX.CONTAINER.MATRIX.isA((Node)node);
    }

    private static final boolean generate$lambda$5(Element node) {
        return BBX.CONTAINER.SPATIAL_GRID.isA((Node)node);
    }

    private static final boolean generate$lambda$6(Element node) {
        return BBX.CONTAINER.SPATIAL_GRID.isA((Node)node);
    }

    private static final boolean generate$lambda$7(Element node) {
        return BBX.CONTAINER.TEMPLATE.isA((Node)node);
    }

    private static final boolean generate$lambda$8(Element node) {
        return BBX.CONTAINER.TEMPLATE.isA((Node)node);
    }

    private static final boolean generate$lambda$10(Element node) {
        return BBX.BLOCK.isA((Node)node);
    }

    private static final boolean generate$lambda$11(Element $blockEndActual, Element ancestor) {
        Intrinsics.checkNotNullParameter((Object)ancestor, (String)"ancestor");
        return ancestor == $blockEndActual;
    }

    public static final /* synthetic */ void access$setCurrent(StylePane $this) {
        $this.setCurrent();
    }

    public static final /* synthetic */ void access$updateTextView(StylePane $this) {
        $this.updateTextView();
    }

    public static final /* synthetic */ Manager access$getM$p(StylePane $this) {
        return $this.m;
    }

    static {
        Logger logger = LoggerFactory.getLogger(StylePane.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        log = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/brailleblaster/perspectives/braille/views/style/StylePane$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "NAME", "", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

