/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.perspectives.braille.views.tree;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;
import nu.xom.Text;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.perspectives.braille.mapping.elements.TextMapElement;
import org.brailleblaster.perspectives.braille.views.tree.TreeView;
import org.brailleblaster.settings.UTDManager;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 62\u00020\u0001:\u000256B\u001b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0015H\u0016J\b\u0010\u0019\u001a\u00020\u0015H\u0016J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u001a\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001e\u001a\u0004\u0018\u00010\fH\u0002J\u0018\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010 \u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\n2\u0006\u0010!\u001a\u00020\nH\u0002J\u0012\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0012\u0010$\u001a\u0004\u0018\u00010#2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010%\u001a\u00020\u00152\u0006\u0010&\u001a\u00020'H\u0016J\u0014\u0010(\u001a\u0004\u0018\u00010'2\b\u0010&\u001a\u0004\u0018\u00010'H\u0016J\b\u0010,\u001a\u00020\u0015H\u0016J\u0014\u0010-\u001a\u00060.R\u00020\u00002\u0006\u0010\u001e\u001a\u00020\fH\u0002J\u000e\u0010/\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\fJ\u000e\u00100\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\fJ\u0010\u00101\u001a\u0002022\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u00103\u001a\u0002022\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u00104\u001a\u0002022\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u0016\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\r\u001a\u0004\u0018\u00010\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\f@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010)\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+\u00a8\u00067"}, d2={"Lorg/brailleblaster/perspectives/braille/views/tree/DividerTree;", "Lorg/brailleblaster/perspectives/braille/views/tree/TreeView;", "dm", "Lorg/brailleblaster/perspectives/braille/Manager;", "sash", "Lorg/eclipse/swt/custom/SashForm;", "<init>", "(Lorg/brailleblaster/perspectives/braille/Manager;Lorg/eclipse/swt/custom/SashForm;)V", "headings", "", "", "value", "Lorg/eclipse/swt/widgets/TreeItem;", "root", "getRoot", "()Lorg/eclipse/swt/widgets/TreeItem;", "selectionListener", "Lorg/eclipse/swt/events/SelectionAdapter;", "count", "", "resetView", "", "parent", "Lorg/eclipse/swt/widgets/Composite;", "initializeListeners", "removeListeners", "setRoot", "e", "Lnu/xom/Element;", "setTree", "item", "setNewItemData", "formatTreeString", "page", "getText", "Lnu/xom/Text;", "getCenteredHeadingText", "setSelection", "t", "Lorg/brailleblaster/perspectives/braille/mapping/elements/TextMapElement;", "getSelection", "selectionIndex", "getSelectionIndex", "()I", "clearTree", "getItemData", "Lorg/brailleblaster/perspectives/braille/views/tree/DividerTree$TreeItemData;", "getElement", "getTreeIndex", "isSection", "", "hasBlocks", "isHeading", "TreeItemData", "Companion", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nDividerTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DividerTree.kt\norg/brailleblaster/perspectives/braille/views/tree/DividerTree\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,191:1\n1#2:192\n*E\n"})
public final class DividerTree
extends TreeView {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private List<String> headings;
    @Nullable
    private TreeItem root;
    @Nullable
    private SelectionAdapter selectionListener;
    private int count;
    @NotNull
    private static final List<String> DEFAULT_HEADING_LIST;

    public DividerTree(@Nullable Manager dm, @Nullable SashForm sash) {
        Manager manager = dm;
        Intrinsics.checkNotNull((Object)manager);
        SashForm sashForm = sash;
        Intrinsics.checkNotNull((Object)sashForm);
        super(manager, (Composite)sashForm);
        this.getTree().pack();
    }

    @Override
    @Nullable
    public TreeItem getRoot() {
        return this.root;
    }

    @Override
    public void resetView(@NotNull Composite parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        TreeItem treeItem = this.getRoot();
        Intrinsics.checkNotNull((Object)treeItem);
        treeItem.setExpanded(false);
        TreeItem treeItem2 = this.getRoot();
        Intrinsics.checkNotNull((Object)treeItem2);
        treeItem2.dispose();
        this.root = null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void initializeListeners() {
        void it;
        SelectionAdapter selectionAdapter;
        SelectionAdapter selectionAdapter2 = selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }
        };
        Tree tree = this.getTree();
        boolean bl = false;
        this.selectionListener = (SelectionAdapter)it;
        tree.addSelectionListener((SelectionListener)selectionAdapter);
    }

    @Override
    public void removeListeners() {
        this.getTree().removeSelectionListener((SelectionListener)this.selectionListener);
    }

    @Override
    public void setRoot(@NotNull Element e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.root = new TreeItem(this.getTree(), 18432);
        this.headings = DEFAULT_HEADING_LIST;
        TreeItem treeItem = this.getRoot();
        Intrinsics.checkNotNull((Object)treeItem);
        treeItem.setText(this.getManager().getDocumentName());
        this.setTree(e, this.getRoot());
    }

    private final void setTree(Element e, TreeItem item) {
        Elements els = e.getChildElements();
        int n = els.size();
        for (int i = 0; i < n; ++i) {
            Element element = els.get(i);
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"get(...)");
            if (this.isSection(element)) {
                if (this.hasBlocks(e)) {
                    TreeItem childItem = new TreeItem(item, 18432);
                    Element element2 = els.get(i);
                    Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"get(...)");
                    this.setNewItemData(childItem, element2);
                    Element element3 = els.get(i);
                    Intrinsics.checkNotNullExpressionValue((Object)element3, (String)"get(...)");
                    this.setTree(element3, childItem);
                    continue;
                }
                Element element4 = els.get(i);
                Intrinsics.checkNotNullExpressionValue((Object)element4, (String)"get(...)");
                this.setTree(element4, item);
                continue;
            }
            if (Intrinsics.areEqual((Object)els.get(i).getLocalName(), (Object)"brl")) continue;
            Element element5 = els.get(i);
            Intrinsics.checkNotNullExpressionValue((Object)element5, (String)"get(...)");
            this.setTree(element5, item);
        }
    }

    private final void setNewItemData(TreeItem item, Element e) {
        Text t = this.getText(e);
        String pageNum = UTDManager.Companion.getNextPageNum(e);
        item.setData((Object)new TreeItemData(e));
        if (t != null) {
            String string = t.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
            item.setText(this.formatTreeString(string, pageNum));
        } else {
            item.setText(this.formatTreeString("SECTION", pageNum));
        }
    }

    private final String formatTreeString(String item, String page) {
        return "p. " + page + ":   " + item;
    }

    private final Text getText(Element e) {
        Elements els = e.getChildElements();
        int count = els.size();
        for (int i = 0; i < count; ++i) {
            if (!BBX.BLOCK.isA((Node)els.get(i))) continue;
            Element element = els.get(i);
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"get(...)");
            if (!this.isHeading(element)) continue;
            Element element2 = els.get(i);
            Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"get(...)");
            return this.getCenteredHeadingText(element2);
        }
        return null;
    }

    private final Text getCenteredHeadingText(Element e) {
        int count = e.getChildCount();
        for (int i = 0; i < count; ++i) {
            if (e.getChild(i) instanceof Element) {
                Node node = e.getChild(i);
                Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Element");
                if (!Intrinsics.areEqual((Object)((Element)node).getLocalName(), (Object)"brl")) {
                    Text t;
                    Node node2 = e.getChild(i);
                    Intrinsics.checkNotNull((Object)node2, (String)"null cannot be cast to non-null type nu.xom.Element");
                    Text text = t = this.getCenteredHeadingText((Element)node2);
                    if (text == null) continue;
                    return text;
                }
            }
            if (!(e.getChild(i) instanceof Text)) continue;
            Node node = e.getChild(i);
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Text");
            return (Text)node;
        }
        return null;
    }

    @Override
    public void setSelection(@NotNull TextMapElement t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
    }

    @Override
    @Nullable
    public TextMapElement getSelection(@Nullable TextMapElement t) {
        return t;
    }

    @Override
    public int getSelectionIndex() {
        TreeItem[] treeItemArray = this.getTree().getSelection();
        Intrinsics.checkNotNullExpressionValue((Object)treeItemArray, (String)"getSelection(...)");
        if (!(((Object[])treeItemArray).length == 0) && !Intrinsics.areEqual((Object)this.getTree().getSelection()[0], (Object)this.getRoot())) {
            TreeItem parent = this.getTree().getSelection()[0].getParentItem();
            return parent.indexOf(this.getTree().getSelection()[0]);
        }
        return 0;
    }

    @Override
    public void clearTree() {
        this.getTree().removeAll();
    }

    private final TreeItemData getItemData(TreeItem item) {
        Object object = item.getData();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.brailleblaster.perspectives.braille.views.tree.DividerTree.TreeItemData");
        return (TreeItemData)object;
    }

    @NotNull
    public final Element getElement(@NotNull TreeItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        return this.getItemData(item).getE();
    }

    public final int getTreeIndex(@NotNull TreeItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        return this.getItemData(item).getIndex();
    }

    private final boolean isSection(Element e) {
        return BBX.SECTION.isA((Node)e);
    }

    private final boolean hasBlocks(Element e) {
        Elements els = e.getChildElements();
        int count = els.size();
        for (int i = 0; i < count; ++i) {
            if (!BBX.BLOCK.isA((Node)els.get(i)) && !BBX.CONTAINER.isA((Node)els.get(i))) continue;
            return true;
        }
        return false;
    }

    private final boolean isHeading(Element e) {
        Attribute atr = e.getAttribute("overrideStyle", "http://brailleblaster.org/ns/utd");
        if (atr != null) {
            List<String> list = this.headings;
            Intrinsics.checkNotNull(list);
            return list.contains(atr.getValue());
        }
        return false;
    }

    static {
        Object[] objectArray = new String[]{"Centered Heading", "Cell 5 Heading", "Cell 7 Heading", "h4", "h5", "h6"};
        DEFAULT_HEADING_LIST = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/brailleblaster/perspectives/braille/views/tree/DividerTree$Companion;", "", "<init>", "()V", "DEFAULT_HEADING_LIST", "", "", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/brailleblaster/perspectives/braille/views/tree/DividerTree$TreeItemData;", "", "e", "Lnu/xom/Element;", "<init>", "(Lorg/brailleblaster/perspectives/braille/views/tree/DividerTree;Lnu/xom/Element;)V", "getE", "()Lnu/xom/Element;", "index", "", "getIndex", "()I", "brailleblaster-core"})
    private final class TreeItemData {
        @NotNull
        private final Element e;
        private final int index;

        public TreeItemData(Element e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.e = e;
            this.index = DividerTree.this.count;
            int n = DividerTree.this.count;
            DividerTree.this.count = n + 1;
        }

        @NotNull
        public final Element getE() {
            return this.e;
        }

        public final int getIndex() {
            return this.index;
        }
    }
}

