/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.perspectives.braille.views.wp.formatters;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.perspectives.braille.eventQueue.Event;
import org.brailleblaster.perspectives.braille.eventQueue.EventFrame;
import org.brailleblaster.perspectives.braille.eventQueue.EventTypes;
import org.brailleblaster.perspectives.braille.eventQueue.ViewEvent;
import org.brailleblaster.perspectives.braille.views.wp.TextView;
import org.eclipse.swt.custom.ExtendedModifyEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0018\u0010\u001e\u001a\u00020\u001b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u0016\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u0019J \u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\u00192\u0006\u0010$\u001a\u00020\u0017H\u0002J \u0010%\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\u00192\u0006\u0010$\u001a\u00020\u0017H\u0002J\"\u0010&\u001a\u00020'2\b\u0010\u001c\u001a\u0004\u0018\u00010(2\u0006\u0010\"\u001a\u00020\u00192\u0006\u0010$\u001a\u00020\u0017H\u0002R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/brailleblaster/perspectives/braille/views/wp/formatters/EditRecorder;", "", "manager", "Lorg/brailleblaster/perspectives/braille/Manager;", "text", "Lorg/brailleblaster/perspectives/braille/views/wp/TextView;", "<init>", "(Lorg/brailleblaster/perspectives/braille/Manager;Lorg/brailleblaster/perspectives/braille/views/wp/TextView;)V", "getManager", "()Lorg/brailleblaster/perspectives/braille/Manager;", "setManager", "(Lorg/brailleblaster/perspectives/braille/Manager;)V", "getText", "()Lorg/brailleblaster/perspectives/braille/views/wp/TextView;", "setText", "(Lorg/brailleblaster/perspectives/braille/views/wp/TextView;)V", "frame", "Lorg/brailleblaster/perspectives/braille/eventQueue/EventFrame;", "getFrame", "()Lorg/brailleblaster/perspectives/braille/eventQueue/EventFrame;", "setFrame", "(Lorg/brailleblaster/perspectives/braille/eventQueue/EventFrame;)V", "currentLine", "", "currentLineNumber", "", "recordEvent", "", "e", "Lorg/eclipse/swt/custom/ExtendedModifyEvent;", "recordLine", "start", "end", "createEvent", "wordStart", "wordEnd", "recordedText", "addEvent", "sameWord", "", "Lorg/brailleblaster/perspectives/braille/eventQueue/ViewEvent;", "brailleblaster-core"})
public final class EditRecorder {
    @NotNull
    private Manager manager;
    @NotNull
    private TextView text;
    @Nullable
    private EventFrame frame;
    @Nullable
    private String currentLine;
    private int currentLineNumber;

    public EditRecorder(@NotNull Manager manager, @NotNull TextView text) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.manager = manager;
        this.text = text;
    }

    @NotNull
    public final Manager getManager() {
        return this.manager;
    }

    public final void setManager(@NotNull Manager manager) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"<set-?>");
        this.manager = manager;
    }

    @NotNull
    public final TextView getText() {
        return this.text;
    }

    public final void setText(@NotNull TextView textView) {
        Intrinsics.checkNotNullParameter((Object)textView, (String)"<set-?>");
        this.text = textView;
    }

    @Nullable
    public final EventFrame getFrame() {
        return this.frame;
    }

    public final void setFrame(@Nullable EventFrame eventFrame) {
        this.frame = eventFrame;
    }

    public final void recordEvent(@NotNull ExtendedModifyEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        int n = e.start;
        int n2 = e.length;
        String string = e.replacedText;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"replacedText");
        this.createEvent(n, n2, string);
    }

    public final void recordLine(@Nullable String currentLine, int currentLineNumber) {
        this.currentLine = currentLine;
        this.currentLineNumber = currentLineNumber;
    }

    public final void recordLine(int start, int end) {
        int firstLine = this.text.getView().getLineAtOffset(start);
        int lastLine = this.text.getView().getLineAtOffset(end);
        int firstOffset = this.text.getView().getOffsetAtLine(firstLine);
        int lastOffset = this.text.getView().getOffsetAtLine(lastLine) + this.text.getView().getLine(lastLine).length();
        this.currentLineNumber = firstLine;
        this.currentLine = this.text.getView().getTextRange(firstOffset, lastOffset - firstOffset);
    }

    private final void createEvent(int wordStart, int wordEnd, String recordedText) {
        EventFrame eventFrame = this.manager.peekUndoEvent();
        Object object = eventFrame;
        if ((object != null && (object = ((EventFrame)object).peek()) != null ? ((Event)object).getEventType() : null) == EventTypes.Edit) {
            ViewEvent ev = (ViewEvent)eventFrame.peek();
            if (this.sameWord(ev, wordStart, recordedText)) {
                eventFrame.addEvent(new ViewEvent(EventTypes.Edit, wordStart, wordEnd, 0, 0, recordedText));
            } else {
                this.addEvent(wordStart, wordEnd, recordedText);
            }
        } else {
            this.addEvent(wordStart, wordEnd, recordedText);
        }
    }

    private final void addEvent(int wordStart, int wordEnd, String recordedText) {
        EventFrame eventFrame = this.frame = new EventFrame();
        Intrinsics.checkNotNull((Object)eventFrame);
        eventFrame.addEvent(new ViewEvent(EventTypes.Edit, wordStart, wordEnd, 0, 0, recordedText));
        this.manager.addUndoEvent(this.frame);
    }

    private final boolean sameWord(ViewEvent e, int wordStart, String recordedText) {
        int line = this.text.getView().getLineAtOffset(wordStart);
        if (line == this.currentLineNumber) {
            ViewEvent viewEvent = e;
            Intrinsics.checkNotNull((Object)viewEvent);
            int priorStart = viewEvent.getTextOffset();
            return wordStart + 1 == priorStart || wordStart - 1 == priorStart;
        }
        return false;
    }
}

