/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.perspectives.braille.views.wp.tableEditor;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import kotlin.sequences.Sequence;
import net.miginfocom.swt.MigLayout;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.bbx.BBXUtils;
import org.brailleblaster.exceptions.EditingException;
import org.brailleblaster.math.mathml.MathModuleUtils;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.perspectives.braille.document.BrailleDocument;
import org.brailleblaster.perspectives.braille.mapping.interfaces.Uneditable;
import org.brailleblaster.perspectives.braille.mapping.maps.MapList;
import org.brailleblaster.perspectives.braille.messages.Sender;
import org.brailleblaster.perspectives.braille.ui.BBStyleableText;
import org.brailleblaster.perspectives.braille.views.wp.tableEditor.CellText;
import org.brailleblaster.perspectives.braille.views.wp.tableEditor.ChangeToFacingDialog;
import org.brailleblaster.perspectives.braille.views.wp.tableEditor.ConversionColumnSelectorDialog;
import org.brailleblaster.perspectives.braille.views.wp.tableEditor.ITable;
import org.brailleblaster.perspectives.braille.views.wp.tableEditor.InternalFacingTable;
import org.brailleblaster.perspectives.braille.views.wp.tableEditor.InternalTable;
import org.brailleblaster.perspectives.braille.views.wp.tableEditor.Mode;
import org.brailleblaster.perspectives.braille.views.wp.tableEditor.TableType;
import org.brailleblaster.perspectives.mvc.BBSimpleManager;
import org.brailleblaster.perspectives.mvc.XMLNodeCaret;
import org.brailleblaster.perspectives.mvc.XMLTextCaret;
import org.brailleblaster.perspectives.mvc.events.ModifyEvent;
import org.brailleblaster.settings.UTDManager;
import org.brailleblaster.utd.IStyle;
import org.brailleblaster.utd.IStyleMap;
import org.brailleblaster.utd.Style;
import org.brailleblaster.utd.exceptions.NodeException;
import org.brailleblaster.utd.internal.xml.FastXPath;
import org.brailleblaster.utd.properties.UTDElements;
import org.brailleblaster.utd.utils.TableUtils;
import org.brailleblaster.utd.utils.UTDHelper;
import org.brailleblaster.util.Notify;
import org.brailleblaster.utils.localization.LocaleHandler;
import org.brailleblaster.utils.swt.AccessibilityUtils;
import org.brailleblaster.utils.swt.ButtonBuilder1;
import org.brailleblaster.utils.swt.EasyListeners;
import org.brailleblaster.utils.swt.EasySWT;
import org.brailleblaster.utils.swt.MenuBuilder;
import org.brailleblaster.utils.swt.SubMenuBuilder;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.jetbrains.annotations.NotNull;

public class TableEditor
extends Dialog {
    private static final LocaleHandler localeHandler = LocaleHandler.getDefault();
    private static final LocaleHandler banaStyles = LocaleHandler.getBanaStyles();
    public static final String OK_BUTTON = "Ok";
    public static final String SAVE_BUTTON = "Save";
    public static final String CANCEL_BUTTON = "Cancel";
    public static final String REFORMAT_BUTTON = "Reformat Table";
    public static final String ADVANCED_REFORMAT_BUTTON = "Advanced Reformat";
    public static final String CHANGE_DIMENSIONS_BUTTON = "Change Dimensions";
    public static final String INSERT_MENUITEM = "Table";
    public static final String EDIT_MENUITEM = "Table Editor";
    public static final String CONVERT_MENU_ITEM = "Convert Text to Table";
    public static final String ERROR_DIALOG_TITLE = "Error";
    private static final String ERROR_DIALOG_INSERT = "Table cannot be inserted here";
    private static final String ERROR_DIALOG_EDIT = "Cursor is not on table";
    private static final String ERROR_CONVERT_TEXT_UNSELECTED = "At least two items need to be selected to convert to a table";
    private static final String ERROR_CONVERT_TEXT_ALREADY_IN_TABLE = "Selection already contains table";
    private static final String LINEAR_TN_HEADING = "Columns follow one another in this order:";
    private static final String STAIRSTEP_TN_HEADING = "Table changed as follows:";
    private static final String LISTED_TN_HEADING = "Print format is changed. Row headings are blocked in cell 5; column headings begin in cell 1. All headings are repeated for clarity. A colon separates headings from table entries.";
    private static final String ACCESSIBLE_DELETE_ROW_NAME = "Delete Row";
    public static final String ACCESSIBLE_COLUMN_NAME = "Column";
    public static final String ACCESSIBLE_ROW_NAME = "Row";
    private static final String ACCESSIBLE_CAPTION_NAME = "Caption";
    private static final String ACCESSIBLE_DELETE_CAPTION_NAME = "Delete Caption";
    public static final String ACCESSIBLE_TN_HEADING_NAME = "TN Heading";
    private UTDManager m;
    private Shell shell;
    private Element tableNode;
    private Combo tableTypeCombo;
    private Text rowText;
    private Text colText;
    private Consumer<Node[]> callback;
    @NotNull
    private final List<TableUtils.SimpleTableOptions> options = new ArrayList<TableUtils.SimpleTableOptions>();
    private int[] widths;
    private ITable state;
    static final int MAX_CELLS = 300;
    private static boolean debug = false;
    private Mode mode;
    private final TableType[] tableTypes = new TableType[]{TableType.AUTO, TableType.SIMPLE, TableType.LISTED, TableType.STAIRSTEP, TableType.LINEAR};

    public TableEditor(Shell parent) {
        super(parent, 0);
    }

    public void initTable(Manager manager, boolean insert) {
        this.m = manager.getDocument().getSettingsManager();
        this.mode = insert ? Mode.INSERT : Mode.EDIT;
        Node selectedNode = manager.getSimpleManager().getCurrentCaret().getNode();
        if (BBX.CONTAINER.TABLETN.isA(selectedNode)) {
            ParentNode parent = selectedNode.getParent();
            int index = parent.indexOf(selectedNode);
            if (index != parent.getChildCount() - 1 && BBX.CONTAINER.TABLE.isA(parent.getChild(index + 1))) {
                selectedNode = parent.getChild(index + 1);
            } else {
                throw new IllegalStateException("TableTN container has no table");
            }
        }
        if (this.validateNode(selectedNode, manager, insert)) {
            this.tableNode = insert ? this.createEmptyTable(manager.getSimpleManager()) : Manager.getTableParent(selectedNode);
            this.open(nodeList -> {
                if (manager.isEmptyDocument()) {
                    StreamSupport.stream(((Iterable)() -> ((Sequence)FastXPath.descendant((Node)manager.getDoc().getRootElement())).iterator()).spliterator(), false).filter(rootDesc -> BBX.BLOCK.isA((Node)rootDesc) && BrailleDocument.isEmptyPlaceholder((Element)rootDesc)).findFirst().ifPresent(Node::detach);
                }
                manager.getSimpleManager().dispatchEvent(new ModifyEvent(Sender.NO_SENDER, true, (Node)nodeList));
            }, n -> {
                if (insert) {
                    this.tableNode.detach();
                }
            });
        } else if (insert) {
            EasySWT.makeEasyOkDialog((String)ERROR_DIALOG_TITLE, (String)ERROR_DIALOG_INSERT, (Shell)this.getParent());
        } else {
            EasySWT.makeEasyOkDialog((String)ERROR_DIALOG_TITLE, (String)ERROR_DIALOG_EDIT, (Shell)this.getParent());
        }
    }

    private Element createEmptyTable(BBSimpleManager m) {
        boolean before;
        XMLNodeCaret caret = m.getCurrentCaret();
        if (caret instanceof XMLTextCaret) {
            XMLTextCaret text = (XMLTextCaret)caret;
            nu.xom.Text block = text.getNode();
            while (!BBX.BLOCK.isA((Node)block)) {
                block = block.getParent();
            }
            int actualOffset = text.getOffset();
            int blockTextLength = 0;
            boolean pastOriginalText = false;
            Iterator iter = StreamSupport.stream(((Iterable)() -> ((Sequence)FastXPath.descendant((Node)block)).iterator()).spliterator(), false).filter(e -> e instanceof nu.xom.Text && !UTDElements.BRL.isA((Node)e.getParent())).iterator();
            while (iter.hasNext()) {
                Node next = (Node)iter.next();
                if (next == text.getNode()) {
                    pastOriginalText = true;
                }
                if (!pastOriginalText) {
                    actualOffset += next.getValue().length();
                }
                blockTextLength += next.getValue().length();
            }
            int blockHalfPoint = blockTextLength / 2;
            before = actualOffset <= blockHalfPoint;
        } else {
            MapList mapList = m.getManager().getMapList();
            before = mapList.findNextNonWhitespace(mapList.indexOf(mapList.getCurrent())) != null;
        }
        Element table = BBX.CONTAINER.TABLE.create();
        int DEFAULT_ROWS = 3;
        for (int i = 0; i < DEFAULT_ROWS; ++i) {
            Element newRow = BBX.CONTAINER.TABLE_ROW.create(BBX.TableRowType.NORMAL);
            table.appendChild((Node)newRow);
            int DEFAULT_COLS = 3;
            for (int j = 0; j < DEFAULT_COLS; ++j) {
                newRow.appendChild((Node)BBX.BLOCK.TABLE_CELL.create());
            }
        }
        Node sibling = caret.getNode();
        while (!BBX.BLOCK.isA(sibling) && !BBX.CONTAINER.isA(sibling)) {
            if ((sibling = sibling.getParent()) != null) continue;
            throw new EditingException("Block not found");
        }
        ParentNode parent = sibling.getParent();
        int index = parent.indexOf(sibling);
        parent.insertChild((Node)table, before ? index : index + 1);
        return table;
    }

    private boolean validateNode(Node node, Manager manager, boolean insert) {
        if (node == null || node instanceof Document || node.getDocument() == null || node.getDocument().getRootElement() == node) {
            return false;
        }
        if (insert && manager.getMapList().getCurrent().isReadOnly()) {
            return false;
        }
        if (insert && manager.getMapList().getCurrent() instanceof Uneditable) {
            ((Uneditable)((Object)manager.getMapList().getCurrent())).blockEdit(manager);
            return false;
        }
        return insert || Manager.getTableParent(node) != null;
    }

    public void convertTextToTable(Manager manager) {
        this.m = manager.getDocument().getSettingsManager();
        List<Element> blocks = manager.getSimpleManager().getCurrentSelection().getSelectedBlocks();
        if (blocks.size() < 2) {
            Notify.INSTANCE.notify(ERROR_CONVERT_TEXT_UNSELECTED, ERROR_DIALOG_TITLE);
            return;
        }
        for (Element block : blocks) {
            if (Manager.getTableParent((Node)block) == null) continue;
            Notify.INSTANCE.notify(ERROR_CONVERT_TEXT_ALREADY_IN_TABLE, ERROR_DIALOG_TITLE);
            return;
        }
        new ConversionColumnSelectorDialog().open(i -> {
            if (i != null) {
                this.tableNode = this.createConvertedTable(blocks, (int)i);
                ((Element)blocks.getFirst()).getParent().insertChild((Node)this.tableNode, ((Element)blocks.getFirst()).getParent().indexOf((Node)blocks.getFirst()));
                this.open(nodes -> {
                    blocks.forEach(e -> {
                        while (e.getChildCount() > 0) {
                            e.getChild(0).detach();
                        }
                        BBXUtils.cleanupBlock((Node)e);
                    });
                    manager.getSimpleManager().dispatchEvent(new ModifyEvent(Sender.NO_SENDER, true, (Node)nodes));
                }, n -> this.tableNode.detach());
            }
        }, manager.getWpManager().getShell(), blocks.size());
    }

    private Element createConvertedTable(List<Element> blocks, int columns) {
        Element parent = BBX.CONTAINER.TABLE.create();
        Element curRow = null;
        int columnNum = 0;
        for (Element block : blocks) {
            if (columnNum == 0) {
                curRow = BBX.CONTAINER.TABLE_ROW.create(BBX.TableRowType.NORMAL);
                parent.appendChild((Node)curRow);
            }
            Element tableCell = BBX.BLOCK.TABLE_CELL.create();
            block = block.copy();
            while (block.getChildCount() > 0) {
                Node child = block.getChild(0);
                child.detach();
                tableCell.appendChild(child);
            }
            curRow.appendChild((Node)tableCell);
            if (++columnNum != columns) continue;
            columnNum = 0;
        }
        while (columnNum < columns && columnNum != 0) {
            curRow.appendChild((Node)BBX.BLOCK.TABLE_CELL.create());
            ++columnNum;
        }
        return parent;
    }

    private void open(Consumer<Node[]> callback, Consumer<Node> onCancel) {
        this.shell = new Shell(this.getParent(), 67696);
        this.shell.setText(EDIT_MENUITEM);
        this.shell.setLayout((Layout)new MigLayout("fill"));
        if (onCancel != null) {
            this.shell.addDisposeListener(e -> onCancel.accept(null));
        }
        this.options.clear();
        if (!this.isFacingTable(this.tableNode) && !this.isFacingTable((Element)this.tableNode.getParent())) {
            this.options.addAll(this.findOptions(this.tableNode));
            List captions = TableUtils.findCaption((Element)this.tableNode, (IStyleMap)this.m.getEngine().getStyleMap());
            List<List<Node>> rows = this.getTableCells(this.tableNode);
            Element tnContainer = this.copyTNContainer(this.getTranscribersNote(this.tableNode));
            this.state = new InternalTable(rows, captions, tnContainer, this.getTableType(this.tableNode));
            this.createContents();
        } else {
            if (!"facingTable".equals(this.tableNode.getAttributeValue("class"))) {
                this.tableNode = (Element)this.tableNode.getParent();
            }
            Element[] tables = this.getFacingTableParents(this.tableNode);
            int split = this.getTableCells(tables[0]).getFirst().size();
            List<List<Node>> combinedTables = this.combineFacingTables(this.tableNode);
            this.state = new InternalFacingTable(combinedTables, split, new ArrayList(), TableType.SIMPLE_FACING);
            this.createFacingContents();
        }
        EasySWT.INSTANCE.setLargeDialogSize(this.shell);
        this.shell.open();
        this.shell.layout();
        this.callback = callback;
    }

    private void createContents() {
        String tableType;
        List<List<Node>> rows = this.state.getNodes();
        TableType type = this.state.getType();
        final ScrolledComposite sc = new ScrolledComposite((Composite)this.shell, 2816);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        sc.setShowFocusedControl(true);
        sc.setLayoutData((Object)"wmin 0, hmin 0, grow");
        int totalRows = rows.size();
        int totalColumns = this.state.getCols();
        final List<CellText> textBoxes = this.createTexts((Composite)sc, true);
        Composite buttonPanel = new Composite((Composite)this.shell, 0);
        buttonPanel.setLayout((Layout)new GridLayout(8, false));
        buttonPanel.setLayoutData((Object)"dock south, grow");
        Label tableTypeLabel = EasySWT.makeLabel((Composite)buttonPanel, (String)"Table type:", (int)1);
        EasySWT.buildGridData().setHint(Integer.valueOf(60), null).setAlign(Integer.valueOf(131072), Integer.valueOf(0x1000000)).applyTo((Control)tableTypeLabel);
        this.tableTypeCombo = new Combo(buttonPanel, 8);
        EasySWT.buildGridData().setHint(Integer.valueOf(150), null).setAlign(Integer.valueOf(16384), Integer.valueOf(1)).applyTo((Control)this.tableTypeCombo);
        String[] tableTypeNames = new String[this.tableTypes.length];
        for (int i = 0; i < this.tableTypes.length; ++i) {
            tableTypeNames[i] = this.tableTypes[i].displayName;
        }
        this.tableTypeCombo.setItems(tableTypeNames);
        this.tableTypeCombo.select(0);
        String string = tableType = type.equals((Object)TableType.UNSET) ? this.tableNode.getAttributeValue("format") : type.displayName.toLowerCase();
        if ("simple".equals(tableType)) {
            this.tableTypeCombo.select(this.tableTypeCombo.indexOf(TableType.SIMPLE.displayName));
        } else if ("listed".equals(tableType)) {
            this.tableTypeCombo.select(this.tableTypeCombo.indexOf(TableType.LISTED.displayName));
        } else if ("stairstep".equals(tableType)) {
            this.tableTypeCombo.select(this.tableTypeCombo.indexOf(TableType.STAIRSTEP.displayName));
        } else if ("linear".equals(tableType)) {
            this.tableTypeCombo.select(this.tableTypeCombo.indexOf(TableType.LINEAR.displayName));
        }
        final Button formatSpecificOption = EasySWT.makePushButton((Composite)buttonPanel, (String)"Format Specific Option", (int)1, null);
        formatSpecificOption.setVisible(false);
        Label spacingLabel = EasySWT.makeLabel((Composite)buttonPanel, (String)"", (int)1);
        EasySWT.buildGridData().setColumns(1).setGrabSpace(true, false).applyTo((Control)spacingLabel);
        EasySWT.makeLabel((Composite)buttonPanel, (String)"Rows:", (int)1);
        this.rowText = EasySWT.makeText((Composite)buttonPanel, (int)40, (int)1);
        EasyListeners.verifyNumbersOnly((Text)this.rowText);
        this.rowText.setText(Integer.toString(totalRows));
        this.rowText.setTextLimit(2);
        EasySWT.makeLabel((Composite)buttonPanel, (String)"Columns:", (int)1);
        this.colText = EasySWT.makeText((Composite)buttonPanel, (int)1);
        EasySWT.buildGridData().setHint(Integer.valueOf(40), null).applyTo((Control)this.colText);
        EasyListeners.verifyNumbersOnly((Text)this.colText);
        this.colText.setText(Integer.toString(totalColumns));
        this.colText.setTextLimit(2);
        EasyListeners.modify((Text)this.rowText, e -> {
            if (this.rowText.getText().isEmpty() || this.colText.getText().isEmpty()) {
                return;
            }
            if (Integer.parseInt(this.colText.getText()) * Integer.parseInt(this.rowText.getText()) > 300) {
                EasySWT.makeEasyOkDialog((String)ERROR_DIALOG_TITLE, (String)"Table cannot exceed 300 cells", (Shell)this.shell);
                return;
            }
            this.updateState(textBoxes);
            this.deleteTexts((Composite)sc, textBoxes);
            this.state.setDisplayedRows(Integer.parseInt(this.rowText.getText()));
            this.recreateTexts((Composite)sc, textBoxes, formatSpecificOption);
            this.checkFormatSpecificOption((Composite)sc, formatSpecificOption, textBoxes);
        });
        EasyListeners.modify((Text)this.colText, e -> {
            if (this.rowText.getText().isEmpty() || this.colText.getText().isEmpty()) {
                return;
            }
            if (Integer.parseInt(this.colText.getText()) * Integer.parseInt(this.rowText.getText()) > 300) {
                EasySWT.makeEasyOkDialog((String)ERROR_DIALOG_TITLE, (String)"Table cannot exceed 300 cells", (Shell)this.shell);
                return;
            }
            this.updateState(textBoxes);
            this.deleteTexts((Composite)sc, textBoxes);
            this.state.setDisplayedCols(Integer.parseInt(this.colText.getText()));
            this.recreateTexts((Composite)sc, textBoxes, formatSpecificOption);
            this.checkFormatSpecificOption((Composite)sc, formatSpecificOption, textBoxes);
            if (this.tableTypes[this.tableTypeCombo.getSelectionIndex()] == TableType.SIMPLE && this.options.contains(TableUtils.SimpleTableOptions.CUSTOM_WIDTHS)) {
                this.options.remove(TableUtils.SimpleTableOptions.CUSTOM_WIDTHS);
                this.widths = null;
                EasySWT.makeEasyOkDialog((String)"Custom widths reset", (String)"Custom column widths have been reset", (Shell)this.shell);
                if (this.options.isEmpty()) {
                    formatSpecificOption.setText("Simple Table Options");
                }
            }
        });
        this.tableTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(this){
            final /* synthetic */ TableEditor this$0;
            {
                this.this$0 = this$0;
            }

            public void widgetSelected(SelectionEvent e) {
                if (this.this$0.state.getTNContainer() != null) {
                    this.this$0.removeTNContainerFromState((Composite)sc, textBoxes, formatSpecificOption);
                    this.this$0.updateRowColTexts();
                }
                if (this.this$0.tableTypes[this.this$0.tableTypeCombo.getSelectionIndex()] == TableType.SIMPLE_FACING) {
                    int result = new ChangeToFacingDialog().open(this.this$0.shell, this.this$0.state, false)[0];
                    if (result == -1) {
                        this.this$0.tableTypeCombo.select(this.this$0.tableTypeCombo.indexOf(TableType.SIMPLE.displayName));
                    } else {
                        this.this$0.updateState(textBoxes);
                        List<List<Node>> tempRows = this.this$0.state.getDisplayedNodes();
                        this.this$0.state = new InternalFacingTable(tempRows, result, this.this$0.state.getCaptions(), TableType.SIMPLE_FACING);
                        this.this$0.rebuildView();
                    }
                } else {
                    this.this$0.checkFormatSpecificOption((Composite)sc, formatSpecificOption, textBoxes);
                }
            }
        });
        this.makeButtonPanel(buttonPanel, textBoxes, null);
        this.checkFormatSpecificOption((Composite)sc, formatSpecificOption, textBoxes);
        this.createMenu(textBoxes, null, debug);
    }

    private void createFacingContents() {
        List<List<Node>> leftRows = ((InternalFacingTable)this.state).getLeftNodes();
        List<List<Node>> rightRows = ((InternalFacingTable)this.state).getRightNodes();
        ScrolledComposite doubleSC = new ScrolledComposite((Composite)this.shell, 2816);
        doubleSC.setExpandHorizontal(true);
        doubleSC.setExpandVertical(true);
        doubleSC.setLayoutData((Object)"wmin 0, hmin 0");
        doubleSC.setLayout((Layout)new MigLayout("fill"));
        Composite tableContainer = new Composite((Composite)doubleSC, 0);
        tableContainer.setLayoutData((Object)"wmin 0, hmin 0");
        tableContainer.setLayout((Layout)new MigLayout("fill"));
        Composite leftSC = new Composite(tableContainer, 0);
        leftSC.setLayoutData((Object)"wmin 0, hmin 0, grow, dock west");
        leftSC.setLayout((Layout)new GridLayout(1, false));
        Label leftTableLabel = EasySWT.makeLabel((Composite)leftSC, (String)"Left Page", (int)1);
        EasySWT.buildGridData().setAlign(Integer.valueOf(0x1000000), Integer.valueOf(1)).applyTo((Control)leftTableLabel);
        final List<CellText> leftBoxes = this.createTexts(leftSC, leftRows, ((InternalFacingTable)this.state).split, this.state.getRows(), new ArrayList<Element>(), null, false);
        if (leftBoxes == null) {
            return;
        }
        Label border = new Label(tableContainer, 2048);
        border.setBackground(Display.getCurrent().getSystemColor(17));
        border.setLayoutData((Object)"growy, wmax 4");
        Composite rightSC = new Composite(tableContainer, 0);
        Label rightTableLabel = EasySWT.makeLabel((Composite)rightSC, (String)"Right Page", (int)1);
        EasySWT.buildGridData().setAlign(Integer.valueOf(0x1000000), Integer.valueOf(1)).applyTo((Control)rightTableLabel);
        rightSC.setLayoutData((Object)"wmin 0, hmin 0, grow, dock east");
        rightSC.setLayout((Layout)new GridLayout(1, false));
        final List<CellText> rightBoxes = this.createTexts(rightSC, rightRows, this.state.getCols() - ((InternalFacingTable)this.state).split, this.state.getRows(), new ArrayList<Element>(), null, false);
        if (rightBoxes == null) {
            return;
        }
        rightBoxes.forEach(ct -> ct.col += ((InternalFacingTable)this.state).split);
        doubleSC.setContent((Control)tableContainer);
        doubleSC.setMinSize(tableContainer.computeSize(-1, -1));
        Composite buttonPanel = new Composite((Composite)this.shell, 0);
        buttonPanel.setLayout((Layout)new GridLayout(8, false));
        buttonPanel.setLayoutData((Object)"wmin 0, growx, dock south");
        Label tableTypeLabel = EasySWT.makeLabel((Composite)buttonPanel, (String)"Table type:", (int)1);
        EasySWT.buildGridData().setHint(Integer.valueOf(60), null).setAlign(Integer.valueOf(131072), Integer.valueOf(0x1000000)).applyTo((Control)tableTypeLabel);
        this.tableTypeCombo = new Combo(buttonPanel, 8);
        EasySWT.buildGridData().setHint(Integer.valueOf(150), null).setAlign(Integer.valueOf(16384), Integer.valueOf(1)).applyTo((Control)this.tableTypeCombo);
        String[] tableTypeNames = new String[this.tableTypes.length];
        for (int i = 0; i < this.tableTypes.length; ++i) {
            tableTypeNames[i] = this.tableTypes[i].displayName;
        }
        this.tableTypeCombo.setItems(tableTypeNames);
        this.tableTypeCombo.select(this.tableTypeCombo.indexOf(TableType.SIMPLE_FACING.displayName));
        this.tableTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(this){
            final /* synthetic */ TableEditor this$0;
            {
                this.this$0 = this$0;
            }

            public void widgetSelected(SelectionEvent e) {
                if (this.this$0.tableTypes[this.this$0.tableTypeCombo.getSelectionIndex()] != TableType.SIMPLE_FACING) {
                    int newSelection = this.this$0.tableTypeCombo.getSelectionIndex();
                    this.this$0.updateState(leftBoxes);
                    this.this$0.updateState(rightBoxes);
                    this.this$0.state = new InternalTable(this.this$0.state.getNodes(), this.this$0.state.getCaptions(), this.this$0.state.getTNContainer(), this.this$0.tableTypes[newSelection]);
                    this.this$0.rebuildView();
                    this.this$0.tableTypeCombo.select(newSelection);
                }
            }
        });
        EasySWT.makePushButton((Composite)buttonPanel, (String)CHANGE_DIMENSIONS_BUTTON, (int)2, e -> {
            int[] results = new ChangeToFacingDialog().open(this.shell, this.state, true);
            if (results[0] > 0) {
                this.state.setRows(results[1]);
                this.state.setCols(results[2]);
                ((InternalFacingTable)this.state).split = results[0];
                this.rebuildView();
            }
        });
        Label spacingLabel = EasySWT.makeLabel((Composite)buttonPanel, (String)"", (int)1);
        EasySWT.buildGridData().setColumns(4).setGrabSpace(true, false).applyTo((Control)spacingLabel);
        this.makeButtonPanel(buttonPanel, leftBoxes, rightBoxes);
        this.createMenu(leftBoxes, rightBoxes, debug);
    }

    private void createMenu(List<CellText> texts, List<CellText> rightTexts, boolean debug) {
        this.deleteMenu();
        MenuBuilder mb = new MenuBuilder(this.shell);
        boolean edit = this.mode == Mode.EDIT;
        mb.addToMenu("Actions").addPushItem(REFORMAT_BUTTON, 0, edit, e -> this.selectStyle(style -> {
            this.destroyTable((Style)style, texts, rightTexts);
            this.closeShell();
        })).addPushItem(ADVANCED_REFORMAT_BUTTON, 0, edit, e -> {
            if (this.advancedDestroy(texts, rightTexts)) {
                this.closeShell();
            }
        }).addPushItem("Delete Table", 0, edit, e -> this.deleteTable()).addToMenu("Tools").addPushItem("Swap columns and rows", -1, e -> {
            this.state.setRows(this.state.getDisplayedRows());
            this.state.setCols(this.state.getDisplayedCols());
            this.updateState(texts);
            if (rightTexts != null) {
                this.updateState(rightTexts);
            }
            this.swapNodes();
            this.rebuildView();
        }).addSubMenu("Add Emphasis To All", this.createEmphasisSubMenu(texts, rightTexts)).addPushItem(localeHandler.get("tableEditor.mathToAll"), SWT.MOD3 | MathModuleUtils.MATH_ACCELERATOR, e -> {
            texts.forEach(t -> t.text.applyEmphasisToAll(BBStyleableText.MathTags.MATH));
            if (rightTexts != null) {
                rightTexts.forEach(t -> t.text.applyEmphasisToAll(BBStyleableText.MathTags.MATH));
            }
        }).addPushItem("Remove All Emphasis", SWT.MOD1 | SWT.MOD3 | 0x45, e -> {
            texts.forEach(t -> t.text.removeAllEmphasis());
            if (rightTexts != null) {
                rightTexts.forEach(t -> t.text.removeAllEmphasis());
            }
        }).addToMenu("Emphasis");
        this.createEmphasisMenu(mb, tag -> {
            BBStyleableText curText = this.getCurrentText(texts, rightTexts);
            if (curText != null) {
                curText.toggleTag((BBStyleableText.EmphasisTags)((Object)tag));
            }
        });
        mb.addToMenu("Translation").addPushItem("Direct Translation", BBStyleableText.EmphasisTags.CTEXACT.getDefaultAccelerator(), e -> {
            BBStyleableText curText = this.getCurrentText(texts, rightTexts);
            if (curText != null) {
                curText.toggleTag(BBStyleableText.EmphasisTags.CTEXACT);
            }
        }).addPushItem("Uncontracted Translation", BBStyleableText.EmphasisTags.CTUNCONTRACTED.getDefaultAccelerator(), e -> {
            BBStyleableText curText = this.getCurrentText(texts, rightTexts);
            if (curText != null) {
                curText.toggleTag(BBStyleableText.EmphasisTags.CTUNCONTRACTED);
            }
        }).addPushItem("Math Translation", MathModuleUtils.MATH_ACCELERATOR, e -> {
            BBStyleableText curText = this.getCurrentText(texts, rightTexts);
            if (curText != null) {
                curText.toggleTag(BBStyleableText.MathTags.MATH);
            }
        });
        if (debug) {
            mb.addToMenu("Debug").addPushItem("Print state", 0, e -> {
                this.updateState(texts);
                System.out.println(this.state.toPrintableState());
            }).addPushItem("Fill table", 0, e -> {
                ArrayList<List<Node>> newList = new ArrayList<List<Node>>();
                for (int i = 0; i < this.state.getRows(); ++i) {
                    newList.add(new ArrayList());
                    for (int j = 0; j < this.state.getCols(); ++j) {
                        Element newElement = new Element("td");
                        newElement.appendChild("Test " + i + ", " + j);
                        ((List)newList.get(i)).add(newElement);
                    }
                }
                this.state = this.state instanceof InternalFacingTable ? new InternalFacingTable(newList, ((InternalFacingTable)this.state).split, this.state.getCaptions(), this.state.getType()) : new InternalTable(newList, this.state.getCaptions(), this.state.getTNContainer(), this.state.getType());
                this.rebuildView();
            });
        }
        mb.build();
    }

    private void rebuildView() {
        Control[] children;
        for (Control child : children = this.shell.getChildren()) {
            child.dispose();
        }
        if (this.state instanceof InternalFacingTable) {
            this.createFacingContents();
        } else {
            this.createContents();
        }
        this.shell.layout(true);
    }

    private void deleteMenu() {
        if (this.shell.getMenuBar() != null) {
            this.shell.getMenuBar().dispose();
        }
    }

    private void createEmphasisMenu(MenuBuilder mb, Consumer<BBStyleableText.EmphasisTags> onClick) {
        for (BBStyleableText.EmphasisTags tag : BBStyleableText.EmphasisTags.getEntries()) {
            if (tag == BBStyleableText.EmphasisTags.ITALICBOLD || tag == BBStyleableText.EmphasisTags.CTEXACT || tag == BBStyleableText.EmphasisTags.CTUNCONTRACTED) continue;
            mb.addPushItem(tag.getTagName(), tag.getDefaultAccelerator(), e -> onClick.accept(tag));
        }
    }

    private SubMenuBuilder createEmphasisSubMenu(List<CellText> texts, List<CellText> rightTexts) {
        SubMenuBuilder smb = new SubMenuBuilder(this.shell);
        for (BBStyleableText.EmphasisTags tag : BBStyleableText.EmphasisTags.getEntries()) {
            if (tag == BBStyleableText.EmphasisTags.ITALICBOLD) continue;
            smb.addPushItem(tag.getTagName(), SWT.MOD3 | tag.getDefaultAccelerator(), e -> {
                texts.forEach(t -> t.text.applyEmphasisToAll(tag));
                if (rightTexts != null) {
                    rightTexts.forEach(t -> t.text.applyEmphasisToAll(tag));
                }
            });
        }
        return smb;
    }

    private void makeButtonPanel(Composite buttonPanel, List<CellText> textBoxes, List<CellText> rightBoxes) {
        Composite spacingComp = EasySWT.makeComposite((Composite)buttonPanel, (int)1);
        EasySWT.buildGridData().setColumns(3).applyTo((Control)spacingComp);
        Composite saveCancelComp = EasySWT.makeComposite((Composite)buttonPanel, (int)2);
        EasySWT.buildGridData().setAlign(Integer.valueOf(0x1000008), Integer.valueOf(0x1000000)).setColumns(5).applyTo((Control)saveCancelComp);
        Button saveButton = EasySWT.makePushButton((Composite)saveCancelComp, (String)SAVE_BUTTON, (int)2, e -> {
            Node[] newNodes;
            this.updateState(textBoxes);
            Node[] nodeArray = newNodes = rightBoxes != null ? this.generateNewFacingTable(textBoxes, rightBoxes) : this.generateNewTable(this.state.getNodes(), this.state.getDisplayedCols(), this.state.getDisplayedRows(), this.tableNode);
            if (newNodes != null) {
                this.callback.accept(newNodes);
            }
            this.closeShell();
        });
        EasySWT.buildGridData().setHint(Integer.valueOf(80), Integer.valueOf(30)).setColumns(1).applyTo((Control)saveButton);
        Button cancelButton = EasySWT.makePushButton((Composite)saveCancelComp, (String)CANCEL_BUTTON, (int)2, e -> this.shell.close());
        EasySWT.buildGridData().setHint(Integer.valueOf(80), Integer.valueOf(30)).setColumns(1).applyTo((Control)cancelButton);
    }

    private List<List<Node>> combineFacingTables(Element parent) {
        Element[] parents = this.getFacingTableParents(parent);
        return this.combineNodeLists(this.getTableCells(parents[0]), this.getTableCells(parents[1]));
    }

    private List<List<Node>> combineNodeLists(List<List<Node>> leftTable, List<List<Node>> rightTable) {
        ArrayList<List<Node>> returnList = new ArrayList<List<Node>>();
        for (int row = 0; row < Math.max(leftTable.size(), rightTable.size()); ++row) {
            int col;
            returnList.add(new ArrayList());
            if (row < leftTable.size()) {
                for (col = 0; col < leftTable.get(row).size(); ++col) {
                    ((List)returnList.getLast()).add(leftTable.get(row).get(col));
                }
            }
            if (row >= rightTable.size()) continue;
            for (col = 0; col < rightTable.get(row).size(); ++col) {
                ((List)returnList.getLast()).add(rightTable.get(row).get(col));
            }
        }
        return returnList;
    }

    private void checkFormatSpecificOption(Composite parent, Button button, List<CellText> textBoxes) {
        TableType type;
        if (button.getListeners(13).length == 0) {
            button.addSelectionListener((SelectionListener)this.getFormatSpecificButtonListener(parent, textBoxes, button));
        }
        if ((type = this.tableTypes[this.tableTypeCombo.getSelectionIndex()]) == TableType.SIMPLE) {
            button.setText("Simple Table Options" + (!this.options.isEmpty() ? "*" : ""));
        } else if (type == TableType.STAIRSTEP || type == TableType.LINEAR || type == TableType.LISTED) {
            if (this.state.getTNContainer() == null) {
                button.setText("Create Transcriber Note Heading");
            } else {
                button.setText("Remove Transcriber Note Heading");
            }
        } else {
            button.setText("");
        }
        if (button.getText().isEmpty()) {
            button.pack(true);
            button.setVisible(false);
        } else {
            button.getParent().layout(true);
            button.setSize(EasySWT.getWidthOfText((String)(button.getText() + "    ")), button.computeSize((int)-1, (int)-1).y);
            EasySWT.buildGridData().applyTo((Control)button);
            button.setVisible(true);
        }
    }

    private SelectionAdapter getFormatSpecificButtonListener(final Composite parent, final List<CellText> textBoxes, final Button formatSpecificButton) {
        return new SelectionAdapter(this){
            final /* synthetic */ TableEditor this$0;
            {
                this.this$0 = this$0;
            }

            public void widgetSelected(SelectionEvent e) {
                TableType type = this.this$0.tableTypes[this.this$0.tableTypeCombo.getSelectionIndex()];
                if (type == TableType.SIMPLE) {
                    this.this$0.new SimpleTableOptionDialog().open(this.this$0.shell, this.this$0.tableNode, this.this$0.state.getDisplayedCols(), this.this$0.options, this.this$0.m);
                } else if (type == TableType.STAIRSTEP || type == TableType.LINEAR || type == TableType.LISTED) {
                    if (this.this$0.state.getTNContainer() == null) {
                        Element tNote = BBX.BLOCK.STYLE.create("7-5");
                        if (type == TableType.LISTED) {
                            tNote.appendChild(TableEditor.LISTED_TN_HEADING);
                        } else if (type == TableType.STAIRSTEP) {
                            tNote.appendChild(TableEditor.STAIRSTEP_TN_HEADING);
                        } else {
                            tNote.appendChild(TableEditor.LINEAR_TN_HEADING);
                        }
                        this.this$0.updateState(textBoxes);
                        List<CellText> firstRow = textBoxes.stream().filter(t -> t.row == 0).collect(Collectors.toList());
                        if (type != TableType.LISTED) {
                            for (CellText text : firstRow) {
                                textBoxes.remove(text);
                            }
                            for (CellText text : textBoxes) {
                                --text.row;
                            }
                            this.this$0.state.getNodes().removeFirst();
                            this.this$0.state.setDisplayedRows(this.this$0.state.getDisplayedRows() - 1);
                            this.this$0.updateState(textBoxes);
                        }
                        Element tnContainer = this.this$0.createTNContainer(tNote, firstRow);
                        this.this$0.state.setTNContainer(tnContainer);
                        if (!this.this$0.shell.isDisposed()) {
                            this.this$0.updateRowColTexts();
                            this.this$0.deleteTexts(parent, textBoxes);
                            this.this$0.recreateTexts(parent, textBoxes, formatSpecificButton);
                            this.this$0.checkFormatSpecificOption(parent, formatSpecificButton, textBoxes);
                        }
                    } else {
                        this.this$0.removeTNContainerFromState(parent, textBoxes, formatSpecificButton);
                    }
                }
            }
        };
    }

    private void closeShell() {
        if (this.shell.getListeners(12).length > 0) {
            this.shell.removeListener(12, this.shell.getListeners(12)[0]);
        }
        this.shell.close();
    }

    private List<CellText> createTexts(Composite sc, boolean destroyable) {
        return this.createTexts(sc, this.state.getNodes(), this.state.getDisplayedCols(), this.state.getDisplayedRows(), this.state.getCaptions(), this.state.getTNContainer(), destroyable);
    }

    private List<CellText> createTexts(Composite sc, List<List<Node>> rows, int displayCols, int displayRows, List<Element> captions, Element tnContainer, boolean destroyable) {
        final ArrayList<CellText> returnList = new ArrayList<CellText>();
        Composite tableComp = new Composite(sc, 0);
        tableComp.setLayout((Layout)new GridLayout(displayCols + 1, false));
        EasySWT.INSTANCE.setGridData((Control)tableComp);
        ArrayList<List<Node>> tempRows = new ArrayList<List<Node>>(rows);
        if (!captions.isEmpty()) {
            Element captionParent = captions.getFirst();
            IStyle parentStyle = this.m.getEngine().getStyle((Node)captionParent);
            while (parentStyle == null || !parentStyle.getName().toLowerCase().contains("caption")) {
                if ((captionParent = (Element)captionParent.getParent()) == this.tableNode.getDocument().getRootElement()) {
                    captionParent = captions.getFirst();
                    break;
                }
                parentStyle = this.m.getEngine().getStyle((Node)captionParent);
            }
            Composite composite = EasySWT.makeComposite((Composite)tableComp, (int)(displayCols + 1));
            EasySWT.buildGridData().setColumns(displayCols + 1).applyTo((Control)composite);
            Button destroyButton = null;
            if (destroyable) {
                destroyButton = EasySWT.makePushButton((Composite)composite, (String)"X", (int)1, null);
                EasySWT.buildGridData().setAlign(Integer.valueOf(0x1000000), Integer.valueOf(0x1000000)).applyTo((Control)destroyButton);
                AccessibilityUtils.setName((Control)destroyButton, (String)ACCESSIBLE_DELETE_CAPTION_NAME);
            }
            Composite labelAndTextContainer = EasySWT.makeComposite((Composite)composite, (int)2);
            Label captionLabel = EasySWT.makeLabel((Composite)labelAndTextContainer, (String)ACCESSIBLE_CAPTION_NAME, (int)1);
            EasySWT.buildGridData().setAlign(Integer.valueOf(0x1000000), Integer.valueOf(0x1000000)).applyTo((Control)captionLabel);
            Composite textHolder = EasySWT.makeComposite((Composite)labelAndTextContainer, (int)1);
            CellText captionText = new CellText(textHolder, -1, -1);
            captionText.setCaption(true);
            EasySWT.buildGridData().setHint(Integer.valueOf(400), Integer.valueOf(100)).setAlign(Integer.valueOf(0x1000000), Integer.valueOf(0x1000000)).applyTo((Control)captionText.getWidget());
            captionText.text.setXML(captionParent);
            captionText.getWidget().setData((Object)new Element("caption"));
            AccessibilityUtils.setName((Control)captionText.getWidget(), (String)ACCESSIBLE_CAPTION_NAME);
            returnList.add(captionText);
            if (destroyable) {
                EasyListeners.selection((Button)destroyButton, e -> this.destroyCaption(captionText));
            }
        }
        if (tnContainer != null) {
            Element containerCopy = this.copyTNContainer(tnContainer, this.state.getType());
            Composite tnRow = EasySWT.makeComposite((Composite)tableComp, (int)(displayCols + 1));
            EasySWT.buildGridData().setColumns(displayCols + 1).applyTo((Control)tnRow);
            Label label = EasySWT.makeLabel((Composite)tnRow, (String)ACCESSIBLE_TN_HEADING_NAME, (int)1);
            EasySWT.buildGridData().setAlign(Integer.valueOf(0x1000000), Integer.valueOf(0x1000000)).applyTo((Control)label);
            CellText tnHeadingText = new CellText(tnRow, -1, -1);
            EasySWT.buildGridData().setColumns(displayCols).setHint(Integer.valueOf(400), Integer.valueOf(50)).applyTo((Control)tnHeadingText.getWidget());
            tnHeadingText.setTN(true);
            tnHeadingText.text.setXML((Element)containerCopy.getChild(0));
            returnList.add(tnHeadingText);
            if (this.state.getType() != TableType.LISTED) {
                if (this.state.getType() == TableType.STAIRSTEP) {
                    Label spacingLabel = EasySWT.makeLabel((Composite)tnRow, (String)"", (int)1);
                    EasySWT.buildGridData().setAlign(Integer.valueOf(0x1000000), Integer.valueOf(0x1000000)).applyTo((Control)spacingLabel);
                    for (int i = 0; i < displayCols; ++i) {
                        int margin = i * 2 + 1;
                        Label colLabel = EasySWT.makeLabel((Composite)tnRow, (String)(margin + "-" + margin), (int)1);
                        EasySWT.buildGridData().setAlign(Integer.valueOf(0x1000000), Integer.valueOf(0x1000000)).applyTo((Control)colLabel);
                    }
                }
                Label tnLabel2 = EasySWT.makeLabel((Composite)tnRow, (String)(this.state.getType() == TableType.LINEAR ? "7-5" : ""), (int)1);
                EasySWT.buildGridData().setAlign(Integer.valueOf(0x1000000), Integer.valueOf(0x1000000)).applyTo((Control)tnLabel2);
                for (int i = 0; i < displayCols; ++i) {
                    Composite textComp = EasySWT.makeComposite((Composite)tnRow, (int)1);
                    CellText newText = new CellText(textComp, -1, i);
                    EasySWT.buildGridData().setHint(Integer.valueOf(200), Integer.valueOf(150)).applyTo((Control)newText.getWidget());
                    if (i + 1 < containerCopy.getChildCount()) {
                        try {
                            newText.text.setXML((Element)containerCopy.getChild(i + 1));
                        }
                        catch (NodeException ne) {
                            Notify.showMessage("Error setting TN text. Table may be too long:\n" + ne.getMessage(), new Object[0]);
                            this.closeShell();
                            return null;
                        }
                    }
                    newText.setTN(true);
                    returnList.add(newText);
                }
            }
        }
        EasySWT.makeLabel((Composite)tableComp, (String)"", (int)1);
        for (int i = 0; i < displayCols; ++i) {
            Label newLabel = EasySWT.makeLabel((Composite)tableComp, (String)("Column " + (i + 1)), (int)1);
            EasySWT.buildGridData().setAlign(Integer.valueOf(0x1000000), Integer.valueOf(1)).applyTo((Control)newLabel);
        }
        while (tempRows.size() < displayRows) {
            tempRows.add(new ArrayList());
        }
        int iterator = 1;
        for (List list : tempRows) {
            int iteration = iterator - 1;
            Composite rowLabel = EasySWT.makeComposite((Composite)tableComp, (int)2);
            if (destroyable) {
                Button destroyButton = EasySWT.makePushButton((Composite)rowLabel, (String)"X", (int)1, e -> this.destroyRow(returnList, iteration));
                EasySWT.buildGridData().setAlign(Integer.valueOf(131072), Integer.valueOf(131072)).applyTo((Control)destroyButton);
                AccessibilityUtils.setName((Control)destroyButton, (String)("Delete Row " + iterator));
            }
            Label newLabel = EasySWT.makeLabel((Composite)rowLabel, (String)"", (int)1);
            if (iterator == 1 && tnContainer == null) {
                newLabel.setText("Heading");
            } else {
                newLabel.setText("Row " + iterator);
            }
            EasySWT.buildGridData().setAlign(Integer.valueOf(131072), Integer.valueOf(0x1000000)).setColumns(destroyable ? 1 : 2).applyTo((Control)newLabel);
            while (list.size() < displayCols) {
                Element dummyElement = new Element("td");
                list.add(dummyElement);
            }
            int totalTexts = 0;
            for (Node node : list) {
                Composite textPanel = EasySWT.makeComposite((Composite)tableComp, (int)1);
                CellText newText = new CellText(textPanel, tempRows.indexOf(list), list.indexOf(node));
                EasySWT.buildGridData().setHint(Integer.valueOf(200), Integer.valueOf(150)).applyTo((Control)newText.getWidget());
                newText.text.setXML((Element)node);
                returnList.add(newText);
                newText.getWidget().addKeyListener((KeyListener)this.debugListener());
                if (++totalTexts != displayCols) continue;
                break;
            }
            if (iterator == displayRows) break;
            ++iterator;
        }
        if (sc instanceof ScrolledComposite) {
            ((ScrolledComposite)sc).setContent((Control)tableComp);
            ((ScrolledComposite)sc).setMinSize(tableComp.computeSize(-1, -1));
        }
        if (!returnList.isEmpty()) {
            ((CellText)returnList.getFirst()).getWidget().setFocus();
        }
        for (CellText cellText : returnList) {
            cellText.getWidget().addKeyListener((KeyListener)new KeyAdapter(this){
                final /* synthetic */ TableEditor this$0;
                {
                    this.this$0 = this$0;
                }

                public void keyPressed(KeyEvent e) {
                    int textIndex = this.this$0.textFocusedWhere(returnList);
                    if (textIndex != -1 && (e.stateMask & 0x40000) == 262144 && (e.stateMask & 0x10000) == 65536) {
                        if (e.keyCode == 0x1000001) {
                            if (textIndex - this.this$0.state.getDisplayedCols() >= 0) {
                                ((CellText)returnList.get(textIndex - this.this$0.state.getDisplayedCols())).getWidget().setFocus();
                            } else {
                                ((CellText)returnList.getFirst()).getWidget().setFocus();
                            }
                        } else if (e.keyCode == 0x1000002) {
                            if (textIndex + this.this$0.state.getDisplayedCols() < returnList.size()) {
                                ((CellText)returnList.get(textIndex + this.this$0.state.getDisplayedCols())).getWidget().setFocus();
                            } else {
                                ((CellText)returnList.getLast()).getWidget().setFocus();
                            }
                        } else if (e.keyCode == 0x1000003) {
                            if (textIndex - 1 >= 0) {
                                ((CellText)returnList.get(textIndex - 1)).getWidget().setFocus();
                            }
                        } else if (e.keyCode == 0x1000004) {
                            if (textIndex + 1 < returnList.size()) {
                                ((CellText)returnList.get(textIndex + 1)).getWidget().setFocus();
                            }
                        } else if (e.keyCode == 0x1000007) {
                            ((CellText)returnList.getFirst()).getWidget().setFocus();
                        } else if (e.keyCode == 0x1000008) {
                            ((CellText)returnList.getLast()).getWidget().setFocus();
                        }
                    }
                }
            });
        }
        return returnList;
    }

    private int textFocusedWhere(List<CellText> myText) {
        for (int i = 0; i < myText.size(); ++i) {
            if (!myText.get(i).getWidget().isFocusControl()) continue;
            return i;
        }
        return -1;
    }

    private void recreateTexts(Composite sc, List<CellText> textBoxes, Button formatSpecificOptionButton) {
        textBoxes.clear();
        textBoxes.addAll(this.createTexts(sc, true));
        this.shell.layout();
    }

    private void destroyRow(List<CellText> textBoxes, int rowNum) {
        if (this.state.getRows() == 2) {
            MessageBox question = new MessageBox(this.shell, 192);
            question.setMessage("Destroying this row will eliminate the entire table. Would you like to continue?");
            question.setText("Destroy Row");
            if (question.open() == 64) {
                this.selectStyle(style -> {
                    this.destroyTable((Style)style, textBoxes, null);
                    this.shell.close();
                });
            }
            return;
        }
        Shell destroyRowPopup = new Shell(this.shell, 2144);
        destroyRowPopup.setLayout((Layout)new GridLayout(1, false));
        destroyRowPopup.setText("Place Destroyed Row");
        Composite container = EasySWT.makeComposite((Composite)destroyRowPopup, (int)1);
        ButtonBuilder1 buttonBuilder = EasySWT.buildPushButton((Composite)container);
        buttonBuilder.text = "Place row before table";
        buttonBuilder.setSwtOptions(16);
        Button radio1 = buttonBuilder.build();
        radio1.setSelection(true);
        buttonBuilder = EasySWT.buildPushButton((Composite)container);
        buttonBuilder.text = "Place row after table";
        buttonBuilder.setSwtOptions(16);
        buttonBuilder.build();
        buttonBuilder = EasySWT.buildPushButton((Composite)container);
        buttonBuilder.text = "Delete row entirely";
        buttonBuilder.setSwtOptions(16);
        Button radio3 = buttonBuilder.build();
        EasySWT.buildComposite((Composite)container).addButton(OK_BUTTON, 1, i -> {
            boolean before = radio1.getSelection();
            if (radio3.getSelection()) {
                destroyRowPopup.close();
                this.destroyRow(null, textBoxes, before, true, rowNum);
            } else {
                this.selectStyle(style -> this.destroyRow((Style)style, textBoxes, before, false, rowNum));
                destroyRowPopup.close();
            }
        }).addButton(CANCEL_BUTTON, 1, i -> destroyRowPopup.close()).build();
        destroyRowPopup.open();
        destroyRowPopup.pack();
    }

    private void destroyCaption(CellText captionText) {
        if (this.state.getCaptions().isEmpty()) {
            return;
        }
        Element parent = (Element)this.tableNode.getParent();
        int index = parent.indexOf((Node)this.tableNode);
        this.state.getCaptions().forEach(Node::detach);
        Element caption = captionText.text.getXML(BBX.BLOCK.STYLE.create(ACCESSIBLE_CAPTION_NAME));
        parent.insertChild((Node)caption, index);
        this.callback.accept(new Node[]{caption, parent});
        this.shell.close();
    }

    private void destroyRow(Style replacementStyle, List<CellText> textBoxes, boolean before, boolean delete, int rowNum) {
        this.updateState(textBoxes);
        List<Node> nodes = this.state.getNodes().get(rowNum);
        ParentNode tableParent = this.tableNode.getParent();
        int index = tableParent.indexOf((Node)this.tableNode);
        if (!before && ++index < tableParent.getChildCount() && tableParent.getChild(index) instanceof Element && ((Element)tableParent.getChild(index)).getAttribute("class") != null && ((Element)tableParent.getChild(index)).getAttributeValue("class").contains("utd:table")) {
            tableParent.getChild(index).detach();
        }
        ArrayList<Object> nodesToTranslate = new ArrayList<Object>();
        if (replacementStyle != null) {
            for (Node node : nodes) {
                if (!(node instanceof Element) || node.getValue().isEmpty()) continue;
                Element el = BBX.BLOCK.STYLE.create(replacementStyle.getName());
                if (delete) continue;
                while (node.getChildCount() > 0) {
                    Node child = node.getChild(node.getChildCount() - 1);
                    child.detach();
                    el.insertChild(child, 0);
                }
                tableParent.insertChild((Node)el, index);
                nodesToTranslate.add(el);
                ++index;
            }
        }
        this.state.getNodes().remove(rowNum);
        Node[] newNodes = this.generateNewTable(this.state.getNodes(), this.state.getDisplayedCols(), this.state.getDisplayedRows() - 1, this.tableNode);
        if (newNodes != null) {
            nodesToTranslate.addAll(Arrays.asList(newNodes));
            this.callback.accept(nodesToTranslate.toArray(new Node[0]));
        }
        this.shell.close();
    }

    private void deleteTexts(Composite parent, List<CellText> textBoxes) {
        textBoxes.forEach(CellText::dispose);
        textBoxes.clear();
        for (Control control : parent.getChildren()) {
            if (control instanceof Composite) {
                this.deleteTexts((Composite)control, textBoxes);
            }
            control.dispose();
        }
    }

    private void updateState(List<CellText> textBoxes) {
        this.state.setType(this.getTableType(this.tableTypeCombo.getItem(this.tableTypeCombo.getSelectionIndex())));
        List<CellText> tnTexts = textBoxes.stream().filter(CellText::isTN).collect(Collectors.toList());
        this.state.setTNContainer(this.createTNContainer(tnTexts));
        for (CellText text : textBoxes) {
            if (text.isTN()) continue;
            if (text.isCaption()) {
                this.state.getCaptions().clear();
                if (text.getWidget().getText().isEmpty()) continue;
                this.state.getCaptions().add(text.text.getXML(BBX.BLOCK.STYLE.create(ACCESSIBLE_CAPTION_NAME)));
                continue;
            }
            int row = text.row;
            int col = text.col;
            this.state.getNodes().get(row).remove(col);
            this.state.getNodes().get(row).add(col, (Node)text.text.getXML(BBX.BLOCK.TABLE_CELL.create()));
        }
    }

    private void removeTNContainerFromState(Composite parent, List<CellText> textBoxes, Button formatSpecificButton) {
        this.updateState(textBoxes);
        List<CellText> tnTexts = textBoxes.stream().filter(CellText::isTN).toList();
        if (tnTexts.size() > 1) {
            ArrayList<Element> firstRow = new ArrayList<Element>();
            for (int i = 1; i < tnTexts.size(); ++i) {
                firstRow.add(tnTexts.get((int)i).text.getXML(BBX.BLOCK.STYLE.create("1-3")));
            }
            this.state.getNodes().addFirst(firstRow);
            this.state.setDisplayedRows(this.state.getDisplayedRows() + 1);
            this.updateRowColTexts();
        }
        this.state.setTNContainer(null);
        this.deleteTexts(parent, textBoxes);
        this.recreateTexts(parent, textBoxes, formatSpecificButton);
        this.checkFormatSpecificOption(parent, formatSpecificButton, textBoxes);
    }

    private void updateRowColTexts() {
        EasyListeners.pauseListener((Widget)this.rowText, (int)24, w -> ((Text)w).setText(String.valueOf(this.state.getDisplayedRows())));
        EasyListeners.pauseListener((Widget)this.colText, (int)24, w -> ((Text)w).setText(String.valueOf(this.state.getDisplayedCols())));
    }

    private Element createTNContainer(List<CellText> tnTexts) {
        if (tnTexts.isEmpty()) {
            return null;
        }
        if (this.state.getType().equals((Object)TableType.UNSET)) {
            throw new IllegalStateException("state type");
        }
        Element firstBlock = tnTexts.getFirst().text.getXML(BBX.BLOCK.STYLE.create("7-5"));
        ArrayList<CellText> tnTextsCopy = new ArrayList<CellText>(tnTexts);
        tnTextsCopy.removeFirst();
        return this.createTNContainer(firstBlock, tnTextsCopy);
    }

    private Element createTNContainer(Element note, List<CellText> firstRow) {
        Element container = BBX.CONTAINER.TABLETN.create();
        container.appendChild((Node)BBXUtils.wrapAsTransNote(note));
        switch (this.state.getType()) {
            case STAIRSTEP: {
                for (int i = 0; i < firstRow.size(); ++i) {
                    int margin = i * 2 + 1;
                    if (margin > 10) {
                        Notify.showMessage("Cannot add transcriber notes to a stairstep table of this size.", new Object[0]);
                        this.closeShell();
                        return null;
                    }
                    Element block = firstRow.get((int)i).text.getXML(BBX.BLOCK.STYLE.create(margin + "-" + margin));
                    container.appendChild((Node)block);
                }
                break;
            }
            case LINEAR: {
                Element secondBlock = BBX.BLOCK.STYLE.create("1-3");
                for (int i = 0; i < firstRow.size(); ++i) {
                    Element span = firstRow.get((int)i).text.getXML(BBX.SPAN.OTHER.create());
                    secondBlock.appendChild((Node)span);
                    if (i == 0) {
                        secondBlock.appendChild(": ");
                        continue;
                    }
                    if (i == firstRow.size() - 1) {
                        secondBlock.appendChild(".");
                        continue;
                    }
                    secondBlock.appendChild("; ");
                }
                container.appendChild((Node)secondBlock);
                break;
            }
            case LISTED: {
                break;
            }
            default: {
                return null;
            }
        }
        return container;
    }

    private Node[] generateNewTable(List<List<Node>> nodes, int cols, int rows, Element existingTable) {
        String tableType;
        this.trimTable(nodes);
        if (nodes.isEmpty()) {
            return null;
        }
        Element newTable = BBX.CONTAINER.TABLE.create();
        int rowNum = 0;
        for (List<Node> row : nodes) {
            Element newRow = BBX.CONTAINER.TABLE_ROW.create(BBX.TableRowType.NORMAL);
            int colNum = 0;
            for (Node col : row) {
                newRow.appendChild(col);
                if (++colNum < cols) continue;
                break;
            }
            newTable.appendChild((Node)newRow);
            if (++rowNum < rows) continue;
            break;
        }
        if (!this.state.getCaptions().isEmpty() && !this.state.getCaptions().getFirst().getValue().isEmpty()) {
            Element captionContainer = BBX.CONTAINER.CAPTION.create();
            captionContainer.insertChild((Node)this.state.getCaptions().getFirst(), 0);
            newTable.insertChild((Node)captionContainer, 0);
        }
        if (!(tableType = this.tableTypeCombo.getItem(this.tableTypeCombo.getSelectionIndex()).toLowerCase()).equals(TableType.AUTO.displayName.toLowerCase())) {
            newTable.addAttribute(new Attribute("format", tableType));
        }
        Element parent = (Element)existingTable.getParent();
        parent.replaceChild((Node)existingTable, (Node)newTable);
        if (!this.options.isEmpty() && this.tableTypes[this.tableTypeCombo.getSelectionIndex()] == TableType.SIMPLE) {
            this.options.forEach(o -> {
                if (o == TableUtils.SimpleTableOptions.CUSTOM_WIDTHS) {
                    if (this.widths != null) {
                        TableUtils.applyCustomSimpleTableWidths((Element)newTable, (int[])this.widths);
                    } else {
                        int[] existingWidths = TableUtils.getCustomSimpleTableWidths((Element)existingTable);
                        if (existingWidths != null) {
                            TableUtils.applyCustomSimpleTableWidths((Element)newTable, (int[])existingWidths);
                        }
                    }
                } else {
                    TableUtils.applySimpleTableOption((Element)newTable, (TableUtils.SimpleTableOptions)o);
                }
            });
        }
        if (this.state.getTNContainer() != null) {
            Element tnContainer = this.state.getTNContainer().copy();
            Element transcribersNote = this.getTranscribersNote(newTable);
            if (transcribersNote != null) {
                transcribersNote.detach();
            }
            parent.insertChild((Node)tnContainer, parent.indexOf((Node)newTable));
            tnContainer.addAttribute(new Attribute("format", this.state.getType().toString().toLowerCase()));
            return new Node[]{tnContainer, newTable};
        }
        int index = parent.indexOf((Node)newTable);
        if (index > 0 && BBX.CONTAINER.TABLETN.isA(parent.getChild(index - 1))) {
            parent.removeChild(index - 1);
        }
        return new Node[]{newTable};
    }

    private void trimTable(List<List<Node>> nodes) {
        List<Node> finalRow = nodes.getLast();
        boolean emptyRow = true;
        for (Node node : finalRow) {
            Node nodeCopy = node.copy();
            UTDHelper.stripUTDRecursive((Element)((Element)nodeCopy));
            if (nodeCopy.getValue().isEmpty()) continue;
            emptyRow = false;
            break;
        }
        if (emptyRow) {
            nodes.removeLast();
            if (nodes.isEmpty()) {
                return;
            }
            this.trimTable(nodes);
            return;
        }
        boolean emptyCol = true;
        for (List<Node> row : nodes) {
            Node finalNode = row.getLast().copy();
            UTDHelper.stripUTDRecursive((Element)((Element)finalNode));
            if (finalNode.getValue().isEmpty()) continue;
            emptyCol = false;
            break;
        }
        if (emptyCol) {
            for (List<Node> row : nodes) {
                row.removeLast();
            }
            if (!nodes.isEmpty()) {
                this.trimTable(nodes);
            }
        }
    }

    private Node[] generateNewFacingTable(List<CellText> leftBoxes, List<CellText> rightBoxes) {
        this.updateState(leftBoxes);
        this.updateState(rightBoxes);
        InternalFacingTable ftState = (InternalFacingTable)this.state;
        if (this.isFacingTable(this.tableNode)) {
            Element[] tables = this.getFacingTableParents(this.tableNode);
            this.generateNewTable(ftState.getLeftNodes(), ftState.split, ftState.getRows(), tables[0]);
            this.generateNewTable(ftState.getRightNodes(), ftState.getCols() - ftState.split, ftState.getRows(), tables[1]);
            return new Node[]{this.tableNode};
        }
        this.deleteExistingTable(this.tableNode);
        Element newParent = new Element("span");
        newParent.addAttribute(new Attribute("class", "facingTable"));
        newParent.appendChild((Node)new Element("table"));
        newParent.appendChild((Node)new Element("table"));
        this.tableNode.getParent().replaceChild((Node)this.tableNode, (Node)newParent);
        this.tableNode = newParent;
        this.generateNewTable(ftState.getLeftNodes(), ftState.split, ftState.getRows(), (Element)newParent.getChild(0));
        this.generateNewTable(ftState.getRightNodes(), ftState.getCols() - ftState.split, ftState.getRows(), (Element)newParent.getChild(1));
        return new Node[]{newParent};
    }

    private void deleteExistingTable(Element table) {
        Node neighbor;
        Element parent = (Element)table.getParent();
        int index = parent.indexOf((Node)table);
        if (index + 1 < parent.getChildCount() - 1 && (neighbor = parent.getChild(index + 1)) instanceof Element && BBX.CONTAINER.TABLE.isA(neighbor) && ((Element)neighbor).getAttribute("class") != null && ((Element)neighbor).getAttributeValue("class").contains("utd:table")) {
            neighbor.detach();
        }
    }

    private void destroyTable(Style replacementStyle, List<CellText> textBoxes, List<CellText> rightBoxes) {
        ArrayList<Style> newList = new ArrayList<Style>();
        newList.add(replacementStyle);
        this.destroyTable(newList, textBoxes);
    }

    private void destroyTable(List<Style> replacementStyle, List<CellText> textBoxes) {
        Element adjElem;
        Node node;
        Element parent = (Element)this.tableNode.getParent();
        int index = parent.indexOf((Node)this.tableNode);
        String namespace = parent.getNamespaceURI();
        if (index + 1 < parent.getChildCount() && (node = parent.getChild(index + 1)) instanceof Element && (adjElem = (Element)node).getAttribute("class") != null && adjElem.getAttributeValue("class").contains("utd:table")) {
            parent.removeChild(index + 1);
        }
        parent.removeChild(index);
        int iterator = 0;
        CellText captionText = null;
        if (!textBoxes.isEmpty() && textBoxes.getFirst().isCaption()) {
            captionText = textBoxes.removeFirst();
        }
        LinkedHashMap<Element, Style> newElements = new LinkedHashMap<Element, Style>();
        for (CellText cellText : textBoxes) {
            Element newSpan;
            try {
                newSpan = cellText.text.getXML(BBX.BLOCK.STYLE.create("DEFAULT"));
            }
            catch (Exception e) {
                Notify.showMessage("Exception encountered when pulling from text box: {}. Styles removed from text.\nException: {}", cellText.getWidget().getText(), e);
                newSpan = new Element("span", namespace);
                newSpan.appendChild(cellText.getWidget().getText());
            }
            parent.insertChild((Node)newSpan, index + iterator);
            Style newStyle = replacementStyle.get(iterator >= replacementStyle.size() ? replacementStyle.size() - 1 : iterator);
            newElements.put(newSpan, newStyle);
            ++iterator;
        }
        if (captionText != null) {
            Element caption = captionText.text.getXML(BBX.BLOCK.STYLE.create(ACCESSIBLE_CAPTION_NAME));
            parent.insertChild((Node)caption, index);
        }
        for (Map.Entry entry : newElements.entrySet()) {
            Element elem = (Element)entry.getKey();
            Style style = (Style)entry.getValue();
            this.m.applyStyle(style, elem);
        }
        Shell loadingBox = new Shell(this.shell, 0);
        loadingBox.setText("Loading");
        loadingBox.setLayout((Layout)new RowLayout(512));
        Label label = new Label((Composite)loadingBox, 0);
        label.setText("Please wait, reloading document");
        loadingBox.setLocation(this.shell.getLocation().x + this.shell.getSize().x / 2, this.shell.getLocation().y + this.shell.getSize().y / 2);
        loadingBox.pack();
        loadingBox.open();
        this.callback.accept(new Node[]{parent});
        loadingBox.close();
    }

    /*
     * Exception decompiling
     */
    private boolean advancedDestroy(List<CellText> textBoxes, List<CellText> rightBoxes) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void deleteTable() {
        Element transcribersNote = this.getTranscribersNote(this.tableNode);
        if (transcribersNote != null) {
            transcribersNote.detach();
        }
        ParentNode tableParent = this.tableNode.getParent();
        int index = tableParent.indexOf((Node)this.tableNode);
        if (tableParent.getChildCount() > index + 1 && BBX.CONTAINER.TABLE.isA(tableParent.getChild(index + 1)) && TableUtils.isTableCopy((Element)((Element)tableParent.getChild(index + 1)))) {
            tableParent.removeChild(index + 1);
        }
        tableParent.removeChild(index);
        this.callback.accept(new Node[]{tableParent});
        this.closeShell();
    }

    private void swapNodes() {
        if (this.state.getNodes().isEmpty()) {
            return;
        }
        ArrayList<List<Node>> newList = new ArrayList<List<Node>>();
        for (int i = 0; i < this.state.getNodes().getFirst().size(); ++i) {
            newList.add(new ArrayList());
        }
        for (int col = 0; col < this.state.getNodes().getFirst().size(); ++col) {
            for (int row = 0; row < this.state.getNodes().size(); ++row) {
                ((List)newList.get(col)).add(this.state.getNodes().get(row).get(col));
            }
        }
        this.state = this.state instanceof InternalTable ? new InternalTable(newList, this.state.getCaptions(), this.state.getTNContainer(), this.state.getType()) : new InternalFacingTable(newList, ((List)newList.getFirst()).size() / 2, new ArrayList(), this.state.getType());
    }

    /*
     * Exception decompiling
     */
    private void selectStyle(Consumer<Style> onFinished) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<List<Node>> getTableCells(Element tableNode) {
        return this._getTableCells(tableNode, new ArrayList<List<Node>>());
    }

    private List<List<Node>> _getTableCells(Element tableNode, List<List<Node>> rows) {
        for (int i = 0; i < tableNode.getChildElements().size(); ++i) {
            Element child = tableNode.getChildElements().get(i);
            if (BBX.BLOCK.TABLE_CELL.isA((Node)child)) {
                rows.getLast().add((Node)child);
            } else if (BBX.CONTAINER.TABLE_ROW.isA((Node)child)) {
                rows.add(new ArrayList());
            }
            this._getTableCells(child, rows);
        }
        return rows;
    }

    private Element getTranscribersNote(Element tableNode) {
        Node sibling;
        ParentNode parent = tableNode.getParent();
        int index = parent.indexOf((Node)tableNode);
        if (index > 0 && BBX.CONTAINER.TABLETN.isA(sibling = parent.getChild(index - 1)) && this.checkTNElement((Element)sibling)) {
            return (Element)sibling;
        }
        return null;
    }

    private Element copyTNContainer(Element tnContainer) {
        if (tnContainer == null) {
            return null;
        }
        return this.copyTNContainer(tnContainer, this.getTableType(tnContainer.getAttributeValue("format")));
    }

    private Element copyTNContainer(Element tnContainer, TableType type) {
        if (tnContainer == null) {
            return null;
        }
        Element containerCopy = tnContainer.copy();
        UTDHelper.stripUTDRecursive((Element)containerCopy);
        for (Node child : () -> ((Sequence)FastXPath.descendant((Node)containerCopy)).iterator()) {
            if (!BBX.SPAN.OTHER.isA(child) || type != TableType.LINEAR) continue;
            child.detach();
            containerCopy.appendChild(child);
        }
        if (type == TableType.LINEAR && containerCopy.getChildCount() > 1 && BBX.BLOCK.isA(containerCopy.getChild(1))) {
            containerCopy.removeChild(1);
        }
        return containerCopy;
    }

    @NotNull
    private TableType getTableType(Element tableNode) {
        String attrValue = tableNode.getAttributeValue("format");
        return this.getTableType(attrValue);
    }

    @NotNull
    private TableType getTableType(String tableType) {
        if (tableType == null) {
            return TableType.UNSET;
        }
        return switch (tableType = tableType.toLowerCase()) {
            case "simple" -> TableType.SIMPLE;
            case "listed" -> TableType.LISTED;
            case "linear" -> TableType.LINEAR;
            case "stairstep" -> TableType.STAIRSTEP;
            default -> TableType.UNSET;
        };
    }

    private boolean checkTNElement(Element tnElement) {
        if (tnElement.getChildCount() == 0) {
            return false;
        }
        for (int i = 0; i < tnElement.getChildCount(); ++i) {
            if (BBX.BLOCK.isA(tnElement.getChild(i))) continue;
            return false;
        }
        return true;
    }

    private BBStyleableText getCurrentText(List<CellText> texts, List<CellText> rightTexts) {
        for (CellText text : texts) {
            if (!text.getWidget().isFocusControl()) continue;
            return text.text;
        }
        if (rightTexts != null) {
            for (CellText text : rightTexts) {
                if (!text.getWidget().isFocusControl()) continue;
                return text.text;
            }
        }
        return null;
    }

    private boolean isFacingTable(Element parent) {
        return "facingTable".equals(parent.getAttributeValue("class"));
    }

    private Element[] getFacingTableParents(Element parent) {
        Nodes query = parent.query("descendant::*[local-name()='table']");
        for (int i = query.size() - 1; i >= 0; --i) {
            if (!"utd:tableSimple".equals(((Element)query.get(i)).getAttributeValue("class"))) continue;
            query.remove(i);
        }
        if (query.size() == 2) {
            return new Element[]{(Element)query.get(0), (Element)query.get(1)};
        }
        throw new IllegalArgumentException("Table is not facing");
    }

    private List<TableUtils.SimpleTableOptions> findOptions(Element table) {
        ArrayList<TableUtils.SimpleTableOptions> options = new ArrayList<TableUtils.SimpleTableOptions>();
        if ("simple".equals(table.getAttributeValue("format"))) {
            if (TableUtils.hasSimpleTableOption((TableUtils.SimpleTableOptions)TableUtils.SimpleTableOptions.ONE_CELL_BETWEEN_COLUMNS, (Element)table)) {
                options.add(TableUtils.SimpleTableOptions.ONE_CELL_BETWEEN_COLUMNS);
            }
            if (TableUtils.hasSimpleTableOption((TableUtils.SimpleTableOptions)TableUtils.SimpleTableOptions.ROW_HEADING_DISABLED, (Element)table)) {
                options.add(TableUtils.SimpleTableOptions.ROW_HEADING_DISABLED);
            }
            if (TableUtils.hasSimpleTableOption((TableUtils.SimpleTableOptions)TableUtils.SimpleTableOptions.COLUMN_HEADING_DISABLED, (Element)table)) {
                options.add(TableUtils.SimpleTableOptions.COLUMN_HEADING_DISABLED);
            }
            if (TableUtils.hasSimpleTableOption((TableUtils.SimpleTableOptions)TableUtils.SimpleTableOptions.GUIDE_DOTS_DISABLED, (Element)table)) {
                options.add(TableUtils.SimpleTableOptions.GUIDE_DOTS_DISABLED);
            }
            if (TableUtils.hasSimpleTableOption((TableUtils.SimpleTableOptions)TableUtils.SimpleTableOptions.CUSTOM_WIDTHS, (Element)table)) {
                options.add(TableUtils.SimpleTableOptions.CUSTOM_WIDTHS);
            }
        }
        return options;
    }

    private KeyAdapter debugListener() {
        return new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if ((e.stateMask & SWT.MOD1) != 0 && (e.stateMask & SWT.MOD2) != 0 && e.keyCode == 96) {
                    debug = true;
                    TableEditor.this.rebuildView();
                }
            }
        };
    }

    private static /* synthetic */ void lambda$selectStyle$2(Consumer onFinished, List styles, Integer i) {
        if (i != -1) {
            onFinished.accept((Style)styles.get(i));
        }
    }

    private static /* synthetic */ void lambda$advancedDestroy$2(List newStyles, List styles, Integer i) {
        if (i != -1) {
            newStyles.add((Style)styles.get(i));
        } else {
            newStyles.add(null);
        }
    }

    private class SimpleTableOptionDialog {
        private List<Text> widthTexts;

        private SimpleTableOptionDialog() {
        }

        public void open(Shell parent, Element table, int columns, List<TableUtils.SimpleTableOptions> options, UTDManager m) {
            int pageWidth = m.getEngine().getBrailleSettings().getCellType().getCellsForWidth(BigDecimal.valueOf(m.getEngine().getPageSettings().getDrawableWidth()));
            Shell dialog = new Shell(parent, 67680);
            dialog.setText("Simple Table Options");
            dialog.setLayout((Layout)new GridLayout(1, false));
            Composite container = EasySWT.makeComposite((Composite)dialog, (int)2);
            EasySWT.makeLabel((Composite)container, (String)"Cells between columns:", (int)1);
            Combo cellsBwColCombo = new Combo(container, 8);
            cellsBwColCombo.setItems(new String[]{"1", "2"});
            cellsBwColCombo.select(options.contains(TableUtils.SimpleTableOptions.ONE_CELL_BETWEEN_COLUMNS) || TableUtils.hasSimpleTableOption((TableUtils.SimpleTableOptions)TableUtils.SimpleTableOptions.ONE_CELL_BETWEEN_COLUMNS, (Element)table) ? 0 : 1);
            EasySWT.makeLabel((Composite)container, (String)"Guide dots:", (int)1);
            Combo guideDotsCombo = new Combo(container, 8);
            guideDotsCombo.setItems(new String[]{"Enabled", "Disabled"});
            guideDotsCombo.select(options.contains(TableUtils.SimpleTableOptions.GUIDE_DOTS_DISABLED) || TableUtils.hasSimpleTableOption((TableUtils.SimpleTableOptions)TableUtils.SimpleTableOptions.GUIDE_DOTS_DISABLED, (Element)table) ? 1 : 0);
            EasySWT.makeLabel((Composite)container, (String)"Row headings:", (int)1);
            Combo rowHeadCombo = new Combo(container, 8);
            rowHeadCombo.setItems(new String[]{"Enabled", "Disabled"});
            rowHeadCombo.select(options.contains(TableUtils.SimpleTableOptions.ROW_HEADING_DISABLED) || TableUtils.hasSimpleTableOption((TableUtils.SimpleTableOptions)TableUtils.SimpleTableOptions.ROW_HEADING_DISABLED, (Element)table) ? 1 : 0);
            EasySWT.makeLabel((Composite)container, (String)"Column headings:", (int)1);
            Combo colHeadCombo = new Combo(container, 8);
            colHeadCombo.setItems(new String[]{"Enabled", "Disabled"});
            colHeadCombo.select(options.contains(TableUtils.SimpleTableOptions.COLUMN_HEADING_DISABLED) || TableUtils.hasSimpleTableOption((TableUtils.SimpleTableOptions)TableUtils.SimpleTableOptions.COLUMN_HEADING_DISABLED, (Element)table) ? 1 : 0);
            EasySWT.makeLabel((Composite)container, (String)"Column widths:", (int)1);
            Combo colWidthCombo = new Combo(container, 8);
            colWidthCombo.setItems(new String[]{"Default", "Custom"});
            colWidthCombo.select(options.contains(TableUtils.SimpleTableOptions.CUSTOM_WIDTHS) || TableUtils.hasSimpleTableOption((TableUtils.SimpleTableOptions)TableUtils.SimpleTableOptions.CUSTOM_WIDTHS, (Element)table) ? 1 : 0);
            Composite widthPanel = EasySWT.makeComposite((Composite)dialog, (int)1);
            if (colWidthCombo.getSelectionIndex() == 1) {
                this.makeColWidthPanel(dialog, widthPanel, table, columns, pageWidth, cellsBwColCombo.getSelectionIndex() == 1);
            }
            EasyListeners.selection((Combo)colWidthCombo, e -> {
                if (colWidthCombo.getSelectionIndex() == 1) {
                    if (widthPanel.getChildren().length == 0) {
                        this.makeColWidthPanel(dialog, widthPanel, table, columns, pageWidth, cellsBwColCombo.getSelectionIndex() == 1);
                    }
                } else {
                    this.destroyColWidthPanel(dialog, widthPanel);
                }
            });
            EasyListeners.selection((Combo)cellsBwColCombo, e -> {
                if (widthPanel.getChildren().length > 0) {
                    this.destroyColWidthPanel(dialog, widthPanel);
                    this.makeColWidthPanel(dialog, widthPanel, table, columns, pageWidth, cellsBwColCombo.getSelectionIndex() == 1);
                }
            });
            Composite buttonPanel = EasySWT.makeComposite((Composite)dialog, (int)2);
            EasySWT.makePushButton((Composite)buttonPanel, (String)TableEditor.OK_BUTTON, (int)1, e -> {
                if (this.widthTexts != null) {
                    int totalWidth = 0;
                    for (Text text : this.widthTexts) {
                        if (text.getText().isEmpty()) {
                            EasySWT.makeEasyOkDialog((String)TableEditor.ERROR_DIALOG_TITLE, (String)"Width cannot be blank", (Shell)dialog);
                            return;
                        }
                        int number = Integer.parseInt(text.getText());
                        if (number < 2) {
                            EasySWT.makeEasyOkDialog((String)TableEditor.ERROR_DIALOG_TITLE, (String)"Each column must be at least two cells width", (Shell)dialog);
                            return;
                        }
                        if (number > pageWidth) {
                            EasySWT.makeEasyOkDialog((String)TableEditor.ERROR_DIALOG_TITLE, (String)"A column cannot be wider than the page", (Shell)dialog);
                            return;
                        }
                        totalWidth += number;
                    }
                    if (totalWidth > pageWidth) {
                        EasySWT.makeEasyOkDialog((String)TableEditor.ERROR_DIALOG_TITLE, (String)"The total width of the columns cannot be wider than the page", (Shell)dialog);
                        return;
                    }
                    TableEditor.this.widths = new int[this.widthTexts.size()];
                    for (int i = 0; i < this.widthTexts.size(); ++i) {
                        TableEditor.this.widths[i] = Integer.parseInt(this.widthTexts.get(i).getText());
                    }
                } else {
                    TableEditor.this.widths = null;
                }
                if (cellsBwColCombo.getSelectionIndex() == 0) {
                    if (!options.contains(TableUtils.SimpleTableOptions.ONE_CELL_BETWEEN_COLUMNS)) {
                        options.add(TableUtils.SimpleTableOptions.ONE_CELL_BETWEEN_COLUMNS);
                    }
                } else {
                    options.remove(TableUtils.SimpleTableOptions.ONE_CELL_BETWEEN_COLUMNS);
                }
                if (guideDotsCombo.getSelectionIndex() == 1) {
                    if (!options.contains(TableUtils.SimpleTableOptions.GUIDE_DOTS_DISABLED)) {
                        options.add(TableUtils.SimpleTableOptions.GUIDE_DOTS_DISABLED);
                    }
                } else {
                    options.remove(TableUtils.SimpleTableOptions.GUIDE_DOTS_DISABLED);
                }
                if (rowHeadCombo.getSelectionIndex() == 1) {
                    if (!options.contains(TableUtils.SimpleTableOptions.ROW_HEADING_DISABLED)) {
                        options.add(TableUtils.SimpleTableOptions.ROW_HEADING_DISABLED);
                    }
                } else {
                    options.remove(TableUtils.SimpleTableOptions.ROW_HEADING_DISABLED);
                }
                if (colHeadCombo.getSelectionIndex() == 1) {
                    if (!options.contains(TableUtils.SimpleTableOptions.COLUMN_HEADING_DISABLED)) {
                        options.add(TableUtils.SimpleTableOptions.COLUMN_HEADING_DISABLED);
                    }
                } else {
                    options.remove(TableUtils.SimpleTableOptions.COLUMN_HEADING_DISABLED);
                }
                if (colWidthCombo.getSelectionIndex() == 1) {
                    if (!options.contains(TableUtils.SimpleTableOptions.CUSTOM_WIDTHS)) {
                        options.add(TableUtils.SimpleTableOptions.CUSTOM_WIDTHS);
                    }
                } else {
                    options.remove(TableUtils.SimpleTableOptions.CUSTOM_WIDTHS);
                }
                dialog.close();
            });
            EasySWT.makePushButton((Composite)buttonPanel, (String)TableEditor.CANCEL_BUTTON, (int)1, e -> dialog.close());
            dialog.pack();
            dialog.open();
            while (!dialog.isDisposed()) {
                Display.getCurrent().readAndDispatch();
            }
        }

        private void makeColWidthPanel(Shell dialog, Composite panel, Element table, int columns, int pageWidth, boolean twoCellsBwCols) {
            int i;
            int[] colWidths;
            int truePageWidth = pageWidth - (columns - 1) * (twoCellsBwCols ? 2 : 1);
            int defaultWidth = truePageWidth / columns;
            int remainder = truePageWidth % columns;
            if (TableEditor.this.widths != null) {
                colWidths = TableEditor.this.widths;
            } else if (TableUtils.hasSimpleTableOption((TableUtils.SimpleTableOptions)TableUtils.SimpleTableOptions.CUSTOM_WIDTHS, (Element)table)) {
                colWidths = Objects.requireNonNull(TableUtils.getCustomSimpleTableWidths((Element)table));
            } else {
                colWidths = new int[columns];
                for (int i2 = 0; i2 < colWidths.length; ++i2) {
                    colWidths[i2] = defaultWidth + (remainder > 0 ? 1 : 0);
                    if (remainder <= 0) continue;
                    --remainder;
                }
            }
            this.widthTexts = new ArrayList<Text>();
            Label columnLabel = EasySWT.makeLabel((Composite)panel, (String)"Column Widths:", (int)1);
            EasySWT.buildGridData().setAlign(Integer.valueOf(0x1000000), Integer.valueOf(0x1000000)).applyTo((Control)columnLabel);
            Composite textContainer = EasySWT.makeComposite((Composite)panel, (int)(columns * 2 - 1));
            for (i = 0; i < columns; ++i) {
                Label label = EasySWT.makeLabel((Composite)textContainer, (String)String.valueOf(i + 1), (int)1);
                EasySWT.buildGridData().setAlign(Integer.valueOf(0x1000000), Integer.valueOf(0x1000000)).applyTo((Control)label);
                if (i == columns - 1) continue;
                EasySWT.makeLabel((Composite)textContainer, (String)"", (int)1);
            }
            for (i = 0; i < columns; ++i) {
                Text text = EasySWT.makeText((Composite)textContainer, (int)1);
                EasySWT.buildGridData().setHint(Integer.valueOf(EasySWT.getWidthOfText((String)"999")), Integer.valueOf(-1)).applyTo((Control)text);
                EasyListeners.verifyNumbersOnly((Text)text);
                text.setText(String.valueOf(colWidths[i]));
                text.setTextLimit(3);
                this.widthTexts.add(text);
                if (i == columns - 1) continue;
                EasySWT.buildGridData().setAlign(Integer.valueOf(0x1000000), Integer.valueOf(0x1000000)).applyTo((Control)EasySWT.makeLabel((Composite)textContainer, (String)(twoCellsBwCols ? "(2)" : "(1)"), (int)1));
            }
            int totalWidth = (columns - 1) * (twoCellsBwCols ? 2 : 1);
            for (int width : colWidths) {
                totalWidth += width;
            }
            Label label = EasySWT.makeLabel((Composite)textContainer, (String)("Total Width: " + totalWidth), (int)1);
            this.widthTexts.forEach(wt -> wt.addModifyListener(this.colTextModify(pageWidthLabel, pageWidth, truePageWidth)));
            EasySWT.buildGridData().setAlign(Integer.valueOf(0x1000000), Integer.valueOf(0x1000000)).setColumns(columns * 2 - 1).applyTo((Control)label);
            panel.layout(true);
            dialog.pack();
        }

        private void destroyColWidthPanel(Shell dialog, Composite panel) {
            Control[] children;
            this.widthTexts = null;
            for (Control child : children = panel.getChildren()) {
                child.dispose();
            }
            panel.layout(true);
            dialog.pack();
        }

        private ModifyListener colTextModify(Label pageWidthLabel, int pageWidth, int truePageWidth) {
            return e -> {
                Text text = (Text)e.widget;
                if (text.getText().isEmpty()) {
                    return;
                }
                if (Integer.parseInt(text.getText()) < 2 || Integer.parseInt(text.getText()) > pageWidth) {
                    text.setForeground(Display.getCurrent().getSystemColor(3));
                } else {
                    text.setForeground(Display.getCurrent().getSystemColor(2));
                }
                int totalWidth = 0;
                for (Text colText : this.widthTexts) {
                    if (colText.getText().isEmpty()) {
                        return;
                    }
                    totalWidth += Integer.parseInt(colText.getText());
                }
                pageWidthLabel.setText("Total Width: " + (totalWidth += pageWidth - truePageWidth));
                if (totalWidth > pageWidth) {
                    pageWidthLabel.setForeground(Display.getCurrent().getSystemColor(3));
                } else {
                    pageWidthLabel.setForeground(Display.getCurrent().getSystemColor(2));
                }
                pageWidthLabel.pack(true);
            };
        }
    }
}

