/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.perspectives.mvc.menu;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.brailleblaster.perspectives.mvc.menu.BBSelectionData;
import org.brailleblaster.perspectives.mvc.menu.BBSeparator;
import org.brailleblaster.perspectives.mvc.menu.BBSubMenu;
import org.brailleblaster.perspectives.mvc.menu.EmphasisItem;
import org.brailleblaster.perspectives.mvc.menu.EnableListener;
import org.brailleblaster.perspectives.mvc.menu.IBBMenu;
import org.brailleblaster.perspectives.mvc.menu.IBBMenuItem;
import org.brailleblaster.perspectives.mvc.menu.IBBSubMenu;
import org.brailleblaster.perspectives.mvc.menu.SharedItem;
import org.brailleblaster.perspectives.mvc.menu.SubMenuBuilder;
import org.brailleblaster.perspectives.mvc.menu.TopMenu;
import org.brailleblaster.settings.ui.BrailleSettingsDialog;
import org.brailleblaster.settings.ui.PagePropertiesTab;
import org.brailleblaster.tools.EmphasisMenuTool;
import org.brailleblaster.userHelp.AboutTool;
import org.brailleblaster.util.ui.MenuUtils;
import org.brailleblaster.wordprocessor.WPManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010#\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020%J$\u0010&\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020%2\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020\u001e0)H\u0002J\u000e\u0010+\u001a\u00020\u001c2\u0006\u0010,\u001a\u00020\u0017J\u0010\u0010-\u001a\u00020\u001c2\u0006\u0010,\u001a\u00020.H\u0002J\u0010\u0010/\u001a\u00020\u001c2\u0006\u0010,\u001a\u00020\nH\u0002J\u0016\u00100\u001a\u00020\u001c2\u0006\u00101\u001a\u00020\u001e2\u0006\u00102\u001a\u000203J\u0016\u00104\u001a\u00020\u001c2\u0006\u00105\u001a\u00020\t2\u0006\u00102\u001a\u000203J\u001c\u00106\u001a\u0004\u0018\u00010%2\u0006\u00101\u001a\u00020\u001e2\b\u00107\u001a\u0004\u0018\u000108H\u0007J\"\u0010>\u001a\u00020%2\u0006\u00105\u001a\u00020\t2\b\u0010?\u001a\u0004\u0018\u00010@2\u0006\u0010A\u001a\u00020BH\u0007J\u001c\u0010C\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001a2\u0006\u00105\u001a\u00020\tH\u0007J\u001c\u0010D\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001a2\u0006\u00105\u001a\u00020\tH\u0002J\u0016\u0010E\u001a\b\u0012\u0004\u0012\u00020\u001b0F2\u0006\u00105\u001a\u00020\u0019H\u0007J\u001c\u0010G\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001a2\u0006\u00105\u001a\u00020\u0019H\u0002J\u0016\u0010H\u001a\u00020\u001c2\u0006\u0010I\u001a\u00020 2\u0006\u0010J\u001a\u00020BJ\u0018\u0010K\u001a\u00020\u001c2\u0006\u0010I\u001a\u00020 2\u0006\u00105\u001a\u00020\u0013H\u0007J\u0012\u0010L\u001a\u00020\u001c2\b\u0010$\u001a\u0004\u0018\u00010%H\u0007J\u0010\u0010M\u001a\u00020\u001e2\u0006\u0010N\u001a\u00020*H\u0007J\u001a\u0010M\u001a\u00020\u001c2\n\u0010O\u001a\u00060Pj\u0002`Q2\u0006\u0010N\u001a\u00020*R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000e0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00100\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\fR\u001d\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00130\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\fR\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0018\u001a\u001a\u0012\u0004\u0012\u00020\u0019\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001a0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u000e0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00020 \u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00160\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u00109\u001a\b\u0012\u0004\u0012\u00020\u001e0:8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b;\u0010\u0003\u001a\u0004\b<\u0010=\u00a8\u0006R"}, d2={"Lorg/brailleblaster/perspectives/mvc/menu/MenuManager;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "sharedItems", "Ljava/util/HashMap;", "Lorg/brailleblaster/perspectives/mvc/menu/SharedItem;", "Lorg/brailleblaster/perspectives/mvc/menu/IBBMenuItem;", "getSharedItems", "()Ljava/util/HashMap;", "sharedSubMenus", "Lorg/brailleblaster/perspectives/mvc/menu/BBSubMenu;", "sharedToolBars", "Lorg/eclipse/swt/widgets/ToolItem;", "getSharedToolBars", "sharedMenuItems", "Lorg/eclipse/swt/widgets/MenuItem;", "getSharedMenuItems", "items", "", "Lorg/brailleblaster/perspectives/mvc/menu/IBBMenu;", "emphasisHandlers", "Lorg/brailleblaster/perspectives/mvc/menu/EmphasisItem;", "Lkotlin/Function1;", "Lorg/brailleblaster/perspectives/mvc/menu/BBSelectionData;", "", "styleMenus", "", "enableItems", "Lorg/brailleblaster/perspectives/mvc/menu/EnableListener;", "disposeDisplayListener", "Lorg/eclipse/swt/widgets/Listener;", "buildMenu", "shellMenu", "Lorg/eclipse/swt/widgets/Menu;", "checkMenuAcceleratorsForDuplicates", "rootMenu", "existingAccelerators", "", "", "add", "tool", "addSubMenu", "Lorg/brailleblaster/perspectives/mvc/menu/IBBSubMenu;", "addMenuItem", "addToStyleMenu", "category", "subMenu", "Lorg/brailleblaster/perspectives/mvc/menu/SubMenuBuilder;", "addToSharedSubMenus", "item", "getFromStyleMenu", "parent", "Lorg/eclipse/swt/widgets/Composite;", "styleMenuCategories", "", "getStyleMenuCategories$annotations", "getStyleMenuCategories", "()Ljava/util/Set;", "createSharedSubMenu", "shell", "Lorg/eclipse/swt/widgets/Shell;", "floating", "", "getSharedSelection", "lookupSelection", "getEmphasisSelection", "Ljava/util/function/Consumer;", "lookupEmphasis", "notifyEnableListeners", "listener", "value", "addToListenerMap", "disposeMenu", "menuItemAcceleratorSuffix", "accelerator", "textBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nMenuManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MenuManager.kt\norg/brailleblaster/perspectives/mvc/menu/MenuManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,408:1\n777#2:409\n873#2,2:410\n1915#2,2:412\n*S KotlinDebug\n*F\n+ 1 MenuManager.kt\norg/brailleblaster/perspectives/mvc/menu/MenuManager\n*L\n101#1:409\n101#1:410,2\n101#1:412,2\n*E\n"})
public final class MenuManager {
    @NotNull
    public static final MenuManager INSTANCE = new MenuManager();
    private static final Logger log = LoggerFactory.getLogger(MenuManager.class);
    @NotNull
    private static final HashMap<SharedItem, IBBMenuItem> sharedItems = new LinkedHashMap();
    @NotNull
    private static final HashMap<SharedItem, BBSubMenu> sharedSubMenus = new LinkedHashMap();
    @NotNull
    private static final HashMap<SharedItem, ToolItem> sharedToolBars = new LinkedHashMap();
    @NotNull
    private static final HashMap<SharedItem, MenuItem> sharedMenuItems = new LinkedHashMap();
    @NotNull
    private static final List<IBBMenu> items = new ArrayList();
    @NotNull
    private static final HashMap<EmphasisItem, Function1<BBSelectionData, Unit>> emphasisHandlers = new LinkedHashMap();
    @NotNull
    private static final HashMap<String, BBSubMenu> styleMenus = new LinkedHashMap();
    @NotNull
    private static final HashMap<EnableListener, List<MenuItem>> enableItems = new LinkedHashMap();
    @Nullable
    private static Listener disposeDisplayListener;

    private MenuManager() {
    }

    @NotNull
    public final HashMap<SharedItem, IBBMenuItem> getSharedItems() {
        return sharedItems;
    }

    @NotNull
    public final HashMap<SharedItem, ToolItem> getSharedToolBars() {
        return sharedToolBars;
    }

    @NotNull
    public final HashMap<SharedItem, MenuItem> getSharedMenuItems() {
        return sharedMenuItems;
    }

    /*
     * WARNING - void declaration
     */
    public final void buildMenu(@NotNull Menu shellMenu) {
        Intrinsics.checkNotNullParameter((Object)shellMenu, (String)"shellMenu");
        if (disposeDisplayListener == null) {
            disposeDisplayListener = MenuManager::buildMenu$lambda$0;
            Display.getCurrent().addListener(12, disposeDisplayListener);
        }
        enableItems.clear();
        for (TopMenu menu : TopMenu.getEntries()) {
            void $this$forEach$iv;
            Iterator $this$filterTo$iv$iv;
            MenuItem newMenuItem = new MenuItem(shellMenu, 64);
            newMenuItem.setText(menu.menuName);
            Menu newMenu = new Menu((Decorations)shellMenu.getShell(), 4);
            newMenuItem.setMenu(newMenu);
            Iterable $this$filter$iv = items;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv = iterator.next();
                IBBMenu it = (IBBMenu)element$iv$iv;
                boolean bl = false;
                if (!(it.getTopMenu() == menu)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            $this$filterTo$iv$iv = $this$forEach$iv.iterator();
            while ($this$filterTo$iv$iv.hasNext()) {
                Object element$iv = $this$filterTo$iv$iv.next();
                IBBMenu it = (IBBMenu)element$iv;
                boolean bl = false;
                it.build(newMenu);
            }
        }
        HashMap existingAccelerators = new HashMap();
        this.checkMenuAcceleratorsForDuplicates(shellMenu, existingAccelerators);
        MenuItem[] menuItemArray = shellMenu.getItems();
        Intrinsics.checkNotNullExpressionValue((Object)menuItemArray, (String)"getItems(...)");
        for (MenuItem curItem : menuItemArray) {
            String element$iv;
            String string = curItem.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            int altHotkeyStart = StringsKt.indexOf$default((CharSequence)string, (String)"&", (int)0, (boolean)false, (int)6, null);
            if (altHotkeyStart == -1) continue;
            Intrinsics.checkNotNullExpressionValue((Object)curItem.getText(), (String)"getText(...)");
            int n = altHotkeyStart + 1;
            int n2 = altHotkeyStart + 2;
            String string2 = element$iv.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            char altChar = string2.charAt(0);
            log.debug("checking hotkey alt + " + altChar + " in " + curItem.getText());
            int altHotkey = 0x10000 | altChar;
            if (existingAccelerators.containsKey(altHotkey)) {
                throw new RuntimeException("Menu Item alt hotkey " + curItem.getText() + " conflicts with accelerator " + existingAccelerators.get(altHotkey));
            }
            ((Map)existingAccelerators).put(altHotkey, curItem.getText());
        }
        MenuItem[] menuItemArray2 = shellMenu.getItems();
        Intrinsics.checkNotNullExpressionValue((Object)menuItemArray2, (String)"getItems(...)");
        for (MenuItem item : menuItemArray2) {
            MenuItem[] menuItemArray3 = item.getMenu().getItems();
            Intrinsics.checkNotNullExpressionValue((Object)menuItemArray3, (String)"getItems(...)");
            if (!(((Object[])menuItemArray3).length == 0)) continue;
            item.dispose();
        }
        Display display = shellMenu.getDisplay();
        Intrinsics.checkNotNullExpressionValue((Object)display, (String)"getDisplay(...)");
        MenuUtils.INSTANCE.addSystemMenuItem(display, -1, MenuManager::buildMenu$lambda$3);
        Display display2 = shellMenu.getDisplay();
        Intrinsics.checkNotNullExpressionValue((Object)display2, (String)"getDisplay(...)");
        MenuUtils.INSTANCE.addSystemMenuItem(display2, -2, MenuManager::buildMenu$lambda$4);
    }

    private final void checkMenuAcceleratorsForDuplicates(Menu rootMenu, Map<Integer, String> existingAccelerators) {
        MenuItem[] menuItemArray = rootMenu.getItems();
        Intrinsics.checkNotNullExpressionValue((Object)menuItemArray, (String)"getItems(...)");
        for (MenuItem curItem : menuItemArray) {
            int accelerator = curItem.getAccelerator();
            if (accelerator != 0) {
                if (existingAccelerators.containsKey(accelerator)) {
                    throw new RuntimeException("Menu Item '" + curItem.getText() + "' accelerator conflicts with " + existingAccelerators.get(accelerator));
                }
                existingAccelerators.put(accelerator, curItem.getText());
            }
            if (curItem.getMenu() == null) continue;
            Menu menu = curItem.getMenu();
            Intrinsics.checkNotNullExpressionValue((Object)menu, (String)"getMenu(...)");
            this.checkMenuAcceleratorsForDuplicates(menu, existingAccelerators);
        }
    }

    public final void add(@NotNull IBBMenu tool) {
        Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
        IBBMenu iBBMenu = tool;
        if (iBBMenu instanceof IBBMenuItem) {
            this.addMenuItem((IBBMenuItem)tool);
        } else if (iBBMenu instanceof BBSeparator) {
            items.add(tool);
        } else if (iBBMenu instanceof IBBSubMenu) {
            this.addSubMenu((IBBSubMenu)tool);
        }
    }

    private final void addSubMenu(IBBSubMenu tool) {
        boolean mergedWithExisting = false;
        for (IBBMenu item : items) {
            if (!(item instanceof BBSubMenu) || !Intrinsics.areEqual((Object)((BBSubMenu)item).getText(), (Object)tool.getText())) continue;
            mergedWithExisting = true;
            for (IBBMenu subMenuItem : tool.getSubMenuItems()) {
                ((BBSubMenu)item).addItem(subMenuItem);
            }
        }
        if (!mergedWithExisting) {
            items.add(new BBSubMenu(tool.getTopMenu(), tool.getText(), CollectionsKt.toMutableList((Collection)tool.getSubMenuItems())));
        }
    }

    private final void addMenuItem(IBBMenuItem tool) {
        block1: {
            if (tool instanceof EmphasisMenuTool) {
                EmphasisItem emphasis = ((EmphasisMenuTool)tool).getEmphasis();
                ((Map)emphasisHandlers).put(emphasis, new Function1<BBSelectionData, Unit>((Object)tool){

                    public final void invoke(BBSelectionData p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        ((EmphasisMenuTool)this.receiver).run(p0);
                    }
                });
            }
            items.add(tool);
            SharedItem sharedItem = tool.getSharedItem();
            if (sharedItem == null) break block1;
            SharedItem it = sharedItem;
            boolean bl = false;
            ((Map)sharedItems).put(it, tool);
        }
    }

    public final void addToStyleMenu(@NotNull String category, @NotNull SubMenuBuilder subMenu) {
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        Intrinsics.checkNotNullParameter((Object)subMenu, (String)"subMenu");
        ((Map)styleMenus).put(category, subMenu.build().copy());
    }

    public final void addToSharedSubMenus(@NotNull SharedItem item, @NotNull SubMenuBuilder subMenu) {
        Intrinsics.checkNotNullParameter((Object)((Object)item), (String)"item");
        Intrinsics.checkNotNullParameter((Object)subMenu, (String)"subMenu");
        ((Map)sharedSubMenus).put(item, subMenu.build().copy());
    }

    @JvmStatic
    @Nullable
    public static final Menu getFromStyleMenu(@NotNull String category, @Nullable Composite parent) {
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        if (styleMenus.containsKey(category)) {
            BBSubMenu subMenu = styleMenus.get(category);
            Menu newMenu = new Menu((Control)parent);
            BBSubMenu bBSubMenu = subMenu;
            Intrinsics.checkNotNull((Object)bBSubMenu);
            bBSubMenu.getSubMenuItems().forEach(arg_0 -> MenuManager.getFromStyleMenu$lambda$0(newMenu, arg_0));
            return newMenu;
        }
        return null;
    }

    @NotNull
    public static final Set<String> getStyleMenuCategories() {
        Set<String> set = styleMenus.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
        return set;
    }

    @JvmStatic
    public static /* synthetic */ void getStyleMenuCategories$annotations() {
    }

    @JvmStatic
    @NotNull
    public static final Menu createSharedSubMenu(@NotNull SharedItem item, @Nullable Shell shell, boolean floating) {
        Intrinsics.checkNotNullParameter((Object)((Object)item), (String)"item");
        Menu newMenu = new Menu((Decorations)shell, floating ? 0 : 4);
        BBSubMenu bBSubMenu = sharedSubMenus.get((Object)item);
        if (bBSubMenu == null) {
            throw new UnsupportedOperationException("Operation " + item + " not yet supported");
        }
        BBSubMenu foundSMB = bBSubMenu;
        foundSMB.getSubMenuItems().forEach(arg_0 -> MenuManager.createSharedSubMenu$lambda$0(newMenu, arg_0));
        return newMenu;
    }

    @JvmStatic
    @NotNull
    public static final Function1<BBSelectionData, Unit> getSharedSelection(@NotNull SharedItem item) {
        Intrinsics.checkNotNullParameter((Object)((Object)item), (String)"item");
        return arg_0 -> MenuManager.getSharedSelection$lambda$0(item, arg_0);
    }

    private final Function1<BBSelectionData, Unit> lookupSelection(SharedItem item) {
        if (!sharedItems.containsKey((Object)item)) {
            throw new UnsupportedOperationException("Operation " + item + " not yet supported");
        }
        IBBMenuItem iBBMenuItem = sharedItems.get((Object)item);
        Intrinsics.checkNotNull((Object)iBBMenuItem);
        return iBBMenuItem.getOnActivated();
    }

    @JvmStatic
    @NotNull
    public static final Consumer<BBSelectionData> getEmphasisSelection(@NotNull EmphasisItem item) {
        Intrinsics.checkNotNullParameter((Object)((Object)item), (String)"item");
        return arg_0 -> MenuManager.getEmphasisSelection$lambda$0(item, arg_0);
    }

    private final Function1<BBSelectionData, Unit> lookupEmphasis(EmphasisItem item) {
        if (!emphasisHandlers.containsKey((Object)item)) {
            throw new UnsupportedOperationException("Operation " + item + " not yet supported");
        }
        Function1<BBSelectionData, Unit> function1 = emphasisHandlers.get((Object)item);
        Intrinsics.checkNotNull(function1);
        return function1;
    }

    public final void notifyEnableListeners(@NotNull EnableListener listener, boolean value) {
        Intrinsics.checkNotNullParameter((Object)((Object)listener), (String)"listener");
        if (enableItems.containsKey((Object)listener)) {
            List<MenuItem> list = enableItems.get((Object)listener);
            Intrinsics.checkNotNull(list);
            List<MenuItem> items = list;
            items.forEach(arg_0 -> MenuManager.notifyEnableListeners$lambda$0(value, arg_0));
        }
    }

    @JvmStatic
    public static final void addToListenerMap(@NotNull EnableListener listener, @NotNull MenuItem item) {
        Intrinsics.checkNotNullParameter((Object)((Object)listener), (String)"listener");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        if (enableItems.containsKey((Object)listener)) {
            List<MenuItem> list = enableItems.get((Object)listener);
            Intrinsics.checkNotNull(list);
            List<MenuItem> items = list;
            items.add(item);
        } else {
            List items = new ArrayList();
            items.add(item);
            ((Map)enableItems).put(listener, items);
        }
    }

    @JvmStatic
    public static final void disposeMenu(@Nullable Menu shellMenu) {
        if (shellMenu != null && !shellMenu.isDisposed()) {
            shellMenu.dispose();
            items.clear();
        }
    }

    @JvmStatic
    @NotNull
    public static final String menuItemAcceleratorSuffix(int accelerator) {
        StringBuilder sb = new StringBuilder();
        INSTANCE.menuItemAcceleratorSuffix(sb, accelerator);
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * Unable to fully structure code
     */
    public final void menuItemAcceleratorSuffix(@NotNull StringBuilder textBuilder, int accelerator) {
        block30: {
            Intrinsics.checkNotNullParameter((Object)textBuilder, (String)"textBuilder");
            textBuilder.append("\t");
            if ((accelerator & SWT.MOD1) == 0) break block30;
            if (System.getProperty("os.name") == null) ** GOTO lbl-1000
            v0 = System.getProperty("os.name");
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getProperty(...)");
            var4_3 = v0;
            v1 = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getDefault(...)");
            v2 = var4_3.toLowerCase(v1);
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"toLowerCase(...)");
            if (StringsKt.contains$default((CharSequence)v2, (CharSequence)"mac", (boolean)false, (int)2, null)) {
                v3 = true;
            } else lbl-1000:
            // 2 sources

            {
                v3 = false;
            }
            onMac = v3;
            v4 = onMac != false ? textBuilder.append("\u2318 + ") : textBuilder.append("Ctrl + ");
        }
        if ((accelerator & SWT.MOD2) != 0) {
            textBuilder.append("Shift + ");
        }
        if ((accelerator & SWT.MOD3) != 0) {
            textBuilder.append("Alt + ");
        }
        if ((accelerator & SWT.MOD4) != 0) {
            textBuilder.append("Ctrl + ");
        }
        charName = null;
        value = accelerator - (accelerator & SWT.MOD1) - (accelerator & SWT.MOD2) - (accelerator & SWT.MOD3) - (accelerator & SWT.MOD4);
        switch (value) {
            case 0x100000A: {
                charName = "F1";
                break;
            }
            case 0x100000B: {
                charName = "F2";
                break;
            }
            case 0x100000C: {
                charName = "F3";
                break;
            }
            case 0x100000D: {
                charName = "F4";
                break;
            }
            case 0x100000E: {
                charName = "F5";
                break;
            }
            case 0x100000F: {
                charName = "F6";
                break;
            }
            case 0x1000010: {
                charName = "F7";
                break;
            }
            case 0x1000011: {
                charName = "F8";
                break;
            }
            case 0x1000012: {
                charName = "F9";
                break;
            }
            case 0x1000013: {
                charName = "F10";
                break;
            }
            case 0x1000014: {
                charName = "F11";
                break;
            }
            case 0x1000015: {
                charName = "F12";
                break;
            }
            case 0x1000001: {
                charName = "Up";
                break;
            }
            case 0x1000002: {
                charName = "Down";
                break;
            }
            case 0x1000003: {
                charName = "Left";
                break;
            }
            case 0x1000004: {
                charName = "Right";
                break;
            }
            case 0x1000007: {
                charName = "Home";
                break;
            }
            case 0x1000008: {
                charName = "End";
                break;
            }
            case 0x1000006: {
                charName = "Page Down";
                break;
            }
            case 0x1000005: {
                charName = "Page Up";
                break;
            }
            case 0x1000009: {
                charName = "Insert";
                break;
            }
            case 13: {
                charName = "Enter";
                break;
            }
            case 9: {
                charName = "Tab";
                break;
            }
            default: {
                character = (char)(255 & accelerator);
                charName = "" + character;
                if (!Character.isLowerCase(character)) break;
                textBuilder.append((String)charName);
                throw new RuntimeException("Letter must be uuppercase in " + textBuilder);
            }
        }
        textBuilder.append((String)charName);
    }

    private static final void buildMenu$lambda$0(Event it) {
        disposeDisplayListener = null;
        sharedItems.clear();
        sharedSubMenus.clear();
        items.clear();
        emphasisHandlers.clear();
        styleMenus.clear();
        enableItems.clear();
    }

    private static final void buildMenu$lambda$3(Event e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Widget widget = e.widget;
        Intrinsics.checkNotNullExpressionValue((Object)widget, (String)"widget");
        AboutTool.INSTANCE.run(new BBSelectionData(widget, WPManager.Companion.getInstance()));
    }

    private static final void buildMenu$lambda$4(Event it) {
        new BrailleSettingsDialog(WPManager.Companion.getInstance().getController(), PagePropertiesTab.class);
    }

    private static final void getFromStyleMenu$lambda$0(Menu $newMenu, IBBMenu i) {
        Intrinsics.checkNotNullParameter((Object)i, (String)"i");
        i.build($newMenu);
    }

    private static final void createSharedSubMenu$lambda$0(Menu $newMenu, IBBMenu i) {
        Intrinsics.checkNotNullParameter((Object)i, (String)"i");
        i.build($newMenu);
    }

    private static final Unit getSharedSelection$lambda$0(SharedItem $item, BBSelectionData e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        INSTANCE.lookupSelection($item).invoke((Object)e);
        return Unit.INSTANCE;
    }

    private static final void getEmphasisSelection$lambda$0(EmphasisItem $item, BBSelectionData e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        INSTANCE.lookupEmphasis($item).invoke((Object)e);
    }

    private static final void notifyEnableListeners$lambda$0(boolean $value, MenuItem mi) {
        Intrinsics.checkNotNullParameter((Object)mi, (String)"mi");
        mi.setEnabled($value);
    }
}

