/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.perspectives.mvc.modules.misc;

import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.brailleblaster.BBIni;
import org.brailleblaster.userHelp.Project;
import org.brailleblaster.userHelp.VersionInfo;
import org.brailleblaster.util.ConstantsKt;
import org.brailleblaster.util.Utils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0004789:B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u001c\u001a\u0004\u0018\u00010\t2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0005H\u0002J\u0014\u0010%\u001a\u0004\u0018\u00010\u000b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0005H\u0002J\r\u0010&\u001a\u0004\u0018\u00010'\u00a2\u0006\u0002\u0010(J\u000e\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020'J*\u0010,\u001a\u00020*2\b\u0010-\u001a\u0004\u0018\u00010.2\b\u0010/\u001a\u0004\u0018\u00010\u00052\u000e\u00100\u001a\n\u0012\u0004\u0012\u000202\u0018\u000101J\u001c\u00103\u001a\u0002022\b\u00104\u001a\u0004\u0018\u00010.2\b\u0010/\u001a\u0004\u0018\u00010\u0005H\u0002J\u001c\u00105\u001a\u00020\u00052\b\u00106\u001a\u0004\u0018\u00010.2\b\u0010/\u001a\u0004\u0018\u00010\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R$\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\t8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR*\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u000b8F@FX\u0087\u000e\u00a2\u0006\u0012\u0012\u0004\b \u0010\u0003\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$\u00a8\u0006;"}, d2={"Lorg/brailleblaster/perspectives/mvc/modules/misc/ExceptionReportingModule;", "", "<init>", "()V", "ERROR_SUFFIX", "", "log", "Lorg/slf4j/Logger;", "DEFAULT_REPORTING_VALUE", "Lorg/brailleblaster/perspectives/mvc/modules/misc/ExceptionReportingModule$ExceptionReportingLevel;", "DEFAULT_RECOVERY_VALUE", "Lorg/brailleblaster/perspectives/mvc/modules/misc/ExceptionReportingModule$ExceptionRecoveryLevel;", "EXCEPTION_LEVEL_PROPERTY", "EXCEPTION_RECOVERY_PROPERTY", "REPORTER_THREAD", "Ljava/util/concurrent/ExecutorService;", "USER_SETTING_AUTO_UPLOAD", "USER_SETTING_REPORT_UUID", "AUTO_REPORT_INSTALLER_CONFIG", "Ljava/io/File;", "kotlin.jvm.PlatformType", "ERROR_REPORT_ADDRESS", "level", "exceptionReportingLevel", "getExceptionReportingLevel", "()Lorg/brailleblaster/perspectives/mvc/modules/misc/ExceptionReportingModule$ExceptionReportingLevel;", "setExceptionReportingLevel", "(Lorg/brailleblaster/perspectives/mvc/modules/misc/ExceptionReportingModule$ExceptionReportingLevel;)V", "getEquivalentReportingLevel", "value", "newLevel", "exceptionRecoveryLevel", "getExceptionRecoveryLevel$annotations", "getExceptionRecoveryLevel", "()Lorg/brailleblaster/perspectives/mvc/modules/misc/ExceptionReportingModule$ExceptionRecoveryLevel;", "setExceptionRecoveryLevel", "(Lorg/brailleblaster/perspectives/mvc/modules/misc/ExceptionReportingModule$ExceptionRecoveryLevel;)V", "getEquivalentRecoveryLevel", "isAutoUploadEnabledOrNull", "", "()Ljava/lang/Boolean;", "setAutoUploadEnabled", "", "enabled", "reportException", "t", "", "description", "callback", "Ljava/util/function/Consumer;", "Lorg/brailleblaster/perspectives/mvc/modules/misc/ExceptionReportingModule$ErrorReportResponse;", "reportErrorAsUserMessage", "e", "reportError", "exception", "ExceptionReportingLevel", "ExceptionRecoveryLevel", "ExceptionReporterRunnable", "ErrorReportResponse", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nExceptionReportingModule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExceptionReportingModule.kt\norg/brailleblaster/perspectives/mvc/modules/misc/ExceptionReportingModule\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,227:1\n106#2:228\n78#2,22:229\n37#3,2:251\n*S KotlinDebug\n*F\n+ 1 ExceptionReportingModule.kt\norg/brailleblaster/perspectives/mvc/modules/misc/ExceptionReportingModule\n*L\n115#1:228\n115#1:229,22\n193#1:251,2\n*E\n"})
public final class ExceptionReportingModule {
    @NotNull
    public static final ExceptionReportingModule INSTANCE = new ExceptionReportingModule();
    @NotNull
    private static final String ERROR_SUFFIX = ", please contact bb-support@tech.aph.org";
    @NotNull
    private static final Logger log;
    @NotNull
    private static final ExceptionReportingLevel DEFAULT_REPORTING_VALUE;
    @NotNull
    private static final ExceptionRecoveryLevel DEFAULT_RECOVERY_VALUE;
    @NotNull
    private static final String EXCEPTION_LEVEL_PROPERTY = "exceptionLevel";
    @NotNull
    private static final String EXCEPTION_RECOVERY_PROPERTY = "exceptionRecovery";
    @NotNull
    private static final ExecutorService REPORTER_THREAD;
    @NotNull
    private static final String USER_SETTING_AUTO_UPLOAD = "exceptionReporter.autoUpload";
    @NotNull
    private static final String USER_SETTING_REPORT_UUID = "notify.reportUuid";
    private static final File AUTO_REPORT_INSTALLER_CONFIG;
    @NotNull
    private static final String ERROR_REPORT_ADDRESS = "https://brailleblaster.org/errorReport/?v=2";

    private ExceptionReportingModule() {
    }

    @NotNull
    public final ExceptionReportingLevel getExceptionReportingLevel() {
        String propertyValue = BBIni.getPropertyFileManager().getProperty(EXCEPTION_LEVEL_PROPERTY);
        ExceptionReportingLevel exceptionReportingLevel = this.getEquivalentReportingLevel(propertyValue);
        if (exceptionReportingLevel == null) {
            return DEFAULT_REPORTING_VALUE;
        }
        ExceptionReportingLevel level = exceptionReportingLevel;
        return level;
    }

    public final void setExceptionReportingLevel(@NotNull ExceptionReportingLevel level) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        BBIni.getPropertyFileManager().save(EXCEPTION_LEVEL_PROPERTY, level.getPropertyValue());
    }

    private final ExceptionReportingLevel getEquivalentReportingLevel(String value) {
        if (value != null) {
            for (ExceptionReportingLevel enumValue : ExceptionReportingLevel.getEntries()) {
                if (!Intrinsics.areEqual((Object)enumValue.getPropertyValue(), (Object)value)) continue;
                return enumValue;
            }
        }
        return null;
    }

    @NotNull
    public static final ExceptionRecoveryLevel getExceptionRecoveryLevel() {
        String propertyValue = BBIni.getPropertyFileManager().getProperty(EXCEPTION_RECOVERY_PROPERTY);
        ExceptionRecoveryLevel exceptionRecoveryLevel = INSTANCE.getEquivalentRecoveryLevel(propertyValue);
        if (exceptionRecoveryLevel == null) {
            return DEFAULT_RECOVERY_VALUE;
        }
        ExceptionRecoveryLevel level = exceptionRecoveryLevel;
        return level;
    }

    public static final void setExceptionRecoveryLevel(@NotNull ExceptionRecoveryLevel newLevel) {
        Intrinsics.checkNotNullParameter((Object)((Object)newLevel), (String)"newLevel");
        BBIni.getPropertyFileManager().save(EXCEPTION_RECOVERY_PROPERTY, newLevel.getPropertyValue());
    }

    @JvmStatic
    public static /* synthetic */ void getExceptionRecoveryLevel$annotations() {
    }

    private final ExceptionRecoveryLevel getEquivalentRecoveryLevel(String value) {
        if (value != null) {
            for (ExceptionRecoveryLevel enumValue : ExceptionRecoveryLevel.getEntries()) {
                if (!Intrinsics.areEqual((Object)enumValue.getPropertyValue(), (Object)value)) continue;
                return enumValue;
            }
        }
        return null;
    }

    @Nullable
    public final Boolean isAutoUploadEnabledOrNull() {
        String userSetting = BBIni.getPropertyFileManager().getProperty(USER_SETTING_AUTO_UPLOAD);
        if (userSetting != null) {
            return Boolean.parseBoolean(userSetting);
        }
        if (AUTO_REPORT_INSTALLER_CONFIG.exists()) {
            try {
                File file = AUTO_REPORT_INSTALLER_CONFIG;
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"AUTO_REPORT_INSTALLER_CONFIG");
                String $this$trim$iv = FilesKt.readText((File)file, (Charset)Charsets.UTF_8);
                boolean $i$f$trim = false;
                CharSequence $this$trim$iv$iv = $this$trim$iv;
                boolean $i$f$trim2 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                return Intrinsics.areEqual((Object)((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString(), (Object)"true");
            }
            catch (Exception e) {
                log.error("Unable to read installer auto-report config at {}", (Object)AUTO_REPORT_INSTALLER_CONFIG, (Object)e);
            }
        }
        return null;
    }

    public final void setAutoUploadEnabled(boolean enabled) {
        BBIni.getPropertyFileManager().saveAsBoolean(USER_SETTING_AUTO_UPLOAD, enabled);
    }

    public final void reportException(@Nullable Throwable t, @Nullable String description, @Nullable Consumer<ErrorReportResponse> callback) {
        REPORTER_THREAD.execute(new ExceptionReporterRunnable(t, description, callback));
    }

    private final ErrorReportResponse reportErrorAsUserMessage(Throwable e, String description) {
        try {
            ErrorReportResponse errorReportResponse;
            String response = this.reportError(e, description);
            if (Intrinsics.areEqual((Object)response, (Object)"0")) {
                errorReportResponse = new ErrorReportResponse("Error Report Successful", response, true);
            } else if (StringsKt.startsWith$default((String)response, (String)"2", (boolean)false, (int)2, null)) {
                if (BBIni.INSTANCE.isReleaseBuild()) {
                    errorReportResponse = new ErrorReportResponse("Error Report Successful with old version but is not a release build", response, true);
                } else {
                    char[] cArray = new char[]{'2', ' '};
                    ErrorReportResponse errorReportResponse2 = new ErrorReportResponse("Error Report Successful but old version detected", StringsKt.trimStart((String)response, (char[])cArray), false);
                    errorReportResponse = errorReportResponse2;
                }
            } else {
                errorReportResponse = new ErrorReportResponse("Error Report Unsuccessful", response, false);
            }
            return errorReportResponse;
        }
        catch (Exception reportException) {
            log.error("Failed to send error report", (Throwable)reportException);
            String string = "%s%s%s%s%s";
            Object[] objectArray = new Object[]{ExceptionUtils.getRootCause((Throwable)reportException) instanceof ConnectException ? "Cannot connect" : "Unknown error when reporting", ERROR_SUFFIX, ConstantsKt.getLINE_BREAK(), ConstantsKt.getLINE_BREAK(), ExceptionUtils.getRootCauseMessage((Throwable)reportException)};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            return new ErrorReportResponse("Error Report Unsuccessful", string2, false);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String reportError(Throwable exception, String description) throws IOException, InterruptedException {
        void $this$toTypedArray$iv;
        String userId = BBIni.getPropertyFileManager().getProperty(USER_SETTING_REPORT_UUID);
        if (userId == null) {
            userId = UUID.randomUUID().toString();
            BBIni.getPropertyFileManager().save(USER_SETTING_REPORT_UUID, userId);
        }
        Pair[] pairArray = new Pair[10];
        pairArray[0] = TuplesKt.to((Object)"exception", (Object)ExceptionUtils.getStackTrace((Throwable)exception));
        String string = description;
        if (string == null) {
            string = "";
        }
        pairArray[1] = TuplesKt.to((Object)"description", (Object)string);
        pairArray[2] = TuplesKt.to((Object)"versionBb", (Object)Project.BB.INSTANCE.getVersion());
        pairArray[3] = TuplesKt.to((Object)"versionUtd", (Object)"Unknown");
        pairArray[4] = TuplesKt.to((Object)"versionJLouis", (Object)"Unknown");
        Object object = Project.LIBLOUIS.INSTANCE.getVersionWithRev();
        Regex regex = new Regex("]");
        int n = 2;
        object = regex.split((CharSequence)object, n);
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        pairArray[5] = TuplesKt.to((Object)"versionLibLouis", (Object)(thisCollection$iv.toArray(new String[0])[0] + "]"));
        pairArray[6] = TuplesKt.to((Object)"versionOs", (Object)VersionInfo.getOSVersion());
        pairArray[7] = TuplesKt.to((Object)"versionJava", (Object)VersionInfo.getJavaVersion());
        pairArray[8] = TuplesKt.to((Object)"newLineSize", (Object)String.valueOf(ConstantsKt.getLINE_BREAK().length()));
        pairArray[9] = TuplesKt.to((Object)"userId", (Object)userId);
        return Utils.INSTANCE.httpPost(ERROR_REPORT_ADDRESS, MapsKt.mapOf((Pair[])pairArray));
    }

    static {
        Logger logger = LoggerFactory.getLogger(ExceptionReportingModule.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        log = logger;
        DEFAULT_REPORTING_VALUE = ExceptionReportingLevel.USER_FRIENDLY;
        DEFAULT_RECOVERY_VALUE = ExceptionRecoveryLevel.RECOVER;
        ExecutorService executorService = Executors.newCachedThreadPool();
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newCachedThreadPool(...)");
        REPORTER_THREAD = executorService;
        String[] stringArray = new String[]{"reportErrors"};
        AUTO_REPORT_INSTALLER_CONFIG = BBIni.getProgramDataPath().resolve(Paths.get("settings", stringArray)).toFile();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/brailleblaster/perspectives/mvc/modules/misc/ExceptionReportingModule$ErrorReportResponse;", "", "title", "", "text", "success", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Z)V", "getTitle", "()Ljava/lang/String;", "getText", "getSuccess", "()Z", "brailleblaster-core"})
    public static final class ErrorReportResponse {
        @NotNull
        private final String title;
        @NotNull
        private final String text;
        private final boolean success;

        public ErrorReportResponse(@NotNull String title, @NotNull String text, boolean success) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this.title = title;
            this.text = text;
            this.success = success;
        }

        @NotNull
        public final String getTitle() {
            return this.title;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        public final boolean getSuccess() {
            return this.success;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lorg/brailleblaster/perspectives/mvc/modules/misc/ExceptionReportingModule$ExceptionRecoveryLevel;", "", "propertyValue", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getPropertyValue", "()Ljava/lang/String;", "RECOVER", "DO_NOT_RECOVER", "brailleblaster-core"})
    public static final class ExceptionRecoveryLevel
    extends Enum<ExceptionRecoveryLevel> {
        @NotNull
        private final String propertyValue;
        public static final /* enum */ ExceptionRecoveryLevel RECOVER = new ExceptionRecoveryLevel("recover");
        public static final /* enum */ ExceptionRecoveryLevel DO_NOT_RECOVER = new ExceptionRecoveryLevel("doNotRecover");
        private static final /* synthetic */ ExceptionRecoveryLevel[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private ExceptionRecoveryLevel(String propertyValue) {
            this.propertyValue = propertyValue;
        }

        @NotNull
        public final String getPropertyValue() {
            return this.propertyValue;
        }

        public static ExceptionRecoveryLevel[] values() {
            return (ExceptionRecoveryLevel[])$VALUES.clone();
        }

        public static ExceptionRecoveryLevel valueOf(String value) {
            return Enum.valueOf(ExceptionRecoveryLevel.class, value);
        }

        @NotNull
        public static EnumEntries<ExceptionRecoveryLevel> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = exceptionRecoveryLevelArray = new ExceptionRecoveryLevel[]{ExceptionRecoveryLevel.RECOVER, ExceptionRecoveryLevel.DO_NOT_RECOVER};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u00012\u00020\u0002B+\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u0011\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bH\u00c6\u0003J3\u0010\u0014\u001a\u00020\u00002\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bH\u00c6\u0001J\u0014\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0083\u0004J\n\u0010\u0019\u001a\u00020\u001aH\u00d6\u0081\u0004J\n\u0010\u001b\u001a\u00020\u0006H\u00d6\u0081\u0004R\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\fR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\rR\u0019\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u000e\u00a8\u0006\u001c"}, d2={"Lorg/brailleblaster/perspectives/mvc/modules/misc/ExceptionReportingModule$ExceptionReporterRunnable;", "Ljava/lang/Runnable;", "Ljava/lang/Record;", "exception", "", "description", "", "callback", "Ljava/util/function/Consumer;", "Lorg/brailleblaster/perspectives/mvc/modules/misc/ExceptionReportingModule$ErrorReportResponse;", "<init>", "(Ljava/lang/Throwable;Ljava/lang/String;Ljava/util/function/Consumer;)V", "()Ljava/lang/Throwable;", "()Ljava/lang/String;", "()Ljava/util/function/Consumer;", "run", "", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "brailleblaster-core"})
    private static final class ExceptionReporterRunnable
    extends Record
    implements Runnable {
        @Nullable
        private final Throwable exception;
        @Nullable
        private final String description;
        @Nullable
        private final Consumer<ErrorReportResponse> callback;

        public ExceptionReporterRunnable(@Nullable Throwable exception, @Nullable String description, @Nullable Consumer<ErrorReportResponse> callback) {
            this.exception = exception;
            this.description = description;
            this.callback = callback;
        }

        @Nullable
        public final Throwable exception() {
            return this.exception;
        }

        @Nullable
        public final String description() {
            return this.description;
        }

        @Nullable
        public final Consumer<ErrorReportResponse> callback() {
            return this.callback;
        }

        @Override
        public void run() {
            block0: {
                ErrorReportResponse response = INSTANCE.reportErrorAsUserMessage(this.exception, this.description);
                Consumer<ErrorReportResponse> consumer = this.callback;
                if (consumer == null) break block0;
                consumer.accept(response);
            }
        }

        @Nullable
        public final Throwable component1() {
            return this.exception;
        }

        @Nullable
        public final String component2() {
            return this.description;
        }

        @Nullable
        public final Consumer<ErrorReportResponse> component3() {
            return this.callback;
        }

        @NotNull
        public final ExceptionReporterRunnable copy(@Nullable Throwable exception, @Nullable String description, @Nullable Consumer<ErrorReportResponse> callback) {
            return new ExceptionReporterRunnable(exception, description, callback);
        }

        public static /* synthetic */ ExceptionReporterRunnable copy$default(ExceptionReporterRunnable exceptionReporterRunnable, Throwable throwable, String string, Consumer consumer, int n, Object object) {
            if ((n & 1) != 0) {
                throwable = exceptionReporterRunnable.exception;
            }
            if ((n & 2) != 0) {
                string = exceptionReporterRunnable.description;
            }
            if ((n & 4) != 0) {
                consumer = exceptionReporterRunnable.callback;
            }
            return exceptionReporterRunnable.copy(throwable, string, consumer);
        }

        @Override
        @NotNull
        public String toString() {
            return "ExceptionReporterRunnable(exception=" + this.exception + ", description=" + this.description + ", callback=" + this.callback + ")";
        }

        @Override
        public int hashCode() {
            int result = this.exception == null ? 0 : this.exception.hashCode();
            result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
            result = result * 31 + (this.callback == null ? 0 : this.callback.hashCode());
            return result;
        }

        @Override
        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ExceptionReporterRunnable)) {
                return false;
            }
            ExceptionReporterRunnable exceptionReporterRunnable = (ExceptionReporterRunnable)other;
            if (!Intrinsics.areEqual((Object)this.exception, (Object)exceptionReporterRunnable.exception)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.description, (Object)exceptionReporterRunnable.description)) {
                return false;
            }
            return Intrinsics.areEqual(this.callback, exceptionReporterRunnable.callback);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lorg/brailleblaster/perspectives/mvc/modules/misc/ExceptionReportingModule$ExceptionReportingLevel;", "", "propertyValue", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getPropertyValue", "()Ljava/lang/String;", "DEBUG", "USER_FRIENDLY", "STATUS_BAR", "HIDE_ALL", "brailleblaster-core"})
    public static final class ExceptionReportingLevel
    extends Enum<ExceptionReportingLevel> {
        @NotNull
        private final String propertyValue;
        public static final /* enum */ ExceptionReportingLevel DEBUG = new ExceptionReportingLevel("debug");
        public static final /* enum */ ExceptionReportingLevel USER_FRIENDLY = new ExceptionReportingLevel("userFriendly");
        public static final /* enum */ ExceptionReportingLevel STATUS_BAR = new ExceptionReportingLevel("statusBar");
        public static final /* enum */ ExceptionReportingLevel HIDE_ALL = new ExceptionReportingLevel("hideAll");
        private static final /* synthetic */ ExceptionReportingLevel[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private ExceptionReportingLevel(String propertyValue) {
            this.propertyValue = propertyValue;
        }

        @NotNull
        public final String getPropertyValue() {
            return this.propertyValue;
        }

        public static ExceptionReportingLevel[] values() {
            return (ExceptionReportingLevel[])$VALUES.clone();
        }

        public static ExceptionReportingLevel valueOf(String value) {
            return Enum.valueOf(ExceptionReportingLevel.class, value);
        }

        @NotNull
        public static EnumEntries<ExceptionReportingLevel> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = exceptionReportingLevelArray = new ExceptionReportingLevel[]{ExceptionReportingLevel.DEBUG, ExceptionReportingLevel.USER_FRIENDLY, ExceptionReportingLevel.STATUS_BAR, ExceptionReportingLevel.HIDE_ALL};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

