/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.perspectives.mvc.modules.misc;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.brailleblaster.abstractClasses.BBEditorView;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.perspectives.braille.mapping.elements.TextMapElement;
import org.brailleblaster.perspectives.braille.mapping.maps.MapList;
import org.brailleblaster.perspectives.braille.views.wp.TextView;
import org.brailleblaster.perspectives.braille.views.wp.WPView;
import org.brailleblaster.perspectives.mvc.BBSimpleManager;
import org.brailleblaster.perspectives.mvc.SimpleEvent;
import org.brailleblaster.perspectives.mvc.events.BBViewListener;
import org.brailleblaster.utils.swt.EasySWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0005H\u0002J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0005H\u0002J \u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u0005H\u0002J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/brailleblaster/perspectives/mvc/modules/misc/PageDownUpModule;", "Lorg/brailleblaster/perspectives/mvc/BBSimpleManager$SimpleListener;", "Lorg/eclipse/swt/custom/VerifyKeyListener;", "Lorg/brailleblaster/perspectives/mvc/events/BBViewListener;", "manager", "Lorg/brailleblaster/perspectives/braille/Manager;", "<init>", "(Lorg/brailleblaster/perspectives/braille/Manager;)V", "onEvent", "", "event", "Lorg/brailleblaster/perspectives/mvc/SimpleEvent;", "nextPage", "m", "previousPage", "adjustLine", "pageLine", "", "newPageLine", "verifyKey", "e", "Lorg/eclipse/swt/events/VerifyEvent;", "initializeListener", "view", "Lorg/brailleblaster/abstractClasses/BBEditorView;", "removeListener", "brailleblaster-core"})
public final class PageDownUpModule
implements BBSimpleManager.SimpleListener,
VerifyKeyListener,
BBViewListener {
    @NotNull
    private final Manager manager;

    public PageDownUpModule(@NotNull Manager manager) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        this.manager = manager;
    }

    @Override
    public void onEvent(@NotNull SimpleEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
    }

    private final void nextPage(Manager m) {
        int line = WPView.currentLine;
        int pageLine = line % m.getDocument().getLinesPerPage() + 1;
        int newLine = line + m.getDocument().getLinesPerPage();
        if (newLine < m.getTextView().getContent().getLineCount()) {
            m.getText().setCurrentElement(m.getTextView().getOffsetAtLine(newLine));
        } else if (m.getViewInitializer().getSectionList().size() > 1) {
            m.getText().setListenerLock(true);
            TextView textView = m.getText();
            MapList mapList = m.getMapList();
            Intrinsics.checkNotNullExpressionValue((Object)mapList, (String)"getMapList(...)");
            textView.setCurrentElement(((TextMapElement)CollectionsKt.last((List)mapList)).getEnd(m.getMapList()));
            int newPageLine = WPView.currentLine % m.getDocument().getLinesPerPage() + 1;
            if (newPageLine != pageLine) {
                this.adjustLine(pageLine, newPageLine, m);
            }
            m.getText().setListenerLock(false);
        } else {
            m.getTextView().setCaretOffset(m.getTextView().getOffsetAtLine(m.getTextView().getContent().getLineCount() - 1));
        }
        StyledText styledText = m.getTextView();
        Intrinsics.checkNotNullExpressionValue((Object)styledText, (String)"getTextView(...)");
        EasySWT.INSTANCE.scrollViewToCursor(styledText);
    }

    private final void previousPage(Manager m) {
        int line = WPView.currentLine;
        int pageLine = line % m.getDocument().getLinesPerPage() + 1;
        int newLine = line - m.getDocument().getLinesPerPage();
        if (newLine > 0) {
            m.getText().setCurrentElement(m.getTextView().getOffsetAtLine(newLine));
        } else if (m.getViewInitializer().getSectionList().size() > 1) {
            m.getText().setListenerLock(true);
            m.getText().setCurrentElement(m.getMapList().getFirstUsable().getStart(m.getMapList()));
            int newPageLine = WPView.currentLine % m.getDocument().getLinesPerPage() + 1;
            if (newPageLine != pageLine) {
                this.adjustLine(pageLine, newPageLine, m);
            }
            m.getText().setListenerLock(false);
        } else {
            m.getTextView().setCaretOffset(m.getTextView().getOffsetAtLine(0));
        }
        StyledText styledText = m.getTextView();
        Intrinsics.checkNotNullExpressionValue((Object)styledText, (String)"getTextView(...)");
        EasySWT.INSTANCE.scrollViewToCursor(styledText);
    }

    private final void adjustLine(int pageLine, int newPageLine, Manager m) {
        int dif = 0;
        if (newPageLine > pageLine) {
            dif = newPageLine - pageLine;
            m.getTextView().setCaretOffset(m.getTextView().getOffsetAtLine(WPView.currentLine - dif));
        } else {
            dif = pageLine - newPageLine;
            m.getTextView().setCaretOffset(m.getTextView().getOffsetAtLine(WPView.currentLine + dif));
        }
    }

    public void verifyKey(@NotNull VerifyEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e.keyCode == 0x1000006) {
            this.nextPage(this.manager);
        }
        if (e.keyCode == 0x1000005) {
            this.previousPage(this.manager);
        }
    }

    @Override
    public void initializeListener(@NotNull BBEditorView view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.getView().addVerifyKeyListener((VerifyKeyListener)this);
    }

    @Override
    public void removeListener(@NotNull BBEditorView view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.getView().removeVerifyKeyListener((VerifyKeyListener)this);
    }
}

