/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.perspectives.mvc.modules.misc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import nu.xom.Text;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.exceptions.EditingException;
import org.brailleblaster.perspectives.braille.messages.Sender;
import org.brailleblaster.perspectives.mvc.BBSimpleManager;
import org.brailleblaster.perspectives.mvc.SimpleEvent;
import org.brailleblaster.perspectives.mvc.XMLNodeCaret;
import org.brailleblaster.perspectives.mvc.XMLSelection;
import org.brailleblaster.perspectives.mvc.XMLTextCaret;
import org.brailleblaster.perspectives.mvc.events.ModifyEvent;
import org.brailleblaster.utd.Style;
import org.brailleblaster.utd.utils.UTDHelper;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lorg/brailleblaster/perspectives/mvc/modules/misc/SplitElementModule;", "Lorg/brailleblaster/perspectives/mvc/BBSimpleManager$SimpleListener;", "<init>", "()V", "onEvent", "", "event", "Lorg/brailleblaster/perspectives/mvc/SimpleEvent;", "Companion", "brailleblaster-core"})
public final class SplitElementModule
implements BBSimpleManager.SimpleListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger logger = LoggerFactory.getLogger(SplitElementModule.class);

    @Override
    public void onEvent(@NotNull SimpleEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
    }

    @JvmStatic
    public static final boolean splitElement(@NotNull BBSimpleManager simpleManager) {
        return Companion.splitElement(simpleManager);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000e\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/brailleblaster/perspectives/mvc/modules/misc/SplitElementModule$Companion;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "splitElement", "", "simpleManager", "Lorg/brailleblaster/perspectives/mvc/BBSimpleManager;", "copyBlockWithoutStyleOptions", "Lnu/xom/Element;", "block", "createBlockCopy", "styleName", "", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final boolean splitElement(@NotNull BBSimpleManager simpleManager) {
            List list;
            Intrinsics.checkNotNullParameter((Object)simpleManager, (String)"simpleManager");
            try {
                List list2;
                XMLSelection selection = simpleManager.getCurrentSelection();
                if (selection.isTextNoSelection()) {
                    XMLNodeCaret xMLNodeCaret = selection.start;
                    Intrinsics.checkNotNull((Object)xMLNodeCaret, (String)"null cannot be cast to non-null type org.brailleblaster.perspectives.mvc.XMLTextCaret");
                    XMLTextCaret currentCaret = (XMLTextCaret)xMLNodeCaret;
                    Text textNode = currentCaret.getNode();
                    int textIndex = currentCaret.getOffset();
                    logger.debug("Splitting text node: " + textNode.getValue() + " at offset: " + textIndex);
                    String string = textNode.getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
                    String string2 = string.substring(textIndex);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                    String newText = string2;
                    String string3 = textNode.getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getValue(...)");
                    String string4 = string3;
                    int n = 0;
                    String string5 = string4.substring(n, textIndex);
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                    String oldText = string5;
                    Text newTextNode = new Text(newText);
                    textNode.setValue(oldText);
                    List pathToBlock = new ArrayList();
                    Node curNode = (Node)textNode;
                    while (!BBX.BLOCK.isA(curNode)) {
                        ParentNode parentNode = curNode.getParent();
                        Intrinsics.checkNotNull((Object)parentNode, (String)"null cannot be cast to non-null type nu.xom.Element");
                        Element newParent = (Element)parentNode;
                        UTDHelper.stripUTDRecursive((Element)newParent);
                        pathToBlock.add(newParent.indexOf(curNode));
                        curNode = (Node)newParent;
                    }
                    Node newNodeCopy = (Node)newTextNode;
                    Node origNode = (Node)textNode;
                    Iterator iterator = pathToBlock.iterator();
                    while (iterator.hasNext()) {
                        Element element;
                        int integer = ((Number)iterator.next()).intValue();
                        ParentNode parentNode = origNode.getParent();
                        Intrinsics.checkNotNullExpressionValue((Object)parentNode, (String)"getParent(...)");
                        origNode = (Node)parentNode;
                        if (BBX.BLOCK.isA(origNode)) {
                            element = this.copyBlockWithoutStyleOptions((Element)origNode, simpleManager);
                        } else {
                            Node node = origNode.copy();
                            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Element");
                            element = (Element)node;
                        }
                        Element newCopy = element;
                        newCopy.removeChildren();
                        newCopy.appendChild(newNodeCopy);
                        newNodeCopy = (Node)newCopy;
                        for (int curIndex = integer + 1; curIndex < ((ParentNode)origNode).getChildCount(); ++curIndex) {
                            Node childToMove = ((ParentNode)origNode).getChild(curIndex);
                            childToMove.detach();
                            ((Element)newNodeCopy).appendChild(childToMove);
                            --curIndex;
                        }
                    }
                    ParentNode blockParent = origNode.getParent();
                    blockParent.insertChild(newNodeCopy, blockParent.indexOf(origNode) + 1);
                    List modifiedNodes = new ArrayList();
                    if (newNodeCopy.getDocument() != null) {
                        modifiedNodes.add(newNodeCopy);
                    }
                    if (origNode.getDocument() != null) {
                        modifiedNodes.add(origNode);
                    }
                    list2 = modifiedNodes;
                } else {
                    list2 = null;
                }
                list = list2;
            }
            catch (RuntimeException e) {
                throw new EditingException("Error splitting node", (Throwable)e);
            }
            List modifiedNodes = list;
            if (modifiedNodes != null) {
                simpleManager.dispatchEvent(new ModifyEvent(Sender.NO_SENDER, modifiedNodes, true));
                return true;
            }
            return false;
        }

        private final Element copyBlockWithoutStyleOptions(Element block, BBSimpleManager simpleManager) {
            Style baseStyle;
            Style style;
            Style style2 = style = (Style)simpleManager.getUtdManager().getEngine().getStyle((Node)block);
            Object object = baseStyle = style2 != null ? style2.getBaseStyle() : null;
            if (baseStyle != null) {
                Element element;
                if (Intrinsics.areEqual((Object)baseStyle.getName(), (Object)new Style().getName())) {
                    String string = style.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    element = this.createBlockCopy(block, string);
                } else {
                    String string = baseStyle.getId();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
                    if (StringsKt.contains$default((CharSequence)string, (CharSequence)"internal", (boolean)false, (int)2, null)) {
                        String string2 = style.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                        element = this.createBlockCopy(block, string2);
                    } else {
                        String string3 = baseStyle.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
                        element = this.createBlockCopy(block, string3);
                    }
                }
                return element;
            }
            logger.warn("No style found for block: " + block.toXML());
            Element element = block.copy();
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"copy(...)");
            return element;
        }

        private final Element createBlockCopy(Element block, String styleName) {
            Element element;
            if (BBX.BLOCK.DEFAULT.isA((Node)block)) {
                Element element2 = BBX.BLOCK.DEFAULT.create();
                element = element2;
                Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"create(...)");
            } else {
                Element element3 = BBX.BLOCK.STYLE.create(styleName);
                element = element3;
                Intrinsics.checkNotNullExpressionValue((Object)element3, (String)"create(...)");
            }
            return element;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

