/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.perspectives.mvc.modules.misc;

import com.google.common.base.CaseFormat;
import java.nio.file.FileSystems;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import nu.xom.Element;
import nu.xom.Node;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.perspectives.braille.views.wp.NumberInputDialog;
import org.brailleblaster.perspectives.mvc.XMLSelection;
import org.brailleblaster.perspectives.mvc.menu.BBSelectionData;
import org.brailleblaster.perspectives.mvc.menu.BBStyleOptionSelection;
import org.brailleblaster.perspectives.mvc.menu.BBStyleSelection;
import org.brailleblaster.perspectives.mvc.menu.SubMenuBuilder;
import org.brailleblaster.perspectives.mvc.modules.misc.StylesMenuModule;
import org.brailleblaster.utd.IStyle;
import org.brailleblaster.utd.Style;
import org.brailleblaster.utd.config.StyleDefinitions;
import org.brailleblaster.utd.properties.NumberLinePosition;
import org.brailleblaster.utils.localization.LocaleHandler;
import org.brailleblaster.utils.swt.EasySWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010!\n\u0002\b\u0003\b\u0016\u0018\u0000 -2\u00020\u0001:\u0001-B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J*\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0011J.\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J4\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"2\b\u0010$\u001a\u0004\u0018\u00010 J\u000e\u0010%\u001a\u00020 2\u0006\u0010&\u001a\u00020 J\u0010\u0010'\u001a\u00020\"2\u0006\u0010(\u001a\u00020 H\u0002J\u0014\u0010)\u001a\u00020\r2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020 0+J\b\u0010,\u001a\u00020\rH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lorg/brailleblaster/perspectives/mvc/modules/misc/StylesBuilder;", "", "shell", "Lorg/eclipse/swt/widgets/Shell;", "manager", "Lorg/brailleblaster/perspectives/braille/Manager;", "<init>", "(Lorg/eclipse/swt/widgets/Shell;Lorg/brailleblaster/perspectives/braille/Manager;)V", "getShell", "()Lorg/eclipse/swt/widgets/Shell;", "styleDefs", "Lorg/brailleblaster/utd/config/StyleDefinitions;", "getStyleOptions", "", "smb", "Lorg/brailleblaster/perspectives/mvc/menu/SubMenuBuilder;", "onOptionSelect", "Ljava/util/function/Consumer;", "Lorg/brailleblaster/perspectives/mvc/menu/BBStyleOptionSelection;", "onStyleSelect", "Lorg/brailleblaster/perspectives/mvc/menu/BBStyleSelection;", "handleOption", "optionKey", "Lorg/brailleblaster/utd/Style$StyleOption;", "optionValueRaw", "widget", "Lorg/eclipse/swt/widgets/Widget;", "getMenuItem", "Lorg/eclipse/swt/widgets/MenuItem;", "parentMenu", "Lorg/eclipse/swt/widgets/Menu;", "label", "", "menuType", "", "miId", "keyComb", "getStyleName", "styleId", "getCategoryIndex", "categoryName", "addIndexes", "idList", "", "wrapSelectedElements", "Companion", "brailleblaster-core"})
public class StylesBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Shell shell;
    @NotNull
    private final Manager manager;
    @JvmField
    @NotNull
    public final StyleDefinitions styleDefs;
    @NotNull
    private static final LocaleHandler.Companion localeHandler = LocaleHandler.Companion;
    public static final int DEFAULT_STYLE_LEVELS = 5;
    @NotNull
    private static final List<String> STYLES_LIST;
    @NotNull
    public static final String INTERNAL_CATEGORY_NAME = "internal";
    @NotNull
    public static final String LEVELS_INDICATOR = "LEVELS";
    @NotNull
    public static final String OPTIONS_CATEGORY_NAME = "options";
    @NotNull
    private static String sep;
    @NotNull
    private static final String DONT_SPLIT_STYLE_ID = "internal/dontSplit";

    public StylesBuilder(@NotNull Shell shell, @NotNull Manager manager) {
        Intrinsics.checkNotNullParameter((Object)shell, (String)"shell");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        this.shell = shell;
        this.manager = manager;
        this.styleDefs = this.manager.getDocument().getSettingsManager().getEngine().getStyleDefinitions();
    }

    @NotNull
    public final Shell getShell() {
        return this.shell;
    }

    public final void getStyleOptions(@NotNull SubMenuBuilder smb, @NotNull Consumer<BBStyleOptionSelection> onOptionSelect, @NotNull Consumer<BBStyleSelection> onStyleSelect) {
        Intrinsics.checkNotNullParameter((Object)smb, (String)"smb");
        Intrinsics.checkNotNullParameter(onOptionSelect, (String)"onOptionSelect");
        Intrinsics.checkNotNullParameter(onStyleSelect, (String)"onStyleSelect");
        SubMenuBuilder.addItem$default(smb, "Don't Split", 0, 0, null, arg_0 -> StylesBuilder.getStyleOptions$lambda$0(this, onStyleSelect, arg_0), 12, null);
        smb.addSubMenu(SubMenuBuilder.addItem$default(SubMenuBuilder.addItem$default(new SubMenuBuilder(smb, "Keep With Next"), "Yes", 0, 0, null, arg_0 -> StylesBuilder.getStyleOptions$lambda$1(this, onOptionSelect, arg_0), 12, null), "No", 0, 0, null, arg_0 -> StylesBuilder.getStyleOptions$lambda$2(this, onOptionSelect, arg_0), 12, null).build());
        SubMenuBuilder.addItem$default(smb, "Lines Before", 0, 0, null, arg_0 -> StylesBuilder.getStyleOptions$lambda$3(this, onOptionSelect, arg_0), 12, null);
        SubMenuBuilder.addItem$default(smb, "Lines After", 0, 0, null, arg_0 -> StylesBuilder.getStyleOptions$lambda$4(this, onOptionSelect, arg_0), 12, null);
        smb.addSubMenu(SubMenuBuilder.addItem$default(SubMenuBuilder.addItem$default(new SubMenuBuilder(smb, "Page Side"), "Left", 0, 0, null, arg_0 -> StylesBuilder.getStyleOptions$lambda$5(this, onOptionSelect, arg_0), 12, null), "Right", 0, 0, null, arg_0 -> StylesBuilder.getStyleOptions$lambda$6(this, onOptionSelect, arg_0), 12, null).build());
        smb.addSubMenu(SubMenuBuilder.addItem$default(SubMenuBuilder.addItem$default(SubMenuBuilder.addItem$default(SubMenuBuilder.addItem$default(new SubMenuBuilder(smb, "Skip Number Lines"), "Top", 0, 0, null, arg_0 -> StylesBuilder.getStyleOptions$lambda$7(this, onOptionSelect, arg_0), 12, null), "Bottom", 0, 0, null, arg_0 -> StylesBuilder.getStyleOptions$lambda$8(this, onOptionSelect, arg_0), 12, null), "Both", 0, 0, null, arg_0 -> StylesBuilder.getStyleOptions$lambda$9(this, onOptionSelect, arg_0), 12, null), "None", 0, 0, null, arg_0 -> StylesBuilder.getStyleOptions$lambda$10(this, onOptionSelect, arg_0), 12, null).build());
        SubMenuBuilder.addItem$default(smb, "New Pages Before", 0, 0, null, arg_0 -> StylesBuilder.getStyleOptions$lambda$11(this, onOptionSelect, arg_0), 12, null);
        SubMenuBuilder.addItem$default(smb, "New Pages After", 0, 0, null, arg_0 -> StylesBuilder.getStyleOptions$lambda$12(this, onOptionSelect, arg_0), 12, null);
        smb.addSubMenu(SubMenuBuilder.addItem$default(SubMenuBuilder.addItem$default(new SubMenuBuilder(smb, "Guide Words"), "Yes", 0, 0, null, arg_0 -> StylesBuilder.getStyleOptions$lambda$13(this, onOptionSelect, arg_0), 12, null), "No", 0, 0, null, arg_0 -> StylesBuilder.getStyleOptions$lambda$14(this, onOptionSelect, arg_0), 12, null).build());
        SubMenuBuilder.addItem$default(smb, "Double Spaced", 0, 0, null, arg_0 -> StylesBuilder.getStyleOptions$lambda$15(this, arg_0), 12, null);
    }

    private final void handleOption(Style.StyleOption optionKey, Object optionValueRaw, Consumer<BBStyleOptionSelection> onOptionSelect, Widget widget) {
        if (optionKey == Style.StyleOption.LINES_BEFORE || optionKey == Style.StyleOption.LINES_AFTER || optionKey == Style.StyleOption.NEW_PAGES_BEFORE || optionKey == Style.StyleOption.NEW_PAGES_AFTER) {
            String string = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, optionKey.name());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"to(...)");
            String lhKey = string;
            new NumberInputDialog(Display.getCurrent().getActiveShell()).open(LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)localeHandler, null, (int)1, null).get(lhKey), (Function1<? super Integer, Unit>)((Function1)arg_0 -> StylesBuilder.handleOption$lambda$0(onOptionSelect, optionKey, widget, arg_0)));
        } else {
            onOptionSelect.accept(new BBStyleOptionSelection(optionKey, optionValueRaw, widget));
        }
    }

    @NotNull
    public final MenuItem getMenuItem(@Nullable Menu parentMenu, @Nullable String label, int menuType, int miId, @Nullable String keyComb) {
        MenuItem mi = new MenuItem(parentMenu, menuType);
        LocaleHandler localeHandler = LocaleHandler.Companion.getBanaStyles$default((LocaleHandler.Companion)StylesBuilder.localeHandler, null, (int)1, null);
        String string = label;
        Intrinsics.checkNotNull((Object)string);
        StringBuilder tlabel = new StringBuilder(localeHandler.get(string));
        if (keyComb != null && !Intrinsics.areEqual((Object)keyComb, (Object)"")) {
            tlabel.append(StringsKt.repeat((CharSequence)" ", (int)Math.max(0, 35 - tlabel.length())));
            tlabel.append(keyComb);
        }
        mi.setText(tlabel.toString());
        mi.setID(miId);
        return mi;
    }

    @NotNull
    public final String getStyleName(@NotNull String styleId) {
        Intrinsics.checkNotNullParameter((Object)styleId, (String)"styleId");
        String styleName = "";
        for (Style curStyle : this.styleDefs.getStyles()) {
            if (!Intrinsics.areEqual((Object)styleId, (Object)curStyle.getId())) continue;
            String string = curStyle.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            styleName = string;
            break;
        }
        return styleName;
    }

    private final int getCategoryIndex(String categoryName) {
        int n = ((Collection)STYLES_LIST).size();
        for (int i = 0; i < n; ++i) {
            if (!Intrinsics.areEqual((Object)categoryName, (Object)STYLES_LIST.get(i))) continue;
            return i + 10;
        }
        return 0;
    }

    public final void addIndexes(@NotNull List<String> idList) {
        Intrinsics.checkNotNullParameter(idList, (String)"idList");
        String styleId = null;
        String categoryName = null;
        String fileSeparator = "/";
        int n = ((Collection)idList).size();
        for (int i = 0; i < n; ++i) {
            styleId = idList.get(i);
            categoryName = StringsKt.substringBefore$default((String)styleId, (String)fileSeparator, null, (int)2, null);
            idList.set(i, this.getCategoryIndex(categoryName) + "-" + styleId);
        }
    }

    private final void wrapSelectedElements() {
        XMLSelection currentSelection = this.manager.getSimpleManager().getCurrentSelection();
        Node startNode = currentSelection.start.getNode();
        Node endNode = currentSelection.end.getNode();
        Element container = BBX.CONTAINER.DOUBLE_SPACE.create();
        Intrinsics.checkNotNull((Object)container);
        StylesMenuModule.Companion.wrapSelectedElements(this.manager, container, startNode, endNode);
    }

    private static final void getStyleOptions$lambda$0(StylesBuilder this$0, Consumer $onStyleSelect, BBSelectionData e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        String styleName = this$0.getStyleName(DONT_SPLIT_STYLE_ID);
        IStyle style = (IStyle)this$0.styleDefs.getStyleByName(styleName);
        if (style != null) {
            $onStyleSelect.accept(new BBStyleSelection(style, e.getWidget()));
        }
    }

    private static final void getStyleOptions$lambda$1(StylesBuilder this$0, Consumer $onOptionSelect, BBSelectionData e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this$0.handleOption(Style.StyleOption.KEEP_WITH_NEXT, true, $onOptionSelect, e.getWidget());
    }

    private static final void getStyleOptions$lambda$2(StylesBuilder this$0, Consumer $onOptionSelect, BBSelectionData e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this$0.handleOption(Style.StyleOption.KEEP_WITH_NEXT, false, $onOptionSelect, e.getWidget());
    }

    private static final void getStyleOptions$lambda$3(StylesBuilder this$0, Consumer $onOptionSelect, BBSelectionData e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this$0.handleOption(Style.StyleOption.LINES_BEFORE, 0, $onOptionSelect, e.getWidget());
    }

    private static final void getStyleOptions$lambda$4(StylesBuilder this$0, Consumer $onOptionSelect, BBSelectionData e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this$0.handleOption(Style.StyleOption.LINES_AFTER, 0, $onOptionSelect, e.getWidget());
    }

    private static final void getStyleOptions$lambda$5(StylesBuilder this$0, Consumer $onOptionSelect, BBSelectionData e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this$0.handleOption(Style.StyleOption.PAGE_SIDE, "left", $onOptionSelect, e.getWidget());
    }

    private static final void getStyleOptions$lambda$6(StylesBuilder this$0, Consumer $onOptionSelect, BBSelectionData e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this$0.handleOption(Style.StyleOption.PAGE_SIDE, "right", $onOptionSelect, e.getWidget());
    }

    private static final void getStyleOptions$lambda$7(StylesBuilder this$0, Consumer $onOptionSelect, BBSelectionData e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this$0.handleOption(Style.StyleOption.SKIP_NUMBER_LINES, NumberLinePosition.TOP, $onOptionSelect, e.getWidget());
    }

    private static final void getStyleOptions$lambda$8(StylesBuilder this$0, Consumer $onOptionSelect, BBSelectionData e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this$0.handleOption(Style.StyleOption.SKIP_NUMBER_LINES, NumberLinePosition.BOTTOM, $onOptionSelect, e.getWidget());
    }

    private static final void getStyleOptions$lambda$9(StylesBuilder this$0, Consumer $onOptionSelect, BBSelectionData e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this$0.handleOption(Style.StyleOption.SKIP_NUMBER_LINES, NumberLinePosition.BOTH, $onOptionSelect, e.getWidget());
    }

    private static final void getStyleOptions$lambda$10(StylesBuilder this$0, Consumer $onOptionSelect, BBSelectionData e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this$0.handleOption(Style.StyleOption.SKIP_NUMBER_LINES, NumberLinePosition.NONE, $onOptionSelect, e.getWidget());
    }

    private static final void getStyleOptions$lambda$11(StylesBuilder this$0, Consumer $onOptionSelect, BBSelectionData e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this$0.handleOption(Style.StyleOption.NEW_PAGES_BEFORE, 0, $onOptionSelect, e.getWidget());
    }

    private static final void getStyleOptions$lambda$12(StylesBuilder this$0, Consumer $onOptionSelect, BBSelectionData e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this$0.handleOption(Style.StyleOption.NEW_PAGES_AFTER, 0, $onOptionSelect, e.getWidget());
    }

    private static final void getStyleOptions$lambda$13(StylesBuilder this$0, Consumer $onOptionSelect, BBSelectionData e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this$0.handleOption(Style.StyleOption.GUIDE_WORDS, true, $onOptionSelect, e.getWidget());
    }

    private static final void getStyleOptions$lambda$14(StylesBuilder this$0, Consumer $onOptionSelect, BBSelectionData e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this$0.handleOption(Style.StyleOption.GUIDE_WORDS, false, $onOptionSelect, e.getWidget());
    }

    private static final void getStyleOptions$lambda$15(StylesBuilder this$0, BBSelectionData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.wrapSelectedElements();
    }

    private static final Unit handleOption$lambda$0(Consumer $onOptionSelect, Style.StyleOption $optionKey, Widget $widget, int givenValue) {
        if (givenValue <= 0) {
            return Unit.INSTANCE;
        }
        $onOptionSelect.accept(new BBStyleOptionSelection($optionKey, givenValue, $widget));
        return Unit.INSTANCE;
    }

    static {
        Object[] objectArray = new String[]{"basic", "lists", "heading", "captions", "exerciseMaterial", "glossary", "index", "miscellaneous", "notes", "numeric", "plays", "poetry"};
        STYLES_LIST = new ArrayList(CollectionsKt.listOf((Object[])objectArray));
        String string = FileSystems.getDefault().getSeparator();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSeparator(...)");
        sep = string;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\n2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u001b\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/brailleblaster/perspectives/mvc/modules/misc/StylesBuilder$Companion;", "", "<init>", "()V", "localeHandler", "Lorg/brailleblaster/utils/localization/LocaleHandler$Companion;", "DEFAULT_STYLE_LEVELS", "", "STYLES_LIST", "", "", "INTERNAL_CATEGORY_NAME", "LEVELS_INDICATOR", "OPTIONS_CATEGORY_NAME", "sep", "getSep", "()Ljava/lang/String;", "setSep", "(Ljava/lang/String;)V", "newMenuItem", "Lorg/eclipse/swt/widgets/MenuItem;", "parent", "Lorg/eclipse/swt/widgets/Menu;", "text", "onSelect", "Ljava/util/function/Consumer;", "Lorg/eclipse/swt/events/SelectionEvent;", "DONT_SPLIT_STYLE_ID", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getSep() {
            return sep;
        }

        public final void setSep(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            sep = string;
        }

        @NotNull
        public final MenuItem newMenuItem(@Nullable Menu parent, @Nullable String text, @NotNull Consumer<SelectionEvent> onSelect) {
            Intrinsics.checkNotNullParameter(onSelect, (String)"onSelect");
            MenuItem item = new MenuItem(parent, 8);
            item.setText(text);
            EasySWT.INSTANCE.addSelectionListener(item, onSelect);
            return item;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

