/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.perspectives.mvc.modules.misc;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import org.brailleblaster.BBIni;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.exceptions.BBNotifyException;
import org.brailleblaster.frontmatter.VolumeUtils;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.perspectives.braille.messages.Sender;
import org.brailleblaster.perspectives.mvc.BBSimpleManager;
import org.brailleblaster.perspectives.mvc.SimpleEvent;
import org.brailleblaster.perspectives.mvc.events.BuildMenuEvent;
import org.brailleblaster.perspectives.mvc.events.ModifyEvent;
import org.brailleblaster.perspectives.mvc.menu.BBSelectionData;
import org.brailleblaster.perspectives.mvc.menu.MenuManager;
import org.brailleblaster.perspectives.mvc.menu.SubMenuBuilder;
import org.brailleblaster.perspectives.mvc.modules.misc.VolumeInsertModule;
import org.brailleblaster.perspectives.mvc.modules.views.DebugModule;
import org.brailleblaster.utd.exceptions.NodeException;
import org.brailleblaster.util.YesNoChoice;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/brailleblaster/perspectives/mvc/modules/misc/VolumeChangeModule;", "Lorg/brailleblaster/perspectives/mvc/BBSimpleManager$SimpleListener;", "manager", "Lorg/brailleblaster/perspectives/braille/Manager;", "<init>", "(Lorg/brailleblaster/perspectives/braille/Manager;)V", "onEvent", "", "event", "Lorg/brailleblaster/perspectives/mvc/SimpleEvent;", "changeVolumeType", "type", "Lorg/brailleblaster/bbx/BBX$VolumeType;", "deleteCurrentVolume", "Companion", "brailleblaster-core"})
public final class VolumeChangeModule
implements BBSimpleManager.SimpleListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Manager manager;
    @NotNull
    public static final String MENU_DELETE_CURRENT_VOLUME = "Delete Current Volume";

    public VolumeChangeModule(@NotNull Manager manager) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        this.manager = manager;
    }

    @Override
    public void onEvent(@NotNull SimpleEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event instanceof BuildMenuEvent && DebugModule.enabled) {
            SubMenuBuilder volumeManagerMenu = new SubMenuBuilder(VolumeInsertModule.MENU_VOLUME_MANAGER_TOP, "Volume Manager");
            SubMenuBuilder subMenuBuilder = new SubMenuBuilder(volumeManagerMenu, "Change Volume Type");
            String string = BBX.VolumeType.VOLUME.volumeMenuName;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"volumeMenuName");
            SubMenuBuilder subMenuBuilder2 = SubMenuBuilder.addItem$default(subMenuBuilder, string, 0, 0, null, arg_0 -> VolumeChangeModule.onEvent$lambda$0(this, arg_0), 12, null);
            String string2 = BBX.VolumeType.VOLUME_PRELIMINARY.volumeMenuName;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"volumeMenuName");
            SubMenuBuilder subMenuBuilder3 = SubMenuBuilder.addItem$default(subMenuBuilder2, string2, 0, 0, null, arg_0 -> VolumeChangeModule.onEvent$lambda$1(this, arg_0), 12, null);
            String string3 = BBX.VolumeType.VOLUME_SUPPLEMENTAL.volumeMenuName;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"volumeMenuName");
            volumeManagerMenu.addSubMenu(SubMenuBuilder.addItem$default(subMenuBuilder3, string3, 0, 0, null, arg_0 -> VolumeChangeModule.onEvent$lambda$2(this, arg_0), 12, null).build());
            SubMenuBuilder.addItem$default(volumeManagerMenu, MENU_DELETE_CURRENT_VOLUME, 0, 0, null, arg_0 -> VolumeChangeModule.onEvent$lambda$3(this, arg_0), 12, null);
            MenuManager.INSTANCE.add(volumeManagerMenu.build());
        }
    }

    private final void changeVolumeType(BBX.VolumeType type) {
        List<Element> volumes = VolumeUtils.getVolumeElements(this.manager.getDoc());
        if (volumes.isEmpty()) {
            throw new BBNotifyException("Document does not have any volumes");
        }
        List<VolumeUtils.VolumeData> volumeData = VolumeUtils.INSTANCE.getVolumeNames(volumes);
        Element curVolume = this.manager.getVolumeAtCursor();
        int curIndex = volumes.indexOf(curVolume);
        if (curIndex == -1) {
            throw new NodeException("Volume not found?", (Node)curVolume, null, 4, null);
        }
        VolumeUtils.VolumeData curData = volumeData.get(curIndex);
        if (curData.type == type) {
            throw new BBNotifyException("Volume is already a " + VolumeChangeModule.Companion.saneVolumeName(type));
        }
        if (curIndex != 0) {
            VolumeUtils.VolumeData previousData = volumeData.get(curIndex - 1);
            if (type.ordinal() < previousData.type.ordinal()) {
                throw new BBNotifyException("A " + VolumeChangeModule.Companion.saneVolumeName(type) + " cannot follow a " + VolumeChangeModule.Companion.saneVolumeName(previousData.type));
            }
        }
        if (curIndex != volumes.size() - 1) {
            VolumeUtils.VolumeData nextData = volumeData.get(curIndex + 1);
            if (type.ordinal() > nextData.type.ordinal()) {
                throw new BBNotifyException("A " + VolumeChangeModule.Companion.saneVolumeName(type) + " cannot precede a " + VolumeChangeModule.Companion.saneVolumeName(nextData.type));
            }
        }
        BBX.CONTAINER.VOLUME.ATTRIB_TYPE.set(curVolume, type);
        for (Element volume : volumes) {
            VolumeUtils.INSTANCE.updateEndOfVolume(volume, volumes);
        }
        this.manager.getSimpleManager().dispatchEvent(new ModifyEvent(Sender.VOLUME_CHANGE, volumes, true));
    }

    private final void deleteCurrentVolume() {
        Element element = this.manager.getVolumeAtCursor();
        if (element == null) {
            throw new BBNotifyException("No volumes found");
        }
        Element curVolume = element;
        Document doc = curVolume.getDocument();
        List<Element> volumeElements = VolumeUtils.getVolumeElements(this.manager.getDoc());
        VolumeUtils.VolumeData curVolumeData = VolumeUtils.INSTANCE.getVolumeName(volumeElements, curVolume);
        if (!BBIni.getDebugging() && !YesNoChoice.Companion.ask("Delete " + VolumeChangeModule.Companion.saneVolumeName(curVolumeData.type) + " " + curVolumeData.volumeTypeIndex)) {
            return;
        }
        if (volumeElements.size() == 2) {
            ParentNode parentNode = volumeElements.get(0).getParent();
            Intrinsics.checkNotNull((Object)parentNode, (String)"null cannot be cast to non-null type nu.xom.Element");
            Element parent = (Element)parentNode;
            for (Element volumeElement : volumeElements) {
                volumeElement.detach();
            }
            this.manager.getSimpleManager().dispatchEvent(new ModifyEvent(Sender.VOLUME_CHANGE, CollectionsKt.listOf((Object)parent), false));
        } else {
            curVolume.detach();
            volumeElements = VolumeUtils.updateEndOfVolume(doc);
            this.manager.getSimpleManager().dispatchEvent(new ModifyEvent(Sender.VOLUME_CHANGE, volumeElements, true));
        }
    }

    private static final void onEvent$lambda$0(VolumeChangeModule this$0, BBSelectionData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.changeVolumeType(BBX.VolumeType.VOLUME);
    }

    private static final void onEvent$lambda$1(VolumeChangeModule this$0, BBSelectionData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.changeVolumeType(BBX.VolumeType.VOLUME_PRELIMINARY);
    }

    private static final void onEvent$lambda$2(VolumeChangeModule this$0, BBSelectionData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.changeVolumeType(BBX.VolumeType.VOLUME_SUPPLEMENTAL);
    }

    private static final void onEvent$lambda$3(VolumeChangeModule this$0, BBSelectionData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.deleteCurrentVolume();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/brailleblaster/perspectives/mvc/modules/misc/VolumeChangeModule$Companion;", "", "<init>", "()V", "MENU_DELETE_CURRENT_VOLUME", "", "saneVolumeName", "volumeType", "Lorg/brailleblaster/bbx/BBX$VolumeType;", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        private final String saneVolumeName(BBX.VolumeType volumeType) {
            String string;
            if (volumeType == BBX.VolumeType.VOLUME) {
                string = "Regular Volume";
            } else {
                String string2 = volumeType.volumeName;
                Intrinsics.checkNotNull((Object)string2);
                string = string2;
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

