/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.printers;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import nu.xom.Document;
import org.brailleblaster.BBIni;
import org.brailleblaster.embossers.EmbossingUtils;
import org.brailleblaster.exceptions.BBNotifyException;
import org.brailleblaster.libembosser.spi.BrlCell;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.perspectives.braille.document.BrailleDocument;
import org.brailleblaster.perspectives.braille.views.wp.SixKeyHandler;
import org.brailleblaster.perspectives.mvc.menu.MenuManager;
import org.brailleblaster.perspectives.mvc.modules.misc.FontSizeModule;
import org.brailleblaster.printers.DocumentData;
import org.brailleblaster.printers.PPStatusBar;
import org.brailleblaster.settings.UTDManager;
import org.brailleblaster.settings.ui.BrailleSettingsDialog;
import org.brailleblaster.settings.ui.EmbosserSettingsTab;
import org.brailleblaster.utd.BRFWriter;
import org.brailleblaster.utd.ITranslationEngine;
import org.brailleblaster.util.ConstantsKt;
import org.brailleblaster.util.Notify;
import org.brailleblaster.util.WorkingDialog;
import org.brailleblaster.utils.PropertyFileManager;
import org.brailleblaster.utils.braille.BrailleUnicodeConverter;
import org.brailleblaster.utils.swt.AccessibilityUtils;
import org.brailleblaster.utils.swt.EasySWT;
import org.brailleblaster.utils.swt.TextBuilder;
import org.brailleblaster.wordprocessor.FontManager;
import org.brailleblaster.wordprocessor.WPManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CaretEvent;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010\b\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 X2\u00020\u0001:\u0004UVWXB+\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bB#\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\n\u0010\u0010B1\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u0015J\u0010\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020>H\u0002J\b\u0010?\u001a\u00020<H\u0002J\u0012\u0010@\u001a\u00020\"2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0003H\u0002J\u0010\u0010A\u001a\u00020<2\u0006\u0010B\u001a\u00020\u001cH\u0002J\u0006\u0010C\u001a\u00020<J\b\u0010D\u001a\u00020<H\u0002J\u0010\u0010E\u001a\u00020<2\u0006\u0010\u0006\u001a\u00020FH\u0002J\u0010\u0010G\u001a\u00020<2\u0006\u0010\u0006\u001a\u00020HH\u0002J\b\u0010I\u001a\u00020<H\u0002J\b\u0010J\u001a\u00020<H\u0002J:\u0010K\u001a\u00020<2\u0006\u0010I\u001a\u00020>2\u0006\u0010L\u001a\u00020>2\u0006\u0010M\u001a\u00020\u001c2\u0018\u0010N\u001a\u0014\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001c0OH\u0002J\b\u0010P\u001a\u00020<H\u0002J\b\u0010Q\u001a\u00020<H\u0002J\b\u0010R\u001a\u00020<H\u0002J\u0010\u0010S\u001a\u00020\u001f2\u0006\u0010T\u001a\u00020>H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u001c0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u001c0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010$\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020\u001fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u00103\u001a\b\u0012\u0004\u0012\u0002040\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u00105\u001a\u000606R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u00107\u001a\u000606R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u00108\u001a\u000606R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020:X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Y"}, d2={"Lorg/brailleblaster/printers/PrintPreview;", "", "parent", "Lorg/eclipse/swt/widgets/Shell;", "fontManager", "Lorg/brailleblaster/wordprocessor/FontManager;", "docData", "Lorg/brailleblaster/printers/DocumentData;", "m", "Lorg/brailleblaster/perspectives/braille/Manager;", "<init>", "(Lorg/eclipse/swt/widgets/Shell;Lorg/brailleblaster/wordprocessor/FontManager;Lorg/brailleblaster/printers/DocumentData;Lorg/brailleblaster/perspectives/braille/Manager;)V", "brfFile", "Ljava/nio/file/Path;", "wpManager", "Lorg/brailleblaster/wordprocessor/WPManager;", "(Lorg/eclipse/swt/widgets/Shell;Ljava/nio/file/Path;Lorg/brailleblaster/wordprocessor/WPManager;)V", "utdManager", "Lorg/brailleblaster/settings/UTDManager;", "doc", "Lnu/xom/Document;", "(Lorg/eclipse/swt/widgets/Shell;Lorg/brailleblaster/wordprocessor/FontManager;Lorg/brailleblaster/settings/UTDManager;Lnu/xom/Document;Lorg/brailleblaster/perspectives/braille/Manager;)V", "viewColorDefault", "Lorg/eclipse/swt/graphics/Color;", "viewColorDisabled", "shell", "pageStartOffsets", "", "", "brlPageOffsets", "", "", "printPageOffsets", "viewLeft", "Lorg/eclipse/swt/custom/StyledText;", "viewRight", "lastFocusedView", "nextPageButton", "Lorg/eclipse/swt/widgets/Button;", "previousPageButton", "brlPageButton", "rawPageButton", "searchSixKey", "searchSixKeyUppercase", "dualViewMenuItem", "Lorg/eclipse/swt/widgets/MenuItem;", "unicodeMenuItem", "curPage", "Lorg/eclipse/swt/widgets/Text;", "searchText", "brfOutput", "pageRanges", "Lkotlin/ranges/IntRange;", "currentViewMode", "Lorg/brailleblaster/printers/PrintPreview$ViewMode;", "dualViewMode", "singleViewMode", "ppStatusBar", "Lorg/brailleblaster/printers/PPStatusBar;", "updateFont", "", "increase", "", "setFontsInView", "newView", "jumpToAdjacentPage", "direction", "updateCurrentPage", "generateOutput", "generateOutputDoc", "Lorg/brailleblaster/printers/DocumentData$BBDocumentData;", "generateOutputBrf", "Lorg/brailleblaster/printers/DocumentData$BrfDocumentData;", "searchNext", "searchPrev", "search", "nested", "startIndex", "startIndexToFoundOffset", "Ljava/util/function/BiFunction;", "fileEmbossNow", "close", "updatePPStatusBar", "getPPStatusBarMessage", "onlyPage", "ViewMode", "DualViewMode", "SingleViewMode", "Companion", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nPrintPreview.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrintPreview.kt\norg/brailleblaster/printers/PrintPreview\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,1048:1\n1#2:1049\n777#3:1050\n873#3,2:1051\n1586#3:1053\n1661#3,3:1054\n777#3:1057\n873#3,2:1058\n2897#3,7:1060\n2045#3,14:1067\n491#4,7:1081\n491#4,7:1088\n*S KotlinDebug\n*F\n+ 1 PrintPreview.kt\norg/brailleblaster/printers/PrintPreview\n*L\n761#1:1050\n761#1:1051,2\n761#1:1053\n761#1:1054,3\n765#1:1057\n765#1:1058,2\n766#1:1060,7\n989#1:1067,14\n274#1:1081,7\n283#1:1088,7\n*E\n"})
public final class PrintPreview {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final FontManager fontManager;
    @NotNull
    private final DocumentData docData;
    @NotNull
    private final Manager m;
    @NotNull
    private final Color viewColorDefault;
    @NotNull
    private final Color viewColorDisabled;
    @NotNull
    private final Shell shell;
    @NotNull
    private final List<Integer> pageStartOffsets;
    @NotNull
    private final Map<String, Integer> brlPageOffsets;
    @NotNull
    private final Map<String, Integer> printPageOffsets;
    @NotNull
    private final StyledText viewLeft;
    @NotNull
    private final StyledText viewRight;
    @Nullable
    private StyledText lastFocusedView;
    @NotNull
    private final Button nextPageButton;
    @NotNull
    private final Button previousPageButton;
    @NotNull
    private final Button brlPageButton;
    @NotNull
    private final Button rawPageButton;
    @NotNull
    private final Button searchSixKey;
    @NotNull
    private final Button searchSixKeyUppercase;
    @NotNull
    private final MenuItem dualViewMenuItem;
    @NotNull
    private final MenuItem unicodeMenuItem;
    @NotNull
    private final Text curPage;
    @NotNull
    private final Text searchText;
    private String brfOutput;
    @NotNull
    private final List<IntRange> pageRanges;
    @NotNull
    private ViewMode currentViewMode;
    @NotNull
    private final ViewMode dualViewMode;
    @NotNull
    private final ViewMode singleViewMode;
    @NotNull
    private final PPStatusBar ppStatusBar;
    @NotNull
    private static final Logger log;
    @NotNull
    private static final String SETTINGS_KEY_DUAL_VIEW = "printpreview.dualView";
    @NotNull
    private static final String SETTINGS_KEY_PAGE_TYPE = "printpreview.pageType";
    @NotNull
    private static final String SETTINGS_KEY_UNICODE = "printpreview.unicode";
    @NotNull
    private static final String SETTINGS_KEY_SEARCH_SIX_KEY = "printpreview.searchSixKey";
    private static final int MARGIN_LINES = 2;
    private static final int MARGIN_CELLS = 3;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PrintPreview(Shell parent, FontManager fontManager, DocumentData docData, Manager m) {
        this.fontManager = fontManager;
        this.docData = docData;
        this.m = m;
        this.pageStartOffsets = new ArrayList();
        this.brlPageOffsets = new LinkedHashMap();
        this.printPageOffsets = new LinkedHashMap();
        this.pageRanges = new ArrayList();
        AutoCloseable autoCloseable = new WorkingDialog("Generating BRF");
        Throwable throwable = null;
        try {
            WorkingDialog wait = (WorkingDialog)autoCloseable;
            boolean bl = false;
            PropertyFileManager userSettings = BBIni.getPropertyFileManager();
            String pageType = userSettings.getProperty(SETTINGS_KEY_PAGE_TYPE, "rawPage");
            this.shell = new Shell(parent, 16844896);
            this.shell.setLayout((Layout)new GridLayout(2, true));
            this.shell.setText("Braille Preview");
            Menu topMenu = new Menu((Decorations)this.shell, 2);
            this.shell.setMenuBar(topMenu);
            MenuItem fileMenuItem = new MenuItem(topMenu, 64);
            fileMenuItem.setText("File");
            Menu fileMenu = new Menu(fileMenuItem);
            fileMenuItem.setMenu(fileMenu);
            MenuItem embossMenuItem = new MenuItem(fileMenu, 64);
            embossMenuItem.setText("Emboss" + MenuManager.menuItemAcceleratorSuffix(SWT.MOD1 | 0x45));
            embossMenuItem.setAccelerator(SWT.MOD1 | 0x45);
            MenuItem viewMenuItem = new MenuItem(topMenu, 64);
            viewMenuItem.setText("View");
            Menu viewMenu = new Menu(viewMenuItem);
            viewMenuItem.setMenu(viewMenu);
            this.dualViewMenuItem = new MenuItem(viewMenu, 32);
            this.dualViewMenuItem.setText("2 Page View");
            this.unicodeMenuItem = new MenuItem(viewMenu, 32);
            this.unicodeMenuItem.setText("Display as Unicode");
            MenuItem increaseFontMenuItem = new MenuItem(viewMenu, 8);
            increaseFontMenuItem.setText("Increase Font Size" + MenuManager.menuItemAcceleratorSuffix(FontSizeModule.HOTKEY_INCREASE_FONT));
            increaseFontMenuItem.setAccelerator(FontSizeModule.HOTKEY_INCREASE_FONT);
            MenuItem decreaseFontMenuItem = new MenuItem(viewMenu, 8);
            decreaseFontMenuItem.setText("Decrease Font Size" + MenuManager.menuItemAcceleratorSuffix(FontSizeModule.HOTKEY_DECREASE_FONT));
            decreaseFontMenuItem.setAccelerator(FontSizeModule.HOTKEY_DECREASE_FONT);
            Composite settingsWrapper = new Composite((Composite)this.shell, 0);
            settingsWrapper.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
            settingsWrapper.setLayout((Layout)new GridLayout(1, false));
            Composite pageNavPanel = new Composite(settingsWrapper, 0);
            pageNavPanel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false, 1, 1));
            RowLayout rowLayout = new RowLayout();
            rowLayout.center = true;
            pageNavPanel.setLayout((Layout)rowLayout);
            this.curPage = (Text)((TextBuilder)EasySWT.INSTANCE.makeTextBuilder(pageNavPanel, 2052).rowDataWidth(EasySWT.INSTANCE.calcAverageCharWidth((Composite)this.shell) * 5)).get();
            Label pageOf = new Label(pageNavPanel, 0);
            pageOf.setText("of");
            Label pageTotal = new Label(pageNavPanel, 0);
            this.previousPageButton = new Button(pageNavPanel, 0);
            this.previousPageButton.setText("Previous Page");
            this.nextPageButton = new Button(pageNavPanel, 0);
            this.nextPageButton.setText("Next Page");
            Button printPageButton = new Button(pageNavPanel, 16);
            printPageButton.setText("Print Page Number");
            if (Intrinsics.areEqual((Object)pageType, (Object)"printPage")) {
                printPageButton.setSelection(true);
            }
            this.brlPageButton = new Button(pageNavPanel, 16);
            this.brlPageButton.setText("Braille Page Number");
            if (Intrinsics.areEqual((Object)pageType, (Object)"braillePage")) {
                this.brlPageButton.setSelection(true);
            }
            this.rawPageButton = new Button(pageNavPanel, 16);
            this.rawPageButton.setText("Ordinal Page Number");
            if (Intrinsics.areEqual((Object)pageType, (Object)"rawPage")) {
                this.rawPageButton.setSelection(true);
            }
            Composite findPanel = new Composite(settingsWrapper, 0);
            findPanel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false, 1, 1));
            rowLayout = new RowLayout();
            rowLayout.center = true;
            findPanel.setLayout((Layout)rowLayout);
            EasySWT.INSTANCE.newLabel(findPanel, "Find:");
            this.searchText = (Text)((TextBuilder)EasySWT.INSTANCE.makeTextBuilder(findPanel, 2052).rowDataWidth(EasySWT.INSTANCE.calcAverageCharWidth((Composite)this.shell) * 20)).get();
            Button searchPrev = new Button(findPanel, 0);
            searchPrev.setText("Previous");
            searchPrev.setToolTipText("Search Previous");
            Button searchNext = new Button(findPanel, 0);
            searchNext.setText("Next");
            searchNext.setToolTipText("Search Next");
            this.searchSixKey = new Button(findPanel, 32);
            this.searchSixKey.setText("Six Key");
            this.searchSixKey.setSelection(BBIni.getPropertyFileManager().getPropertyAsBoolean(SETTINGS_KEY_SEARCH_SIX_KEY, true));
            this.searchSixKeyUppercase = new Button(findPanel, 32);
            this.searchSixKeyUppercase.setText("Uppercase");
            this.viewLeft = this.newView(this.shell);
            this.viewRight = this.newView(this.shell);
            Color color = this.viewLeft.getBackground();
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getBackground(...)");
            this.viewColorDefault = color;
            Color color2 = Display.getCurrent().getSystemColor(15);
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getSystemColor(...)");
            this.viewColorDisabled = color2;
            this.ppStatusBar = new PPStatusBar(this.shell);
            this.dualViewMenuItem.setSelection(Boolean.parseBoolean(userSettings.getProperty(SETTINGS_KEY_DUAL_VIEW, "true")));
            this.singleViewMode = new SingleViewMode();
            this.dualViewMode = new DualViewMode();
            this.currentViewMode = this.dualViewMenuItem.getSelection() ? this.dualViewMode : this.singleViewMode;
            this.shell.addTraverseListener(arg_0 -> PrintPreview.lambda$0$0(this, arg_0));
            this.shell.addListener(21, arg_0 -> PrintPreview.lambda$0$1(this, arg_0));
            this.curPage.addTraverseListener(arg_0 -> PrintPreview.lambda$0$2(this, arg_0));
            EasySWT.INSTANCE.addSelectionListener(embossMenuItem, arg_0 -> PrintPreview.lambda$0$3(this, arg_0));
            EasySWT.addSelectionListener((Button)this.nextPageButton, arg_0 -> PrintPreview.lambda$0$4(this, arg_0));
            EasySWT.addSelectionListener((Button)this.previousPageButton, arg_0 -> PrintPreview.lambda$0$5(this, arg_0));
            EasySWT.addSelectionListener((Button)this.brlPageButton, arg_0 -> PrintPreview.lambda$0$6(this, arg_0));
            EasySWT.addSelectionListener((Button)printPageButton, arg_0 -> PrintPreview.lambda$0$7(this, arg_0));
            EasySWT.addSelectionListener((Button)this.rawPageButton, arg_0 -> PrintPreview.lambda$0$8(this, arg_0));
            EasySWT.addSelectionListener((Button)this.brlPageButton, PrintPreview::lambda$0$9);
            EasySWT.addSelectionListener((Button)printPageButton, PrintPreview::lambda$0$10);
            EasySWT.addSelectionListener((Button)this.rawPageButton, PrintPreview::lambda$0$11);
            EasySWT.INSTANCE.addSelectionListener(this.dualViewMenuItem, arg_0 -> PrintPreview.lambda$0$12(this, arg_0));
            EasySWT.addSelectionListener((Button)searchPrev, arg_0 -> PrintPreview.lambda$0$13(this, arg_0));
            EasySWT.addSelectionListener((Button)searchNext, arg_0 -> PrintPreview.lambda$0$14(this, arg_0));
            SixKeyHandler skh = new SixKeyHandler(null, null, this.searchSixKey.getSelection());
            this.searchText.addKeyListener((KeyListener)skh);
            this.searchText.addVerifyListener((VerifyListener)skh);
            EasySWT.addSelectionListener((Button)this.searchSixKey, arg_0 -> PrintPreview.lambda$0$15(this, skh, arg_0));
            EasySWT.INSTANCE.addSelectionListener(this.unicodeMenuItem, arg_0 -> PrintPreview.lambda$0$16(this, arg_0));
            this.viewLeft.addCaretListener(arg_0 -> PrintPreview.lambda$0$17(this, arg_0));
            ScrollBar scrollBar = this.viewLeft.getVerticalBar();
            Intrinsics.checkNotNullExpressionValue((Object)scrollBar, (String)"getVerticalBar(...)");
            EasySWT.INSTANCE.addSelectionListener(scrollBar, arg_0 -> PrintPreview.lambda$0$18(this, arg_0));
            EasySWT.INSTANCE.addSelectionListener(increaseFontMenuItem, arg_0 -> PrintPreview.lambda$0$19(this, arg_0));
            EasySWT.INSTANCE.addSelectionListener(decreaseFontMenuItem, arg_0 -> PrintPreview.lambda$0$20(this, arg_0));
            this.unicodeMenuItem.setSelection(Boolean.parseBoolean(userSettings.getProperty(SETTINGS_KEY_UNICODE, "false")));
            try {
                this.generateOutput();
            }
            catch (Exception e) {
                wait.finished();
                throw new RuntimeException("Failed to write brf", e);
            }
            this.curPage.setText("1");
            pageTotal.setText("" + this.pageStartOffsets.size());
            if (this.docData instanceof DocumentData.BrfDocumentData) {
                this.rawPageButton.setSelection(true);
                this.brlPageButton.setEnabled(false);
                printPageButton.setEnabled(false);
                this.unicodeMenuItem.setEnabled(false);
            }
            this.currentViewMode.onModeChange();
            boolean bl2 = this.viewRight.isVisible() || this.viewLeft.getBackground() == this.viewColorDisabled ? this.viewRight.setFocus() : this.viewLeft.setFocus();
            EasySWT.INSTANCE.setLargeDialogSize(this.shell);
            this.shell.open();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    public PrintPreview(@NotNull Shell parent, @Nullable Path brfFile, @NotNull WPManager wpManager) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)wpManager, (String)"wpManager");
        Path path = brfFile;
        Intrinsics.checkNotNull((Object)path);
        this(parent, null, new DocumentData.BrfDocumentData(path), wpManager.getController());
    }

    public PrintPreview(@NotNull Shell parent, @NotNull FontManager fontManager, @NotNull UTDManager utdManager, @NotNull Document doc, @NotNull Manager m) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)fontManager, (String)"fontManager");
        Intrinsics.checkNotNullParameter((Object)utdManager, (String)"utdManager");
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        this(parent, fontManager, new DocumentData.BBDocumentData(utdManager, doc), m);
    }

    private final void updateFont(boolean increase) {
        if (increase) {
            if (this.fontManager != null) {
                this.fontManager.increaseFont();
            } else {
                FontManager.Companion.increaseFontSetting();
            }
        } else if (this.fontManager != null) {
            this.fontManager.decreaseFont();
        } else {
            FontManager.Companion.decreaseFontSetting();
        }
        this.setFontsInView();
        EasySWT.INSTANCE.setLargeDialogSize(this.shell);
    }

    private final void setFontsInView() {
        Font curFont = this.fontManager != null ? (FontManager.Companion.isShowBraille() ? this.fontManager.getM().getBrailleView().getFont() : this.fontManager.getM().getTextView().getFont()) : (FontManager.Companion.isShowBraille() ? FontManager.Companion.newBrailleFont() : FontManager.Companion.newTextFont());
        this.viewLeft.setFont(curFont);
        this.viewRight.setFont(curFont);
    }

    private final StyledText newView(Shell shell) {
        StyledText view = new StyledText((Composite)shell, 2824);
        view.setAlwaysShowScrollBars(false);
        view.setAlwaysShowScrollBars(false);
        view.setWordWrap(false);
        view.setEditable(false);
        GridData viewData = new GridData();
        viewData.horizontalAlignment = 4;
        viewData.verticalAlignment = 4;
        viewData.grabExcessHorizontalSpace = true;
        viewData.grabExcessVerticalSpace = true;
        view.setLayoutData((Object)viewData);
        int marginH = EasySWT.calcAverageCharHeight((Composite)((Composite)shell)) * 2;
        int marginW = EasySWT.INSTANCE.calcAverageCharWidth((Composite)shell) * 3;
        view.setMargins(marginW, marginH, marginW, marginH);
        view.addVerifyKeyListener(arg_0 -> PrintPreview.newView$lambda$0(this, arg_0));
        view.addFocusListener((FocusListener)new FocusAdapter(view, this){
            final /* synthetic */ StyledText $view;
            final /* synthetic */ PrintPreview this$0;
            {
                this.$view = $view;
                this.this$0 = $receiver;
            }

            public void focusGained(FocusEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (this.$view.getBackground() != PrintPreview.access$getViewColorDisabled$p(this.this$0)) {
                    PrintPreview.access$getLog$cp().debug("Switching view");
                    PrintPreview.access$setLastFocusedView$p(this.this$0, this.$view);
                }
            }
        });
        view.addCaretListener(arg_0 -> PrintPreview.newView$lambda$1(this, arg_0));
        view.addMouseWheelListener(arg_0 -> PrintPreview.newView$lambda$2(this, arg_0));
        return view;
    }

    private final void jumpToAdjacentPage(int direction) {
        if (!(direction != 0)) {
            boolean bl = false;
            String string = "direction == 0";
            throw new IllegalArgumentException(string.toString());
        }
        this.currentViewMode.doJumpToAdjacentPage(direction);
        this.updateCurrentPage();
    }

    /*
     * WARNING - void declaration
     */
    public final void updateCurrentPage() {
        int offset = this.currentViewMode.getTotalOffset();
        if (this.rawPageButton.getSelection()) {
            for (IntRange curPageRange : this.pageRanges) {
                if (offset >= curPageRange.getLast()) continue;
                int pageNum = this.pageRanges.indexOf(curPageRange);
                this.curPage.setText("" + (pageNum + 1));
                break;
            }
        } else {
            Object v2;
            void $this$reduceOrNull$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            void $this$mapTo$iv$iv;
            IntRange e;
            Iterable $this$filterTo$iv$iv2;
            Iterable $this$filter$iv2 = this.pageRanges;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv2;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                e = (IntRange)element$iv$iv;
                boolean bl = false;
                int n = e.getFirst();
                boolean bl2 = offset <= e.getLast() ? n <= offset : false;
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map22 = false;
            $this$filterTo$iv$iv2 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                e = (IntRange)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(e.getLast());
            }
            Integer n = (Integer)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
            int pageEnd = n != null ? n : offset;
            Map<String, Integer> lookup = this.brlPageButton.getSelection() ? this.brlPageOffsets : this.printPageOffsets;
            Iterable $i$f$map22 = lookup.entrySet();
            boolean $i$f$filter2 = false;
            destination$iv$iv = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo22 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Map.Entry entry = (Map.Entry)element$iv$iv;
                boolean bl = false;
                int v = ((Number)entry.getValue()).intValue();
                if (!(v <= pageEnd)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv2;
            boolean $i$f$reduceOrNull = false;
            Iterator iterator$iv = $this$reduceOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v2 = null;
            } else {
                Object accumulator$iv = iterator$iv.next();
                while (iterator$iv.hasNext()) {
                    void b;
                    Map.Entry $i$f$filterTo22 = (Map.Entry)iterator$iv.next();
                    Map.Entry cfr_ignored_0 = (Map.Entry)accumulator$iv;
                    boolean bl = false;
                    accumulator$iv = b;
                }
                v2 = accumulator$iv;
            }
            Map.Entry entry = v2;
            if (entry != null) {
                Map.Entry entry2 = entry;
                boolean bl = false;
                String k = (String)entry2.getKey();
                this.curPage.setText(k);
            }
        }
        this.updatePPStatusBar();
    }

    private final void generateOutput() throws IOException {
        this.setFontsInView();
        if (this.docData instanceof DocumentData.BrfDocumentData) {
            this.generateOutputBrf((DocumentData.BrfDocumentData)this.docData);
        } else {
            DocumentData documentData = this.docData;
            Intrinsics.checkNotNull((Object)documentData, (String)"null cannot be cast to non-null type org.brailleblaster.printers.DocumentData.BBDocumentData");
            this.generateOutputDoc((DocumentData.BBDocumentData)documentData);
        }
    }

    private final void generateOutputDoc(DocumentData.BBDocumentData docData) throws IOException {
        log.info("Dumping dom to BRF");
        this.pageStartOffsets.clear();
        this.brlPageOffsets.clear();
        this.printPageOffsets.clear();
        this.pageRanges.clear();
        this.pageStartOffsets.add(0);
        StringBuilder output = new StringBuilder();
        ITranslationEngine.toBRF$default((ITranslationEngine)((ITranslationEngine)docData.getUtdManager().getEngine()), (Document)docData.getDocument(), arg_0 -> PrintPreview.generateOutputDoc$lambda$0(this, output, arg_0), (int)(this.unicodeMenuItem.getSelection() ? 4 : 0), (BRFWriter.PageListener)new BRFWriter.PageListener(output, this){
            final /* synthetic */ StringBuilder $output;
            final /* synthetic */ PrintPreview this$0;
            {
                this.$output = $output;
                this.this$0 = $receiver;
            }

            public void onBrlPageNum(String brlPageBraille, String brlPageOrig) {
                Intrinsics.checkNotNullParameter((Object)brlPageBraille, (String)"brlPageBraille");
                Intrinsics.checkNotNullParameter((Object)brlPageOrig, (String)"brlPageOrig");
                PrintPreview.access$getLog$cp().trace("At length {} braille page {}", (Object)this.$output.length(), (Object)brlPageOrig);
                PrintPreview.access$getBrlPageOffsets$p(this.this$0).put(brlPageOrig, this.$output.length());
            }

            public void onPrintPageNum(String printPageBraille, String printPageOrig) {
                Intrinsics.checkNotNullParameter((Object)printPageBraille, (String)"printPageBraille");
                Intrinsics.checkNotNullParameter((Object)printPageOrig, (String)"printPageOrig");
                Object[] objectArray = new Object[]{this.$output.length(), printPageBraille, printPageOrig};
                PrintPreview.access$getLog$cp().trace("At length {} print braille {} orig {}", objectArray);
                PrintPreview.access$getPrintPageOffsets$p(this.this$0).put(printPageOrig, this.$output.length());
            }
        }, (boolean)false, (int)16, null);
        this.pageStartOffsets.remove(this.pageStartOffsets.size() - 1);
        String string = output.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        this.brfOutput = string;
        this.currentViewMode.onGenerate();
        this.searchSixKeyUppercase.setSelection(false);
        this.searchSixKeyUppercase.setEnabled(false);
    }

    private final void generateOutputBrf(DocumentData.BrfDocumentData docData) throws IOException {
        log.info("Parsing brf file");
        this.pageStartOffsets.clear();
        this.brlPageOffsets.clear();
        this.printPageOffsets.clear();
        this.pageRanges.clear();
        this.brfOutput = PathsKt.readText((Path)docData.getBrfFile(), (Charset)Charsets.UTF_8);
        int pageStart = 0;
        int pageEnd = 0;
        while (true) {
            int n;
            String string;
            if ((string = this.brfOutput) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"brfOutput");
                string = null;
            }
            int it = n = StringsKt.indexOf$default((CharSequence)string, (char)'\f', (int)pageStart, (boolean)false, (int)4, null);
            boolean bl = false;
            pageEnd = it;
            if (n == -1) break;
            this.pageRanges.add(new IntRange(pageStart, pageEnd));
            pageStart = pageEnd + 1;
            this.pageStartOffsets.add(pageStart);
        }
        if (this.pageStartOffsets.isEmpty()) {
            this.pageStartOffsets.add(0);
            String string = this.brfOutput;
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"brfOutput");
                string = null;
            }
            this.pageRanges.add(new IntRange(0, string.length()));
        }
        if (((Number)this.pageStartOffsets.get(0)).intValue() != 0) {
            this.pageStartOffsets.add(0, 0);
        }
        this.currentViewMode.onGenerate();
        Boolean uppercaseMode = null;
        String string = this.brfOutput;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"brfOutput");
            string = null;
        }
        String string2 = string;
        int n = string2.length();
        block4: for (int i = 0; i < n; ++i) {
            char element = string2.charAt(i);
            switch (element) {
                case '\n': 
                case '\r': {
                    continue block4;
                }
                default: {
                    if (StringsKt.indexOf$default((CharSequence)" A1B'K2L@CIF/MSP\"E3H9O6R^DJG>NTQ,*5<-U8V.%[$+X!&;:4\\0Z7(_?W]#Y)=", (char)element, (int)0, (boolean)false, (int)6, null) == -1) {
                        log.info("Uppercase mode failed on character '{}' {}", (Object)Character.valueOf(element), (Object)Character.getName(element));
                        uppercaseMode = false;
                        break block4;
                    }
                    if (StringsKt.indexOf$default((CharSequence)BrailleUnicodeConverter.LOWERCASE_ASCII_BRAILLE, (char)element, (int)0, (boolean)false, (int)6, null) != -1) continue block4;
                    log.info("Lowercase mode failed on character '{}' {}", (Object)Character.valueOf(element), (Object)Character.getName(element));
                    uppercaseMode = true;
                    break block4;
                }
            }
        }
        if (uppercaseMode == null) {
            log.error("No mode failed, defaulting to liblouis");
            uppercaseMode = false;
        }
        this.searchSixKeyUppercase.setSelection(uppercaseMode.booleanValue());
    }

    private final void searchNext() {
        this.search(true, false, this.currentViewMode.searchGetStart(), (arg_0, arg_1) -> PrintPreview.searchNext$lambda$0(this, arg_0, arg_1));
    }

    private final void searchPrev() {
        this.search(false, false, this.currentViewMode.searchGetStart(), (arg_0, arg_1) -> PrintPreview.searchPrev$lambda$0(this, arg_0, arg_1));
    }

    private final void search(boolean searchNext, boolean nested, int startIndex, BiFunction<String, Integer, Integer> startIndexToFoundOffset) {
        String needle;
        String string = needle = this.searchText.getText();
        Intrinsics.checkNotNull((Object)string);
        if (((CharSequence)string).length() == 0) {
            throw new BBNotifyException("No search text entered");
        }
        if (this.searchSixKey.getSelection()) {
            String string2;
            String oldNeedle = needle;
            if (this.searchSixKeyUppercase.getSelection()) {
                var7_8 = needle;
                Intrinsics.checkNotNull((Object)var7_8);
                string2 = BrailleUnicodeConverter.INSTANCE.unicodeToAsciiUppercase(var7_8);
            } else {
                var7_8 = needle;
                Intrinsics.checkNotNull((Object)var7_8);
                string2 = BrailleUnicodeConverter.INSTANCE.unicodeToAsciiLouis(var7_8);
            }
            needle = string2;
            log.info("Mapped six key input '{}' to '{}'", (Object)oldNeedle, (Object)needle);
        } else {
            String string3 = needle;
            Intrinsics.checkNotNull((Object)string3);
            char[] cArray = string3.toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
            char[] charMap = cArray;
            int n = charMap.length;
            for (int i = 0; i < n; ++i) {
                int it;
                int n2;
                char c = charMap[i];
                int index = 0;
                if (this.searchSixKeyUppercase.getSelection()) {
                    it = n2 = StringsKt.indexOf$default((CharSequence)BrailleUnicodeConverter.LOWERCASE_ASCII_BRAILLE, (char)c, (int)0, (boolean)false, (int)6, null);
                    boolean bl = false;
                    index = it;
                    if (n2 != -1) {
                        charMap[i] = " A1B'K2L@CIF/MSP\"E3H9O6R^DJG>NTQ,*5<-U8V.%[$+X!&;:4\\0Z7(_?W]#Y)=".charAt(index);
                        continue;
                    }
                }
                if (this.searchSixKeyUppercase.getSelection()) continue;
                it = n2 = StringsKt.indexOf$default((CharSequence)" A1B'K2L@CIF/MSP\"E3H9O6R^DJG>NTQ,*5<-U8V.%[$+X!&;:4\\0Z7(_?W]#Y)=", (char)c, (int)0, (boolean)false, (int)6, null);
                boolean bl = false;
                index = it;
                if (n2 == -1) continue;
                charMap[i] = BrailleUnicodeConverter.LOWERCASE_ASCII_BRAILLE.charAt(index);
            }
            needle = new String(charMap);
        }
        Integer n = startIndexToFoundOffset.apply(needle, startIndex);
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"apply(...)");
        int foundOffset = ((Number)n).intValue();
        if (foundOffset == -1) {
            int n3;
            log.info("Text '{}' not found from startIndex {}", (Object)needle, (Object)startIndex);
            if (nested) {
                throw new BBNotifyException("Not found");
            }
            if (searchNext) {
                n3 = 0;
            } else {
                String string4 = this.brfOutput;
                if (string4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"brfOutput");
                    string4 = null;
                }
                n3 = string4.length();
            }
            int newStartIndex = n3;
            this.search(searchNext, true, newStartIndex, startIndexToFoundOffset);
            return;
        }
        this.currentViewMode.goToOffset(foundOffset);
        this.currentViewMode.seachSetCaret(foundOffset, needle);
    }

    private final void fileEmbossNow() {
        if (this.docData instanceof DocumentData.BBDocumentData) {
            BrailleDocument brailleDocument = this.m.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)brailleDocument, (String)"getDocument(...)");
            v1 = EmbossingUtils.emboss(brailleDocument, this.m.getDocument().getEngine(), this.shell, arg_0 -> PrintPreview.fileEmbossNow$lambda$0(this, arg_0));
        } else {
            String longestLine;
            Object v4;
            String string = this.brfOutput;
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"brfOutput");
                string = null;
            }
            String string2 = string;
            int n = 0;
            int n2 = ((Number)this.pageStartOffsets.get(1)).intValue();
            String string3 = string2.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            String firstPage = string3;
            String[] stringArray = new String[]{ConstantsKt.getLINE_BREAK()};
            List lines = StringsKt.split$default((CharSequence)firstPage, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            Iterable $this$maxByOrNull$iv = lines;
            boolean $i$f$maxByOrNull = false;
            Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v4 = null;
            } else {
                Object maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v4 = maxElem$iv;
                } else {
                    String it = (String)maxElem$iv;
                    boolean bl = false;
                    int maxValue$iv = it.length();
                    do {
                        Object e$iv = iterator$iv.next();
                        String it2 = (String)e$iv;
                        $i$a$-maxByOrNull-PrintPreview$fileEmbossNow$longestLine$1 = false;
                        int v$iv = it2.length();
                        if (maxValue$iv >= v$iv) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v4 = maxElem$iv;
                }
            }
            String string4 = longestLine = (String)v4;
            Intrinsics.checkNotNull((Object)string4);
            int cellsPerLine = string4.length();
            int linesPerPage = lines.size() - 1;
            BrlCell cellType = this.m.getDocument().getEngine().getBrailleSettings().getCellType();
            BigDecimal bigDecimal = BigDecimal.valueOf((double)linesPerPage);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(...)");
            BigDecimal maxValue$iv = bigDecimal;
            BigDecimal bigDecimal2 = cellType.getHeight();
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"getHeight(...)");
            BigDecimal bigDecimal3 = maxValue$iv.multiply(bigDecimal2);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal3, (String)"multiply(...)");
            BigDecimal minPaperHeight = bigDecimal3.setScale(2, RoundingMode.HALF_UP);
            BigDecimal bigDecimal4 = BigDecimal.valueOf((double)cellsPerLine);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal4, (String)"valueOf(...)");
            BigDecimal bigDecimal5 = bigDecimal4;
            BigDecimal bigDecimal6 = cellType.getWidth();
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal6, (String)"getWidth(...)");
            BigDecimal bigDecimal7 = bigDecimal5.multiply(bigDecimal6);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal7, (String)"multiply(...)");
            BigDecimal minPaperWidth = bigDecimal7.setScale(2, RoundingMode.HALF_UP);
            log.info("BRF minimum paper size (mm): " + minPaperWidth + " x " + minPaperHeight);
            Intrinsics.checkNotNull((Object)minPaperHeight);
            Intrinsics.checkNotNull((Object)minPaperWidth);
            DocumentData documentData = this.docData;
            Intrinsics.checkNotNull((Object)documentData, (String)"null cannot be cast to non-null type org.brailleblaster.printers.DocumentData.BrfDocumentData");
            v1 = EmbossingUtils.INSTANCE.embossBrf(minPaperHeight, minPaperWidth, ((DocumentData.BrfDocumentData)documentData).getBrfFile(), (ITranslationEngine)this.m.getDocument().getEngine(), this.shell, arg_0 -> PrintPreview.fileEmbossNow$lambda$2(this, arg_0));
        }
    }

    private final void close() {
        this.shell.dispose();
    }

    private final void updatePPStatusBar() {
        if (!Intrinsics.areEqual((Object)this.ppStatusBar.getStatusBar().getText(), (Object)this.getPPStatusBarMessage(false))) {
            this.ppStatusBar.setText(this.getPPStatusBarMessage(false));
            if (this.lastFocusedView != null) {
                StyledText styledText = this.lastFocusedView;
                Intrinsics.checkNotNull((Object)styledText);
                AccessibilityUtils.setName((Control)((Control)styledText), (String)this.getPPStatusBarMessage(true));
            }
        }
    }

    private final String getPPStatusBarMessage(boolean onlyPage) {
        Object message = "";
        String page = this.curPage.getText();
        message = (String)message + "Page " + page;
        if (this.lastFocusedView != null && !onlyPage) {
            StyledText styledText = this.lastFocusedView;
            Intrinsics.checkNotNull((Object)styledText);
            StyledText styledText2 = this.lastFocusedView;
            Intrinsics.checkNotNull((Object)styledText2);
            int line = styledText.getLineAtOffset(styledText2.getCaretOffset()) + 1;
            StyledText styledText3 = this.lastFocusedView;
            Intrinsics.checkNotNull((Object)styledText3);
            int n = styledText3.getCaretOffset();
            StyledText styledText4 = this.lastFocusedView;
            Intrinsics.checkNotNull((Object)styledText4);
            int cellNumber = n - styledText4.getOffsetAtLine(line - 1) + 1;
            message = (String)message + " | Line " + line + " | Cell Number " + cellNumber;
        }
        return message;
    }

    private static final void lambda$0$0(PrintPreview this$0, TraverseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e.keyCode == 27) {
            this$0.close();
        }
    }

    private static final void lambda$0$1(PrintPreview this$0, Event it) {
        this$0.close();
    }

    private static final void lambda$0$2(PrintPreview this$0, TraverseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e.detail != 4) {
            return;
        }
        String raw = this$0.curPage.getText();
        int offset = 0;
        if (this$0.rawPageButton.getSelection()) {
            int requestedPage = 0;
            try {
                Intrinsics.checkNotNull((Object)raw);
                requestedPage = Integer.parseInt(raw);
            }
            catch (NumberFormatException numberFormatException) {
                Notify.showMessage(raw + " is not a number", new Object[0]);
                return;
            }
            if (requestedPage > this$0.pageStartOffsets.size()) {
                Notify.showMessage("Page " + requestedPage + " is too big", new Object[0]);
                return;
            }
            offset = ((Number)this$0.pageStartOffsets.get(requestedPage - 1)).intValue();
        } else if (this$0.brlPageButton.getSelection()) {
            Object[] $this$filterKeys$iv = this$0.brlPageOffsets;
            boolean $i$f$filterKeys = false;
            LinkedHashMap<String, Integer> result$iv = new LinkedHashMap<String, Integer>();
            for (Map.Entry<String, Integer> entry$iv : $this$filterKeys$iv.entrySet()) {
                String key = entry$iv.getKey();
                boolean bl = false;
                if (!StringsKt.equals((String)key, (String)raw, (boolean)true)) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            Integer result = (Integer)CollectionsKt.firstOrNull((Iterable)((Map)result$iv).values());
            if (result == null) {
                $this$filterKeys$iv = new Object[]{raw};
                Notify.showMessage("Braille page {} does not exist", $this$filterKeys$iv);
                return;
            }
            offset = result;
        } else {
            Map<String, Integer> $this$filterKeys$iv = this$0.printPageOffsets;
            boolean $i$f$filterKeys = false;
            LinkedHashMap<String, Integer> result$iv = new LinkedHashMap<String, Integer>();
            for (Map.Entry<String, Integer> entry$iv : $this$filterKeys$iv.entrySet()) {
                String key = entry$iv.getKey();
                boolean bl = false;
                if (!StringsKt.equals((String)key, (String)raw, (boolean)true)) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            Integer result = (Integer)CollectionsKt.firstOrNull((Iterable)((Map)result$iv).values());
            if (result == null) {
                Object[] objectArray = new Object[]{raw};
                Notify.showMessage("Print page {} does not exist", objectArray);
                return;
            }
            offset = result;
        }
        log.info("current view {}", this$0.currentViewMode.getClass());
        this$0.currentViewMode.goToOffset(offset);
    }

    private static final void lambda$0$3(PrintPreview this$0, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.fileEmbossNow();
    }

    private static final void lambda$0$4(PrintPreview this$0, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.jumpToAdjacentPage(1);
    }

    private static final void lambda$0$5(PrintPreview this$0, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.jumpToAdjacentPage(-1);
    }

    private static final void lambda$0$6(PrintPreview this$0, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.updateCurrentPage();
    }

    private static final void lambda$0$7(PrintPreview this$0, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.updateCurrentPage();
    }

    private static final void lambda$0$8(PrintPreview this$0, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.updateCurrentPage();
    }

    private static final void lambda$0$9(SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        BBIni.getPropertyFileManager().save(SETTINGS_KEY_PAGE_TYPE, "braillePage");
    }

    private static final void lambda$0$10(SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        BBIni.getPropertyFileManager().save(SETTINGS_KEY_PAGE_TYPE, "printPage");
    }

    private static final void lambda$0$11(SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        BBIni.getPropertyFileManager().save(SETTINGS_KEY_PAGE_TYPE, "rawPage");
    }

    private static final void lambda$0$12(PrintPreview this$0, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        BBIni.getPropertyFileManager().save(SETTINGS_KEY_DUAL_VIEW, String.valueOf(this$0.dualViewMenuItem.getSelection()));
        this$0.currentViewMode = this$0.dualViewMenuItem.getSelection() ? this$0.dualViewMode : this$0.singleViewMode;
        this$0.currentViewMode.onModeChange();
        this$0.currentViewMode.onGenerate();
        this$0.shell.setSize(this$0.shell.computeSize(-1, -1));
        this$0.shell.pack(true);
    }

    private static final void lambda$0$13(PrintPreview this$0, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.searchPrev();
    }

    private static final void lambda$0$14(PrintPreview this$0, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.searchNext();
    }

    private static final void lambda$0$15(PrintPreview this$0, SixKeyHandler $skh, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        boolean sixKeyMode = this$0.searchSixKey.getSelection();
        BBIni.getPropertyFileManager().saveAsBoolean(SETTINGS_KEY_SEARCH_SIX_KEY, sixKeyMode);
        $skh.setSixKeyMode(sixKeyMode);
        this$0.searchText.setText("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void lambda$0$16(PrintPreview this$0, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        boolean isUnicodeSelected = this$0.unicodeMenuItem.getSelection();
        BBIni.getPropertyFileManager().save(SETTINGS_KEY_UNICODE, String.valueOf(isUnicodeSelected));
        try {
            AutoCloseable autoCloseable = new WorkingDialog("Re-generating BRF with unicode " + (isUnicodeSelected ? "enabled" : "disabled"));
            Throwable throwable = null;
            try {
                WorkingDialog it2 = (WorkingDialog)autoCloseable;
                boolean bl = false;
                this$0.generateOutput();
                this$0.shell.setActive();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to refresh view, unicode " + isUnicodeSelected, ex);
        }
    }

    private static final void lambda$0$17(PrintPreview this$0, CaretEvent it) {
        this$0.updateCurrentPage();
    }

    private static final void lambda$0$18(PrintPreview this$0, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.updateCurrentPage();
    }

    private static final void lambda$0$19(PrintPreview this$0, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.updateFont(true);
    }

    private static final void lambda$0$20(PrintPreview this$0, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.updateFont(false);
    }

    private static final void newView$lambda$0(PrintPreview this$0, VerifyEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e.stateMask == SWT.MOD1 && e.keyCode == 113) {
            e.doit = false;
            this$0.close();
        } else if (e.keyCode == 0x1000005) {
            e.doit = false;
            log.debug("Triggered on page up");
            this$0.jumpToAdjacentPage(-1);
        } else if (e.keyCode == 0x1000006) {
            e.doit = false;
            log.debug("Triggered on page down");
            this$0.jumpToAdjacentPage(1);
        }
    }

    private static final void newView$lambda$1(PrintPreview this$0, CaretEvent it) {
        this$0.updatePPStatusBar();
    }

    private static final void newView$lambda$2(PrintPreview this$0, MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e.count == 0) {
            return;
        }
        this$0.jumpToAdjacentPage(e.count * -1);
    }

    private static final void generateOutputDoc$lambda$0(PrintPreview this$0, StringBuilder $output, char onChar) {
        if (onChar == '\f') {
            int lastPageStart = ((Number)this$0.pageStartOffsets.get(this$0.pageStartOffsets.size() - 1)).intValue();
            int lastPageEnd = $output.length();
            this$0.pageRanges.add(new IntRange(lastPageStart, lastPageEnd));
            v0 = this$0.pageStartOffsets.add($output.length());
        } else {
            v0 = $output.append(onChar);
        }
    }

    private static final Integer searchNext$lambda$0(PrintPreview this$0, String needle, int startIndex) {
        String string = this$0.brfOutput;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"brfOutput");
            string = null;
        }
        CharSequence charSequence = string;
        String string2 = needle;
        Intrinsics.checkNotNull((Object)string2);
        return StringsKt.indexOf$default((CharSequence)charSequence, (String)string2, (int)(startIndex + 1), (boolean)false, (int)4, null);
    }

    private static final Integer searchPrev$lambda$0(PrintPreview this$0, String needle, int startIndex) {
        String string = this$0.brfOutput;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"brfOutput");
            string = null;
        }
        String string2 = string;
        int n = 0;
        int n2 = startIndex <= 0 ? 0 : startIndex - 1;
        String string3 = string2.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        CharSequence charSequence = string3;
        String string4 = needle;
        Intrinsics.checkNotNull((Object)string4);
        return StringsKt.lastIndexOf$default((CharSequence)charSequence, (String)string4, (int)0, (boolean)false, (int)6, null);
    }

    private static final void fileEmbossNow$lambda$0(PrintPreview this$0, Shell s) {
        new BrailleSettingsDialog(s, this$0.m, EmbosserSettingsTab.class);
    }

    private static final void fileEmbossNow$lambda$2(PrintPreview this$0, Shell s) {
        new BrailleSettingsDialog(s, this$0.m, EmbosserSettingsTab.class);
    }

    public static final /* synthetic */ void access$setLastFocusedView$p(PrintPreview $this, StyledText styledText) {
        $this.lastFocusedView = styledText;
    }

    public static final /* synthetic */ Map access$getBrlPageOffsets$p(PrintPreview $this) {
        return $this.brlPageOffsets;
    }

    public static final /* synthetic */ Map access$getPrintPageOffsets$p(PrintPreview $this) {
        return $this.printPageOffsets;
    }

    static {
        Logger logger = LoggerFactory.getLogger(PrintPreview.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        log = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/brailleblaster/printers/PrintPreview$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "SETTINGS_KEY_DUAL_VIEW", "", "SETTINGS_KEY_PAGE_TYPE", "SETTINGS_KEY_UNICODE", "SETTINGS_KEY_SEARCH_SIX_KEY", "MARGIN_LINES", "", "MARGIN_CELLS", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0014\u001a\u00020\u0006H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0006\u0010\u001a\u001a\u00020\u0016J\b\u0010\u001b\u001a\u00020\u0016H\u0016J\b\u0010\u001c\u001a\u00020\u0016H\u0016J\u0010\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0006H\u0016J\u0010\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u0006H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\rR\u0014\u0010\u0011\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006 "}, d2={"Lorg/brailleblaster/printers/PrintPreview$DualViewMode;", "Lorg/brailleblaster/printers/PrintPreview$ViewMode;", "Lorg/brailleblaster/printers/PrintPreview;", "<init>", "(Lorg/brailleblaster/printers/PrintPreview;)V", "pageRangeIndex", "", "leftPageIndex", "leftPageRange", "Lkotlin/ranges/IntRange;", "getLeftPageRange", "()Lkotlin/ranges/IntRange;", "setLeftPageRange", "(Lkotlin/ranges/IntRange;)V", "rightPageRange", "getRightPageRange", "setRightPageRange", "totalOffset", "getTotalOffset", "()I", "searchGetStart", "seachSetCaret", "", "foundOffset", "needle", "", "onDualViewPageChange", "onGenerate", "onModeChange", "goToOffset", "doJumpToAdjacentPage", "direction", "brailleblaster-core"})
    private final class DualViewMode
    extends ViewMode {
        private int pageRangeIndex;
        private int leftPageIndex;
        @Nullable
        private IntRange leftPageRange;
        @Nullable
        private IntRange rightPageRange;

        @Nullable
        public final IntRange getLeftPageRange() {
            return this.leftPageRange;
        }

        public final void setLeftPageRange(@Nullable IntRange intRange) {
            this.leftPageRange = intRange;
        }

        @Nullable
        public final IntRange getRightPageRange() {
            return this.rightPageRange;
        }

        public final void setRightPageRange(@Nullable IntRange intRange) {
            this.rightPageRange = intRange;
        }

        @Override
        public int getTotalOffset() {
            return this.getTotalOffset(this.leftPageIndex);
        }

        @Override
        public int searchGetStart() {
            int startIndex = 0;
            if (PrintPreview.this.lastFocusedView == PrintPreview.this.viewLeft) {
                IntRange intRange = this.leftPageRange;
                Intrinsics.checkNotNull((Object)intRange);
                startIndex = intRange.getFirst() + PrintPreview.this.viewLeft.getCaretOffset();
                log.trace("getting left caret {}", (Object)startIndex);
            } else if (PrintPreview.this.lastFocusedView == PrintPreview.this.viewRight) {
                IntRange intRange = this.rightPageRange;
                Intrinsics.checkNotNull((Object)intRange);
                startIndex = intRange.getFirst() + PrintPreview.this.viewRight.getCaretOffset();
                log.trace("getting right caret {}", (Object)startIndex);
            } else if (this.leftPageRange != null) {
                IntRange intRange = this.leftPageRange;
                Intrinsics.checkNotNull((Object)intRange);
                startIndex = intRange.getFirst();
                log.trace("getting start of left {}", (Object)startIndex);
            } else {
                IntRange intRange = this.rightPageRange;
                Intrinsics.checkNotNull((Object)intRange);
                startIndex = intRange.getFirst();
                log.trace("getting start of right {}", (Object)startIndex);
            }
            return startIndex;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void seachSetCaret(int foundOffset, @NotNull String needle) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)needle, (String)"needle");
            if (this.leftPageRange != null) {
                IntRange intRange = this.leftPageRange;
                Intrinsics.checkNotNull((Object)intRange);
                if (intRange.contains(foundOffset)) {
                    StyledText styledText = PrintPreview.this.viewLeft;
                    IntRange intRange2 = this.leftPageRange;
                    Intrinsics.checkNotNull((Object)intRange2);
                    styledText.setSelectionRange(foundOffset - intRange2.getFirst(), needle.length());
                    bl = PrintPreview.this.viewLeft.setFocus();
                    return;
                }
            }
            if (this.rightPageRange == null) throw new RuntimeException("Unable to set selection to " + foundOffset + " with " + this.leftPageRange + " to " + this.rightPageRange);
            IntRange intRange = this.rightPageRange;
            Intrinsics.checkNotNull((Object)intRange);
            if (!intRange.contains(foundOffset)) throw new RuntimeException("Unable to set selection to " + foundOffset + " with " + this.leftPageRange + " to " + this.rightPageRange);
            StyledText styledText = PrintPreview.this.viewRight;
            IntRange intRange3 = this.rightPageRange;
            Intrinsics.checkNotNull((Object)intRange3);
            styledText.setSelectionRange(foundOffset - intRange3.getFirst(), needle.length());
            bl = PrintPreview.this.viewRight.setFocus();
        }

        public final void onDualViewPageChange() {
            int n;
            int n2;
            log.debug("Page index updated to {}", (Object)this.pageRangeIndex);
            this.leftPageIndex = this.pageRangeIndex;
            if (this.pageRangeIndex % 2 == 0) {
                int n3 = this.pageRangeIndex;
                this.pageRangeIndex = n3 + -1;
                log.warn("Increasing even page range");
            }
            if (this.pageRangeIndex != -1) {
                this.leftPageRange = (IntRange)PrintPreview.this.pageRanges.get(this.pageRangeIndex);
                StyledText styledText = PrintPreview.this.viewLeft;
                String string = PrintPreview.this.brfOutput;
                if (string == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"brfOutput");
                    string = null;
                }
                String string2 = string;
                IntRange intRange = this.leftPageRange;
                Intrinsics.checkNotNull((Object)intRange);
                n2 = intRange.getFirst();
                IntRange intRange2 = this.leftPageRange;
                Intrinsics.checkNotNull((Object)intRange2);
                n = intRange2.getLast();
                String string3 = string2.substring(n2, n);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                styledText.setText(string3);
                PrintPreview.this.viewLeft.setBackground(PrintPreview.this.viewColorDefault);
            } else {
                this.leftPageRange = null;
                PrintPreview.this.viewLeft.setText("");
                PrintPreview.this.viewLeft.setBackground(PrintPreview.this.viewColorDisabled);
            }
            if (this.pageRangeIndex + 1 <= PrintPreview.this.pageRanges.size() - 1) {
                this.rightPageRange = (IntRange)PrintPreview.this.pageRanges.get(this.pageRangeIndex + 1);
                StyledText styledText = PrintPreview.this.viewRight;
                String string = PrintPreview.this.brfOutput;
                if (string == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"brfOutput");
                    string = null;
                }
                String string4 = string;
                IntRange intRange = this.rightPageRange;
                Intrinsics.checkNotNull((Object)intRange);
                n2 = intRange.getFirst();
                IntRange intRange3 = this.rightPageRange;
                Intrinsics.checkNotNull((Object)intRange3);
                n = intRange3.getLast();
                String string5 = string4.substring(n2, n);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                styledText.setText(string5);
                PrintPreview.this.viewRight.setBackground(PrintPreview.this.viewColorDefault);
            } else {
                this.rightPageRange = null;
                PrintPreview.this.viewRight.setText("");
                PrintPreview.this.viewRight.setBackground(PrintPreview.this.viewColorDisabled);
            }
            boolean bl = PrintPreview.this.viewLeft.getBackground() != PrintPreview.this.viewColorDisabled ? PrintPreview.this.viewLeft.setFocus() : PrintPreview.this.viewRight.setFocus();
            PrintPreview.this.nextPageButton.setEnabled(this.pageRangeIndex < PrintPreview.this.pageRanges.size() - 1 - 1);
            PrintPreview.this.previousPageButton.setEnabled(this.pageRangeIndex > 0);
            PrintPreview.this.updateCurrentPage();
        }

        @Override
        public void onGenerate() {
            this.onDualViewPageChange();
        }

        @Override
        public void onModeChange() {
            PrintPreview.this.viewLeft.setStyleRanges(new StyleRange[0]);
            PrintPreview.this.viewRight.setStyleRanges(new StyleRange[0]);
            Intrinsics.checkNotNull((Object)PrintPreview.this.viewRight.getLayoutData(), (String)"null cannot be cast to non-null type org.eclipse.swt.layout.GridData");
            ((GridData)PrintPreview.this.viewRight.getLayoutData()).exclude = false;
            PrintPreview.this.viewRight.setVisible(true);
            Intrinsics.checkNotNull((Object)PrintPreview.this.viewLeft.getLayoutData(), (String)"null cannot be cast to non-null type org.eclipse.swt.layout.GridData");
            ((GridData)PrintPreview.this.viewLeft.getLayoutData()).horizontalSpan = 1;
        }

        @Override
        public void goToOffset(int totalOffset) {
            this.pageRangeIndex = this.getPageRangeIndexFromOffset(totalOffset);
            this.onDualViewPageChange();
        }

        @Override
        public void doJumpToAdjacentPage(int direction) {
            if (this.pageRangeIndex <= 0 && direction < 0) {
                PrintPreview.this.viewRight.setCaretOffset(0);
                PrintPreview.this.viewRight.forceFocus();
            } else if (this.pageRangeIndex >= PrintPreview.this.pageRanges.size() - 1 - 1 && direction > 0) {
                if (PrintPreview.this.viewRight.getBackground() == PrintPreview.this.viewColorDisabled) {
                    PrintPreview.this.viewLeft.setCaretOffset(0);
                    v0 = PrintPreview.this.viewLeft.forceFocus();
                } else {
                    PrintPreview.this.viewRight.setCaretOffset(0);
                    v0 = PrintPreview.this.viewRight.forceFocus();
                }
            } else if (direction < 0) {
                this.pageRangeIndex -= 2;
                this.onDualViewPageChange();
            } else if (direction > 0) {
                this.pageRangeIndex += 2;
                this.onDualViewPageChange();
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\f\u001a\u00020\u0006H\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u000eH\u0002J\b\u0010\u0013\u001a\u00020\u000eH\u0016J\b\u0010\u0014\u001a\u00020\u000eH\u0016J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u0006H\u0016J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0006H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lorg/brailleblaster/printers/PrintPreview$SingleViewMode;", "Lorg/brailleblaster/printers/PrintPreview$ViewMode;", "Lorg/brailleblaster/printers/PrintPreview;", "<init>", "(Lorg/brailleblaster/printers/PrintPreview;)V", "pageRangeIndex", "", "pageRange", "Lkotlin/ranges/IntRange;", "totalOffset", "getTotalOffset", "()I", "searchGetStart", "seachSetCaret", "", "foundOffset", "needle", "", "onSingleViewPageChange", "onGenerate", "onModeChange", "goToOffset", "doJumpToAdjacentPage", "direction", "brailleblaster-core"})
    public final class SingleViewMode
    extends ViewMode {
        private int pageRangeIndex;
        @Nullable
        private IntRange pageRange;

        @Override
        public int getTotalOffset() {
            return this.getTotalOffset(this.pageRangeIndex);
        }

        @Override
        public int searchGetStart() {
            IntRange intRange = this.pageRange;
            Intrinsics.checkNotNull((Object)intRange);
            return intRange.getFirst() + PrintPreview.this.viewLeft.getCaretOffset();
        }

        @Override
        public void seachSetCaret(int foundOffset, @NotNull String needle) {
            Intrinsics.checkNotNullParameter((Object)needle, (String)"needle");
            IntRange intRange = this.pageRange;
            Intrinsics.checkNotNull((Object)intRange);
            if (!intRange.contains(foundOffset)) {
                throw new RuntimeException("Unable to set selection to " + foundOffset + " with " + this.pageRange);
            }
            StyledText styledText = PrintPreview.this.viewLeft;
            IntRange intRange2 = this.pageRange;
            Intrinsics.checkNotNull((Object)intRange2);
            styledText.setSelectionRange(foundOffset - intRange2.getFirst(), needle.length());
            PrintPreview.this.viewLeft.setFocus();
        }

        private final void onSingleViewPageChange() {
            log.debug("Page range index set to {}", (Object)this.pageRangeIndex);
            this.pageRange = (IntRange)PrintPreview.this.pageRanges.get(this.pageRangeIndex);
            StyledText styledText = PrintPreview.this.viewLeft;
            String string = PrintPreview.this.brfOutput;
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"brfOutput");
                string = null;
            }
            String string2 = string;
            IntRange intRange = this.pageRange;
            Intrinsics.checkNotNull((Object)intRange);
            int n = intRange.getFirst();
            IntRange intRange2 = this.pageRange;
            Intrinsics.checkNotNull((Object)intRange2);
            int n2 = intRange2.getLast();
            String string3 = string2.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            styledText.setText(string3);
            PrintPreview.this.nextPageButton.setEnabled(this.pageRangeIndex < PrintPreview.this.pageRanges.size() - 1);
            PrintPreview.this.previousPageButton.setEnabled(this.pageRangeIndex > 0);
            PrintPreview.this.viewLeft.setFocus();
            PrintPreview.this.updateCurrentPage();
        }

        @Override
        public void onGenerate() {
            this.onSingleViewPageChange();
        }

        @Override
        public void onModeChange() {
            PrintPreview.this.viewLeft.setStyleRanges(new StyleRange[0]);
            PrintPreview.this.viewRight.setStyleRanges(new StyleRange[0]);
            Intrinsics.checkNotNull((Object)PrintPreview.this.viewRight.getLayoutData(), (String)"null cannot be cast to non-null type org.eclipse.swt.layout.GridData");
            ((GridData)PrintPreview.this.viewRight.getLayoutData()).exclude = true;
            PrintPreview.this.viewRight.setVisible(false);
            Intrinsics.checkNotNull((Object)PrintPreview.this.viewLeft.getLayoutData(), (String)"null cannot be cast to non-null type org.eclipse.swt.layout.GridData");
            ((GridData)PrintPreview.this.viewLeft.getLayoutData()).horizontalSpan = 2;
            PrintPreview.this.viewLeft.setBackground(PrintPreview.this.viewColorDefault);
        }

        @Override
        public void goToOffset(int totalOffset) {
            this.pageRangeIndex = this.getPageRangeIndexFromOffset(totalOffset);
            this.onSingleViewPageChange();
        }

        @Override
        public void doJumpToAdjacentPage(int direction) {
            if (this.pageRangeIndex <= 0 && direction < 0) {
                PrintPreview.this.viewLeft.setCaretOffset(0);
                PrintPreview.this.viewLeft.forceFocus();
            } else if (this.pageRangeIndex >= PrintPreview.this.pageRanges.size() - 1 && direction > 0) {
                PrintPreview.this.viewLeft.setCaretOffset(0);
                PrintPreview.this.viewLeft.forceFocus();
            } else if (direction < 0) {
                --this.pageRangeIndex;
                this.onSingleViewPageChange();
            } else if (direction > 0) {
                ++this.pageRangeIndex;
                this.onSingleViewPageChange();
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u00a6\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0004J\b\u0010\t\u001a\u00020\u0005H&J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH&J\b\u0010\u000f\u001a\u00020\u000bH&J\b\u0010\u0010\u001a\u00020\u000bH&J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u0005H&J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0004J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0005H&R\u0012\u0010\u0007\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\b\u00a8\u0006\u0015"}, d2={"Lorg/brailleblaster/printers/PrintPreview$ViewMode;", "", "<init>", "(Lorg/brailleblaster/printers/PrintPreview;)V", "getTotalOffset", "", "pageIndex", "totalOffset", "()I", "searchGetStart", "seachSetCaret", "", "foundOffset", "needle", "", "onGenerate", "onModeChange", "goToOffset", "getPageRangeIndexFromOffset", "doJumpToAdjacentPage", "direction", "brailleblaster-core"})
    @SourceDebugExtension(value={"SMAP\nPrintPreview.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrintPreview.kt\norg/brailleblaster/printers/PrintPreview$ViewMode\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1048:1\n363#2,7:1049\n*S KotlinDebug\n*F\n+ 1 PrintPreview.kt\norg/brailleblaster/printers/PrintPreview$ViewMode\n*L\n524#1:1049,7\n*E\n"})
    public abstract class ViewMode {
        protected final int getTotalOffset(int pageIndex) {
            int currentPageIndex = Math.max(pageIndex, 0);
            return ((IntRange)PrintPreview.this.pageRanges.get(currentPageIndex)).getFirst();
        }

        public abstract int getTotalOffset();

        public abstract int searchGetStart();

        public abstract void seachSetCaret(int var1, @NotNull String var2);

        public abstract void onGenerate();

        public abstract void onModeChange();

        public abstract void goToOffset(int var1);

        protected final int getPageRangeIndexFromOffset(int totalOffset) {
            int index;
            block4: {
                int n;
                List $this$indexOfFirst$iv = PrintPreview.this.pageRanges;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                for (Object item$iv : $this$indexOfFirst$iv) {
                    IntRange it = (IntRange)item$iv;
                    boolean bl = false;
                    if (totalOffset < it.getLast()) {
                        n = index$iv;
                        break block4;
                    }
                    ++index$iv;
                }
                n = index = -1;
            }
            if (index >= 0) {
                return index;
            }
            String string = PrintPreview.this.brfOutput;
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"brfOutput");
                string = null;
            }
            throw new RuntimeException("Offset " + totalOffset + " not found, total: " + string.length());
        }

        public abstract void doJumpToAdjacentPage(int var1);
    }
}

