/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.printers;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Shell;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 O2\u00020\u0001:\u0001OB\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010M\u001a\u00020NR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR$\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020 \u0018\u00010\u001fX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010%\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001c\u0010&\u001a\u0004\u0018\u00010'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u001c\u0010,\u001a\u0004\u0018\u00010'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010)\"\u0004\b.\u0010+R\u001a\u0010/\u001a\u000200X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R\u001a\u00105\u001a\u000200X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u00102\"\u0004\b7\u00104R\u001a\u00108\u001a\u000200X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u00102\"\u0004\b:\u00104R\u001a\u0010;\u001a\u000200X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u00102\"\u0004\b=\u00104R\u001a\u0010>\u001a\u000200X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u00102\"\u0004\b@\u00104R\u001c\u0010A\u001a\u0004\u0018\u00010BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bC\u0010D\"\u0004\bE\u0010FR\u001a\u0010G\u001a\u00020HX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bI\u0010J\"\u0004\bK\u0010L\u00a8\u0006P"}, d2={"Lorg/brailleblaster/printers/PrintersManager;", "", "shell", "Lorg/eclipse/swt/widgets/Shell;", "text", "Lorg/eclipse/swt/custom/StyledText;", "<init>", "(Lorg/eclipse/swt/widgets/Shell;Lorg/eclipse/swt/custom/StyledText;)V", "getText", "()Lorg/eclipse/swt/custom/StyledText;", "setText", "(Lorg/eclipse/swt/custom/StyledText;)V", "font", "Lorg/eclipse/swt/graphics/Font;", "getFont", "()Lorg/eclipse/swt/graphics/Font;", "setFont", "(Lorg/eclipse/swt/graphics/Font;)V", "backgroundColor", "Lorg/eclipse/swt/graphics/Color;", "getBackgroundColor", "()Lorg/eclipse/swt/graphics/Color;", "setBackgroundColor", "(Lorg/eclipse/swt/graphics/Color;)V", "gc", "Lorg/eclipse/swt/graphics/GC;", "getGc", "()Lorg/eclipse/swt/graphics/GC;", "setGc", "(Lorg/eclipse/swt/graphics/GC;)V", "printerFontData", "", "Lorg/eclipse/swt/graphics/FontData;", "getPrinterFontData", "()[Lorg/eclipse/swt/graphics/FontData;", "setPrinterFontData", "([Lorg/eclipse/swt/graphics/FontData;)V", "[Lorg/eclipse/swt/graphics/FontData;", "printerForeground", "Lorg/eclipse/swt/graphics/RGB;", "getPrinterForeground", "()Lorg/eclipse/swt/graphics/RGB;", "setPrinterForeground", "(Lorg/eclipse/swt/graphics/RGB;)V", "printerBackground", "getPrinterBackground", "setPrinterBackground", "lineHeight", "", "getLineHeight", "()I", "setLineHeight", "(I)V", "x", "getX", "setX", "y", "getY", "setY", "index", "getIndex", "setIndex", "end", "getEnd", "setEnd", "tabs", "", "getTabs", "()Ljava/lang/String;", "setTabs", "(Ljava/lang/String;)V", "dialog", "Lorg/eclipse/swt/printing/PrintDialog;", "getDialog", "()Lorg/eclipse/swt/printing/PrintDialog;", "setDialog", "(Lorg/eclipse/swt/printing/PrintDialog;)V", "beginPrintJob", "", "Companion", "brailleblaster-core"})
public final class PrintersManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private StyledText text;
    @Nullable
    private Font font;
    @Nullable
    private Color backgroundColor;
    @Nullable
    private GC gc;
    @Nullable
    private FontData[] printerFontData;
    @Nullable
    private RGB printerForeground;
    @Nullable
    private RGB printerBackground;
    private int lineHeight;
    private int x;
    private int y;
    private int index;
    private int end;
    @Nullable
    private String tabs;
    @NotNull
    private PrintDialog dialog;
    @NotNull
    private static final Logger logger;

    public PrintersManager(@Nullable Shell shell, @NotNull StyledText text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.text = text;
        this.dialog = new PrintDialog(shell, 1264);
    }

    @NotNull
    public final StyledText getText() {
        return this.text;
    }

    public final void setText(@NotNull StyledText styledText) {
        Intrinsics.checkNotNullParameter((Object)styledText, (String)"<set-?>");
        this.text = styledText;
    }

    @Nullable
    public final Font getFont() {
        return this.font;
    }

    public final void setFont(@Nullable Font font) {
        this.font = font;
    }

    @Nullable
    public final Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public final void setBackgroundColor(@Nullable Color color) {
        this.backgroundColor = color;
    }

    @Nullable
    public final GC getGc() {
        return this.gc;
    }

    public final void setGc(@Nullable GC gC) {
        this.gc = gC;
    }

    @Nullable
    public final FontData[] getPrinterFontData() {
        return this.printerFontData;
    }

    public final void setPrinterFontData(@Nullable FontData[] fontDataArray) {
        this.printerFontData = fontDataArray;
    }

    @Nullable
    public final RGB getPrinterForeground() {
        return this.printerForeground;
    }

    public final void setPrinterForeground(@Nullable RGB rGB) {
        this.printerForeground = rGB;
    }

    @Nullable
    public final RGB getPrinterBackground() {
        return this.printerBackground;
    }

    public final void setPrinterBackground(@Nullable RGB rGB) {
        this.printerBackground = rGB;
    }

    public final int getLineHeight() {
        return this.lineHeight;
    }

    public final void setLineHeight(int n) {
        this.lineHeight = n;
    }

    public final int getX() {
        return this.x;
    }

    public final void setX(int n) {
        this.x = n;
    }

    public final int getY() {
        return this.y;
    }

    public final void setY(int n) {
        this.y = n;
    }

    public final int getIndex() {
        return this.index;
    }

    public final void setIndex(int n) {
        this.index = n;
    }

    public final int getEnd() {
        return this.end;
    }

    public final void setEnd(int n) {
        this.end = n;
    }

    @Nullable
    public final String getTabs() {
        return this.tabs;
    }

    public final void setTabs(@Nullable String string) {
        this.tabs = string;
    }

    @NotNull
    public final PrintDialog getDialog() {
        return this.dialog;
    }

    public final void setDialog(@NotNull PrintDialog printDialog) {
        Intrinsics.checkNotNullParameter((Object)printDialog, (String)"<set-?>");
        this.dialog = printDialog;
    }

    public final void beginPrintJob() {
        PrinterData printerData = this.dialog.open();
        if (printerData == null) {
            return;
        }
        PrinterData data = printerData;
        if (data.printToFile) {
            data.fileName = "print.out";
        }
        this.printerFontData = this.text.getFont().getFontData();
        this.printerForeground = this.text.getForeground().getRGB();
        this.printerBackground = this.text.getBackground().getRGB();
        Printer printer = new Printer(data);
        Runnable thread = this.text.print(printer);
        thread.run();
        printer.dispose();
    }

    static {
        Logger logger = LoggerFactory.getLogger(PrintersManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        PrintersManager.logger = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/brailleblaster/printers/PrintersManager$Companion;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

