/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.settings.ui;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty0;
import kotlin.text.StringsKt;
import org.brailleblaster.libembosser.spi.BrlCell;
import org.brailleblaster.settings.ui.SettingsUITab;
import org.brailleblaster.utd.BrailleSettings;
import org.brailleblaster.utd.PageSettings;
import org.brailleblaster.utd.UTDTranslationEngine;
import org.brailleblaster.utd.utils.Page;
import org.brailleblaster.util.FormUIUtils;
import org.brailleblaster.utils.LengthUtils;
import org.brailleblaster.utils.UnitConverter;
import org.brailleblaster.utils.localization.LocaleHandler;
import org.brailleblaster.utils.swt.AccessibilityUtils;
import org.brailleblaster.utils.swt.EasySWT;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 U2\u00020\u0001:\u0001UB!\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u00104\u001a\u000205H\u0002J\u0018\u00106\u001a\u0002052\u0006\u00107\u001a\u00020\u00102\u0006\u00108\u001a\u00020*H\u0002J\u0010\u00109\u001a\u00020*2\u0006\u0010:\u001a\u00020*H\u0002J\u0010\u0010;\u001a\u00020*2\u0006\u0010<\u001a\u00020*H\u0002J\b\u0010=\u001a\u000205H\u0002J\b\u0010>\u001a\u000205H\u0002J\b\u0010?\u001a\u000205H\u0002J\b\u0010@\u001a\u000205H\u0002J\b\u0010A\u001a\u000205H\u0002J\u0018\u0010B\u001a\u00020$2\u0006\u0010C\u001a\u00020\u00192\u0006\u0010D\u001a\u00020$H\u0002J\n\u0010G\u001a\u0004\u0018\u00010$H\u0016J\u0010\u0010H\u001a\u00020(2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J,\u0010I\u001a\u00020J2\f\u0010K\u001a\b\u0012\u0004\u0012\u00020$0L2\u0006\u0010M\u001a\u00020N2\f\u0010O\u001a\b\u0012\u0004\u0012\u00020Q0PH\u0002J,\u0010R\u001a\u00020S2\f\u0010K\u001a\b\u0012\u0004\u0012\u00020$0L2\u0006\u0010M\u001a\u00020N2\f\u0010O\u001a\b\u0012\u0004\u0012\u00020T0PH\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u000203X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010E\u001a\u00020(8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bE\u0010F\u00a8\u0006V"}, d2={"Lorg/brailleblaster/settings/ui/PagePropertiesTab;", "Lorg/brailleblaster/settings/ui/SettingsUITab;", "parent", "Lorg/eclipse/swt/widgets/Composite;", "engine", "Lorg/brailleblaster/utd/UTDTranslationEngine;", "shell", "Lorg/eclipse/swt/widgets/Shell;", "<init>", "(Lorg/eclipse/swt/widgets/Composite;Lorg/brailleblaster/utd/UTDTranslationEngine;Lorg/eclipse/swt/widgets/Shell;)V", "unitConverter", "Lorg/brailleblaster/utils/UnitConverter;", "standardPages", "", "Lorg/brailleblaster/utd/utils/Page;", "widthBox", "Lorg/eclipse/swt/widgets/Text;", "heightBox", "linesBox", "cellsBox", "marginTopBox", "marginLeftBox", "marginRightBox", "marginBottomBox", "marginTopLabel", "Lorg/eclipse/swt/widgets/Label;", "marginBottomLabel", "marginLeftLabel", "marginRightLabel", "pageTypes", "Lorg/eclipse/swt/widgets/Combo;", "interpointCombo", "regionalButton", "Lorg/eclipse/swt/widgets/Button;", "cellsLinesButton", "unitName", "", "units", "Lorg/brailleblaster/utils/LengthUtils$Units;", "marginLocalUnit", "", "pageHeight", "", "pageWidth", "cellsWidth", "linesHeight", "marginTop", "marginBottom", "marginLeft", "marginRight", "brailleCell", "Lorg/brailleblaster/libembosser/spi/BrlCell;", "updateFields", "", "setTextIfDifferent", "box", "number", "getWholeCellsWidth", "width", "getWholeLinesHeight", "height", "calculateTopAndLeftMarginsAndUpdate", "calculateCellsLinesAndUpdate", "updatePageValues", "onStandardPageSelected", "onMarginUnitSelected", "replaceOldUnitLabel", "label", "newUnit", "isAnyFieldEmpty", "()Z", "validate", "updateEngine", "makeFieldListener", "Lorg/eclipse/swt/events/KeyListener;", "getRawValue", "Ljava/util/function/Supplier;", "setParsedValue", "Ljava/util/function/DoubleUnaryOperator;", "function", "Ljava/util/function/Consumer;", "Lorg/eclipse/swt/events/KeyEvent;", "makeFieldFocusListener", "Lorg/eclipse/swt/events/FocusListener;", "Lorg/eclipse/swt/events/FocusEvent;", "Companion", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nPagePropertiesTab.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PagePropertiesTab.kt\norg/brailleblaster/settings/ui/PagePropertiesTab\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,621:1\n296#2,2:622\n*S KotlinDebug\n*F\n+ 1 PagePropertiesTab.kt\norg/brailleblaster/settings/ui/PagePropertiesTab\n*L\n296#1:622,2\n*E\n"})
public final class PagePropertiesTab
implements SettingsUITab {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UnitConverter unitConverter = new UnitConverter(false, 1, null);
    @NotNull
    private final List<Page> standardPages;
    @NotNull
    private final Text widthBox;
    @NotNull
    private final Text heightBox;
    @NotNull
    private final Text linesBox;
    @NotNull
    private final Text cellsBox;
    @NotNull
    private final Text marginTopBox;
    @NotNull
    private final Text marginLeftBox;
    @NotNull
    private final Text marginRightBox;
    @NotNull
    private final Text marginBottomBox;
    @NotNull
    private final Label marginTopLabel;
    @NotNull
    private final Label marginBottomLabel;
    @NotNull
    private final Label marginLeftLabel;
    @NotNull
    private final Label marginRightLabel;
    @NotNull
    private final Combo pageTypes;
    @NotNull
    private final Combo interpointCombo;
    @NotNull
    private final Button regionalButton;
    @NotNull
    private final Button cellsLinesButton;
    @NotNull
    private final String unitName;
    @NotNull
    private final LengthUtils.Units units;
    private boolean marginLocalUnit = true;
    private double pageHeight;
    private double pageWidth;
    private double cellsWidth;
    private double linesHeight;
    private double marginTop;
    private double marginBottom;
    private double marginLeft;
    private double marginRight;
    @NotNull
    private final BrlCell brailleCell;
    @NotNull
    private static final LocaleHandler localeHandler = LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null);
    @NotNull
    private static final DecimalFormat NUMBER_FORMATTER = new DecimalFormat("###.##");

    private PagePropertiesTab(Composite parent, UTDTranslationEngine engine, Shell shell) {
        this.brailleCell = engine.getBrailleSettings().getCellType();
        boolean metric = this.unitConverter.isMetric();
        this.unitName = metric ? "mm" : "in";
        String unitSuffix = " (" + this.unitName + ")";
        this.units = metric ? LengthUtils.Units.MILLIMETRES : LengthUtils.Units.INCHES;
        this.standardPages = Page.STANDARD_PAGES;
        Group pageGroup = new Group(parent, 0);
        pageGroup.setText(localeHandler.get("pageSize"));
        pageGroup.setLayout((Layout)new GridLayout(2, true));
        EasySWT.INSTANCE.setGridDataGroup(pageGroup);
        EasySWT.INSTANCE.addLabel((Composite)pageGroup, localeHandler.get("pageSize"));
        this.pageTypes = new Combo((Composite)pageGroup, 8);
        EasySWT.INSTANCE.setGridData((Control)this.pageTypes);
        EasySWT.INSTANCE.addLabel((Composite)pageGroup, localeHandler.get("width") + unitSuffix);
        this.widthBox = new Text((Composite)pageGroup, 2048);
        EasySWT.INSTANCE.addDoubleFilter(this.widthBox);
        EasySWT.INSTANCE.setGridData((Control)this.widthBox);
        EasySWT.INSTANCE.addLabel((Composite)pageGroup, localeHandler.get("height") + unitSuffix);
        this.heightBox = new Text((Composite)pageGroup, 2048);
        EasySWT.INSTANCE.addDoubleFilter(this.heightBox);
        EasySWT.INSTANCE.setGridData((Control)this.heightBox);
        EasySWT.INSTANCE.addLabel((Composite)pageGroup, localeHandler.get("linesPerPage"));
        this.linesBox = new Text((Composite)pageGroup, 2048);
        EasySWT.INSTANCE.setGridData((Control)this.linesBox);
        EasySWT.INSTANCE.addIntegerFilter(this.linesBox);
        EasySWT.INSTANCE.addLabel((Composite)pageGroup, localeHandler.get("cellsPerLine"));
        this.cellsBox = new Text((Composite)pageGroup, 2048);
        EasySWT.INSTANCE.setGridData((Control)this.cellsBox);
        EasySWT.INSTANCE.addIntegerFilter(this.cellsBox);
        Group marginGroup = new Group(parent, 0);
        marginGroup.setLayout((Layout)new GridLayout(2, true));
        marginGroup.setText(localeHandler.get("margins"));
        EasySWT.INSTANCE.setGridDataGroup(marginGroup);
        EasySWT.INSTANCE.addLabel((Composite)marginGroup, localeHandler.get("measurementUnits"));
        Composite unitsGroup = new Composite((Composite)marginGroup, 0);
        unitsGroup.setLayout((Layout)new GridLayout(2, true));
        this.regionalButton = new Button(unitsGroup, 16);
        this.regionalButton.setText(this.unitName);
        this.regionalButton.setSelection(true);
        EasySWT.INSTANCE.setGridData((Control)this.regionalButton);
        this.cellsLinesButton = new Button(unitsGroup, 16);
        this.cellsLinesButton.setText(localeHandler.get("cellsLines"));
        EasySWT.INSTANCE.setGridData((Control)this.cellsLinesButton);
        this.marginTopLabel = EasySWT.INSTANCE.addLabel((Composite)marginGroup, localeHandler.get("topMargin") + unitSuffix);
        this.marginTopBox = new Text((Composite)marginGroup, 2048);
        EasySWT.INSTANCE.addDoubleFilter(this.marginTopBox);
        EasySWT.INSTANCE.setGridData((Control)this.marginTopBox);
        this.marginBottomLabel = EasySWT.INSTANCE.addLabel((Composite)marginGroup, localeHandler.get("bottomMargin") + unitSuffix);
        this.marginBottomBox = new Text((Composite)marginGroup, 2056);
        EasySWT.INSTANCE.addDoubleFilter(this.marginBottomBox);
        EasySWT.INSTANCE.setGridData((Control)this.marginBottomBox);
        this.marginLeftLabel = EasySWT.INSTANCE.addLabel((Composite)marginGroup, localeHandler.get("leftMargin") + unitSuffix);
        this.marginLeftBox = new Text((Composite)marginGroup, 2048);
        EasySWT.INSTANCE.addDoubleFilter(this.marginLeftBox);
        EasySWT.INSTANCE.setGridData((Control)this.marginLeftBox);
        this.marginRightLabel = EasySWT.INSTANCE.addLabel((Composite)marginGroup, localeHandler.get("rightMargin") + unitSuffix);
        this.marginRightBox = new Text((Composite)marginGroup, 2056);
        EasySWT.INSTANCE.addDoubleFilter(this.marginRightBox);
        EasySWT.INSTANCE.setGridData((Control)this.marginRightBox);
        Group interpointGroup = new Group(parent, 0);
        interpointGroup.setLayout((Layout)new GridLayout(2, true));
        interpointGroup.setText("Interpoint");
        EasySWT.INSTANCE.setGridDataGroup(interpointGroup);
        Label interpointLabel = EasySWT.INSTANCE.addLabel((Composite)interpointGroup, "Interpoint");
        interpointLabel.setToolTipText("Sets embosser for interpoint embossing and puts t1, p1, and 1 on a right-hand page.");
        this.interpointCombo = PagePropertiesTab.Companion.makeYesNoCombo((Composite)interpointGroup, engine.getPageSettings().getInterpoint());
        AccessibilityUtils.appendName((Control)((Control)this.interpointCombo), (String)"Ensures t1, p1, and 1 appear on right-hand page.");
        this.pageTypes.addSelectionListener(EasySWT.INSTANCE.makeSelectedListener(arg_0 -> PagePropertiesTab._init_$lambda$0(this, arg_0)));
        this.widthBox.addKeyListener(this.makeFieldListener(() -> PagePropertiesTab._init_$lambda$1(this), arg_0 -> PagePropertiesTab._init_$lambda$2(this, arg_0), arg_0 -> PagePropertiesTab._init_$lambda$3(this, arg_0)));
        this.heightBox.addKeyListener(this.makeFieldListener(() -> PagePropertiesTab._init_$lambda$4(this), arg_0 -> PagePropertiesTab._init_$lambda$5(this, arg_0), arg_0 -> PagePropertiesTab._init_$lambda$6(this, arg_0)));
        this.cellsBox.addKeyListener(this.makeFieldListener(() -> PagePropertiesTab._init_$lambda$7(this), arg_0 -> PagePropertiesTab._init_$lambda$8(this, arg_0), arg_0 -> PagePropertiesTab._init_$lambda$9(this, arg_0)));
        this.linesBox.addKeyListener(this.makeFieldListener(() -> PagePropertiesTab._init_$lambda$10(this), arg_0 -> PagePropertiesTab._init_$lambda$11(this, arg_0), arg_0 -> PagePropertiesTab._init_$lambda$12(this, arg_0)));
        DoubleUnaryOperator marginHeight = arg_0 -> PagePropertiesTab._init_$lambda$13(this, arg_0);
        DoubleUnaryOperator marginWidth = arg_0 -> PagePropertiesTab._init_$lambda$14(this, arg_0);
        Supplier<String> supplier = () -> PagePropertiesTab._init_$lambda$15(this);
        DoubleUnaryOperator doubleUnaryOperator = marginHeight.andThen(arg_0 -> PagePropertiesTab._init_$lambda$16(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)doubleUnaryOperator, (String)"andThen(...)");
        this.marginTopBox.addFocusListener(this.makeFieldFocusListener(supplier, doubleUnaryOperator, arg_0 -> PagePropertiesTab._init_$lambda$17(this, arg_0)));
        Supplier<String> supplier2 = () -> PagePropertiesTab._init_$lambda$18(this);
        DoubleUnaryOperator doubleUnaryOperator2 = marginWidth.andThen(arg_0 -> PagePropertiesTab._init_$lambda$19(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)doubleUnaryOperator2, (String)"andThen(...)");
        this.marginLeftBox.addFocusListener(this.makeFieldFocusListener(supplier2, doubleUnaryOperator2, arg_0 -> PagePropertiesTab._init_$lambda$20(this, arg_0)));
        SelectionListener marginUnitChangedListener = EasySWT.INSTANCE.makeSelectedListener(arg_0 -> PagePropertiesTab._init_$lambda$21(this, arg_0));
        this.regionalButton.addSelectionListener(marginUnitChangedListener);
        this.cellsLinesButton.addSelectionListener(marginUnitChangedListener);
        for (Page curPage : this.standardPages) {
            this.pageTypes.add(curPage.toString(this.units, NUMBER_FORMATTER));
        }
        PageSettings pageSettings = engine.getPageSettings();
        if (!(pageSettings.getPaperHeight() == 0.0) && !(pageSettings.getPaperWidth() == 0.0)) {
            this.pageHeight = pageSettings.getPaperHeight();
            this.pageWidth = pageSettings.getPaperWidth();
            this.marginTop = pageSettings.getTopMargin();
            this.marginBottom = pageSettings.getBottomMargin();
            this.marginLeft = pageSettings.getLeftMargin();
            this.marginRight = pageSettings.getRightMargin();
        } else {
            Page defaultPage = this.standardPages.get(0);
            this.pageHeight = defaultPage.getHeight(LengthUtils.Units.MILLIMETRES);
            this.pageWidth = defaultPage.getWidth(LengthUtils.Units.MILLIMETRES);
            this.marginTop = defaultPage.getTopMargin(LengthUtils.Units.MILLIMETRES);
            this.marginBottom = defaultPage.getBottomMargin(LengthUtils.Units.MILLIMETRES);
            this.marginLeft = defaultPage.getLeftMargin(LengthUtils.Units.MILLIMETRES);
            this.marginRight = defaultPage.getRightMargin(LengthUtils.Units.MILLIMETRES);
        }
        this.cellsWidth = Math.max(this.pageWidth - this.marginLeft - this.marginRight, 0.0);
        this.linesHeight = Math.max(this.pageHeight - this.marginTop - this.marginBottom, 0.0);
        this.calculateCellsLinesAndUpdate();
    }

    private final void updateFields() {
        Object v0;
        block5: {
            int microWidth = LengthUtils.Units.MILLIMETRES.fromUnits(this.pageWidth);
            int microHeight = LengthUtils.Units.MILLIMETRES.fromUnits(this.pageHeight);
            Iterable $this$firstOrNull$iv = this.standardPages;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Page p = (Page)element$iv;
                boolean bl = false;
                if (!(p.getHeight() == microHeight && p.getWidth() == microWidth)) continue;
                v0 = element$iv;
                break block5;
            }
            v0 = null;
        }
        Page matchedPage = v0;
        if (matchedPage != null) {
            this.pageTypes.select(this.pageTypes.indexOf(matchedPage.toString(this.units, NUMBER_FORMATTER)));
        } else if (this.pageTypes.getItemCount() == this.standardPages.size()) {
            this.pageTypes.add(localeHandler.get("custom"));
            this.pageTypes.select(this.pageTypes.getItemCount() - 1);
        } else {
            this.pageTypes.select(this.pageTypes.getItemCount() - 1);
        }
        this.setTextIfDifferent(this.widthBox, this.unitConverter.mmToLocalUnits(this.pageWidth));
        this.setTextIfDifferent(this.heightBox, this.unitConverter.mmToLocalUnits(this.pageHeight));
        this.setTextIfDifferent(this.linesBox, this.brailleCell.getLinesForHeight(BigDecimal.valueOf(this.linesHeight)));
        this.setTextIfDifferent(this.cellsBox, this.brailleCell.getCellsForWidth(BigDecimal.valueOf(this.cellsWidth)));
        this.setTextIfDifferent(this.marginTopBox, this.marginLocalUnit ? this.unitConverter.mmToLocalUnits(this.marginTop) : (double)this.brailleCell.getLinesForHeight(BigDecimal.valueOf(this.marginTop)));
        this.setTextIfDifferent(this.marginBottomBox, this.marginLocalUnit ? this.unitConverter.mmToLocalUnits(this.marginBottom) : (double)this.brailleCell.getLinesForHeight(BigDecimal.valueOf(this.marginBottom)));
        this.setTextIfDifferent(this.marginLeftBox, this.marginLocalUnit ? this.unitConverter.mmToLocalUnits(this.marginLeft) : (double)this.brailleCell.getCellsForWidth(BigDecimal.valueOf(this.marginLeft)));
        this.setTextIfDifferent(this.marginRightBox, this.marginLocalUnit ? this.unitConverter.mmToLocalUnits(this.marginRight) : (double)this.brailleCell.getCellsForWidth(BigDecimal.valueOf(this.marginRight)));
    }

    private final void setTextIfDifferent(Text box, double number) {
        String given = box.getText();
        String expected = NUMBER_FORMATTER.format(number);
        Intrinsics.checkNotNull((Object)given);
        if (!(((CharSequence)given).length() > 0) || !(PagePropertiesTab.Companion.parseDouble(given) == number)) {
            box.setText(expected);
        }
    }

    private final double getWholeCellsWidth(double width) {
        int cpl = this.brailleCell.getCellsForWidth(BigDecimal.valueOf(width));
        return this.brailleCell.getWidthForCells(cpl).doubleValue();
    }

    private final double getWholeLinesHeight(double height) {
        int lpp = this.brailleCell.getLinesForHeight(BigDecimal.valueOf(height));
        return this.brailleCell.getHeightForLines(lpp).doubleValue();
    }

    private final void calculateTopAndLeftMarginsAndUpdate() {
        if (this.cellsWidth > this.pageWidth) {
            this.cellsWidth = this.getWholeCellsWidth(this.pageWidth);
        }
        if (this.linesHeight > this.pageHeight) {
            this.linesHeight = this.getWholeLinesHeight(this.pageHeight);
        }
        if (this.pageWidth - this.marginLeft - this.cellsWidth < 0.0) {
            this.marginLeft = this.pageWidth - this.cellsWidth;
        }
        if (this.pageHeight - this.marginTop - this.linesHeight < 0.0) {
            this.marginTop = this.pageHeight - this.linesHeight;
        }
        this.updatePageValues();
    }

    private final void calculateCellsLinesAndUpdate() {
        this.marginLeft = Math.min(this.marginLeft, this.pageWidth);
        if (this.pageWidth - this.marginLeft - this.cellsWidth < 0.0) {
            this.cellsWidth = this.pageWidth - this.marginLeft;
        }
        this.marginTop = Math.min(this.marginTop, this.pageHeight);
        if (this.pageHeight - this.marginTop - this.linesHeight < 0.0) {
            this.linesHeight = this.pageHeight - this.marginTop;
        }
        this.updatePageValues();
    }

    private final void updatePageValues() {
        this.cellsWidth = this.getWholeCellsWidth(this.cellsWidth);
        this.marginRight = this.pageWidth - this.marginLeft - this.cellsWidth;
        this.linesHeight = this.getWholeLinesHeight(this.linesHeight);
        this.marginBottom = this.pageHeight - this.marginTop - this.linesHeight;
        this.updateFields();
    }

    private final void onStandardPageSelected() {
        Page p = this.standardPages.get(this.pageTypes.getSelectionIndex());
        this.pageHeight = p.getHeight(LengthUtils.Units.MILLIMETRES);
        this.pageWidth = p.getWidth(LengthUtils.Units.MILLIMETRES);
        this.marginLeft = p.getLeftMargin(LengthUtils.Units.MILLIMETRES);
        this.marginRight = p.getRightMargin(LengthUtils.Units.MILLIMETRES);
        this.marginTop = p.getTopMargin(LengthUtils.Units.MILLIMETRES);
        this.marginBottom = p.getBottomMargin(LengthUtils.Units.MILLIMETRES);
        this.cellsWidth = Math.max(this.pageWidth - this.marginLeft - this.marginRight, 0.0);
        this.linesHeight = Math.max(this.pageHeight - this.marginTop - this.marginBottom, 0.0);
        this.calculateCellsLinesAndUpdate();
        if (Intrinsics.areEqual((Object)this.pageTypes.getItem(this.pageTypes.getItemCount() - 1), (Object)localeHandler.get("custom"))) {
            this.pageTypes.remove(this.pageTypes.getItemCount() - 1);
        }
    }

    private final void onMarginUnitSelected() {
        if (this.isAnyFieldEmpty() || this.marginLocalUnit == this.regionalButton.getSelection()) {
            return;
        }
        if (this.regionalButton.getSelection()) {
            this.marginLocalUnit = true;
            this.marginTopLabel.setText(this.replaceOldUnitLabel(this.marginTopLabel, this.unitName));
            this.marginBottomLabel.setText(this.replaceOldUnitLabel(this.marginBottomLabel, this.unitName));
            this.marginLeftLabel.setText(this.replaceOldUnitLabel(this.marginLeftLabel, this.unitName));
            this.marginRightLabel.setText(this.replaceOldUnitLabel(this.marginRightLabel, this.unitName));
            this.regionalButton.setSelection(true);
            this.cellsLinesButton.setSelection(false);
        } else {
            this.marginLocalUnit = false;
            this.marginTopLabel.setText(this.replaceOldUnitLabel(this.marginTopLabel, "lines"));
            this.marginBottomLabel.setText(this.replaceOldUnitLabel(this.marginBottomLabel, "lines"));
            this.marginLeftLabel.setText(this.replaceOldUnitLabel(this.marginLeftLabel, "cells"));
            this.marginRightLabel.setText(this.replaceOldUnitLabel(this.marginRightLabel, "cells"));
            this.regionalButton.setSelection(false);
            this.cellsLinesButton.setSelection(true);
        }
        this.updateFields();
    }

    private final String replaceOldUnitLabel(Label label, String newUnit) {
        String text;
        String string = text = label.getText();
        Intrinsics.checkNotNull((Object)string);
        text = StringsKt.substringBeforeLast$default((String)string, (String)" ", null, (int)2, null);
        return text + " (" + newUnit + ")";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isAnyFieldEmpty() {
        String string = this.widthBox.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        if (((CharSequence)string).length() == 0) {
            return true;
        }
        boolean bl = false;
        if (bl) return true;
        String string2 = this.heightBox.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        if (((CharSequence)string2).length() == 0) {
            return true;
        }
        boolean bl2 = false;
        if (bl2) return true;
        String string3 = this.linesBox.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
        if (((CharSequence)string3).length() == 0) {
            return true;
        }
        boolean bl3 = false;
        if (bl3) return true;
        String string4 = this.cellsBox.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getText(...)");
        if (((CharSequence)string4).length() == 0) {
            return true;
        }
        boolean bl4 = false;
        if (bl4) return true;
        String string5 = this.marginTopBox.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getText(...)");
        if (((CharSequence)string5).length() == 0) {
            return true;
        }
        boolean bl5 = false;
        if (bl5) return true;
        String string6 = this.marginLeftBox.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getText(...)");
        if (((CharSequence)string6).length() == 0) {
            return true;
        }
        boolean bl6 = false;
        if (bl6) return true;
        String string7 = this.marginRightBox.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getText(...)");
        if (((CharSequence)string7).length() == 0) {
            return true;
        }
        boolean bl7 = false;
        if (bl7) return true;
        String string8 = this.marginBottomBox.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"getText(...)");
        if (((CharSequence)string8).length() != 0) return false;
        return true;
    }

    @Override
    @Nullable
    public String validate() {
        if (this.marginRight + this.marginLeft + this.cellsWidth > this.pageWidth) {
            return "incorrectMarginWidth";
        }
        if (this.marginTop + this.marginBottom + this.linesHeight > this.pageHeight) {
            return "incorrectMarginHeight";
        }
        if (this.pageHeight <= 0.0 || this.pageWidth <= 0.0 || this.linesHeight <= 0.0 || this.cellsWidth <= 0.0 || this.marginTop < 0.0 || this.marginBottom < 0.0 || this.marginLeft < 0.0 || this.marginRight < 0.0) {
            return "settingsBelowZero";
        }
        return null;
    }

    @Override
    public boolean updateEngine(@NotNull UTDTranslationEngine engine) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        PageSettings pageSettings = engine.getPageSettings();
        BrailleSettings brailleSettings = engine.getBrailleSettings();
        return FormUIUtils.INSTANCE.updateObject((KMutableProperty0)new MutablePropertyReference0Impl(brailleSettings){

            public Object get() {
                return ((BrailleSettings)this.receiver).getCellType();
            }

            public void set(Object value) {
                ((BrailleSettings)this.receiver).setCellType((BrlCell)value);
            }
        }, this.brailleCell) || FormUIUtils.INSTANCE.updateObject((KMutableProperty0)new MutablePropertyReference0Impl(pageSettings){

            public Object get() {
                return ((PageSettings)this.receiver).getPaperHeight();
            }

            public void set(Object value) {
                ((PageSettings)this.receiver).setPaperHeight(((Number)value).doubleValue());
            }
        }, this.pageHeight) || FormUIUtils.INSTANCE.updateObject((KMutableProperty0)new MutablePropertyReference0Impl(pageSettings){

            public Object get() {
                return ((PageSettings)this.receiver).getPaperWidth();
            }

            public void set(Object value) {
                ((PageSettings)this.receiver).setPaperWidth(((Number)value).doubleValue());
            }
        }, this.pageWidth) || FormUIUtils.INSTANCE.updateObject((KMutableProperty0)new MutablePropertyReference0Impl(pageSettings){

            public Object get() {
                return ((PageSettings)this.receiver).getTopMargin();
            }

            public void set(Object value) {
                ((PageSettings)this.receiver).setTopMargin(((Number)value).doubleValue());
            }
        }, this.marginTop) || FormUIUtils.INSTANCE.updateObject((KMutableProperty0)new MutablePropertyReference0Impl(pageSettings){

            public Object get() {
                return ((PageSettings)this.receiver).getBottomMargin();
            }

            public void set(Object value) {
                ((PageSettings)this.receiver).setBottomMargin(((Number)value).doubleValue());
            }
        }, this.marginBottom) || FormUIUtils.INSTANCE.updateObject((KMutableProperty0)new MutablePropertyReference0Impl(pageSettings){

            public Object get() {
                return ((PageSettings)this.receiver).getLeftMargin();
            }

            public void set(Object value) {
                ((PageSettings)this.receiver).setLeftMargin(((Number)value).doubleValue());
            }
        }, this.marginLeft) || FormUIUtils.INSTANCE.updateObject((KMutableProperty0)new MutablePropertyReference0Impl(pageSettings){

            public Object get() {
                return ((PageSettings)this.receiver).getRightMargin();
            }

            public void set(Object value) {
                ((PageSettings)this.receiver).setRightMargin(((Number)value).doubleValue());
            }
        }, this.marginRight) || FormUIUtils.INSTANCE.updateObject((KMutableProperty0)new MutablePropertyReference0Impl(pageSettings){

            public Object get() {
                return ((PageSettings)this.receiver).getInterpoint();
            }

            public void set(Object value) {
                ((PageSettings)this.receiver).setInterpoint(((Boolean)value).booleanValue());
            }
        }, Intrinsics.areEqual((Object)this.interpointCombo.getText(), (Object)"Yes"));
    }

    private final KeyListener makeFieldListener(Supplier<String> getRawValue, DoubleUnaryOperator setParsedValue, Consumer<KeyEvent> function) {
        return (KeyListener)new KeyAdapter(this, getRawValue, setParsedValue, function){
            final /* synthetic */ PagePropertiesTab this$0;
            final /* synthetic */ Supplier<String> $getRawValue;
            final /* synthetic */ DoubleUnaryOperator $setParsedValue;
            final /* synthetic */ Consumer<KeyEvent> $function;
            {
                this.this$0 = $receiver;
                this.$getRawValue = $getRawValue;
                this.$setParsedValue = $setParsedValue;
                this.$function = $function;
            }

            public void keyReleased(KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (PagePropertiesTab.access$isAnyFieldEmpty(this.this$0) || !e.doit) {
                    return;
                }
                String string = this.$getRawValue.get();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
                String rawValue = string;
                if (Intrinsics.areEqual((Object)rawValue, (Object)".") || Intrinsics.areEqual((Object)rawValue, (Object)"-")) {
                    return;
                }
                try {
                    double value = Double.parseDouble(rawValue);
                    this.$setParsedValue.applyAsDouble(value);
                    this.$function.accept(e);
                }
                catch (NumberFormatException numberFormatException) {
                    MessageBox msg = new MessageBox(Display.getCurrent().getActiveShell());
                    msg.setMessage("Incorrect number format. Please enter another number.");
                    msg.open();
                }
            }
        };
    }

    private final FocusListener makeFieldFocusListener(Supplier<String> getRawValue, DoubleUnaryOperator setParsedValue, Consumer<FocusEvent> function) {
        return new FocusListener(this, function, getRawValue, setParsedValue){
            final /* synthetic */ PagePropertiesTab this$0;
            final /* synthetic */ Consumer<FocusEvent> $function;
            final /* synthetic */ Supplier<String> $getRawValue;
            final /* synthetic */ DoubleUnaryOperator $setParsedValue;
            {
                this.this$0 = $receiver;
                this.$function = $function;
                this.$getRawValue = $getRawValue;
                this.$setParsedValue = $setParsedValue;
            }

            public void focusLost(FocusEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (PagePropertiesTab.access$isAnyFieldEmpty(this.this$0)) {
                    this.$function.accept(e);
                }
                String string = this.$getRawValue.get();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
                String rawValue = string;
                if (Intrinsics.areEqual((Object)rawValue, (Object)".") || Intrinsics.areEqual((Object)rawValue, (Object)"-")) {
                    return;
                }
                try {
                    double value = Double.parseDouble(rawValue);
                    this.$setParsedValue.applyAsDouble(value);
                    this.$function.accept(e);
                }
                catch (NumberFormatException numberFormatException) {
                    MessageBox msg = new MessageBox(Display.getCurrent().getActiveShell());
                    msg.setMessage("Incorrect number format. Please enter another number.");
                    msg.open();
                }
            }

            public void focusGained(FocusEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }
        };
    }

    private static final void _init_$lambda$0(PagePropertiesTab this$0, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.onStandardPageSelected();
    }

    private static final String _init_$lambda$1(PagePropertiesTab this$0) {
        return this$0.widthBox.getText();
    }

    private static final double _init_$lambda$2(PagePropertiesTab this$0, double v) {
        this$0.pageWidth = this$0.unitConverter.localUnitsToMM(v);
        return v;
    }

    private static final void _init_$lambda$3(PagePropertiesTab this$0, KeyEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.calculateCellsLinesAndUpdate();
    }

    private static final String _init_$lambda$4(PagePropertiesTab this$0) {
        return this$0.heightBox.getText();
    }

    private static final double _init_$lambda$5(PagePropertiesTab this$0, double v) {
        this$0.pageHeight = this$0.unitConverter.localUnitsToMM(v);
        return v;
    }

    private static final void _init_$lambda$6(PagePropertiesTab this$0, KeyEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.calculateCellsLinesAndUpdate();
    }

    private static final String _init_$lambda$7(PagePropertiesTab this$0) {
        return this$0.cellsBox.getText();
    }

    private static final double _init_$lambda$8(PagePropertiesTab this$0, double v) {
        this$0.cellsWidth = this$0.brailleCell.getWidthForCells((int)v).doubleValue();
        return v;
    }

    private static final void _init_$lambda$9(PagePropertiesTab this$0, KeyEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.calculateTopAndLeftMarginsAndUpdate();
    }

    private static final String _init_$lambda$10(PagePropertiesTab this$0) {
        return this$0.linesBox.getText();
    }

    private static final double _init_$lambda$11(PagePropertiesTab this$0, double v) {
        this$0.linesHeight = this$0.brailleCell.getHeightForLines((int)v).doubleValue();
        return v;
    }

    private static final void _init_$lambda$12(PagePropertiesTab this$0, KeyEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.calculateTopAndLeftMarginsAndUpdate();
    }

    private static final double _init_$lambda$13(PagePropertiesTab this$0, double v) {
        return this$0.marginLocalUnit ? this$0.unitConverter.localUnitsToMM(v) : this$0.brailleCell.getHeightForLines((int)v).doubleValue();
    }

    private static final double _init_$lambda$14(PagePropertiesTab this$0, double v) {
        return this$0.marginLocalUnit ? this$0.unitConverter.localUnitsToMM(v) : this$0.brailleCell.getWidthForCells((int)v).doubleValue();
    }

    private static final String _init_$lambda$15(PagePropertiesTab this$0) {
        return this$0.marginTopBox.getText();
    }

    private static final double _init_$lambda$16(PagePropertiesTab this$0, double v) {
        this$0.marginTop = v;
        return v;
    }

    private static final void _init_$lambda$17(PagePropertiesTab this$0, FocusEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.calculateCellsLinesAndUpdate();
    }

    private static final String _init_$lambda$18(PagePropertiesTab this$0) {
        return this$0.marginLeftBox.getText();
    }

    private static final double _init_$lambda$19(PagePropertiesTab this$0, double v) {
        this$0.marginLeft = v;
        return v;
    }

    private static final void _init_$lambda$20(PagePropertiesTab this$0, FocusEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.calculateCellsLinesAndUpdate();
    }

    private static final void _init_$lambda$21(PagePropertiesTab this$0, SelectionEvent selectionEvent) {
        this$0.onMarginUnitSelected();
    }

    public static final /* synthetic */ boolean access$isAnyFieldEmpty(PagePropertiesTab $this) {
        return $this.isAnyFieldEmpty();
    }

    public /* synthetic */ PagePropertiesTab(Composite parent, UTDTranslationEngine engine, Shell shell, DefaultConstructorMarker $constructor_marker) {
        this(parent, engine, shell);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/brailleblaster/settings/ui/PagePropertiesTab$Companion;", "", "<init>", "()V", "localeHandler", "Lorg/brailleblaster/utils/localization/LocaleHandler;", "NUMBER_FORMATTER", "Ljava/text/DecimalFormat;", "create", "Lorg/brailleblaster/settings/ui/PagePropertiesTab;", "folder", "Lorg/eclipse/swt/widgets/TabFolder;", "engine", "Lorg/brailleblaster/utd/UTDTranslationEngine;", "shell", "Lorg/eclipse/swt/widgets/Shell;", "parseDouble", "", "number", "", "makeYesNoCombo", "Lorg/eclipse/swt/widgets/Combo;", "parent", "Lorg/eclipse/swt/widgets/Composite;", "defaultValue", "", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PagePropertiesTab create(@NotNull TabFolder folder, @NotNull UTDTranslationEngine engine, @NotNull Shell shell) {
            Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
            Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
            Intrinsics.checkNotNullParameter((Object)shell, (String)"shell");
            TabItem tab = new TabItem(folder, 0);
            tab.setText(localeHandler.get("pageProperties"));
            Composite parent = new Composite((Composite)folder, 0);
            parent.setLayout((Layout)new GridLayout(1, true));
            tab.setControl((Control)parent);
            return new PagePropertiesTab(parent, engine, shell, null);
        }

        private final double parseDouble(String number) {
            try {
                return NUMBER_FORMATTER.parse(number).doubleValue();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to parse '" + number + "'", e);
            }
        }

        private final Combo makeYesNoCombo(Composite parent, boolean defaultValue) {
            Combo combo = new Combo(parent, 8);
            combo.add("Yes");
            combo.add("No");
            if (defaultValue) {
                combo.setText("Yes");
            } else {
                combo.setText("No");
            }
            EasySWT.INSTANCE.setGridData((Control)combo);
            return combo;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

