/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.tools;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import nu.xom.Text;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.bbx.BBXUtilsKt;
import org.brailleblaster.exceptions.EditingException;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.perspectives.braille.mapping.elements.TextMapElement;
import org.brailleblaster.perspectives.braille.messages.AdjustLocalStyleMessage;
import org.brailleblaster.perspectives.braille.messages.Sender;
import org.brailleblaster.perspectives.mvc.XMLNodeCaret;
import org.brailleblaster.perspectives.mvc.XMLTextCaret;
import org.brailleblaster.perspectives.mvc.events.ModifyEvent;
import org.brailleblaster.perspectives.mvc.menu.BBSelectionData;
import org.brailleblaster.perspectives.mvc.menu.TopMenu;
import org.brailleblaster.settings.UTDManager;
import org.brailleblaster.tools.MenuToolModule;
import org.brailleblaster.utd.IStyle;
import org.brailleblaster.utd.Style;
import org.brailleblaster.utd.internal.xml.FastXPath;
import org.brailleblaster.utd.internal.xml.XMLHandlerKt;
import org.brailleblaster.util.Utils;
import org.eclipse.swt.custom.StyledText;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/brailleblaster/tools/LineBreakTool;", "Lorg/brailleblaster/tools/MenuToolModule;", "<init>", "()V", "topMenu", "Lorg/brailleblaster/perspectives/mvc/menu/TopMenu;", "getTopMenu", "()Lorg/brailleblaster/perspectives/mvc/menu/TopMenu;", "title", "", "getTitle", "()Ljava/lang/String;", "onRun", "", "bbData", "Lorg/brailleblaster/perspectives/mvc/menu/BBSelectionData;", "insertInlineLineBreak", "manager", "Lorg/brailleblaster/perspectives/braille/Manager;", "dispatchAdjustLinesMessage", "nextNode", "Lnu/xom/Node;", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nLineBreakTool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LineBreakTool.kt\norg/brailleblaster/tools/LineBreakTool\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,147:1\n296#2,2:148\n296#2,2:150\n*S KotlinDebug\n*F\n+ 1 LineBreakTool.kt\norg/brailleblaster/tools/LineBreakTool\n*L\n95#1:148,2\n104#1:150,2\n*E\n"})
public final class LineBreakTool
implements MenuToolModule {
    @NotNull
    public static final LineBreakTool INSTANCE = new LineBreakTool();
    @NotNull
    private static final TopMenu topMenu = TopMenu.EDIT;
    @NotNull
    private static final String title = "Line Break\tShift + Enter";

    private LineBreakTool() {
    }

    @Override
    @NotNull
    public TopMenu getTopMenu() {
        return topMenu;
    }

    @Override
    @NotNull
    public String getTitle() {
        return title;
    }

    @Override
    public void onRun(@NotNull BBSelectionData bbData) {
        Intrinsics.checkNotNullParameter((Object)bbData, (String)"bbData");
        this.insertInlineLineBreak(bbData.getManager());
    }

    /*
     * WARNING - void declaration
     */
    public final void insertInlineLineBreak(@NotNull Manager manager) {
        ParentNode parent;
        block17: {
            Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
            parent = null;
            try {
                manager.checkForUpdatedViews();
                Node currentNode = manager.getSimpleManager().getCurrentSelection().start.getNode();
                TextMapElement textMapElement = manager.getMapList().getCurrent();
                Intrinsics.checkNotNullExpressionValue((Object)textMapElement, (String)"getCurrent(...)");
                TextMapElement currentTme = textMapElement;
                while (currentTme.getText().length() > manager.getTextView().getCaretOffset() && currentTme.getText().charAt(manager.getTextView().getCaretOffset()) == ' ') {
                    StyledText styledText = manager.getTextView();
                    styledText.setCaretOffset(styledText.getCaretOffset() + 1);
                    manager.updateFormatting();
                }
                parent = (ParentNode)BBXUtilsKt.findBlock(currentNode);
                Element lineBreak = BBX.INLINE.LINE_BREAK.create();
                UTDManager utdMan = manager.getDocument().getSettingsManager();
                IStyle iStyle = manager.getStyle((Node)lineBreak);
                Intrinsics.checkNotNull((Object)iStyle, (String)"null cannot be cast to non-null type org.brailleblaster.utd.Style");
                Style style = (Style)iStyle;
                Integer n = 1;
                Intrinsics.checkNotNull((Object)lineBreak);
                utdMan.applyStyleWithOption(style, Style.StyleOption.LINES_BEFORE, n, lineBreak);
                if (BBX.CONTAINER.TABLE.isA(currentNode)) {
                    return;
                }
                if (!(currentNode instanceof Text)) break block17;
                if (((TextMapElement)manager.getMapList().get(0)).getNode() != null && Intrinsics.areEqual((Object)((TextMapElement)manager.getMapList().get(0)).getNode(), (Object)currentNode)) {
                    XMLNodeCaret xMLNodeCaret = manager.getSimpleManager().getCurrentSelection().start;
                    Intrinsics.checkNotNull((Object)xMLNodeCaret, (String)"null cannot be cast to non-null type org.brailleblaster.perspectives.mvc.XMLTextCaret");
                    if (((XMLTextCaret)xMLNodeCaret).getOffset() == 0) {
                        return;
                    }
                }
                String string = ((Text)currentNode).toXML();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toXML(...)");
                if (((CharSequence)string).length() == 0) {
                    return;
                }
                XMLNodeCaret xMLNodeCaret = manager.getSimpleManager().getCurrentSelection().end;
                Intrinsics.checkNotNull((Object)xMLNodeCaret, (String)"null cannot be cast to non-null type org.brailleblaster.perspectives.mvc.XMLTextCaret");
                int offset = ((XMLTextCaret)xMLNodeCaret).getOffset();
                int index = ((Element)parent).indexOf(currentNode);
                if (index == 0 && offset == 0) {
                    IStyle iStyle2 = manager.getStyle((Node)lineBreak);
                    Intrinsics.checkNotNull((Object)iStyle2, (String)"null cannot be cast to non-null type org.brailleblaster.utd.Style");
                    utdMan.applyStyleWithOption((Style)iStyle2, Style.StyleOption.LINES_BEFORE, 2, lineBreak);
                    Utils.insertChildCountSafe(parent, (Node)lineBreak, index);
                    break block17;
                }
                if (offset == 0) {
                    Object v8;
                    block18: {
                        void $this$firstOrNull$iv;
                        Iterable iterable = FastXPath.INSTANCE.precedingAndSelf(currentNode);
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            Node node = (Node)element$iv;
                            boolean bl = false;
                            if (!BBX.INLINE.LINE_BREAK.isA(node)) continue;
                            v8 = element$iv;
                            break block18;
                        }
                        v8 = null;
                    }
                    Node previousNode = v8;
                    if (previousNode != null && BBX.INLINE.LINE_BREAK.isA(previousNode) && Intrinsics.areEqual((Object)BBXUtilsKt.findBlock(previousNode), (Object)parent)) {
                        this.dispatchAdjustLinesMessage(manager, previousNode);
                    } else {
                        Utils.insertChildCountSafe(parent, (Node)lineBreak, index);
                    }
                    break block17;
                }
                if (offset == ((Text)currentNode).getValue().length()) {
                    Object v9;
                    block19: {
                        Iterable $this$firstOrNull$iv = FastXPath.INSTANCE.followingAndSelf(currentNode);
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            Node node = (Node)element$iv;
                            boolean bl = false;
                            if (!BBX.INLINE.LINE_BREAK.isA(node)) continue;
                            v9 = element$iv;
                            break block19;
                        }
                        v9 = null;
                    }
                    Node nextNode = v9;
                    if (nextNode != null && BBX.INLINE.LINE_BREAK.isA(nextNode) && Intrinsics.areEqual((Object)BBXUtilsKt.findBlock(nextNode), (Object)parent)) {
                        this.dispatchAdjustLinesMessage(manager, nextNode);
                    } else {
                        Utils.insertChildCountSafe(parent, (Node)lineBreak, index + 1);
                    }
                    break block17;
                }
                int[] nArray = new int[]{offset};
                List splitTextNode = XMLHandlerKt.splitNode((Text)((Text)currentNode), (int[])nArray);
                if (splitTextNode.size() < 2) {
                    System.out.println((Object)"Split text node in the middle of node, expected 2 nodes but got less.");
                    return;
                }
                index = ((Text)splitTextNode.get(0)).getParent().indexOf((Node)splitTextNode.get(1));
                ParentNode parentNode = ((Text)splitTextNode.get(0)).getParent();
                Intrinsics.checkNotNullExpressionValue((Object)parentNode, (String)"getParent(...)");
                Utils.insertChildCountSafe(parentNode, (Node)lineBreak, index);
            }
            catch (RuntimeException ex) {
                throw new EditingException("An error occurred while adding an inline line break", (Throwable)ex);
            }
        }
        manager.stopFormatting();
        Node[] nodeArray = new Node[]{parent};
        manager.getSimpleManager().dispatchEvent(new ModifyEvent(Sender.NO_SENDER, true, nodeArray));
    }

    private final void dispatchAdjustLinesMessage(Manager manager, Node nextNode) {
        IStyle iStyle = manager.getStyle(nextNode);
        if (iStyle != null) {
            IStyle style = iStyle;
            boolean bl = false;
            try {
                Intrinsics.checkNotNull((Object)nextNode, (String)"null cannot be cast to non-null type nu.xom.Element");
                manager.dispatch(new AdjustLocalStyleMessage.AdjustLinesMessage((Element)nextNode, true, style.getLinesBefore() + 1));
            }
            catch (RuntimeException e) {
                throw new EditingException("An error occurred while adding Lines Before.", (Throwable)e);
            }
        }
    }
}

