/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.usage;

import java.io.Closeable;
import java.io.StringWriter;
import java.io.Writer;
import java.time.Instant;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.brailleblaster.usage.JsonUsageWriter;
import org.brailleblaster.usage.SqliteUsageLogger;
import org.brailleblaster.usage.UsageLogger;
import org.brailleblaster.usage.UsageLoggerKt;
import org.brailleblaster.usage.UsageManager;
import org.brailleblaster.usage.UsageRecord;
import org.brailleblaster.userHelp.Project;
import org.brailleblaster.util.InstallId;
import org.brailleblaster.util.Utils;
import org.brailleblaster.utils.PropertyFileManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00060\u0002j\u0002`\u00032\u00020\u0004B!\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00140 2\b\b\u0002\u0010!\u001a\u00020\u0006J*\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$2\b\b\u0002\u0010&\u001a\u00020'2\b\b\u0002\u0010!\u001a\u00020\u0006J\u0006\u0010(\u001a\u00020\u001eJ\u0010\u0010)\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u0006H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R$\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u00148V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001c\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0017\u00a8\u0006*"}, d2={"Lorg/brailleblaster/usage/BBUsageManager;", "Lorg/brailleblaster/usage/UsageManager;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "Ljava/io/Closeable;", "connectionString", "", "settings", "Lorg/brailleblaster/utils/PropertyFileManager;", "executorService", "Ljava/util/concurrent/ScheduledExecutorService;", "<init>", "(Ljava/lang/String;Lorg/brailleblaster/utils/PropertyFileManager;Ljava/util/concurrent/ScheduledExecutorService;)V", "sqlLogger", "Lorg/brailleblaster/usage/SqliteUsageLogger;", "logger", "Lorg/brailleblaster/usage/UsageLogger;", "getLogger", "()Lorg/brailleblaster/usage/UsageLogger;", "value", "", "trackingEnabled", "getTrackingEnabled", "()Z", "setTrackingEnabled", "(Z)V", "reportHandler", "Ljava/util/concurrent/ScheduledFuture;", "isReportingData", "close", "", "reportDataAsync", "Ljava/util/concurrent/Future;", "url", "startPeriodicDataReporting", "initial", "", "period", "units", "Ljava/util/concurrent/TimeUnit;", "stopPeriodicDataReporting", "reportData", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nUsageManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UsageManager.kt\norg/brailleblaster/usage/BBUsageManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,117:1\n1#2:118\n*E\n"})
public final class BBUsageManager
implements UsageManager,
AutoCloseable,
Closeable {
    @NotNull
    private final PropertyFileManager settings;
    @NotNull
    private final ScheduledExecutorService executorService;
    @NotNull
    private final SqliteUsageLogger sqlLogger;
    @NotNull
    private final UsageLogger logger;
    @Nullable
    private ScheduledFuture<?> reportHandler;

    public BBUsageManager(@NotNull String connectionString, @NotNull PropertyFileManager settings, @NotNull ScheduledExecutorService executorService) {
        Intrinsics.checkNotNullParameter((Object)connectionString, (String)"connectionString");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)executorService, (String)"executorService");
        this.settings = settings;
        this.executorService = executorService;
        this.sqlLogger = new SqliteUsageLogger(connectionString);
        this.logger = UsageLoggerKt.filterLogger(this.sqlLogger, arg_0 -> BBUsageManager.logger$lambda$0(this, arg_0));
    }

    public /* synthetic */ BBUsageManager(String string, PropertyFileManager propertyFileManager, ScheduledExecutorService scheduledExecutorService, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            ScheduledExecutorService scheduledExecutorService2 = Executors.newSingleThreadScheduledExecutor();
            Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService2, (String)"newSingleThreadScheduledExecutor(...)");
            scheduledExecutorService = scheduledExecutorService2;
        }
        this(string, propertyFileManager, scheduledExecutorService);
    }

    @Override
    @NotNull
    public UsageLogger getLogger() {
        return this.logger;
    }

    @Override
    public boolean getTrackingEnabled() {
        String string = this.settings.getProperty("usageTracking");
        return string != null ? Intrinsics.areEqual((Object)StringsKt.toBooleanStrictOrNull((String)string), (Object)true) : false;
    }

    @Override
    public void setTrackingEnabled(boolean value) {
        this.settings.saveAsBoolean("usageTracking", value);
    }

    public final boolean isReportingData() {
        return this.reportHandler != null;
    }

    @Override
    public void close() {
        this.sqlLogger.close();
        this.stopPeriodicDataReporting();
        this.executorService.shutdown();
    }

    @NotNull
    public final Future<Boolean> reportDataAsync(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Future<Boolean> future = this.executorService.submit(() -> BBUsageManager.reportDataAsync$lambda$0(this, url));
        Intrinsics.checkNotNullExpressionValue(future, (String)"submit(...)");
        return future;
    }

    public static /* synthetic */ Future reportDataAsync$default(BBUsageManager bBUsageManager, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "https://www.brailleblaster.org/usage/";
        }
        return bBUsageManager.reportDataAsync(string);
    }

    public final void startPeriodicDataReporting(long initial, long period, @NotNull TimeUnit units, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)((Object)units), (String)"units");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        ScheduledFuture<?> scheduledFuture = this.reportHandler;
        if (scheduledFuture != null) {
            scheduledFuture.cancel(false);
        }
        this.reportHandler = this.executorService.scheduleWithFixedDelay(() -> BBUsageManager.startPeriodicDataReporting$lambda$0(this, url), initial, period, units);
    }

    public static /* synthetic */ void startPeriodicDataReporting$default(BBUsageManager bBUsageManager, long l, long l2, TimeUnit timeUnit, String string, int n, Object object) {
        if ((n & 4) != 0) {
            timeUnit = TimeUnit.SECONDS;
        }
        if ((n & 8) != 0) {
            string = "https://www.brailleblaster.org/usage/";
        }
        bBUsageManager.startPeriodicDataReporting(l, l2, timeUnit, string);
    }

    public final void stopPeriodicDataReporting() {
        block0: {
            ScheduledFuture<?> scheduledFuture = this.reportHandler;
            if (scheduledFuture == null) break block0;
            scheduledFuture.cancel(false);
        }
    }

    private final boolean reportData(String url) {
        boolean bl;
        if (this.getTrackingEnabled()) {
            Comparable comparable;
            List records = CollectionsKt.toList((Iterable)this.sqlLogger);
            StringWriter json = new StringWriter();
            new JsonUsageWriter().write(records, (Writer)json);
            Iterator iterator = ((Iterable)records).iterator();
            if (!iterator.hasNext()) {
                comparable = null;
            } else {
                UsageRecord it = (UsageRecord)iterator.next();
                boolean bl2 = false;
                Comparable comparable2 = it.getTime();
                while (iterator.hasNext()) {
                    UsageRecord it2 = (UsageRecord)iterator.next();
                    $i$a$-maxOfOrNull-BBUsageManager$reportData$lastRecordTime$1 = false;
                    Comparable comparable3 = it2.getTime();
                    if (comparable2.compareTo(comparable3) >= 0) continue;
                    comparable2 = comparable3;
                }
                comparable = comparable2;
            }
            Instant lastRecordTime = (Instant)comparable;
            if (lastRecordTime != null) {
                boolean bl3;
                try {
                    Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"uid", (Object)InstallId.INSTANCE.getId().toString()), TuplesKt.to((Object)"records", (Object)json.toString()), TuplesKt.to((Object)"version", (Object)Project.BB.INSTANCE.getVersion())};
                    Utils.INSTANCE.httpPost(url, MapsKt.mapOf((Pair[])pairArray));
                    this.sqlLogger.clearTo(lastRecordTime);
                    bl3 = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    bl3 = false;
                }
                bl = bl3;
            } else {
                bl = true;
            }
        } else {
            bl = true;
        }
        return bl;
    }

    private static final boolean logger$lambda$0(BBUsageManager this$0, UsageRecord it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.getTrackingEnabled();
    }

    private static final Boolean reportDataAsync$lambda$0(BBUsageManager this$0, String $url) {
        return this$0.reportData($url);
    }

    private static final void startPeriodicDataReporting$lambda$0(BBUsageManager this$0, String $url) {
        this$0.reportData($url);
    }
}

