/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.usage;

import java.util.Iterator;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.brailleblaster.usage.UsageLogger;
import org.brailleblaster.usage.UsageRecord;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010(\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0016J\u0018\u0010\u000b\u001a\u00020\t2\u000e\u0010\f\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00050\rH\u0016J\u0010\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000fH\u0096\u0080\u0004J\t\u0010\u0010\u001a\u00020\tH\u0096\u0001J\u0010\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0012H\u0096\u0083\u0004R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/brailleblaster/usage/FilteredUsageLogger;", "Lorg/brailleblaster/usage/UsageLogger;", "delegate", "predicate", "Ljava/util/function/Predicate;", "Lorg/brailleblaster/usage/UsageRecord;", "<init>", "(Lorg/brailleblaster/usage/UsageLogger;Ljava/util/function/Predicate;)V", "log", "", "record", "forEach", "action", "Ljava/util/function/Consumer;", "spliterator", "Ljava/util/Spliterator;", "clear", "iterator", "", "brailleblaster-core"})
final class FilteredUsageLogger
implements UsageLogger {
    @NotNull
    private final UsageLogger delegate;
    @NotNull
    private final Predicate<UsageRecord> predicate;

    public FilteredUsageLogger(@NotNull UsageLogger delegate, @NotNull Predicate<UsageRecord> predicate) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        this.delegate = delegate;
        this.predicate = predicate;
    }

    @Override
    public void log(@NotNull UsageRecord record) {
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        if (this.predicate.test(record)) {
            this.delegate.log(record);
        }
    }

    @Override
    public void forEach(@NotNull Consumer<? super UsageRecord> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        this.delegate.forEach(action);
    }

    @Override
    @NotNull
    public Spliterator<UsageRecord> spliterator() {
        Spliterator<UsageRecord> spliterator = this.delegate.spliterator();
        Intrinsics.checkNotNullExpressionValue(spliterator, (String)"spliterator(...)");
        return spliterator;
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    @NotNull
    public Iterator<UsageRecord> iterator() {
        return this.delegate.iterator();
    }
}

