/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.util;

import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.brailleblaster.BBIni;
import org.brailleblaster.utils.OS;
import org.brailleblaster.utils.Platform;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\nJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/brailleblaster/util/SoundManager;", "", "<init>", "()V", "SELECTION_BELL", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "playSelectionBell", "", "playBeep", "getLineListener", "Ljavax/sound/sampled/LineListener;", "clip", "Ljavax/sound/sampled/Clip;", "brailleblaster-core"})
public final class SoundManager {
    @NotNull
    public static final SoundManager INSTANCE = new SoundManager();
    @NotNull
    private static final String SELECTION_BELL = "selection_bell.wav";
    private static final Logger log = LoggerFactory.getLogger(SoundManager.class);

    private SoundManager() {
    }

    public final void playSelectionBell() {
        if (OS.Windows == Platform.getOs()) {
            try {
                String[] stringArray = new String[]{SELECTION_BELL};
                Path audioFile = BBIni.getProgramDataPath().resolve(Paths.get("sounds", stringArray));
                AudioInputStream audioStream = AudioSystem.getAudioInputStream(new BufferedInputStream(Files.newInputStream(audioFile, new OpenOption[0])));
                AudioFormat format = audioStream.getFormat();
                DataLine.Info info = new DataLine.Info(Clip.class, format);
                Line line = AudioSystem.getLine(info);
                Intrinsics.checkNotNull((Object)line, (String)"null cannot be cast to non-null type javax.sound.sampled.Clip");
                Clip audioClip = (Clip)line;
                audioClip.addLineListener(this.getLineListener(audioClip));
                audioClip.open(audioStream);
                audioClip.start();
            }
            catch (UnsupportedAudioFileException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (LineUnavailableException e) {
                e.printStackTrace();
            }
        }
    }

    public final void playBeep() {
        try {
            Toolkit.getDefaultToolkit().beep();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private final LineListener getLineListener(Clip clip) {
        return arg_0 -> SoundManager.getLineListener$lambda$0(clip, arg_0);
    }

    private static final void getLineListener$lambda$0(Clip $clip, LineEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        LineEvent.Type type = event.getType();
        log.debug("Line type {}", (Object)type);
        if (type == LineEvent.Type.STOP) {
            $clip.close();
        }
    }
}

