/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import nu.xom.Text;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.bbx.BBXUtils;
import org.brailleblaster.perspectives.braille.messages.Sender;
import org.brailleblaster.perspectives.mvc.events.ModifyEvent;
import org.brailleblaster.perspectives.mvc.menu.BBSelectionData;
import org.brailleblaster.utd.properties.UTDElements;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ(\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0005H\u0002J\u0012\u0010\u0015\u001a\u00020\n2\b\u0010\u0016\u001a\u0004\u0018\u00010\bH\u0002J\b\u0010\u0017\u001a\u00020\nH\u0002J\u0012\u0010\u0018\u001a\u00020\u00192\b\u0010\u0016\u001a\u0004\u0018\u00010\bH\u0002J\u0014\u0010\u001a\u001a\u0004\u0018\u00010\u00052\b\u0010\u0016\u001a\u0004\u0018\u00010\bH\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/brailleblaster/util/UncontractedGlossary;", "", "<init>", "()V", "selectedNode", "Lnu/xom/Node;", "guideWords", "", "Lnu/xom/Element;", "addUncontractedWord", "", "e", "Lorg/brailleblaster/perspectives/mvc/menu/BBSelectionData;", "handleNonGuideWords", "startNode", "endNode", "followingStart", "Lnu/xom/Nodes;", "precedingEnd", "findFirstWord", "node", "getGuideWords", "element", "pronounceGuideWords", "isGuideWord", "", "findFirstTextNode", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nUncontractedGlossary.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UncontractedGlossary.kt\norg/brailleblaster/util/UncontractedGlossary\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,164:1\n742#2,9:165\n37#3,2:174\n*S KotlinDebug\n*F\n+ 1 UncontractedGlossary.kt\norg/brailleblaster/util/UncontractedGlossary\n*L\n97#1:165,9\n97#1:174,2\n*E\n"})
public final class UncontractedGlossary {
    @NotNull
    public static final UncontractedGlossary INSTANCE = new UncontractedGlossary();
    @Nullable
    private static Node selectedNode;
    @NotNull
    private static List<Element> guideWords;

    private UncontractedGlossary() {
    }

    public final void addUncontractedWord(@NotNull BBSelectionData e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Node node = selectedNode = e.getManager().getSimpleManager().getCurrentSelection().start.getNode();
        Intrinsics.checkNotNull((Object)node);
        ParentNode parentNode = node.getParent();
        Intrinsics.checkNotNull((Object)parentNode, (String)"null cannot be cast to non-null type nu.xom.Element");
        Element toRefresh = (Element)parentNode;
        ParentNode parentNode2 = e.getManager().getSimpleManager().getCurrentSelection().start.getNode().getParent();
        Intrinsics.checkNotNull((Object)parentNode2, (String)"null cannot be cast to non-null type nu.xom.Element");
        Element startNode = (Element)parentNode2;
        ParentNode parentNode3 = e.getManager().getSimpleManager().getCurrentSelection().end.getNode().getParent();
        Intrinsics.checkNotNull((Object)parentNode3, (String)"null cannot be cast to non-null type nu.xom.Element");
        Element endNode = (Element)parentNode3;
        Nodes followingStart = startNode.query("following::node()");
        Nodes precedingEnd = endNode.query("preceding::node()");
        if (startNode != endNode) {
            Node node2 = BBXUtils.INSTANCE.getCommonParent((Node)startNode, (Node)endNode);
            Intrinsics.checkNotNull((Object)node2, (String)"null cannot be cast to non-null type nu.xom.Element");
            toRefresh = (Element)node2;
        }
        if (selectedNode instanceof Text) {
            if (startNode != endNode) {
                if (this.isGuideWord(startNode)) {
                    guideWords.add(startNode);
                }
                int n = followingStart.size();
                for (int i = 0; i < n; ++i) {
                    if (!precedingEnd.contains(followingStart.get(i)) || !(followingStart.get(i) instanceof Element)) continue;
                    Node node3 = followingStart.get(i);
                    Intrinsics.checkNotNull((Object)node3, (String)"null cannot be cast to non-null type nu.xom.Element");
                    if (!this.isGuideWord((Element)node3)) continue;
                    Node node4 = followingStart.get(i);
                    Intrinsics.checkNotNull((Object)node4, (String)"null cannot be cast to non-null type nu.xom.Element");
                    guideWords.add((Element)node4);
                }
                if (this.isGuideWord(endNode)) {
                    guideWords.add(endNode);
                }
            } else if (this.isGuideWord(startNode)) {
                guideWords.add(startNode);
            }
        } else if (selectedNode instanceof Element) {
            this.getGuideWords((Element)selectedNode);
        }
        if (guideWords.isEmpty()) {
            Node node5 = (Node)startNode;
            Node node6 = (Node)endNode;
            Intrinsics.checkNotNull((Object)followingStart);
            Intrinsics.checkNotNull((Object)precedingEnd);
            this.handleNonGuideWords(node5, node6, followingStart, precedingEnd);
        }
        this.pronounceGuideWords();
        Node[] nodeArray = new Node[]{toRefresh};
        e.getManager().getSimpleManager().dispatchEvent(new ModifyEvent(Sender.NO_SENDER, true, nodeArray));
        guideWords = new ArrayList();
    }

    private final void handleNonGuideWords(Node startNode, Node endNode, Nodes followingStart, Nodes precedingEnd) {
        this.findFirstWord(startNode);
        int n = followingStart.size();
        for (int i = 0; i < n; ++i) {
            if (!precedingEnd.contains(followingStart.get(i)) || !(followingStart.get(i) instanceof Element) || UTDElements.BRL.isA(followingStart.get(i))) continue;
            Node node = followingStart.get(i);
            Intrinsics.checkNotNullExpressionValue((Object)node, (String)"get(...)");
            this.findFirstWord(node);
        }
        this.findFirstWord(endNode);
    }

    /*
     * WARNING - void declaration
     */
    private final void findFirstWord(Node node) {
        if (node instanceof Text) {
            String string;
            void $this$toTypedArray$iv;
            List list;
            Collection $this$dropLastWhile$iv;
            Element span = BBX.SPAN.OTHER.create();
            String text = ((Text)node).getValue();
            Intrinsics.checkNotNull((Object)text);
            Object object = text;
            Regex regex = new Regex(" ");
            int n = 0;
            object = regex.split((CharSequence)object, n);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    boolean bl = false;
                    if (((CharSequence)it).length() == 0) continue;
                    list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            $this$dropLastWhile$iv = list;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            String firstWord = thisCollection$iv.toArray(new String[0])[0];
            if (firstWord.length() == text.length()) {
                string = "";
            } else {
                String string2 = text.substring(firstWord.length() + 1);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            }
            String remainingText = string;
            span.appendChild(firstWord);
            guideWords.add(span);
            ParentNode parentNode = ((Text)node).getParent();
            Intrinsics.checkNotNull((Object)parentNode, (String)"null cannot be cast to non-null type nu.xom.Element");
            Element parent = (Element)parentNode;
            parent.replaceChild(node, (Node)span);
            if (((CharSequence)remainingText).length() > 0) {
                parent.appendChild(remainingText);
            }
        } else if (node instanceof Element) {
            int n = ((Element)node).getChildCount();
            for (int i = 0; i < n; ++i) {
                Node child = ((Element)node).getChild(i);
                Intrinsics.checkNotNull((Object)child);
                this.findFirstWord(child);
                if (!(child instanceof Text)) continue;
                return;
            }
        }
    }

    private final void getGuideWords(Element element) {
        if (this.isGuideWord(element)) {
            guideWords.add(element);
        }
        Element element2 = element;
        Intrinsics.checkNotNull((Object)element2);
        int n = element2.getChildCount();
        for (int i = 0; i < n; ++i) {
            if (!(element.getChild(i) instanceof Element)) continue;
            Node node = element.getChild(i);
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Element");
            this.getGuideWords((Element)node);
        }
    }

    private final void pronounceGuideWords() {
        Iterator<Element> iterator = guideWords.iterator();
        while (iterator.hasNext()) {
            Element e;
            Element element = e = iterator.next();
            Intrinsics.checkNotNull((Object)element);
            if (element.getAttribute("pronunciation") != null) {
                e.removeAttribute(e.getAttribute("pronunciation"));
                e.removeAttribute(e.getAttribute("type"));
                e.removeAttribute(e.getAttribute("term"));
                continue;
            }
            e.addAttribute(new Attribute("type", "pronunciation"));
            Node node = this.findFirstTextNode(e);
            Intrinsics.checkNotNull((Object)node);
            e.addAttribute(new Attribute("term", node.getValue()));
            e.addAttribute(new Attribute("pronunciation", "done"));
        }
    }

    private final boolean isGuideWord(Element element) {
        Element element2 = element;
        Intrinsics.checkNotNull((Object)element2);
        Attribute style = element2.getAttribute("utd-style");
        return style != null && Intrinsics.areEqual((Object)style.getValue(), (Object)"Guide Word");
    }

    private final Node findFirstTextNode(Element element) {
        Element element2 = element;
        Intrinsics.checkNotNull((Object)element2);
        int n = element2.getChildCount();
        for (int i = 0; i < n; ++i) {
            if (element.getChild(i) instanceof Text) {
                return element.getChild(i);
            }
            if (!(element.getChild(i) instanceof Element)) continue;
            Node node = element.getChild(i);
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Element");
            return this.findFirstTextNode((Element)node);
        }
        return null;
    }

    static {
        guideWords = new ArrayList();
    }
}

