/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.util;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Arrays;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import nu.xom.Node;
import nu.xom.ParentNode;
import nu.xom.Text;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.settings.UTDManager;
import org.brailleblaster.utd.internal.xml.FastXPath;
import org.brailleblaster.util.ConstantsKt;
import org.brailleblaster.util.Utils$combineAdjacentTextNodes$;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.helpers.MessageFormatter;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J/\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0016\u0010\u0007\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\b\"\u0004\u0018\u00010\u0001H\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0018\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016J \u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0005H\u0007J \u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0005H\u0007J\u0012\u0010\u001e\u001a\u00020\u00122\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0007J\"\u0010!\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020 2\b\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020\u0019H\u0007J\u0016\u0010&\u001a\u00020\u00192\u0006\u0010'\u001a\u00020\u00142\u0006\u0010(\u001a\u00020)J\u0016\u0010*\u001a\u00020\u00052\u0006\u0010+\u001a\u00020\u00052\u0006\u0010,\u001a\u00020\u000eJ\"\u0010-\u001a\u00020\u00052\u0006\u0010+\u001a\u00020\u00052\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050/J,\u00100\u001a\u00020\u00052\u0006\u0010+\u001a\u00020\u00052\u0006\u0010,\u001a\u00020\u000e2\u0012\u00101\u001a\u000e\u0012\u0004\u0012\u000203\u0012\u0004\u0012\u00020\u001202H\u0002J\u001c\u00104\u001a\u00020\u00052\u0012\u00105\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050/H\u0002R\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000f\u00a8\u00066"}, d2={"Lorg/brailleblaster/util/Utils;", "", "<init>", "()V", "formatMessage", "", "inputPattern", "args", "", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "runtimeToString", "startTimeMills", "", "isWindows", "", "()Z", "isLinux", "adjustFontToDialog", "", "m", "Lorg/brailleblaster/perspectives/braille/Manager;", "text", "Lorg/eclipse/swt/custom/StyledText;", "removeRegionString", "start", "", "end", "str", "removeRegionRangeString", "range", "combineAdjacentTextNodes", "parent", "Lnu/xom/ParentNode;", "insertChildCountSafe", "p", "n", "Lnu/xom/Node;", "index", "vPosToLines", "manager", "vPos", "", "httpGet", "requestURL", "firstLineOnly", "httpPost", "postDataParams", "", "httpRun", "callback", "Lkotlin/Function1;", "Ljava/net/HttpURLConnection;", "httpPostMakePostParams", "params", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\norg/brailleblaster/util/Utils\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,207:1\n479#2:208\n*S KotlinDebug\n*F\n+ 1 Utils.kt\norg/brailleblaster/util/Utils\n*L\n98#1:208\n*E\n"})
public final class Utils {
    @NotNull
    public static final Utils INSTANCE = new Utils();

    private Utils() {
    }

    @JvmStatic
    @NotNull
    public static final String formatMessage(@Nullable String inputPattern, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        if (!(args.length == 0) && args[args.length - 1] instanceof Throwable) {
            throw new RuntimeException("Simple formatter cannot handle exceptions, see attached", (Throwable)args[args.length - 1]);
        }
        String string = MessageFormatter.arrayFormat((String)inputPattern, (Object[])args).getMessage();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMessage(...)");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String runtimeToString(long startTimeMills) {
        String string = DurationFormatUtils.formatDurationHMS((long)(System.currentTimeMillis() - startTimeMills));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatDurationHMS(...)");
        return string;
    }

    public final boolean isWindows() {
        return Intrinsics.areEqual((Object)SWT.getPlatform(), (Object)"win32");
    }

    public final boolean isLinux() {
        return Intrinsics.areEqual((Object)SWT.getPlatform(), (Object)"gtk");
    }

    public final void adjustFontToDialog(@Nullable Manager m, @NotNull StyledText text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Manager manager = m;
        Intrinsics.checkNotNull((Object)manager);
        double middle = UTDManager.Companion.getCellsPerLine(manager);
        double width = text.getBounds().width;
        double charWidth = width / middle;
        FontData fd = text.getFont().getFontData()[0];
        fd.setHeight((int)charWidth);
        Font f = new Font((Device)text.getDisplay(), fd);
        text.setFont(f);
    }

    @JvmStatic
    @NotNull
    public static final String removeRegionString(int start, int end, @NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        return StringsKt.take((String)str, (int)start) + StringsKt.drop((String)str, (int)end);
    }

    @JvmStatic
    @NotNull
    public static final String removeRegionRangeString(int start, int range, @NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        return StringsKt.take((String)str, (int)start) + StringsKt.drop((String)str, (int)(start + range));
    }

    @JvmStatic
    public static final void combineAdjacentTextNodes(@Nullable ParentNode parent) {
        Sequence $this$filterIsInstance$iv = FastXPath.descendant((Node)((Node)parent));
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)combineAdjacentTextNodes$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        Sequence textNodes = sequence;
        for (Text node : textNodes) {
            ParentNode textParent = node.getParent();
            int index = textParent.indexOf((Node)node);
            if (index + 1 >= textParent.getChildCount() || !(textParent.getChild(index + 1) instanceof Text)) continue;
            Node node2 = textParent.getChild(index + 1);
            Intrinsics.checkNotNull((Object)node2, (String)"null cannot be cast to non-null type nu.xom.Text");
            Text sibling = (Text)node2;
            sibling.detach();
            node.setValue(node.getValue() + sibling.getValue());
            Utils.combineAdjacentTextNodes(parent);
            return;
        }
    }

    @JvmStatic
    public static final void insertChildCountSafe(@NotNull ParentNode p, @Nullable Node n, int index) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        if (index < 0) {
            if (p.getChildCount() > 0) {
                p.insertChild(n, 0);
            } else {
                p.appendChild(n);
            }
        } else if (p.getChildCount() > index) {
            p.insertChild(n, index);
        } else {
            p.appendChild(n);
        }
    }

    public final int vPosToLines(@NotNull Manager manager, double vPos) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        return manager.getSimpleManager().getUtdManager().getEngine().getBrailleSettings().getCellType().getLinesForHeight(new BigDecimal(String.valueOf(vPos)));
    }

    @NotNull
    public final String httpGet(@NotNull String requestURL, boolean firstLineOnly) {
        Intrinsics.checkNotNullParameter((Object)requestURL, (String)"requestURL");
        return this.httpRun(requestURL, firstLineOnly, (Function1<? super HttpURLConnection, Unit>)((Function1)Utils::httpGet$lambda$0));
    }

    @NotNull
    public final String httpPost(@NotNull String requestURL, @NotNull Map<String, String> postDataParams) throws IOException, InterruptedException {
        Intrinsics.checkNotNullParameter((Object)requestURL, (String)"requestURL");
        Intrinsics.checkNotNullParameter(postDataParams, (String)"postDataParams");
        HttpClient client = HttpClient.newHttpClient();
        String body = this.httpPostMakePostParams(postDataParams);
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(requestURL)).POST(HttpRequest.BodyPublishers.ofString(body)).header("Content-Type", "application/x-www-form-urlencoded").timeout(Duration.ofSeconds(15L)).build();
        HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() == 200) {
            String string = response.body();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"body(...)");
            return string;
        }
        throw new RuntimeException("Error " + response.statusCode() + " when posting to " + requestURL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String httpRun(String requestURL, boolean firstLineOnly, Function1<? super HttpURLConnection, Unit> callback) {
        String requestMethod = "POST";
        try {
            URI uri = new URI(requestURL);
            URL url = uri.toURL();
            URLConnection uRLConnection = url.openConnection();
            Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
            HttpURLConnection conn = (HttpURLConnection)uRLConnection;
            conn.setReadTimeout(15000);
            conn.setConnectTimeout(15000);
            conn.setRequestMethod(requestMethod);
            conn.setDoInput(true);
            conn.setDoOutput(true);
            callback.invoke((Object)conn);
            int responseCode = conn.getResponseCode();
            String response = null;
            Closeable closeable = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            Throwable throwable = null;
            try {
                String string;
                BufferedReader br = (BufferedReader)closeable;
                boolean bl = false;
                if (!firstLineOnly) {
                    string = CollectionsKt.joinToString$default((Iterable)TextStreamsKt.readLines((Reader)br), (CharSequence)ConstantsKt.getLINE_BREAK(), null, null, (int)0, null, null, (int)62, null);
                } else {
                    String string2 = br.readLine();
                    Intrinsics.checkNotNull((Object)string2);
                    string = string2;
                }
                response = string;
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            if (responseCode != 200) {
                throw new RuntimeException("Error " + responseCode + " when connecting to " + requestURL);
            }
            return response;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to connect to url " + requestURL, e);
        }
    }

    private final String httpPostMakePostParams(Map<String, String> params) {
        return CollectionsKt.joinToString$default((Iterable)params.entrySet(), (CharSequence)"&", null, null, (int)0, null, Utils::httpPostMakePostParams$lambda$0, (int)30, null);
    }

    private static final Unit httpGet$lambda$0(HttpURLConnection it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    private static final CharSequence httpPostMakePostParams$lambda$0(Map.Entry e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        String string = "%s=%s";
        Object[] objectArray = new Object[]{URLEncoder.encode((String)e.getKey(), StandardCharsets.UTF_8), URLEncoder.encode((String)e.getValue(), StandardCharsets.UTF_8)};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }
}

