/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.util;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.bbx.BBXUtilsKt;
import org.brailleblaster.math.mathml.MathModuleUtils;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.perspectives.braille.mapping.elements.FormattingWhiteSpaceElement;
import org.brailleblaster.perspectives.braille.mapping.elements.ImagePlaceholderTextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.LineBreakElement;
import org.brailleblaster.perspectives.braille.mapping.elements.PageBreakWhiteSpaceElement;
import org.brailleblaster.perspectives.braille.mapping.elements.PaintedWhiteSpaceElement;
import org.brailleblaster.perspectives.braille.mapping.elements.TextMapElement;
import org.brailleblaster.perspectives.braille.mapping.maps.MapList;
import org.brailleblaster.utd.properties.UTDElements;
import org.brailleblaster.util.Utils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0018\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J(\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J \u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u0017\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0012H\u0007\u00a8\u0006\u001a"}, d2={"Lorg/brailleblaster/util/WhitespaceUtils;", "", "<init>", "()V", "convertWhiteSpaceToLineBreaks", "", "t1", "Lorg/brailleblaster/perspectives/braille/mapping/elements/TextMapElement;", "t2", "list", "Lorg/brailleblaster/perspectives/braille/mapping/maps/MapList;", "appendLineBreakElement", "Lnu/xom/Element;", "n", "Lnu/xom/Node;", "prependLineBreakElement", "addLineBreakElement", "offset", "", "countLineBreaks", "countEndOfLine", "", "areAdjacentTMEs", "removeLineBreakElements", "start", "end", "brailleblaster-core"})
public final class WhitespaceUtils {
    @NotNull
    public static final WhitespaceUtils INSTANCE = new WhitespaceUtils();

    private WhitespaceUtils() {
    }

    @JvmStatic
    public static final void convertWhiteSpaceToLineBreaks(@NotNull TextMapElement t1, @NotNull TextMapElement t2, @NotNull MapList list) {
        Intrinsics.checkNotNullParameter((Object)t1, (String)"t1");
        Intrinsics.checkNotNullParameter((Object)t2, (String)"t2");
        Intrinsics.checkNotNullParameter((Object)list, (String)"list");
        int index1 = list.indexOf(t1);
        int index2 = list.indexOf(t2);
        boolean addEndOfLine = !(t1 instanceof ImagePlaceholderTextMapElement);
        for (int i = index1 + 1; i < index2; ++i) {
            if (list.get(i) instanceof FormattingWhiteSpaceElement && !(list.get(i) instanceof PaintedWhiteSpaceElement) && !(list.get(i) instanceof PageBreakWhiteSpaceElement)) {
                Node node = t1.getNode();
                Intrinsics.checkNotNullExpressionValue((Object)node, (String)"getNode(...)");
                Element lineBreak = WhitespaceUtils.appendLineBreakElement(node);
                list.remove(i);
                list.add(i, new LineBreakElement(lineBreak));
                continue;
            }
            if (!(list.get(i) instanceof LineBreakElement) && !(list.get(i) instanceof PageBreakWhiteSpaceElement)) continue;
            addEndOfLine = false;
        }
        if (addEndOfLine || INSTANCE.areAdjacentTMEs(t1, t2, list)) {
            Node node = t1.getNode();
            Intrinsics.checkNotNullExpressionValue((Object)node, (String)"getNode(...)");
            Element endOfLineBreak = WhitespaceUtils.appendLineBreakElement(node);
            LineBreakElement lbe = new LineBreakElement(endOfLineBreak);
            lbe.setEndOfLine(true);
            list.add(index1 + 1, lbe);
        }
    }

    @JvmStatic
    @NotNull
    public static final Element appendLineBreakElement(@NotNull Node n) {
        Intrinsics.checkNotNullParameter((Object)n, (String)"n");
        return INSTANCE.addLineBreakElement(n, 1);
    }

    @JvmStatic
    @NotNull
    public static final Element prependLineBreakElement(@NotNull Node n) {
        Intrinsics.checkNotNullParameter((Object)n, (String)"n");
        return INSTANCE.addLineBreakElement(n, 0);
    }

    private final Element addLineBreakElement(Node n, int offset) {
        int offset2 = offset;
        Element block = BBXUtilsKt.findBlockOrNull(n);
        if (block == null || BBX.BLOCK.TABLE_CELL.isA((Node)block)) {
            if (Manager.getTableParent(n) != null) {
                block = Manager.getTableParent(n);
                if (offset2 == 1) {
                    ++offset2;
                }
            } else if (n instanceof Element) {
                block = (Element)n;
            } else {
                throw new IllegalStateException("Text node without parent block");
            }
        }
        if (MathModuleUtils.isSpatialMath(n)) {
            block = MathModuleUtils.INSTANCE.getSpatialMathParent(n);
        }
        ParentNode parent = block.getParent();
        Element lineBreak = UTDElements.NEW_LINE.create();
        Intrinsics.checkNotNull((Object)parent);
        Utils.insertChildCountSafe(parent, (Node)lineBreak, parent.indexOf((Node)block) + offset2);
        return lineBreak;
    }

    @JvmStatic
    public static final int countLineBreaks(@NotNull TextMapElement t1, @NotNull TextMapElement t2, @NotNull MapList list, boolean countEndOfLine) {
        Intrinsics.checkNotNullParameter((Object)t1, (String)"t1");
        Intrinsics.checkNotNullParameter((Object)t2, (String)"t2");
        Intrinsics.checkNotNullParameter((Object)list, (String)"list");
        int count = 0;
        int n = list.indexOf(t2);
        for (int i = list.indexOf(t1); i < n; ++i) {
            if (!(list.get(i) instanceof LineBreakElement)) continue;
            if (!countEndOfLine) {
                Object e = list.get(i);
                Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type org.brailleblaster.perspectives.braille.mapping.elements.LineBreakElement");
                if (((LineBreakElement)e).isEndOfLine()) continue;
            }
            ++count;
        }
        return count;
    }

    private final boolean areAdjacentTMEs(TextMapElement t1, TextMapElement t2, MapList list) {
        int index1 = list.indexOf(t1);
        int index2 = list.indexOf(t2);
        if (index2 == index1 + 1) {
            return true;
        }
        for (int i = index1 + 1; i < index2; ++i) {
            if (list.get(i) instanceof PaintedWhiteSpaceElement) continue;
            return false;
        }
        return true;
    }

    @JvmStatic
    public static final void removeLineBreakElements(@NotNull MapList list, int start, int end) {
        Intrinsics.checkNotNullParameter((Object)list, (String)"list");
        boolean bl = 0 <= start ? start <= end : false;
        if (bl && end < list.size()) {
            list.subList(start, end + 1).removeIf(arg_0 -> WhitespaceUtils.removeLineBreakElements$lambda$1(WhitespaceUtils::removeLineBreakElements$lambda$0, arg_0));
        }
    }

    private static final boolean removeLineBreakElements$lambda$0(TextMapElement it) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it instanceof LineBreakElement) {
            ((LineBreakElement)it).getNode().detach();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private static final boolean removeLineBreakElements$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

