/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.util.ui;

import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.brailleblaster.utils.localization.LocaleHandler;
import org.brailleblaster.wordprocessor.WPManager;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\b\u001a\u00020\u00072\b\u0010\t\u001a\u0004\u0018\u00010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/brailleblaster/util/ui/AutoSaveDialog;", "Lorg/eclipse/swt/widgets/Dialog;", "parent", "Lorg/eclipse/swt/widgets/Shell;", "<init>", "(Lorg/eclipse/swt/widgets/Shell;)V", "selection", "", "openAutoSaveDialog", "title", "", "recentSaves", "", "Ljava/nio/file/Path;", "Companion", "brailleblaster-core"})
public final class AutoSaveDialog
extends Dialog {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int selection;
    @NotNull
    private static final LocaleHandler localeHandler = LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null);

    public AutoSaveDialog(@Nullable Shell parent) {
        super(parent);
    }

    public final int openAutoSaveDialog(@Nullable String title, @NotNull Iterable<? extends Path> recentSaves) {
        Intrinsics.checkNotNullParameter(recentSaves, (String)"recentSaves");
        this.selection = -1;
        Shell parent = this.getParent();
        Shell shell = new Shell(parent, 16844896);
        shell.setText(title);
        shell.setLocation(250, 250);
        shell.setLayout((Layout)new GridLayout(2, true));
        Label lblInfo = new Label((Composite)shell, 0);
        lblInfo.setText("We have some data that have been saved automatically by the system, do you want to open it now?");
        GridData lbl = new GridData(1, 1, false, false);
        lbl.horizontalSpan = 2;
        lblInfo.setLayoutData((Object)lbl);
        GridData data = new GridData(0x1000000, 1, false, false);
        List list = new List((Composite)shell, 2564);
        recentSaves.forEach(arg_0 -> AutoSaveDialog.openAutoSaveDialog$lambda$0(list, arg_0));
        data.horizontalSpan = 2;
        list.setLayoutData((Object)data);
        list.setBounds(0, 0, 100, 300);
        list.select(0);
        GridData btn = new GridData(0x1000000, 1, false, false);
        Button buttonOK = new Button((Composite)shell, 8);
        buttonOK.setText(localeHandler.get("Yes"));
        buttonOK.setLayoutData((Object)btn);
        Button buttonCancel = new Button((Composite)shell, 8);
        buttonCancel.setText(localeHandler.get("No"));
        buttonOK.addListener(13, arg_0 -> AutoSaveDialog.openAutoSaveDialog$lambda$1(list, shell, arg_0));
        buttonCancel.addListener(13, arg_0 -> AutoSaveDialog.openAutoSaveDialog$lambda$2(this, shell, arg_0));
        shell.addListener(31, AutoSaveDialog::openAutoSaveDialog$lambda$3);
        shell.addFocusListener(new FocusListener(list){
            final /* synthetic */ List $list;
            {
                this.$list = $list;
            }

            public void focusLost(FocusEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }

            public void focusGained(FocusEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$list.setFocus();
            }
        });
        shell.pack();
        shell.open();
        Display display = parent.getDisplay();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.selection;
    }

    private static final void openAutoSaveDialog$lambda$0(List $list, Path curPath) {
        Intrinsics.checkNotNullParameter((Object)curPath, (String)"curPath");
        String path = ((Object)curPath).toString();
        if (Files.exists(curPath, new LinkOption[0]) && !Files.isDirectory(curPath, new LinkOption[0])) {
            $list.add(path);
        }
    }

    private static final void openAutoSaveDialog$lambda$1(List $list, Shell $shell, Event it) {
        Path filePath = Paths.get($list.getItem($list.getSelectionIndex()), new String[0]);
        Path newPath = null;
        try {
            Path path = Files.createTempFile("recovered-", "-" + filePath.getFileName(), new FileAttribute[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createTempFile(...)");
            newPath = path;
            Files.delete(newPath);
            Files.copy(filePath, newPath, new CopyOption[0]);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to move " + filePath + " to temp directory", ex);
        }
        WPManager.Companion.getInstance().addDocumentManager(newPath);
        $shell.dispose();
    }

    private static final void openAutoSaveDialog$lambda$2(AutoSaveDialog this$0, Shell $shell, Event it) {
        this$0.selection = -1;
        $shell.dispose();
    }

    private static final void openAutoSaveDialog$lambda$3(Event event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.detail == 2) {
            event.doit = false;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/brailleblaster/util/ui/AutoSaveDialog$Companion;", "", "<init>", "()V", "localeHandler", "Lorg/brailleblaster/utils/localization/LocaleHandler;", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

