/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.wordprocessor;

import java.io.File;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.brailleblaster.BBIni;
import org.brailleblaster.utils.OS;
import org.brailleblaster.utils.Platform;
import org.brailleblaster.utils.PropertyFileManager;
import org.brailleblaster.utils.localization.LocaleHandler;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017BU\b\u0007\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0005\u0012\b\b\u0002\u0010\f\u001a\u00020\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\u0013\u001a\u0004\u0018\u00010\u0007J\u0012\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0007H\u0002R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0018"}, d2={"Lorg/brailleblaster/wordprocessor/BBFileDialog;", "", "shell", "Lorg/eclipse/swt/widgets/Shell;", "type", "", "suggestedFileName", "", "filterNames", "", "filterExtensions", "filterIndex", "filterPath", "<init>", "(Lorg/eclipse/swt/widgets/Shell;ILjava/lang/String;[Ljava/lang/String;[Ljava/lang/String;ILjava/lang/String;)V", "widget", "Lorg/eclipse/swt/widgets/FileDialog;", "getWidget", "()Lorg/eclipse/swt/widgets/FileDialog;", "open", "savePath", "", "path", "Companion", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nBBFileDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BBFileDialog.kt\norg/brailleblaster/wordprocessor/BBFileDialog\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,118:1\n1#2:119\n*E\n"})
public final class BBFileDialog {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FileDialog widget;
    @NotNull
    private static final LocaleHandler localeHandler = LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null);
    private static final Logger log = LoggerFactory.getLogger(BBFileDialog.class);
    @NotNull
    private static final String LAST = "lastFileLocation";

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public BBFileDialog(@Nullable Shell shell, int type, @Nullable String suggestedFileName, @NotNull String[] filterNames, @NotNull String[] filterExtensions, int filterIndex, @NotNull String filterPath) {
        void w;
        FileDialog fileDialog;
        Intrinsics.checkNotNullParameter((Object)filterNames, (String)"filterNames");
        Intrinsics.checkNotNullParameter((Object)filterExtensions, (String)"filterExtensions");
        Intrinsics.checkNotNullParameter((Object)filterPath, (String)"filterPath");
        FileDialog fileDialog2 = fileDialog = new FileDialog(shell, type);
        BBFileDialog bBFileDialog = this;
        boolean bl = false;
        Object[] objectArray = new Object[]{filterPath, filterNames, filterExtensions};
        log.debug("Path {} Names {} Extensions {}", objectArray);
        log.debug("suggested file name: " + suggestedFileName);
        if (suggestedFileName != null) {
            w.setFileName(suggestedFileName);
        }
        w.setFilterPath(filterPath);
        w.setFilterNames(Arrays.copyOf(filterNames, filterNames.length));
        w.setFilterExtensions(Arrays.copyOf(filterExtensions, filterExtensions.length));
        w.setOverwrite(true);
        w.setFilterPath(filterPath);
        bBFileDialog.widget = fileDialog;
    }

    public /* synthetic */ BBFileDialog(Shell shell, int n, String string, String[] stringArray, String[] stringArray2, int n2, String string2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 0x20) != 0) {
            n2 = 0;
        }
        if ((n3 & 0x40) != 0) {
            string2 = BBFileDialog.Companion.getDefaultFilterPath();
        }
        this(shell, n, string, stringArray, stringArray2, n2, string2);
    }

    @NotNull
    public final FileDialog getWidget() {
        return this.widget;
    }

    @Nullable
    public final String open() {
        String string;
        if ((this.widget.getStyle() & 0x1000) == 4096) {
            Object file;
            boolean validResult = false;
            String openFileName = null;
            while (!validResult) {
                openFileName = this.widget.open();
                if (openFileName == null) {
                    validResult = true;
                    continue;
                }
                file = new File(openFileName);
                if (((File)file).canRead()) {
                    validResult = true;
                    continue;
                }
                MessageBox errMsg = new MessageBox(this.widget.getParent(), 33);
                if (!((File)file).exists()) {
                    errMsg.setText(localeHandler.get("fileNotExist"));
                    var6_8 = localeHandler.get("fileNotExistMsg");
                    var7_9 = new Object[]{openFileName};
                    String string2 = String.format(var6_8, Arrays.copyOf(var7_9, var7_9.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                    errMsg.setMessage(string2);
                } else {
                    errMsg.setText(localeHandler.get("couldNotReadFile"));
                    var6_8 = localeHandler.get("couldNotReadFileMsg");
                    var7_9 = new Object[]{openFileName};
                    String string3 = String.format(var6_8, Arrays.copyOf(var7_9, var7_9.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
                    errMsg.setMessage(string3);
                }
                errMsg.open();
            }
            file = openFileName;
            String it = file;
            boolean bl = false;
            this.savePath(it);
            string = file;
        } else {
            String string4;
            String it = string4 = this.widget.open();
            boolean bl = false;
            this.savePath(it);
            string = string4;
        }
        return string;
    }

    private final void savePath(String path) {
        if (path == null) {
            return;
        }
        File f = new File(path);
        if (f.exists()) {
            String parent = f.getParent();
            PropertyFileManager propertyFileManager = BBIni.getPropertyFileManager();
            Intrinsics.checkNotNull((Object)parent);
            propertyFileManager.save(LAST, parent);
        }
    }

    @JvmOverloads
    public BBFileDialog(@Nullable Shell shell, int type, @Nullable String suggestedFileName, @NotNull String[] filterNames, @NotNull String[] filterExtensions, int filterIndex) {
        Intrinsics.checkNotNullParameter((Object)filterNames, (String)"filterNames");
        Intrinsics.checkNotNullParameter((Object)filterExtensions, (String)"filterExtensions");
        this(shell, type, suggestedFileName, filterNames, filterExtensions, filterIndex, null, 64, null);
    }

    @JvmOverloads
    public BBFileDialog(@Nullable Shell shell, int type, @Nullable String suggestedFileName, @NotNull String[] filterNames, @NotNull String[] filterExtensions) {
        Intrinsics.checkNotNullParameter((Object)filterNames, (String)"filterNames");
        Intrinsics.checkNotNullParameter((Object)filterExtensions, (String)"filterExtensions");
        this(shell, type, suggestedFileName, filterNames, filterExtensions, 0, null, 96, null);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000b\u001a\u00020\nH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/brailleblaster/wordprocessor/BBFileDialog$Companion;", "", "<init>", "()V", "localeHandler", "Lorg/brailleblaster/utils/localization/LocaleHandler;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "LAST", "", "getDefaultFilterPath", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        private final String getDefaultFilterPath() {
            String string = BBIni.getPropertyFileManager().getProperty(BBFileDialog.LAST);
            if (string == null) {
                if (OS.Windows == Platform.getOs()) {
                    String string2 = System.getProperty("user.home", "c:\\");
                    Intrinsics.checkNotNull((Object)string2);
                    string = string2;
                } else {
                    string = "/";
                }
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

