/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.wordprocessor;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.brailleblaster.BBIni;
import org.brailleblaster.abstractClasses.BBEditorView;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.perspectives.braille.views.style.StylePane;
import org.brailleblaster.perspectives.braille.views.wp.BrailleView;
import org.brailleblaster.perspectives.braille.views.wp.TextView;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Display;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 )2\u00020\u0001:\u0003'()B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\b\u001a\u00020\tJ\b\u0010\n\u001a\u00020\tH\u0002J\b\u0010\u000b\u001a\u00020\tH\u0002J\u0006\u0010\f\u001a\u00020\tJ\u0006\u0010\r\u001a\u00020\tJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u000e\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u000fJ\u0006\u0010\u0019\u001a\u00020\tJ\u0006\u0010\u001a\u001a\u00020\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\u001b\u001a\u00020\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020 8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020$8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&\u00a8\u0006*"}, d2={"Lorg/brailleblaster/wordprocessor/FontManager;", "", "m", "Lorg/brailleblaster/perspectives/braille/Manager;", "<init>", "(Lorg/brailleblaster/perspectives/braille/Manager;)V", "getM", "()Lorg/brailleblaster/perspectives/braille/Manager;", "initViews", "", "initTextView", "initBrailleView", "lineUpStylePaneWithTextView", "lineUpBrailleViewWithTextView", "lineUpSpacingWithTextViewByLineHeight", "", "widget", "Lorg/eclipse/swt/custom/StyledText;", "lineUpSpacingWithTextViewByFontSize", "font", "Lorg/brailleblaster/wordprocessor/FontManager$LoadedFont;", "getLineDelta", "", "toggleBrailleFont", "showSimBraille", "increaseFont", "decreaseFont", "brailleView", "Lorg/brailleblaster/perspectives/braille/views/wp/BrailleView;", "getBrailleView", "()Lorg/brailleblaster/perspectives/braille/views/wp/BrailleView;", "textView", "Lorg/brailleblaster/perspectives/braille/views/wp/TextView;", "getTextView", "()Lorg/brailleblaster/perspectives/braille/views/wp/TextView;", "stylePane", "Lorg/brailleblaster/perspectives/braille/views/style/StylePane;", "getStylePane", "()Lorg/brailleblaster/perspectives/braille/views/style/StylePane;", "LoadedFont", "SystemFont", "Companion", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nFontManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FontManager.kt\norg/brailleblaster/wordprocessor/FontManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,384:1\n1#2:385\n777#3:386\n873#3,2:387\n777#3:389\n873#3,2:390\n*S KotlinDebug\n*F\n+ 1 FontManager.kt\norg/brailleblaster/wordprocessor/FontManager\n*L\n293#1:386\n293#1:387,2\n302#1:389\n302#1:390,2\n*E\n"})
public final class FontManager {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Manager m;
    @NotNull
    private static final Logger log;
    private static final File FONT_DIR;
    @NotNull
    private static final String SETTING_SHOW_BRAILLE = "simBraille";
    @NotNull
    private static final String SETTING_SIZE_DELTA = "fontManager.sizeDelta";
    private static final String FALLBACK_FONT_NAME;
    @NotNull
    private static final List<LoadedFont> TEXT_FONTS;
    @NotNull
    private static final List<LoadedFont> BRAILLE_FONTS;
    @NotNull
    private static final LoadedFont SELECTED_TEXT_FONT;
    private static LoadedFont SELECTED_BRAILLE_FONT;
    private static final int FONT_SIZE_DELTA = 1;
    private static final int MINIMUM_FONT_SIZE_DELTA = -7;
    private static final int MAXIMUM_FONT_SIZE_DELTA = 20;

    public FontManager(@NotNull Manager m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        this.m = m;
    }

    @NotNull
    public final Manager getM() {
        return this.m;
    }

    public final void initViews() {
        this.initTextView();
        this.initBrailleView();
    }

    private final void initTextView() {
        if (BBIni.getDebugging()) {
            this.m.getText().setCharWidth();
            return;
        }
        Font swtFont = Companion.newTextFont();
        log.info("Set text view font to {} height {}", (Object)swtFont.getFontData()[0].getName(), (Object)swtFont.getFontData()[0].getHeight());
        this.getTextView().getView().setFont(swtFont);
        this.getStylePane().getWidget().setFont(swtFont);
        this.lineUpStylePaneWithTextView();
        this.m.getText().setCharWidth();
    }

    private final void initBrailleView() {
        if (BBIni.getDebugging()) {
            this.m.getBraille().setCharWidth();
            this.m.getBraille().getView().setEditable(false);
            return;
        }
        Font swtFont = Companion.newBrailleFont();
        log.info("Set braille view font to {} height {}", (Object)swtFont.getFontData()[0].getName(), (Object)swtFont.getFontData()[0].getHeight());
        this.getBrailleView().getView().setFont(swtFont);
        this.lineUpBrailleViewWithTextView();
        this.m.getBraille().setCharWidth();
        this.m.getBraille().getView().setEditable(false);
    }

    public final void lineUpStylePaneWithTextView() {
        log.trace("style");
        int indexBefore = this.getTextView().getView().getTopPixel();
        this.getTextView().getView().setTopPixel(0);
        this.getStylePane().getView().setTopPixel(0);
        this.getStylePane().getView().setLineSpacing(0);
        if (!this.lineUpSpacingWithTextViewByFontSize(this.getStylePane().getView(), SELECTED_TEXT_FONT)) {
            this.lineUpSpacingWithTextViewByLineHeight(this.getStylePane().getView());
        }
        this.getTextView().getView().setTopPixel(indexBefore);
        this.getStylePane().getView().setTopPixel(indexBefore);
    }

    public final void lineUpBrailleViewWithTextView() {
        log.trace("braille");
        int indexBefore = this.getTextView().getView().getTopPixel();
        this.getTextView().getView().setTopPixel(0);
        this.getBrailleView().getView().setTopPixel(0);
        this.getBrailleView().getView().setLineSpacing(0);
        StyledText styledText = this.getBrailleView().getView();
        LoadedFont loadedFont = SELECTED_BRAILLE_FONT;
        if (loadedFont == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"SELECTED_BRAILLE_FONT");
            loadedFont = null;
        }
        if (!this.lineUpSpacingWithTextViewByFontSize(styledText, loadedFont)) {
            this.lineUpSpacingWithTextViewByLineHeight(this.getBrailleView().getView());
        }
        this.getTextView().getView().setTopPixel(indexBefore);
        this.getBrailleView().getView().setTopPixel(indexBefore);
    }

    private final boolean lineUpSpacingWithTextViewByLineHeight(StyledText widget) {
        if (BBIni.getDebugging()) {
            return true;
        }
        int previousDelta = this.getLineDelta(widget);
        if (previousDelta > 0) {
            log.warn("View is bigger than text view");
            widget.setLineSpacing(0);
            previousDelta = this.getLineDelta(widget);
        }
        if (previousDelta == 0) {
            log.info("Views already line up");
            return true;
        }
        while (true) {
            int newLineSpacing = widget.getLineSpacing() + 1;
            log.debug("Setting line spacing to {}, ", (Object)newLineSpacing);
            widget.setLineSpacing(newLineSpacing);
            int newDelta = this.getLineDelta(widget);
            log.debug("previous delta {} new {}", (Object)previousDelta, (Object)newDelta);
            if (newDelta == 0) {
                log.debug("Done");
                break;
            }
            if (newDelta == previousDelta) {
                widget.setLineSpacing(0);
                log.error("Failed to change line height");
                return false;
            }
            if (Math.abs((double)newDelta) >= Math.abs((double)previousDelta)) {
                widget.setLineSpacing(newLineSpacing - 1);
                break;
            }
            previousDelta = newDelta;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean lineUpSpacingWithTextViewByFontSize(StyledText widget, LoadedFont font) {
        if (BBIni.getDebugging()) {
            return true;
        }
        int previousDelta = this.getLineDelta(widget);
        if (previousDelta > 0) {
            log.warn("View is bigger than text view");
            widget.setFont(LoadedFont.newFont$default(font, 0, 1, null));
            previousDelta = this.getLineDelta(widget);
        }
        if (previousDelta == 0) {
            log.info("Views already line up");
            return true;
        }
        int curHeight = 0;
        curHeight = widget.getFont().getFontData()[0].getHeight();
        while (true) {
            void it;
            log.debug("Setting font from {} to {}", (Object)curHeight, (Object)(curHeight + 1));
            boolean bl = true;
            LoadedFont loadedFont = font;
            boolean bl2 = false;
            int n = curHeight += it;
            Font newFont = loadedFont.newFont(n);
            widget.setFont(newFont);
            int newDelta = this.getLineDelta(widget);
            log.debug("previous delta {} new {}", (Object)previousDelta, (Object)newDelta);
            if (newDelta == 0) {
                return true;
            }
            if (newDelta == previousDelta) {
                log.error("Failed to change line height by font size?");
                return false;
            }
            if (newDelta > 0) {
                void it2;
                log.trace("too far");
                bl2 = true;
                loadedFont = font;
                boolean bl3 = false;
                n = curHeight -= it2;
                newFont = loadedFont.newFont(n);
                widget.setFont(newFont);
                return previousDelta > 0;
            }
            previousDelta = newDelta;
        }
    }

    private final int getLineDelta(StyledText widget) {
        int stylePos = widget.getLinePixel(15);
        int textPos = this.getTextView().getView().getLinePixel(15);
        return stylePos - textPos;
    }

    public final void toggleBrailleFont(boolean showSimBraille) {
        BBIni.getPropertyFileManager().save(SETTING_SHOW_BRAILLE, String.valueOf(showSimBraille));
        this.initBrailleView();
    }

    public final void increaseFont() {
        Companion.increaseFontSetting();
        this.initViews();
    }

    public final void decreaseFont() {
        Companion.decreaseFontSetting();
        this.initViews();
    }

    private final BrailleView getBrailleView() {
        return this.m.getViewManager().getBrailleView();
    }

    private final TextView getTextView() {
        return this.m.getViewManager().getTextView();
    }

    private final StylePane getStylePane() {
        return this.m.getViewManager().stylePane;
    }

    @JvmStatic
    @NotNull
    public static final Font newTextFont() {
        return Companion.newTextFont();
    }

    @JvmStatic
    @NotNull
    public static final Font newBrailleFont() {
        return Companion.newBrailleFont();
    }

    @JvmStatic
    public static final void increaseFontSetting() {
        Companion.increaseFontSetting();
    }

    @JvmStatic
    public static final void decreaseFontSetting() {
        Companion.decreaseFontSetting();
    }

    @JvmStatic
    public static final void copyViewFont(@NotNull Manager m, @NotNull BBEditorView view, @NotNull GC gc) {
        Companion.copyViewFont(m, view, gc);
    }

    public static final boolean isShowBraille() {
        return Companion.isShowBraille();
    }

    /*
     * WARNING - void declaration
     */
    static {
        Object object;
        void var3_3;
        Object object2;
        LoadedFont it;
        Object element$iv$iv;
        Object $this$filterTo$iv$iv;
        Companion = new Companion(null);
        Logger logger = LoggerFactory.getLogger(FontManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        log = logger;
        FONT_DIR = BBIni.getProgramDataPath().resolve("fonts").toFile();
        FALLBACK_FONT_NAME = Display.getCurrent().getFontList(null, true)[0].getName();
        Object object3 = new SystemFont[]{new SystemFont("Courier New", 12), new SystemFont("Liberation Mono", 12)};
        Object $this$filter$iv = (Object[])CollectionsKt.listOf((Object[])object3);
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = iterator.next();
            it = (SystemFont)element$iv$iv;
            boolean bl = false;
            if (!FontManager.Companion.isFontLoaded(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        if ($this$filter$iv.isEmpty()) {
            boolean bl = false;
            log.error("No text fonts found, using fallback {}", (Object)FALLBACK_FONT_NAME);
            String string = FALLBACK_FONT_NAME;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FALLBACK_FONT_NAME");
            object2 = CollectionsKt.listOf((Object)new SystemFont(string, 12));
        } else {
            object2 = $this$filter$iv;
        }
        TEXT_FONTS = (List)object2;
        $this$filter$iv = new LoadedFont[]{new LoadedFont("APH_Braille_Font-6s.otf", 12), new LoadedFont("unibraille29.ttf", 12)};
        $this$filter$iv = CollectionsKt.listOf((Object[])$this$filter$iv);
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = iterator.next();
            it = (LoadedFont)element$iv$iv;
            boolean bl = false;
            if (!FontManager.Companion.isFontLoaded(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        object3 = (List)var3_3;
        if (object3.isEmpty()) {
            boolean bl = false;
            log.error("No braille fonts found, using fallback {}", (Object)FALLBACK_FONT_NAME);
            String string = FALLBACK_FONT_NAME;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FALLBACK_FONT_NAME");
            object = CollectionsKt.listOf((Object)new SystemFont(string, 12));
        } else {
            object = object3;
        }
        BRAILLE_FONTS = (List)object;
        SELECTED_TEXT_FONT = TEXT_FONTS.get(0);
        FontManager.Companion.refreshBrailleFont();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020 H\u0007J\b\u0010!\u001a\u00020 H\u0007J\b\u0010\"\u001a\u00020\u001eH\u0007J\b\u0010#\u001a\u00020\u001eH\u0007J \u0010$\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0007J\u0010\u00101\u001a\u00020\u001e2\u0006\u00102\u001a\u00020\u001aH\u0002J\u0012\u00103\u001a\u00020\r2\b\u00104\u001a\u0004\u0018\u00010\nH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\n \b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0011\u0010\u0003R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001aX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001aX\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010+\u001a\u00020\r8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b,\u0010\u0003\u001a\u0004\b+\u0010-R\u0014\u0010.\u001a\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u001a\u00105\u001a\b\u0012\u0004\u0012\u0002060\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u0010\u0016\u00a8\u00068"}, d2={"Lorg/brailleblaster/wordprocessor/FontManager$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "FONT_DIR", "Ljava/io/File;", "kotlin.jvm.PlatformType", "SETTING_SHOW_BRAILLE", "", "SETTING_SIZE_DELTA", "isFontLoaded", "", "it", "Lorg/brailleblaster/wordprocessor/FontManager$LoadedFont;", "FALLBACK_FONT_NAME", "getFALLBACK_FONT_NAME$annotations", "TEXT_FONTS", "", "BRAILLE_FONTS", "getBRAILLE_FONTS", "()Ljava/util/List;", "SELECTED_TEXT_FONT", "SELECTED_BRAILLE_FONT", "FONT_SIZE_DELTA", "", "MINIMUM_FONT_SIZE_DELTA", "MAXIMUM_FONT_SIZE_DELTA", "refreshBrailleFont", "", "newTextFont", "Lorg/eclipse/swt/graphics/Font;", "newBrailleFont", "increaseFontSetting", "decreaseFontSetting", "copyViewFont", "m", "Lorg/brailleblaster/perspectives/braille/Manager;", "view", "Lorg/brailleblaster/abstractClasses/BBEditorView;", "gc", "Lorg/eclipse/swt/graphics/GC;", "isShowBraille", "isShowBraille$annotations", "()Z", "sizeDelta", "getSizeDelta", "()I", "adjustSizeDelta", "additional", "fontExists", "font", "sWTFonts", "Lorg/eclipse/swt/graphics/FontData;", "getSWTFonts", "brailleblaster-core"})
    @SourceDebugExtension(value={"SMAP\nFontManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FontManager.kt\norg/brailleblaster/wordprocessor/FontManager$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,384:1\n1807#2,3:385\n*S KotlinDebug\n*F\n+ 1 FontManager.kt\norg/brailleblaster/wordprocessor/FontManager$Companion\n*L\n374#1:385,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isFontLoaded(LoadedFont it) {
            boolean bl;
            if (!it.load()) {
                log.warn("Unable to load font {}", (Object)it.getName());
                bl = false;
            } else {
                bl = true;
            }
            return bl;
        }

        private static /* synthetic */ void getFALLBACK_FONT_NAME$annotations() {
        }

        @NotNull
        public final List<LoadedFont> getBRAILLE_FONTS() {
            return BRAILLE_FONTS;
        }

        private final void refreshBrailleFont() {
            SELECTED_BRAILLE_FONT = this.isShowBraille() ? this.getBRAILLE_FONTS().get(0) : (LoadedFont)TEXT_FONTS.get(0);
        }

        @JvmStatic
        @NotNull
        public final Font newTextFont() {
            return SELECTED_TEXT_FONT.newFont(SELECTED_TEXT_FONT.getDefaultHeight() + this.getSizeDelta());
        }

        @JvmStatic
        @NotNull
        public final Font newBrailleFont() {
            LoadedFont loadedFont;
            this.refreshBrailleFont();
            LoadedFont loadedFont2 = SELECTED_BRAILLE_FONT;
            if (loadedFont2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"SELECTED_BRAILLE_FONT");
                loadedFont2 = null;
            }
            if ((loadedFont = SELECTED_BRAILLE_FONT) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"SELECTED_BRAILLE_FONT");
                loadedFont = null;
            }
            return loadedFont2.newFont(loadedFont.getDefaultHeight() + this.getSizeDelta());
        }

        @JvmStatic
        public final void increaseFontSetting() {
            this.adjustSizeDelta(1);
        }

        @JvmStatic
        public final void decreaseFontSetting() {
            this.adjustSizeDelta(-1);
        }

        @JvmStatic
        public final void copyViewFont(@NotNull Manager m, @NotNull BBEditorView view, @NotNull GC gc) {
            Intrinsics.checkNotNullParameter((Object)m, (String)"m");
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            Intrinsics.checkNotNullParameter((Object)gc, (String)"gc");
            if (view == m.getText()) {
                gc.setFont(m.getTextView().getFont());
            } else {
                gc.setFont(m.getBrailleView().getFont());
            }
        }

        public final boolean isShowBraille() {
            return Intrinsics.areEqual((Object)BBIni.getPropertyFileManager().getProperty(FontManager.SETTING_SHOW_BRAILLE, "true"), (Object)"true");
        }

        @JvmStatic
        public static /* synthetic */ void isShowBraille$annotations() {
        }

        private final int getSizeDelta() {
            return BBIni.getPropertyFileManager().getPropertyAsInt(FontManager.SETTING_SIZE_DELTA, 0);
        }

        private final void adjustSizeDelta(int additional) {
            int newSize = BBIni.getPropertyFileManager().getPropertyAsInt(FontManager.SETTING_SIZE_DELTA, 0) + additional;
            if (!(-7 <= newSize ? newSize < 21 : false)) {
                return;
            }
            BBIni.getPropertyFileManager().saveAsInt(FontManager.SETTING_SIZE_DELTA, newSize);
        }

        private final boolean fontExists(String font) {
            boolean bl;
            block3: {
                Iterable $this$any$iv = this.getSWTFonts();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FontData fontData = (FontData)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)fontData.getName(), (Object)font)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private final List<FontData> getSWTFonts() {
            FontData[] fontDataArray = Display.getCurrent().getFontList(null, true);
            return CollectionsKt.listOf((Object[])Arrays.copyOf(fontDataArray, fontDataArray.length));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\u0012\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0005H\u0007R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\t\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/brailleblaster/wordprocessor/FontManager$LoadedFont;", "", "filename", "", "defaultHeight", "", "<init>", "(Ljava/lang/String;I)V", "getFilename", "()Ljava/lang/String;", "getDefaultHeight", "()I", "name", "getName", "setName", "(Ljava/lang/String;)V", "loaded", "", "load", "newFont", "Lorg/eclipse/swt/graphics/Font;", "height", "brailleblaster-core"})
    @SourceDebugExtension(value={"SMAP\nFontManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FontManager.kt\norg/brailleblaster/wordprocessor/FontManager$LoadedFont\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,384:1\n13225#2,2:385\n1#3:387\n*S KotlinDebug\n*F\n+ 1 FontManager.kt\norg/brailleblaster/wordprocessor/FontManager$LoadedFont\n*L\n247#1:385,2\n*E\n"})
    public static class LoadedFont {
        @NotNull
        private final String filename;
        private final int defaultHeight;
        @NotNull
        private String name;
        private boolean loaded;

        public LoadedFont(@NotNull String filename, int defaultHeight) {
            Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
            this.filename = filename;
            this.defaultHeight = defaultHeight;
            this.name = StringsKt.substringBeforeLast$default((String)this.filename, (char)'.', null, (int)2, null);
        }

        @NotNull
        protected final String getFilename() {
            return this.filename;
        }

        public final int getDefaultHeight() {
            return this.defaultHeight;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final void setName(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.name = string;
        }

        public boolean load() {
            boolean bl;
            block4: {
                if (this.loaded) {
                    return true;
                }
                FontData[] fonts = Display.getCurrent().getFontList(null, true);
                Intrinsics.checkNotNull((Object)fonts);
                FontData[] $this$any$iv = fonts;
                boolean $i$f$any = false;
                int n = $this$any$iv.length;
                for (int i = 0; i < n; ++i) {
                    FontData element$iv;
                    FontData it = element$iv = $this$any$iv[i];
                    boolean bl2 = false;
                    String string = it.getName();
                    Intrinsics.checkNotNull((Object)string);
                    if (!string.contentEquals(this.name)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
            if (bl) {
                this.loaded = true;
                return true;
            }
            String fontPath = new File(FONT_DIR, this.filename).getAbsolutePath();
            log.info("Loading font: {}", (Object)fontPath);
            this.loaded = true;
            boolean result = Display.getCurrent().loadFont(fontPath);
            if (!result) {
                log.error("SWT failed to load font {}", (Object)fontPath);
            }
            return result;
        }

        @JvmOverloads
        @NotNull
        public final Font newFont(int height) {
            if (!this.load()) {
                boolean bl = false;
                String string = "Font " + this.name + " not loaded";
                throw new IllegalStateException(string.toString());
            }
            return new Font((Device)Display.getCurrent(), this.name, RangesKt.coerceAtLeast((int)height, (int)1), 0);
        }

        public static /* synthetic */ Font newFont$default(LoadedFont loadedFont, int n, int n2, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: newFont");
            }
            if ((n2 & 1) != 0) {
                n = loadedFont.defaultHeight;
            }
            return loadedFont.newFont(n);
        }

        @JvmOverloads
        @NotNull
        public final Font newFont() {
            return LoadedFont.newFont$default(this, 0, 1, null);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/brailleblaster/wordprocessor/FontManager$SystemFont;", "Lorg/brailleblaster/wordprocessor/FontManager$LoadedFont;", "name", "", "defaultHeight", "", "<init>", "(Ljava/lang/String;I)V", "load", "", "brailleblaster-core"})
    private static final class SystemFont
    extends LoadedFont {
        public SystemFont(@NotNull String name, int defaultHeight) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            super(name, defaultHeight);
        }

        @Override
        public boolean load() {
            return Companion.fontExists(this.getName());
        }
    }
}

