/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.libembosser.drivers.enablingTechnologies;

import com.google.common.io.ByteSource;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Function;
import org.brailleblaster.libembosser.drivers.enablingTechnologies.EnablingTechnologiesDocumentHandler;
import org.brailleblaster.libembosser.drivers.enablingTechnologies.Model;
import org.brailleblaster.libembosser.drivers.utils.BaseTextEmbosser;
import org.brailleblaster.libembosser.drivers.utils.document.events.DocumentEvent;
import org.brailleblaster.libembosser.drivers.utils.document.filters.PageFilter;
import org.brailleblaster.libembosser.embossing.attribute.BrailleCellType;
import org.brailleblaster.libembosser.embossing.attribute.Copies;
import org.brailleblaster.libembosser.embossing.attribute.PageRanges;
import org.brailleblaster.libembosser.embossing.attribute.PaperLayout;
import org.brailleblaster.libembosser.embossing.attribute.PaperMargins;
import org.brailleblaster.libembosser.embossing.attribute.PaperSize;
import org.brailleblaster.libembosser.spi.BrlCell;
import org.brailleblaster.libembosser.spi.EmbossingAttributeSet;
import org.brailleblaster.libembosser.spi.Layout;
import org.brailleblaster.libembosser.spi.Margins;
import org.brailleblaster.libembosser.spi.Rectangle;
import org.jetbrains.annotations.NotNull;

public class EnablingTechnologiesEmbosser
extends BaseTextEmbosser {
    private boolean interpoint;
    private final Model embosserModel;

    public EnablingTechnologiesEmbosser(Model embosserModel, Rectangle maxPaper, Rectangle minPaper, boolean interpoint) {
        super(embosserModel.getId(), "Enabling Technologies", embosserModel.getName(), maxPaper, minPaper);
        this.interpoint = interpoint;
        this.embosserModel = embosserModel;
    }

    @Override
    @NotNull
    protected Function<Iterator<DocumentEvent>, ByteSource> createHandler(EmbossingAttributeSet attributes) {
        BrlCell cell2 = Optional.ofNullable(attributes.get(BrailleCellType.class)).map(v -> (BrlCell)((BrailleCellType)v).getValue()).orElse(BrlCell.NLS);
        Rectangle paper2 = Optional.ofNullable(attributes.get(PaperSize.class)).map(v -> (Rectangle)((PaperSize)v).getValue()).orElse(this.getMaximumPaper());
        Margins margins2 = Optional.ofNullable(attributes.get(PaperMargins.class)).map(v -> (Margins)((PaperMargins)v).getValue()).orElse(Margins.NO_MARGINS);
        BigDecimal[] heightInInches = paper2.getHeight().divideAndRemainder(new BigDecimal("25.4"));
        int paperHeight = heightInInches[1].compareTo(new BigDecimal("0.5")) > 0 ? heightInInches[0].intValue() + 1 : heightInInches[0].intValue();
        int leftMargin = cell2.getCellsForWidth(margins2.getLeft());
        int cellsPerLine = Math.min(cell2.getCellsForWidth(paper2.getWidth().subtract(margins2.getRight()).subtract(margins2.getRight())), this.embosserModel.getMaxCellsPerLine());
        int topMargin = 0;
        if (BigDecimal.ZERO.compareTo(margins2.getTop()) < 0) {
            topMargin = cell2.getLinesForHeight(margins2.getTop());
        }
        int linesPerPage = cell2.getLinesForHeight(paper2.getHeight().subtract(margins2.getTop()).subtract(margins2.getBottom()));
        EnablingTechnologiesDocumentHandler.Builder builder = new EnablingTechnologiesDocumentHandler.Builder(this.embosserModel);
        Optional.ofNullable(attributes.get(Copies.class)).ifPresent(v -> builder.setCopies(((Copies)v).getValue()));
        builder.setLeftMargin(leftMargin).setCellsPerLine(cellsPerLine).setPageLength(paperHeight).setLinesPerPage(linesPerPage).setTopMargin(topMargin);
        builder.setPapermode(Optional.ofNullable(attributes.get(PaperLayout.class)).filter(v -> this.interpoint).map(v -> (Layout)((PaperLayout)v).getValue()).filter(arg_0 -> EnablingTechnologiesDocumentHandler.supportedDuplexModes().contains(arg_0)).orElse(Layout.P1ONLY));
        if (EnablingTechnologiesDocumentHandler.supportedCellTypes().contains((Object)cell2)) {
            builder.setCell(cell2);
        }
        EnablingTechnologiesDocumentHandler handler = builder.build();
        PageRanges pages = Optional.ofNullable((PageRanges)attributes.get(PageRanges.class)).orElseGet(PageRanges::new);
        return new PageFilter(pages).andThen(handler);
    }

    public boolean supportsInterpoint() {
        return this.interpoint;
    }
}

