/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.libembosser.drivers.indexBraille;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteSource;
import java.math.BigDecimal;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.brailleblaster.libembosser.drivers.indexBraille.IndexBrailleDocumentHandler;
import org.brailleblaster.libembosser.drivers.utils.BaseTextEmbosser;
import org.brailleblaster.libembosser.drivers.utils.document.events.DocumentEvent;
import org.brailleblaster.libembosser.drivers.utils.document.filters.PageFilter;
import org.brailleblaster.libembosser.embossing.attribute.Copies;
import org.brailleblaster.libembosser.embossing.attribute.PageRanges;
import org.brailleblaster.libembosser.embossing.attribute.PaperLayout;
import org.brailleblaster.libembosser.embossing.attribute.PaperMargins;
import org.brailleblaster.libembosser.embossing.attribute.PaperSize;
import org.brailleblaster.libembosser.spi.BrlCell;
import org.brailleblaster.libembosser.spi.EmbossingAttributeSet;
import org.brailleblaster.libembosser.spi.Layout;
import org.brailleblaster.libembosser.spi.Margins;
import org.brailleblaster.libembosser.spi.Rectangle;
import org.jetbrains.annotations.NotNull;

public class IndexBrailleEmbosser
extends BaseTextEmbosser {
    private final int maxCellsPerLine;
    private final EnumSet<Layout> supportedSides;
    private final Map<Rectangle, Integer> paperSizes;

    public IndexBrailleEmbosser(String id, String manufacturer, String model, Rectangle maxPaper, Rectangle minPaper, EnumSet<Layout> sides) {
        this(id, manufacturer, model, maxPaper, minPaper, 49, sides);
    }

    public IndexBrailleEmbosser(String id, String manufacturer, String model, Rectangle maxPaper, Rectangle minPaper, int maxCellsPerLine, EnumSet<Layout> sides) {
        this(id, manufacturer, model, maxPaper, minPaper, 49, sides, (Map<Rectangle, Integer>)ImmutableMap.of());
    }

    public IndexBrailleEmbosser(String id, String manufacturer, String model, Rectangle maxPaper, Rectangle minPaper, int maxCellsPerLine, EnumSet<Layout> sides, Map<Rectangle, Integer> paperSizes) {
        super(id, manufacturer, model, maxPaper, minPaper);
        this.maxCellsPerLine = maxCellsPerLine;
        this.supportedSides = sides;
        this.paperSizes = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(paperSizes)));
    }

    public boolean supportsInterpoint() {
        return this.supportedSides.stream().anyMatch(Layout::isDoubleSide);
    }

    @Override
    @NotNull
    protected Function<Iterator<DocumentEvent>, ByteSource> createHandler(EmbossingAttributeSet attributes) {
        BigDecimal bottomMargin;
        BigDecimal topMargin;
        BigDecimal rightMargin;
        BrlCell cell2 = BrlCell.NLS;
        Optional<Rectangle> paperOption = Optional.ofNullable(attributes.get(PaperSize.class)).map(v -> (Rectangle)((PaperSize)v).getValue());
        Margins margins2 = Optional.ofNullable(attributes.get(PaperMargins.class)).map(v -> (Margins)((PaperMargins)v).getValue()).orElse(Margins.NO_MARGINS);
        Rectangle paper2 = paperOption.orElse(this.getMaximumPaper());
        BigDecimal leftMargin = margins2.getLeft();
        if (BigDecimal.ZERO.compareTo(leftMargin) > 0) {
            leftMargin = BigDecimal.ZERO;
        }
        if (BigDecimal.ZERO.compareTo(rightMargin = margins2.getRight()) > 0) {
            rightMargin = BigDecimal.ZERO;
        }
        if (BigDecimal.ZERO.compareTo(topMargin = margins2.getTop()) > 0) {
            topMargin = BigDecimal.ZERO;
        }
        if (BigDecimal.ZERO.compareTo(bottomMargin = margins2.getBottom()) > 0) {
            bottomMargin = BigDecimal.ZERO;
        }
        int cellsPerLine = Math.min(cell2.getCellsForWidth(paper2.getWidth().subtract(leftMargin).subtract(rightMargin)), this.maxCellsPerLine);
        int bindingMargin = IntStream.of(BrlCell.NLS.getCellsForWidth(leftMargin)).filter(i -> i + cellsPerLine <= this.maxCellsPerLine).findFirst().orElseGet(() -> this.maxCellsPerLine - cellsPerLine);
        int topLines = cell2.getLinesForHeight(topMargin);
        int linesPerPage = cell2.getLinesForHeight(paper2.getHeight().subtract(topMargin).subtract(bottomMargin));
        IndexBrailleDocumentHandler.Builder builder = new IndexBrailleDocumentHandler.Builder();
        builder.setLeftMargin(bindingMargin).setCellsPerLine(cellsPerLine).setTopMargin(topLines).setLinesPerPage(linesPerPage);
        Optional.ofNullable(attributes.get(PaperLayout.class)).map(v -> (Layout)((PaperLayout)v).getValue()).ifPresent(v -> builder.setPaperMode(this.getDuplexValue((Layout)v)));
        paperOption.map(p -> this.paperSizes.getOrDefault(paper2, null)).ifPresent(p -> builder.setPaper(OptionalInt.of(p)));
        Optional.ofNullable(attributes.get(Copies.class)).ifPresent(v -> builder.setCopies(((Copies)v).getValue()));
        IndexBrailleDocumentHandler handler = builder.build();
        PageRanges pages = Optional.ofNullable((PageRanges)attributes.get(PageRanges.class)).orElseGet(PageRanges::new);
        return new PageFilter(pages).andThen(handler);
    }

    private int getDuplexValue(Layout sides) {
        switch (this.findNearestSupportedSides(sides)) {
            case INTERPOINT: {
                return 2;
            }
            case P1ONLY: 
            case P2ONLY: {
                return 1;
            }
            case Z_FOLDING_DOUBLE_HORIZONTAL: {
                return 3;
            }
            case Z_FOLDING_SINGLE_HORIZONTAL: {
                return 5;
            }
            case Z_FOLDING_DOUBLE_VERTICAL: {
                return 6;
            }
            case Z_FOLDING_SINGLE_VERTICAL: {
                return 7;
            }
            case SADDLE_STITCH_DOUBLE_SIDED: {
                return 4;
            }
            case SADDLE_STITCH_SINGLE_SIDED: {
                return 8;
            }
        }
        return 1;
    }

    private Layout findNearestSupportedSides(Layout sides) {
        if (this.supportedSides.contains(sides)) {
            return sides;
        }
        if (sides.isDoubleSide() && this.supportedSides.contains(Layout.INTERPOINT)) {
            return Layout.INTERPOINT;
        }
        return Layout.P1ONLY;
    }
}

