/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.libembosser.drivers.utils;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.google.common.io.BaseEncoding;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.imageio.ImageIO;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.brailleblaster.libembosser.drivers.utils.DocumentHandler;
import org.brailleblaster.libembosser.drivers.utils.DocumentParser;
import org.brailleblaster.libembosser.drivers.utils.document.events.BrailleEvent;
import org.brailleblaster.libembosser.drivers.utils.document.events.CellsPerLine;
import org.brailleblaster.libembosser.drivers.utils.document.events.EndDocumentEvent;
import org.brailleblaster.libembosser.drivers.utils.document.events.EndGraphicEvent;
import org.brailleblaster.libembosser.drivers.utils.document.events.EndLineEvent;
import org.brailleblaster.libembosser.drivers.utils.document.events.EndPageEvent;
import org.brailleblaster.libembosser.drivers.utils.document.events.EndSectionEvent;
import org.brailleblaster.libembosser.drivers.utils.document.events.EndVolumeEvent;
import org.brailleblaster.libembosser.drivers.utils.document.events.GraphicOption;
import org.brailleblaster.libembosser.drivers.utils.document.events.LinesPerPage;
import org.brailleblaster.libembosser.drivers.utils.document.events.PageOption;
import org.brailleblaster.libembosser.drivers.utils.document.events.RowGap;
import org.brailleblaster.libembosser.drivers.utils.document.events.RowOption;
import org.brailleblaster.libembosser.drivers.utils.document.events.SectionOption;
import org.brailleblaster.libembosser.drivers.utils.document.events.StartDocumentEvent;
import org.brailleblaster.libembosser.drivers.utils.document.events.StartGraphicEvent;
import org.brailleblaster.libembosser.drivers.utils.document.events.StartLineEvent;
import org.brailleblaster.libembosser.drivers.utils.document.events.StartPageEvent;
import org.brailleblaster.libembosser.drivers.utils.document.events.StartSectionEvent;
import org.brailleblaster.libembosser.drivers.utils.document.events.StartVolumeEvent;
import org.brailleblaster.libembosser.drivers.utils.document.events.VolumeOption;
import org.brailleblaster.libembosser.utils.PEFElementType;
import org.brailleblaster.libembosser.utils.PEFNamespaceContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \"2\u00020\u0001:\u0002\"#B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0012H\u0002J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00112\u0006\u0010\u001a\u001a\u00020\u0012H\u0002J\u0016\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0005\u001a\u00020\u0006J\u0018\u0010!\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006$"}, d2={"Lorg/brailleblaster/libembosser/drivers/utils/DocumentParser;", "", "()V", "createLineEvents", "", "handler", "Lorg/brailleblaster/libembosser/drivers/utils/DocumentHandler;", "lineBuffer", "Ljava/io/ByteArrayOutputStream;", "enterNode", "", "node", "Lorg/w3c/dom/Node;", "resourceNodes", "Lorg/w3c/dom/NodeList;", "exitNode", "findResourceById", "Ljava/util/Optional;", "Lorg/w3c/dom/Element;", "resources", "id", "", "getResourceNodes", "pefNode", "loadImageFromElement", "Ljava/awt/Image;", "e", "parseBrf", "input", "Ljava/io/InputStream;", "parsePef", "inputDoc", "Lorg/w3c/dom/Document;", "processPefElement", "Companion", "ParseException", "libembosser-core-drivers"})
@SourceDebugExtension(value={"SMAP\nDocumentParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocumentParser.kt\norg/brailleblaster/libembosser/drivers/utils/DocumentParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,281:1\n1#2:282\n107#3:283\n79#3,22:284\n*S KotlinDebug\n*F\n+ 1 DocumentParser.kt\norg/brailleblaster/libembosser/drivers/utils/DocumentParser\n*L\n195#1:283\n195#1:284,22\n*E\n"})
public final class DocumentParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger log;

    public final void parseBrf(@NotNull InputStream input, @NotNull DocumentHandler handler) throws ParseException {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        InputStream bufferedInput = new BufferedInputStream(input);
        ByteArrayOutputStream lineBuffer = new ByteArrayOutputStream(100);
        int newLines = 0;
        int newPages = 0;
        int prevByte = -1;
        handler.onEvent(new StartDocumentEvent());
        handler.onEvent(new StartVolumeEvent());
        handler.onEvent(new StartSectionEvent());
        handler.onEvent(new StartPageEvent());
        int readByte = 0;
        try {
            while (true) {
                int n;
                int it = n = bufferedInput.read();
                boolean bl = false;
                readByte = it;
                if (n < 0) break;
                switch (readByte) {
                    case 12: {
                        newLines = 0;
                        ++newPages;
                        this.createLineEvents(handler, lineBuffer);
                        break;
                    }
                    case 10: {
                        if (prevByte == 13) break;
                        ++newLines;
                        this.createLineEvents(handler, lineBuffer);
                        break;
                    }
                    case 13: {
                        ++newLines;
                        this.createLineEvents(handler, lineBuffer);
                        break;
                    }
                    default: {
                        while (newPages > 0) {
                            handler.onEvent(new EndPageEvent());
                            handler.onEvent(new StartPageEvent());
                            --newPages;
                        }
                        while (newLines > 1) {
                            handler.onEvent(new StartLineEvent());
                            handler.onEvent(new EndLineEvent());
                            --newLines;
                        }
                        newLines = 0;
                        lineBuffer.write(readByte);
                    }
                }
                prevByte = readByte;
            }
            this.createLineEvents(handler, lineBuffer);
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
        handler.onEvent(new EndPageEvent());
        handler.onEvent(new EndSectionEvent());
        handler.onEvent(new EndVolumeEvent());
        handler.onEvent(new EndDocumentEvent());
    }

    private final void createLineEvents(DocumentHandler handler, ByteArrayOutputStream lineBuffer) throws UnsupportedEncodingException {
        if (lineBuffer.size() > 0) {
            handler.onEvent(new StartLineEvent());
            handler.onEvent(new BrailleEvent(lineBuffer.toString(Charsets.US_ASCII.name())));
            handler.onEvent(new EndLineEvent());
        }
        lineBuffer.reset();
    }

    public final void parsePef(@NotNull Document inputDoc, @NotNull DocumentHandler handler) {
        Intrinsics.checkNotNullParameter((Object)inputDoc, (String)"inputDoc");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Element root = inputDoc.getDocumentElement();
        if (root != null && Intrinsics.areEqual(Optional.of(PEFElementType.PEF), (Object)PEFElementType.findElementType((Element)root))) {
            this.processPefElement(root, handler);
        }
    }

    private final void processPefElement(Element pefNode, DocumentHandler handler) {
        NodeList resourceNodes = this.getResourceNodes(pefNode);
        Deque nodeStack = new LinkedList();
        Node nextNode = pefNode;
        boolean descend = false;
        do {
            boolean bl;
            if (nextNode != null) {
                nodeStack.push(nextNode);
                bl = this.enterNode(nextNode, resourceNodes, handler);
            } else {
                bl = false;
            }
            descend = bl;
            Node curNode = (Node)nodeStack.peek();
            Node node = nextNode = descend ? curNode.getFirstChild() : null;
            if (nextNode != null) continue;
            nextNode = curNode.getNextSibling();
            nodeStack.pop();
            Intrinsics.checkNotNullExpressionValue((Object)curNode, (String)"curNode");
            this.exitNode(curNode, handler);
        } while (!nodeStack.isEmpty());
    }

    /*
     * WARNING - void declaration
     */
    private final boolean enterNode(Node node, NodeList resourceNodes, DocumentHandler handler) {
        Optional elementType;
        boolean result = true;
        if (node instanceof Element && (elementType = PEFElementType.findElementType((Element)((Element)node))).isPresent()) {
            Optional<CellsPerLine> cols = null;
            Optional duplex2 = null;
            Optional<RowGap> rowGap = null;
            Optional<LinesPerPage> rows = null;
            switch (WhenMappings.$EnumSwitchMapping$0[((PEFElementType)elementType.get()).ordinal()]) {
                case 1: {
                    handler.onEvent(new StartDocumentEvent());
                    break;
                }
                case 2: {
                    Optional<CellsPerLine> optional = Optional.ofNullable(((Element)node).getAttribute("cols")).flatMap(arg_0 -> DocumentParser.enterNode$lambda$1(enterNode.1.INSTANCE, arg_0)).map(arg_0 -> DocumentParser.enterNode$lambda$2(enterNode.2.INSTANCE, arg_0));
                    Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(node.getAttri\u2026 -> CellsPerLine(value) }");
                    cols = optional;
                    Optional optional2 = Optional.ofNullable(((Element)node).getAttribute("duplex")).map(arg_0 -> DocumentParser.enterNode$lambda$3(enterNode.3.INSTANCE, arg_0)).flatMap(arg_0 -> DocumentParser.enterNode$lambda$4(enterNode.4.INSTANCE, arg_0));
                    Intrinsics.checkNotNullExpressionValue(optional2, (String)"ofNullable(node.getAttri\u2026) else Optional.empty() }");
                    duplex2 = optional2;
                    Optional<RowGap> optional3 = Optional.ofNullable(((Element)node).getAttribute("rowgap")).flatMap(arg_0 -> DocumentParser.enterNode$lambda$5(enterNode.5.INSTANCE, arg_0)).map(arg_0 -> DocumentParser.enterNode$lambda$6(enterNode.6.INSTANCE, arg_0));
                    Intrinsics.checkNotNullExpressionValue(optional3, (String)"ofNullable(node.getAttri\u2026: Int? -> RowGap(value) }");
                    rowGap = optional3;
                    Optional<LinesPerPage> optional4 = Optional.ofNullable(((Element)node).getAttribute("rows")).flatMap(arg_0 -> DocumentParser.enterNode$lambda$7(enterNode.7.INSTANCE, arg_0)).map(arg_0 -> DocumentParser.enterNode$lambda$8(enterNode.8.INSTANCE, arg_0));
                    Intrinsics.checkNotNullExpressionValue(optional4, (String)"ofNullable(node.getAttri\u2026 -> LinesPerPage(value) }");
                    rows = optional4;
                    Stream[] streamArray = new Stream[]{Streams.stream(cols), Streams.stream(duplex2), Streams.stream(rowGap), Streams.stream(rows)};
                    Set<VolumeOption> set = Streams.concat((Stream[])streamArray).collect(Collectors.toSet());
                    Intrinsics.checkNotNullExpressionValue(set, (String)"concat(Streams.stream(co\u2026llect(Collectors.toSet())");
                    Set<VolumeOption> volOptions = set;
                    handler.onEvent(new StartVolumeEvent(volOptions));
                    break;
                }
                case 3: {
                    Optional<CellsPerLine> optional = Optional.ofNullable(((Element)node).getAttribute("cols")).flatMap(arg_0 -> DocumentParser.enterNode$lambda$9(enterNode.9.INSTANCE, arg_0)).map(arg_0 -> DocumentParser.enterNode$lambda$10(enterNode.10.INSTANCE, arg_0));
                    Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(node.getAttri\u2026 -> CellsPerLine(value) }");
                    cols = optional;
                    Optional optional5 = Optional.ofNullable(((Element)node).getAttribute("duplex")).map(arg_0 -> DocumentParser.enterNode$lambda$11(enterNode.11.INSTANCE, arg_0)).flatMap(arg_0 -> DocumentParser.enterNode$lambda$12(enterNode.12.INSTANCE, arg_0));
                    Intrinsics.checkNotNullExpressionValue(optional5, (String)"ofNullable(node.getAttri\u2026) else Optional.empty() }");
                    duplex2 = optional5;
                    Optional<RowGap> optional6 = Optional.ofNullable(((Element)node).getAttribute("rowgap")).flatMap(arg_0 -> DocumentParser.enterNode$lambda$13(enterNode.13.INSTANCE, arg_0)).map(arg_0 -> DocumentParser.enterNode$lambda$14(enterNode.14.INSTANCE, arg_0));
                    Intrinsics.checkNotNullExpressionValue(optional6, (String)"ofNullable(node.getAttri\u2026: Int? -> RowGap(value) }");
                    rowGap = optional6;
                    Optional<LinesPerPage> optional7 = Optional.ofNullable(((Element)node).getAttribute("rows")).flatMap(arg_0 -> DocumentParser.enterNode$lambda$15(enterNode.15.INSTANCE, arg_0)).map(arg_0 -> DocumentParser.enterNode$lambda$16(enterNode.16.INSTANCE, arg_0));
                    Intrinsics.checkNotNullExpressionValue(optional7, (String)"ofNullable(node.getAttri\u2026 -> LinesPerPage(value) }");
                    rows = optional7;
                    Stream[] streamArray = new Stream[]{Streams.stream(cols), Streams.stream(duplex2), Streams.stream(rowGap), Streams.stream(rows)};
                    Set<SectionOption> set = Streams.concat((Stream[])streamArray).collect(Collectors.toSet());
                    Intrinsics.checkNotNullExpressionValue(set, (String)"concat(Streams.stream(co\u2026llect(Collectors.toSet())");
                    Set<SectionOption> sectionOptions = set;
                    handler.onEvent(new StartSectionEvent(sectionOptions));
                    break;
                }
                case 4: {
                    Optional<CellsPerLine> optional = Optional.ofNullable(((Element)node).getAttribute("cols")).flatMap(arg_0 -> DocumentParser.enterNode$lambda$17(enterNode.17.INSTANCE, arg_0)).map(arg_0 -> DocumentParser.enterNode$lambda$18(enterNode.18.INSTANCE, arg_0));
                    Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(node.getAttri\u2026 -> CellsPerLine(value) }");
                    cols = optional;
                    Optional<RowGap> optional8 = Optional.ofNullable(((Element)node).getAttribute("rowgap")).flatMap(arg_0 -> DocumentParser.enterNode$lambda$19(enterNode.19.INSTANCE, arg_0)).map(arg_0 -> DocumentParser.enterNode$lambda$20(enterNode.20.INSTANCE, arg_0));
                    Intrinsics.checkNotNullExpressionValue(optional8, (String)"ofNullable(node.getAttri\u2026: Int? -> RowGap(value) }");
                    rowGap = optional8;
                    Optional<LinesPerPage> optional9 = Optional.ofNullable(((Element)node).getAttribute("rows")).flatMap(arg_0 -> DocumentParser.enterNode$lambda$21(enterNode.21.INSTANCE, arg_0)).map(arg_0 -> DocumentParser.enterNode$lambda$22(enterNode.22.INSTANCE, arg_0));
                    Intrinsics.checkNotNullExpressionValue(optional9, (String)"ofNullable(node.getAttri\u2026 -> LinesPerPage(value) }");
                    rows = optional9;
                    Stream[] streamArray = new Stream[]{Streams.stream(cols), Streams.stream(rowGap), Streams.stream(rows)};
                    Set<PageOption> set = Streams.concat((Stream[])streamArray).collect(Collectors.toSet());
                    Intrinsics.checkNotNullExpressionValue(set, (String)"concat(Streams.stream(co\u2026llect(Collectors.toSet())");
                    Set<PageOption> pageOptions = set;
                    handler.onEvent(new StartPageEvent(pageOptions));
                    break;
                }
                case 5: {
                    void $this$trim$iv;
                    Object child;
                    Optional<RowGap> optional = Optional.ofNullable(((Element)node).getAttribute("rowgap")).flatMap(arg_0 -> DocumentParser.enterNode$lambda$23(enterNode.23.INSTANCE, arg_0)).map(arg_0 -> DocumentParser.enterNode$lambda$24(enterNode.24.INSTANCE, arg_0));
                    Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(node.getAttri\u2026: Int? -> RowGap(value) }");
                    rowGap = optional;
                    Set<RowOption> set = Streams.stream(rowGap).collect(Collectors.toSet());
                    Intrinsics.checkNotNullExpressionValue(set, (String)"stream(rowGap).collect(Collectors.toSet())");
                    Set<RowOption> rowOptions = set;
                    handler.onEvent(new StartLineEvent(rowOptions));
                    NodeList children = node.getChildNodes();
                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < children.getLength(); ++i) {
                        child = children.item(i);
                        if (!(child instanceof Text)) continue;
                        sb.append(child.getNodeValue());
                    }
                    String string = sb.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
                    child = string;
                    DocumentHandler documentHandler = handler;
                    boolean $i$f$trim = false;
                    CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
                    boolean $i$f$trim2 = false;
                    int startIndex$iv$iv = 0;
                    int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                    boolean startFound$iv$iv = false;
                    while (startIndex$iv$iv <= endIndex$iv$iv) {
                        boolean match$iv$iv;
                        int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                        char it = $this$trim$iv$iv.charAt(index$iv$iv);
                        boolean bl = false;
                        boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                        if (!startFound$iv$iv) {
                            if (!match$iv$iv) {
                                startFound$iv$iv = true;
                                continue;
                            }
                            ++startIndex$iv$iv;
                            continue;
                        }
                        if (!match$iv$iv) break;
                        --endIndex$iv$iv;
                    }
                    String string2 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                    documentHandler.onEvent(new BrailleEvent(string2));
                    result = false;
                    break;
                }
                case 6: {
                    Optional<GraphicOption.ImageData> img2 = Optional.ofNullable(((Element)node).getAttribute("idref")).flatMap(arg_0 -> DocumentParser.enterNode$lambda$26((Function1)new Function1<String, Optional<Element>>(this, resourceNodes){
                        final /* synthetic */ DocumentParser this$0;
                        final /* synthetic */ NodeList $resourceNodes;
                        {
                            this.this$0 = $receiver;
                            this.$resourceNodes = $resourceNodes;
                            super(1);
                        }

                        public final Optional<Element> invoke(@NotNull String a) {
                            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
                            return DocumentParser.access$findResourceById(this.this$0, this.$resourceNodes, a);
                        }
                    }, arg_0)).flatMap(arg_0 -> DocumentParser.enterNode$lambda$27((Function1)new Function1<Element, Optional<Image>>(this){
                        final /* synthetic */ DocumentParser this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        public final Optional<Image> invoke(@NotNull Element e) {
                            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                            return DocumentParser.access$loadImageFromElement(this.this$0, e);
                        }
                    }, arg_0)).map(arg_0 -> DocumentParser.enterNode$lambda$28(enterNode.img.3.INSTANCE, arg_0));
                    Optional<GraphicOption.Height> height2 = Optional.ofNullable(((Element)node).getAttribute("height")).flatMap(arg_0 -> DocumentParser.enterNode$lambda$29(enterNode.height.1.INSTANCE, arg_0)).map(arg_0 -> DocumentParser.enterNode$lambda$30(enterNode.height.2.INSTANCE, arg_0));
                    Optional<GraphicOption.Indent> indent2 = Optional.ofNullable(((Element)node).getAttribute("indent")).flatMap(arg_0 -> DocumentParser.enterNode$lambda$31(enterNode.indent.1.INSTANCE, arg_0)).map(arg_0 -> DocumentParser.enterNode$lambda$32(enterNode.indent.2.INSTANCE, arg_0));
                    Optional<GraphicOption.Width> width2 = Optional.ofNullable(((Element)node).getAttribute("width")).flatMap(arg_0 -> DocumentParser.enterNode$lambda$33(enterNode.width.1.INSTANCE, arg_0)).map(arg_0 -> DocumentParser.enterNode$lambda$34(enterNode.width.2.INSTANCE, arg_0));
                    Stream[] streamArray = new Stream[]{Streams.stream(img2), Streams.stream(height2), Streams.stream(indent2), Streams.stream(width2)};
                    Object r = Streams.concat((Stream[])streamArray).collect(ImmutableSet.toImmutableSet());
                    Intrinsics.checkNotNullExpressionValue(r, (String)"concat(Streams.stream(im\u2026ableSet<GraphicOption>())");
                    Set graphicOptions = (Set)r;
                    handler.onEvent(new StartGraphicEvent(graphicOptions));
                    result = true;
                    break;
                }
                case 7: {
                    result = false;
                    break;
                }
            }
        }
        return result;
    }

    private final void exitNode(Node node, DocumentHandler handler) {
        if (node instanceof Element) {
            PEFElementType.findElementType((Element)((Element)node)).ifPresent(arg_0 -> DocumentParser.exitNode$lambda$35((Function1)new Function1<PEFElementType, Unit>(handler){
                final /* synthetic */ DocumentHandler $handler;
                {
                    this.$handler = $handler;
                    super(1);
                }

                public final void invoke(@Nullable PEFElementType t) {
                    PEFElementType pEFElementType = t;
                    switch (pEFElementType == null ? -1 : exitNode.WhenMappings.$EnumSwitchMapping$0[pEFElementType.ordinal()]) {
                        case 1: {
                            this.$handler.onEvent(new EndDocumentEvent());
                            break;
                        }
                        case 2: {
                            this.$handler.onEvent(new EndVolumeEvent());
                            break;
                        }
                        case 3: {
                            this.$handler.onEvent(new EndSectionEvent());
                            break;
                        }
                        case 4: {
                            this.$handler.onEvent(new EndPageEvent());
                            break;
                        }
                        case 5: {
                            this.$handler.onEvent(new EndLineEvent());
                            break;
                        }
                        case 6: {
                            this.$handler.onEvent(new EndGraphicEvent());
                            break;
                        }
                    }
                }
            }, arg_0));
        }
    }

    private final NodeList getResourceNodes(Element pefNode) {
        NodeList nodeList;
        try {
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            xpath.setNamespaceContext((NamespaceContext)new PEFNamespaceContext());
            XPathExpression findGraphics = xpath.compile("/pef:pef/tg:images/tg:imageData");
            Object object = findGraphics.evaluate(pefNode, XPathConstants.NODESET);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.w3c.dom.NodeList");
            nodeList = (NodeList)object;
        }
        catch (XPathExpressionException e) {
            nodeList = new NodeList(){

                @NotNull
                public Node item(int index) {
                    throw new IndexOutOfBoundsException(String.valueOf(index));
                }

                public int getLength() {
                    return 0;
                }
            };
        }
        return nodeList;
    }

    private final Optional<Element> findResourceById(NodeList resources, String id) {
        int n = resources.getLength();
        for (int i = 0; i < n; ++i) {
            Node n2 = resources.item(i);
            if (!(n2 instanceof Element)) continue;
            String string = id;
            String string2 = ((Element)n2).getAttribute("id");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"n.getAttribute(\"id\")");
            if (!string.contentEquals(string2)) continue;
            Optional<Node> optional = Optional.of(n2);
            Intrinsics.checkNotNullExpressionValue(optional, (String)"of(n)");
            return optional;
        }
        Optional<Element> optional = Optional.empty();
        Intrinsics.checkNotNullExpressionValue(optional, (String)"empty()");
        return optional;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Optional<Image> loadImageFromElement(Element e) {
        Optional<Image> result = null;
        Optional<Image> optional = Optional.empty();
        Intrinsics.checkNotNullExpressionValue(optional, (String)"empty()");
        result = optional;
        if (StringsKt.equals((String)"base64", (String)e.getAttribute("encoding"), (boolean)true)) {
            String s = e.getTextContent();
            try {
                Closeable closeable = BaseEncoding.base64().decodingStream((Reader)new StringReader(s));
                Throwable throwable = null;
                try {
                    InputStream input = (InputStream)closeable;
                    boolean bl = false;
                    BufferedImage img2 = ImageIO.read(input);
                    Optional<BufferedImage> optional2 = Optional.ofNullable(img2);
                    Intrinsics.checkNotNullExpressionValue(optional2, (String)"ofNullable(img)");
                    result = optional2;
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return result;
    }

    private static final Optional enterNode$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Optional)$tmp0.invoke(p0);
    }

    private static final CellsPerLine enterNode$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (CellsPerLine)$tmp0.invoke(p0);
    }

    private static final String enterNode$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final Optional enterNode$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Optional)$tmp0.invoke(p0);
    }

    private static final Optional enterNode$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Optional)$tmp0.invoke(p0);
    }

    private static final RowGap enterNode$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (RowGap)$tmp0.invoke(p0);
    }

    private static final Optional enterNode$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Optional)$tmp0.invoke(p0);
    }

    private static final LinesPerPage enterNode$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (LinesPerPage)$tmp0.invoke(p0);
    }

    private static final Optional enterNode$lambda$9(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Optional)$tmp0.invoke(p0);
    }

    private static final CellsPerLine enterNode$lambda$10(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (CellsPerLine)$tmp0.invoke(p0);
    }

    private static final String enterNode$lambda$11(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final Optional enterNode$lambda$12(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Optional)$tmp0.invoke(p0);
    }

    private static final Optional enterNode$lambda$13(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Optional)$tmp0.invoke(p0);
    }

    private static final RowGap enterNode$lambda$14(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (RowGap)$tmp0.invoke(p0);
    }

    private static final Optional enterNode$lambda$15(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Optional)$tmp0.invoke(p0);
    }

    private static final LinesPerPage enterNode$lambda$16(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (LinesPerPage)$tmp0.invoke(p0);
    }

    private static final Optional enterNode$lambda$17(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Optional)$tmp0.invoke(p0);
    }

    private static final CellsPerLine enterNode$lambda$18(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (CellsPerLine)$tmp0.invoke(p0);
    }

    private static final Optional enterNode$lambda$19(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Optional)$tmp0.invoke(p0);
    }

    private static final RowGap enterNode$lambda$20(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (RowGap)$tmp0.invoke(p0);
    }

    private static final Optional enterNode$lambda$21(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Optional)$tmp0.invoke(p0);
    }

    private static final LinesPerPage enterNode$lambda$22(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (LinesPerPage)$tmp0.invoke(p0);
    }

    private static final Optional enterNode$lambda$23(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Optional)$tmp0.invoke(p0);
    }

    private static final RowGap enterNode$lambda$24(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (RowGap)$tmp0.invoke(p0);
    }

    private static final Optional enterNode$lambda$26(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Optional)$tmp0.invoke(p0);
    }

    private static final Optional enterNode$lambda$27(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Optional)$tmp0.invoke(p0);
    }

    private static final GraphicOption.ImageData enterNode$lambda$28(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (GraphicOption.ImageData)$tmp0.invoke(p0);
    }

    private static final Optional enterNode$lambda$29(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Optional)$tmp0.invoke(p0);
    }

    private static final GraphicOption.Height enterNode$lambda$30(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (GraphicOption.Height)$tmp0.invoke(p0);
    }

    private static final Optional enterNode$lambda$31(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Optional)$tmp0.invoke(p0);
    }

    private static final GraphicOption.Indent enterNode$lambda$32(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (GraphicOption.Indent)$tmp0.invoke(p0);
    }

    private static final Optional enterNode$lambda$33(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Optional)$tmp0.invoke(p0);
    }

    private static final GraphicOption.Width enterNode$lambda$34(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (GraphicOption.Width)$tmp0.invoke(p0);
    }

    private static final void exitNode$lambda$35(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ Optional access$findResourceById(DocumentParser $this, NodeList resources, String id) {
        return $this.findResourceById(resources, id);
    }

    public static final /* synthetic */ Optional access$loadImageFromElement(DocumentParser $this, Element e) {
        return $this.loadImageFromElement(e);
    }

    static {
        Logger logger = LoggerFactory.getLogger(DocumentParser.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(DocumentParser::class.java)");
        log = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0004\u0018\u0000 \u000b2\u00060\u0001j\u0002`\u0002:\u0001\u000bB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0003B\u0011\b\u0016\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006B\u0011\b\u0016\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tB\u001b\b\u0016\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\n\u00a8\u0006\f"}, d2={"Lorg/brailleblaster/libembosser/drivers/utils/DocumentParser$ParseException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "()V", "msg", "", "(Ljava/lang/String;)V", "cause", "", "(Ljava/lang/Throwable;)V", "(Ljava/lang/String;Ljava/lang/Throwable;)V", "Companion", "libembosser-core-drivers"})
    public static final class ParseException
    extends Exception {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private static final long serialVersionUID = -2233072119599883441L;

        public ParseException() {
        }

        public ParseException(@Nullable String msg) {
            super(msg);
        }

        public ParseException(@Nullable Throwable cause) {
            super(cause);
        }

        public ParseException(@Nullable String msg, @Nullable Throwable cause) {
            super(msg, cause);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/brailleblaster/libembosser/drivers/utils/DocumentParser$ParseException$Companion;", "", "()V", "serialVersionUID", "", "libembosser-core-drivers"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PEFElementType.values().length];
            try {
                nArray[PEFElementType.BODY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PEFElementType.VOLUME.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PEFElementType.SECTION.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PEFElementType.PAGE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PEFElementType.ROW.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PEFElementType.GRAPHIC.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PEFElementType.HEAD.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/brailleblaster/libembosser/drivers/utils/DocumentParser$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "libembosser-core-drivers"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLog() {
            return log;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

