/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.libembosser.drivers.utils.document;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteSource;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Set;
import org.brailleblaster.libembosser.drivers.utils.ClassUtils;
import org.brailleblaster.libembosser.drivers.utils.document.ByteSourceHandlerToFunctionAdapter;
import org.brailleblaster.libembosser.drivers.utils.document.events.BrailleEvent;
import org.brailleblaster.libembosser.drivers.utils.document.events.CellsPerLine;
import org.brailleblaster.libembosser.drivers.utils.document.events.DocumentEvent;
import org.brailleblaster.libembosser.drivers.utils.document.events.DocumentOption;
import org.brailleblaster.libembosser.drivers.utils.document.events.Duplex;
import org.brailleblaster.libembosser.drivers.utils.document.events.EndDocumentEvent;
import org.brailleblaster.libembosser.drivers.utils.document.events.EndLineEvent;
import org.brailleblaster.libembosser.drivers.utils.document.events.EndPageEvent;
import org.brailleblaster.libembosser.drivers.utils.document.events.EndSectionEvent;
import org.brailleblaster.libembosser.drivers.utils.document.events.EndVolumeEvent;
import org.brailleblaster.libembosser.drivers.utils.document.events.LinesPerPage;
import org.brailleblaster.libembosser.drivers.utils.document.events.Option;
import org.brailleblaster.libembosser.drivers.utils.document.events.PageOption;
import org.brailleblaster.libembosser.drivers.utils.document.events.RowGap;
import org.brailleblaster.libembosser.drivers.utils.document.events.RowOption;
import org.brailleblaster.libembosser.drivers.utils.document.events.SectionOption;
import org.brailleblaster.libembosser.drivers.utils.document.events.StartDocumentEvent;
import org.brailleblaster.libembosser.drivers.utils.document.events.StartLineEvent;
import org.brailleblaster.libembosser.drivers.utils.document.events.StartPageEvent;
import org.brailleblaster.libembosser.drivers.utils.document.events.StartSectionEvent;
import org.brailleblaster.libembosser.drivers.utils.document.events.StartVolumeEvent;
import org.brailleblaster.libembosser.drivers.utils.document.events.VolumeOption;
import org.brailleblaster.libembosser.utils.BrailleMapper;

public class GenericTextDocumentHandler
implements ByteSourceHandlerToFunctionAdapter {
    private ByteArrayOutputStream output;
    private final int initialBufferCapacity;
    private final int maxCellsPerLine;
    private final int maxLinesPerPage;
    private final boolean defaultInterpoint;
    private final int defaultRowGap;
    private int leftMargin;
    private int topMargin;
    private int linesRemaining = 0;
    private final int copies;
    private int cellsPerLine;
    private int cellsRemaining = 0;
    private final Deque<Set<? extends Option>> optionStack = new LinkedList<Set<? extends Option>>();
    private final Deque<HandlerStates> stateStack = new LinkedList<HandlerStates>();
    private final byte[] newLineBytes;
    private byte[] newPageBytes;
    private final boolean eopOnFullPage;
    private final boolean bottomPadding;
    private int pendingLines;
    private boolean rightPage = true;
    private final ByteSource header;
    private final ByteSource footer;

    private static void throwInvalidStateException(DocumentEvent event, String state) {
        throw new IllegalStateException(String.format("Invalid event %s for state %s", event.getClass().getName(), state));
    }

    private GenericTextDocumentHandler(int leftMargin, int topMargin, int cellsPerLine, int linesPerPage, byte[] endOfLine, byte[] endOfPage, boolean eopOnFullPage, boolean bottomPadding, boolean interpoint, int copies, byte[] header, byte[] footer) {
        this.maxCellsPerLine = cellsPerLine;
        this.copies = copies;
        this.bottomPadding = bottomPadding;
        this.cellsPerLine = this.maxCellsPerLine;
        this.maxLinesPerPage = linesPerPage;
        this.defaultInterpoint = interpoint;
        this.defaultRowGap = 0;
        this.leftMargin = leftMargin;
        this.topMargin = topMargin;
        this.initialBufferCapacity = 1000000;
        this.output = new ByteArrayOutputStream(this.initialBufferCapacity);
        this.newLineBytes = endOfLine;
        this.newPageBytes = endOfPage;
        this.eopOnFullPage = eopOnFullPage;
        this.header = ByteSource.wrap((byte[])header);
        this.footer = ByteSource.wrap((byte[])footer);
    }

    @Override
    public void onEvent(DocumentEvent event) {
        HandlerStates state = this.stateStack.isEmpty() ? HandlerStates.READY : this.stateStack.peek();
        state.accept(this, event);
    }

    public void startDocument(Set<DocumentOption> options) {
        this.output.reset();
        this.optionStack.clear();
        this.optionStack.push(options);
        this.stateStack.push(HandlerStates.DOCUMENT);
        this.rightPage = true;
    }

    public void endDocument() {
        this.optionStack.pop();
        this.stateStack.pop();
    }

    public void startVolume(Set<VolumeOption> options) {
        this.optionStack.push(options);
        this.stateStack.push(HandlerStates.VOLUME);
    }

    public void endVolume() {
        this.optionStack.pop();
        this.stateStack.pop();
    }

    public void startSection(Set<SectionOption> options) {
        this.optionStack.push(options);
        this.stateStack.push(HandlerStates.SECTION);
        this.ensureRightPage();
    }

    private void ensureRightPage() {
        if (!this.rightPage && this.defaultInterpoint) {
            this.rightPage = !this.rightPage;
            this.write(this.newPageBytes);
        }
    }

    public void endSection() {
        this.ensureRightPage();
        this.optionStack.pop();
        this.stateStack.pop();
    }

    public void startPage(Set<PageOption> options) {
        this.optionStack.push(options);
        this.linesRemaining = Math.min(this.maxLinesPerPage, this.optionStack.stream().flatMap(Collection::stream).filter(o -> o instanceof LinesPerPage).findFirst().map(o -> (Integer)((LinesPerPage)o).getValue()).orElse(this.maxLinesPerPage) - 1);
        this.cellsPerLine = Math.min(this.maxCellsPerLine, this.optionStack.stream().flatMap(Collection::stream).filter(o -> o instanceof CellsPerLine).findFirst().map(o -> (Integer)((CellsPerLine)o).getValue()).orElse(this.maxCellsPerLine));
        this.pendingLines = this.topMargin;
        this.stateStack.push(HandlerStates.PAGE);
        if (this.defaultInterpoint && !this.rightPage && this.optionStack.stream().flatMap(Collection::stream).filter(o -> o instanceof Duplex).anyMatch(o -> (Boolean)((Duplex)o).getValue() == false)) {
            this.write(this.newPageBytes);
            this.rightPage = !this.rightPage;
        }
    }

    public void endPage() {
        boolean pageNotFull;
        this.pendingLines += Math.max(this.linesRemaining, 0);
        boolean bl = pageNotFull = this.pendingLines > 0;
        if (this.bottomPadding && pageNotFull) {
            this.write(this.repeatedBytes(this.newLineBytes, this.pendingLines));
        }
        if (this.eopOnFullPage || pageNotFull) {
            this.write(this.newPageBytes);
        } else {
            this.write(this.newLineBytes);
        }
        this.rightPage = !this.rightPage;
        this.optionStack.pop();
        this.stateStack.pop();
    }

    private byte[] repeatedBytes(byte[] inBytes, int count) {
        byte[] buf = new byte[count * inBytes.length];
        for (int i = 0; i < buf.length; i += this.newLineBytes.length) {
            System.arraycopy(inBytes, 0, buf, i, inBytes.length);
        }
        return buf;
    }

    public void startLine(Set<RowOption> options) {
        this.optionStack.push(options);
        if (this.pendingLines > 0) {
            this.write(this.repeatedBytes(this.newLineBytes, this.pendingLines));
        }
        this.pendingLines = 0;
        if (this.leftMargin > 0) {
            byte[] margin = new byte[this.leftMargin];
            Arrays.fill(margin, (byte)32);
            this.write(margin);
        }
        this.cellsRemaining = this.cellsPerLine;
        this.stateStack.push(HandlerStates.LINE);
    }

    public void endLine() {
        int rowGap = this.optionStack.stream().flatMap(Collection::stream).filter(o -> o instanceof RowGap).findFirst().map(o -> (Integer)((RowGap)o).getValue()).orElse(this.defaultRowGap) + 1;
        this.pendingLines = Math.min(this.linesRemaining, rowGap);
        this.linesRemaining -= rowGap;
        this.optionStack.pop();
        this.stateStack.pop();
    }

    public void writeBraille(String braille) {
        if (this.linesRemaining >= 0) {
            String asciiBraille = BrailleMapper.UNICODE_TO_ASCII_FAST.map(braille.substring(0, Math.min(braille.length(), this.cellsRemaining)));
            this.write(asciiBraille.getBytes(Charsets.UTF_8));
            this.cellsRemaining -= asciiBraille.length();
        }
    }

    private void write(byte[] bytes) {
        this.output.write(bytes, 0, bytes.length);
    }

    @Override
    public ByteSource asByteSource() {
        byte[] outputBytes = this.output.toByteArray();
        ArrayList<ByteSource> sources = new ArrayList<ByteSource>(this.copies + 2);
        sources.add(this.header);
        for (int i = 0; i < this.copies; ++i) {
            sources.add(ByteSource.wrap((byte[])outputBytes));
        }
        sources.add(this.footer);
        return ByteSource.concat(sources);
    }

    public static final class Builder {
        private int cellsPerLine = 40;
        private int linesPerPage = 25;
        private boolean interpoint = false;
        private int leftMargin = 0;
        private int topMargin = 0;
        private int copies = 1;
        private byte[] endOfLine = new byte[]{13, 10};
        private byte[] endOfPage = new byte[]{12};
        private boolean padWithBlanks = false;
        private boolean eopOnFullPage = true;
        private byte[] header = new byte[0];
        private byte[] footer = new byte[0];

        public Builder setHeader(byte[] header) {
            Preconditions.checkNotNull((Object)header);
            this.header = Arrays.copyOf(header, header.length);
            return this;
        }

        public byte[] getHeader() {
            return Arrays.copyOf(this.header, this.header.length);
        }

        public Builder setFooter(byte[] footer) {
            Preconditions.checkNotNull((Object)footer);
            this.footer = Arrays.copyOf(footer, footer.length);
            return this;
        }

        public byte[] getfooter() {
            return Arrays.copyOf(this.footer, this.footer.length);
        }

        public Builder setEndOfLine(byte[] eol) {
            Preconditions.checkNotNull((Object)eol);
            this.endOfLine = Arrays.copyOf(eol, eol.length);
            return this;
        }

        public Builder setEndOfPage(byte[] endOfPage) {
            Preconditions.checkNotNull((Object)endOfPage);
            this.endOfPage = Arrays.copyOf(endOfPage, endOfPage.length);
            return this;
        }

        public Builder setEopOnFullPage(boolean eopOnFull) {
            this.eopOnFullPage = eopOnFull;
            return this;
        }

        public Builder padWithBlankLines(boolean pad) {
            this.padWithBlanks = pad;
            return this;
        }

        public Builder setCopies(int copies) {
            this.copies = copies;
            return this;
        }

        public Builder setCellsPerLine(int cellsPerLine) {
            this.cellsPerLine = cellsPerLine;
            return this;
        }

        public Builder setLinesPerPage(int linesPerPage) {
            this.linesPerPage = linesPerPage;
            return this;
        }

        public Builder setInterpoint(boolean interpoint) {
            this.interpoint = interpoint;
            return this;
        }

        public Builder setLeftMargin(int leftMargin) {
            this.leftMargin = leftMargin;
            return this;
        }

        public Builder setTopMargin(int topMargin) {
            this.topMargin = topMargin;
            return this;
        }

        public GenericTextDocumentHandler build() {
            return new GenericTextDocumentHandler(this.leftMargin, this.topMargin, this.cellsPerLine, this.linesPerPage, this.endOfLine, this.endOfPage, this.eopOnFullPage, this.padWithBlanks, this.interpoint, this.copies, this.header, this.footer);
        }
    }

    private static enum HandlerStates {
        READY{

            @Override
            public void accept(GenericTextDocumentHandler h, DocumentEvent e) {
                if (e instanceof StartDocumentEvent) {
                    h.startDocument(((StartDocumentEvent)e).getOptions());
                } else {
                    GenericTextDocumentHandler.throwInvalidStateException(e, "READY");
                }
            }
        }
        ,
        DOCUMENT{

            @Override
            public void accept(GenericTextDocumentHandler h, DocumentEvent e) {
                if (e instanceof StartVolumeEvent) {
                    h.startVolume(((StartVolumeEvent)e).getOptions());
                } else if (e instanceof EndDocumentEvent) {
                    h.endDocument();
                } else {
                    GenericTextDocumentHandler.throwInvalidStateException(e, "DOCUMENT");
                }
            }
        }
        ,
        VOLUME{

            @Override
            public void accept(GenericTextDocumentHandler h, DocumentEvent e) {
                if (e instanceof StartSectionEvent) {
                    h.startSection(((StartSectionEvent)e).getOptions());
                } else if (e instanceof EndVolumeEvent) {
                    h.endVolume();
                } else {
                    GenericTextDocumentHandler.throwInvalidStateException(e, "VOLUME");
                }
            }
        }
        ,
        SECTION{
            private ImmutableList<Class<?>> invalidEventTypes = ImmutableList.of(StartDocumentEvent.class, StartVolumeEvent.class, StartSectionEvent.class, StartLineEvent.class, BrailleEvent.class, EndLineEvent.class, EndPageEvent.class, EndVolumeEvent.class, EndDocumentEvent.class);

            @Override
            public void accept(GenericTextDocumentHandler h, DocumentEvent e) {
                if (e instanceof StartPageEvent) {
                    h.startPage(((StartPageEvent)e).getOptions());
                } else if (e instanceof EndSectionEvent) {
                    h.endSection();
                } else if (ClassUtils.isInstanceOf((Object)e, this.invalidEventTypes.stream())) {
                    GenericTextDocumentHandler.throwInvalidStateException(e, "SECTION");
                }
            }
        }
        ,
        PAGE{
            ImmutableList<Class<?>> invalidEventTypes = ImmutableList.of(StartDocumentEvent.class, StartVolumeEvent.class, StartSectionEvent.class, StartPageEvent.class, BrailleEvent.class, EndLineEvent.class, EndSectionEvent.class, EndVolumeEvent.class, EndDocumentEvent.class);

            @Override
            public void accept(GenericTextDocumentHandler h, DocumentEvent e) {
                if (e instanceof StartLineEvent) {
                    h.startLine(((StartLineEvent)e).getOptions());
                } else if (e instanceof EndPageEvent) {
                    h.endPage();
                } else if (ClassUtils.isInstanceOf((Object)e, this.invalidEventTypes.stream())) {
                    GenericTextDocumentHandler.throwInvalidStateException(e, "PAGE");
                }
            }
        }
        ,
        LINE{

            @Override
            public void accept(GenericTextDocumentHandler h, DocumentEvent e) {
                if (e instanceof BrailleEvent) {
                    h.writeBraille(((BrailleEvent)e).getBraille());
                } else if (e instanceof EndLineEvent) {
                    h.endLine();
                } else {
                    GenericTextDocumentHandler.throwInvalidStateException(e, "LINE");
                }
            }
        };


        public abstract void accept(GenericTextDocumentHandler var1, DocumentEvent var2);
    }
}

