/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.libembosser.drivers.utils.document.filters;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.function.Function;
import org.brailleblaster.libembosser.drivers.utils.document.events.DocumentEvent;
import org.brailleblaster.libembosser.drivers.utils.document.events.EndPageEvent;
import org.brailleblaster.libembosser.drivers.utils.document.events.StartDocumentEvent;
import org.brailleblaster.libembosser.drivers.utils.document.events.StartPageEvent;
import org.brailleblaster.libembosser.embossing.attribute.PageRanges;

public class PageFilter
implements Function<Iterator<DocumentEvent>, Iterator<DocumentEvent>> {
    private PageRanges pages;
    private int page = 0;
    private boolean passOnEvents = true;

    public PageFilter(PageRanges pages) {
        this.pages = (PageRanges)Preconditions.checkNotNull((Object)pages);
    }

    boolean retainEvent(DocumentEvent event) {
        if (event instanceof StartDocumentEvent) {
            this.page = 1;
            this.passOnEvents = true;
        } else if (event instanceof StartPageEvent) {
            this.passOnEvents = this.pages.contains(this.page);
        }
        boolean result = this.passOnEvents;
        if (event instanceof EndPageEvent) {
            this.passOnEvents = true;
            ++this.page;
        }
        return result;
    }

    @Override
    public Iterator<DocumentEvent> apply(Iterator<DocumentEvent> doc) {
        return Iterators.filter(doc, this::retainEvent);
    }
}

