/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.libembosser.drivers.braillo;

import com.google.common.io.ByteSource;
import org.brailleblaster.libembosser.drivers.utils.document.ByteSourceHandlerToFunctionAdapter;
import org.brailleblaster.libembosser.drivers.utils.document.GenericTextDocumentHandler;
import org.brailleblaster.libembosser.drivers.utils.document.events.DocumentEvent;

public abstract class AbstractBrailloDocumentHandler
implements ByteSourceHandlerToFunctionAdapter {
    private GenericTextDocumentHandler handler;

    protected AbstractBrailloDocumentHandler(int cellsPerLine, double sheetLength, int topMargin, int bottomMargin, int leftMargin, int rightMargin, boolean interpoint, int copies) {
        int linesPerPage = (int)Math.floor(sheetLength * 2.54);
        this.handler = new GenericTextDocumentHandler.Builder().setTopMargin(topMargin).setLeftMargin(leftMargin).setCellsPerLine(cellsPerLine - leftMargin - rightMargin).setLinesPerPage(linesPerPage - topMargin - bottomMargin).setEndOfPage(new byte[]{13, 10, 12}).setInterpoint(interpoint).setCopies(copies).build();
    }

    protected abstract ByteSource getHeader();

    public void onEvent(DocumentEvent event) {
        this.handler.onEvent(event);
    }

    public ByteSource asByteSource() {
        return ByteSource.concat((ByteSource[])new ByteSource[]{this.getHeader(), this.handler.asByteSource()});
    }
}

