/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.utils;

import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CharIterator;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u000e\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/brailleblaster/utils/ByteStringEncoding;", "", "<init>", "()V", "BACK_SLASH", "", "LF", "CR", "FF", "TAB", "HEX_CHARS", "", "decode", "", "chars", "", "parseEscapeSequence", "", "iter", "Lkotlin/collections/CharIterator;", "parseHexByte", "encode", "bytes", "utils"})
public final class ByteStringEncoding {
    @NotNull
    public static final ByteStringEncoding INSTANCE = new ByteStringEncoding();
    private static final byte BACK_SLASH = 92;
    private static final byte LF = 10;
    private static final byte CR = 13;
    private static final byte FF = 12;
    private static final byte TAB = 9;
    @NotNull
    private static final String HEX_CHARS = "0123456789abcdef";

    private ByteStringEncoding() {
    }

    @NotNull
    public final byte[] decode(@NotNull CharSequence chars) {
        Intrinsics.checkNotNullParameter((Object)chars, (String)"chars");
        CharIterator iter = StringsKt.iterator((CharSequence)chars);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(chars.length() * 4);
        while (iter.hasNext()) {
            int n;
            char c = iter.nextChar();
            if (c == '\\') {
                n = this.parseEscapeSequence(iter);
            } else {
                boolean bl = '\u0000' <= c ? c < '\u0100' : false;
                if (bl) {
                    n = c;
                } else {
                    throw new IllegalArgumentException("Input contains invalid byte " + c);
                }
            }
            int b = n;
            buffer.write(b);
        }
        byte[] byArray = buffer.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        return byArray;
    }

    private final int parseEscapeSequence(CharIterator iter) {
        Number number;
        if (iter.hasNext()) {
            char escapeLetter = iter.nextChar();
            switch (escapeLetter) {
                case '\\': {
                    number = (byte)92;
                    break;
                }
                case 'f': {
                    number = (byte)12;
                    break;
                }
                case 't': {
                    number = (byte)9;
                    break;
                }
                case 'r': {
                    number = (byte)13;
                    break;
                }
                case 'n': {
                    number = (byte)10;
                    break;
                }
                case 'x': {
                    number = this.parseHexByte(iter);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid escape sequence found \\" + escapeLetter);
                }
            }
        } else {
            throw new IllegalArgumentException("Escape char \\ must be followed by a character");
        }
        return ((Number)number).intValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final int parseHexByte(CharIterator iter) {
        int hexValue = 0;
        int i = 4;
        int n = ProgressionUtilKt.getProgressionLastElement((int)4, (int)0, (int)-4);
        if (n > i) return hexValue;
        while (iter.hasNext()) {
            char hc = iter.nextChar();
            int v = StringsKt.indexOf$default((CharSequence)HEX_CHARS, (char)hc, (int)0, (boolean)false, (int)6, null);
            if (v < 0) throw new IllegalArgumentException("Character " + hc + " is not a hex character.");
            hexValue += v << i;
            if (i == n) return hexValue;
            i -= 4;
        }
        throw new IllegalArgumentException("Not enough characters for hex escape sequence");
    }

    @NotNull
    public final String encode(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        return ArraysKt.joinToString$default((byte[])bytes, (CharSequence)"", null, null, (int)0, null, ByteStringEncoding::encode$lambda$0, (int)30, null);
    }

    private static final CharSequence encode$lambda$0(byte b) {
        CharSequence charSequence;
        byte by = b;
        if (by == 92) {
            charSequence = "\\\\";
        } else if (by == 10) {
            charSequence = "\\n";
        } else if (by == 13) {
            charSequence = "\\r";
        } else if (by == 12) {
            charSequence = "\\f";
        } else if (by == 9) {
            charSequence = "\\t";
        } else {
            byte by2 = by;
            boolean bl = 32 <= by2 ? by2 < 127 : false;
            if (bl) {
                by2 = b;
                if (by2 < 0 || by2 > 65535) {
                    throw new IllegalArgumentException("Invalid Char code: " + by2);
                }
                charSequence = String.valueOf((char)by2);
            } else {
                String string = "\\x%02x";
                Object[] objectArray = new Object[]{b};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                charSequence = string2;
            }
        }
        return charSequence;
    }
}

