/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.utils;

import java.util.Locale;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.brailleblaster.utils.Architecture;
import org.brailleblaster.utils.OS;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\"\u001b\u0010\u0000\u001a\u00020\u00018FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0002\u0010\u0003\"\u001b\u0010\u0006\u001a\u00020\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u0005\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000b"}, d2={"os", "Lorg/brailleblaster/utils/OS;", "getOs", "()Lorg/brailleblaster/utils/OS;", "os$delegate", "Lkotlin/Lazy;", "arch", "Lorg/brailleblaster/utils/Architecture;", "getArch", "()Lorg/brailleblaster/utils/Architecture;", "arch$delegate", "utils"})
@JvmName(name="Platform")
public final class Platform {
    @NotNull
    private static final Lazy os$delegate = LazyKt.lazy(Platform::os_delegate$lambda$0);
    @NotNull
    private static final Lazy arch$delegate = LazyKt.lazy(Platform::arch_delegate$lambda$0);

    @NotNull
    public static final OS getOs() {
        Lazy lazy = os$delegate;
        return (OS)((Object)lazy.getValue());
    }

    @NotNull
    public static final Architecture getArch() {
        Lazy lazy = arch$delegate;
        return (Architecture)((Object)lazy.getValue());
    }

    private static final OS os_delegate$lambda$0() {
        String osName = System.getProperty("os.name");
        Intrinsics.checkNotNull((Object)osName);
        return StringsKt.startsWith((String)osName, (String)"Windows CE", (boolean)true) ? OS.WindowsCE : (StringsKt.startsWith((String)osName, (String)"Windows", (boolean)true) ? OS.Windows : (StringsKt.startsWith((String)osName, (String)"Mac", (boolean)true) || StringsKt.startsWith((String)osName, (String)"Darwin", (boolean)true) ? OS.Mac : (StringsKt.startsWith((String)osName, (String)"Linux", (boolean)true) ? (StringsKt.equals((String)"dalvik", (String)System.getProperty("java.vm.name"), (boolean)true) ? OS.Android : OS.Linux) : OS.Unknown)));
    }

    private static final Architecture arch_delegate$lambda$0() {
        String string = System.getProperty("os.arch");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String arch = string2;
        return Intrinsics.areEqual((Object)arch, (Object)"x86-64") || Intrinsics.areEqual((Object)arch, (Object)"x86_64") || Intrinsics.areEqual((Object)arch, (Object)"amd64") ? Architecture.X86_64 : (Intrinsics.areEqual((Object)arch, (Object)"x86") ? Architecture.X86 : (Intrinsics.areEqual((Object)arch, (Object)"aarch64") ? Architecture.AArch64 : (StringsKt.startsWith$default((String)arch, (String)"ARM", (boolean)false, (int)2, null) ? Architecture.ARM : Architecture.Unknown)));
    }
}

