/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.utils;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import java.util.function.BiFunction;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0010\n\u0002\b\u000b\b\u0016\u0018\u0000 &2\u00020\u0001:\u0001&B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0006\u0010\nJ\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\tJ\u0016\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0014J\u0016\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0016J,\u0010\u0017\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0012\u001a\u00020\u00162\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00160\u0019J+\u0010\u001a\u001a\u00020\u0010\"\u000e\b\u0000\u0010\u001b*\b\u0012\u0004\u0012\u0002H\u001b0\u001c2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u0002H\u001b\u00a2\u0006\u0002\u0010\u001dJ\u0010\u0010\u001e\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0011\u001a\u00020\tJ\u0016\u0010\u001e\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\tJ\u0016\u0010 \u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\u0016J\u0016\u0010!\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\u0014J*\u0010\"\u001a\u0004\u0018\u0001H\u001b\"\u0010\b\u0000\u0010\u001b\u0018\u0001*\b\u0012\u0004\u0012\u0002H\u001b0\u001c2\u0006\u0010\u0011\u001a\u00020\tH\u0086\b\u00a2\u0006\u0002\u0010#J\u0010\u0010$\u001a\u0004\u0018\u00010\t2\u0006\u0010%\u001a\u00020\tJ\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006'"}, d2={"Lorg/brailleblaster/utils/PropertyFileManager;", "", "file", "Ljava/io/File;", "prop", "Ljava/util/Properties;", "<init>", "(Ljava/io/File;Ljava/util/Properties;)V", "filePath", "", "(Ljava/lang/String;)V", "getFile", "()Ljava/io/File;", "getProp", "()Ljava/util/Properties;", "save", "", "property", "value", "saveAsInt", "", "saveAsBoolean", "", "saveAsBooleanCompute", "remappingFunction", "Ljava/util/function/Function;", "saveAsEnum", "E", "", "(Ljava/lang/String;Ljava/lang/Enum;)V", "getProperty", "defaultValue", "getPropertyAsBoolean", "getPropertyAsInt", "getPropertyAsEnumOrNull", "(Ljava/lang/String;)Ljava/lang/Enum;", "removeProperty", "key", "Companion", "utils"})
@SourceDebugExtension(value={"SMAP\nPropertyFileManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PropertyFileManager.kt\norg/brailleblaster/utils/PropertyFileManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,107:1\n1#2:108\n*E\n"})
public class PropertyFileManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File file;
    @NotNull
    private final Properties prop;
    @NotNull
    private static final Logger log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyFileManager(@NotNull File file, @NotNull Properties prop) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)prop, (String)"prop");
        this.file = file;
        this.prop = prop;
        if (this.file.canRead()) {
            Closeable closeable = new FileInputStream(this.file);
            Throwable throwable = null;
            try {
                FileInputStream it = (FileInputStream)closeable;
                boolean bl = false;
                try {
                    this.prop.load(it);
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to load " + this.file.getAbsolutePath(), e);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
    }

    public /* synthetic */ PropertyFileManager(File file, Properties properties, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            properties = new Properties();
        }
        this(file, properties);
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    @NotNull
    public final Properties getProp() {
        return this.prop;
    }

    public PropertyFileManager(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        this(new File(filePath), null, 2, null);
    }

    public final void save(@NotNull String property, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        log.info("Setting {} to {}", (Object)property, (Object)value);
        this.prop.setProperty(property, value);
        this.save();
    }

    public final void saveAsInt(@NotNull String property, int value) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        this.save(property, String.valueOf(value));
    }

    public final void saveAsBoolean(@NotNull String property, boolean value) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        this.save(property, String.valueOf(value));
    }

    public final void saveAsBooleanCompute(@Nullable String property, boolean value, @NotNull Function<Boolean, Boolean> remappingFunction) {
        Intrinsics.checkNotNullParameter(remappingFunction, (String)"remappingFunction");
        this.prop.merge(property, String.valueOf(value), (BiFunction<? super Object, ? super Object, ?>)((BiFunction<Object, Object, Object>)(arg_0, arg_1) -> PropertyFileManager.saveAsBooleanCompute$lambda$1((arg_0, arg_1) -> PropertyFileManager.saveAsBooleanCompute$lambda$0(remappingFunction, arg_0, arg_1), arg_0, arg_1)));
        log.info("Setting {} to {}", (Object)property, this.prop.get(property));
        this.save();
    }

    public final <E extends Enum<E>> void saveAsEnum(@NotNull String property, @NotNull E value) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.save(property, value.toString());
    }

    @Nullable
    public final String getProperty(@NotNull String property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        return this.prop.getProperty(property);
    }

    @NotNull
    public final String getProperty(@NotNull String property, @NotNull String defaultValue) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter((Object)defaultValue, (String)"defaultValue");
        String string = this.prop.getProperty(property, defaultValue);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        return string;
    }

    public final boolean getPropertyAsBoolean(@NotNull String property, boolean defaultValue) {
        String value;
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        String string = value = this.getProperty(property);
        return string == null ? defaultValue : Boolean.parseBoolean(string);
    }

    public final int getPropertyAsInt(@NotNull String property, int defaultValue) {
        String value;
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        String string = value = this.getProperty(property);
        return string != null ? Integer.parseInt(string) : defaultValue;
    }

    public final /* synthetic */ <E extends Enum<E>> E getPropertyAsEnumOrNull(String property) {
        Enum enum_;
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        boolean $i$f$getPropertyAsEnumOrNull = false;
        String string = this.getProperty(property);
        if (string != null) {
            String it = string;
            boolean bl = false;
            String string2 = it;
            Intrinsics.reifiedOperationMarker((int)5, (String)"E");
            enum_ = (Enum)Enum.valueOf(null, string2);
        } else {
            enum_ = null;
        }
        return (E)enum_;
    }

    @Nullable
    public final String removeProperty(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        log.info("Removing {}", (Object)key);
        return (String)this.prop.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        Closeable closeable = new FileOutputStream(this.file);
        Throwable throwable = null;
        try {
            FileOutputStream it = (FileOutputStream)closeable;
            boolean bl = false;
            try {
                this.prop.store(it, null);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to save " + this.file.getAbsolutePath(), e);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private static final Object saveAsBooleanCompute$lambda$0(Function $remappingFunction, Object oldValueRaw, Object object) {
        Intrinsics.checkNotNullParameter((Object)oldValueRaw, (String)"oldValueRaw");
        Intrinsics.checkNotNullParameter((Object)object, (String)"<unused var>");
        boolean oldValue = Boolean.parseBoolean(oldValueRaw.toString());
        Object r = $remappingFunction.apply(oldValue);
        Intrinsics.checkNotNullExpressionValue(r, (String)"apply(...)");
        boolean expected = (Boolean)r;
        return String.valueOf(expected);
    }

    private static final Object saveAsBooleanCompute$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return $tmp0.invoke(p0, p1);
    }

    static {
        Logger logger = LoggerFactory.getLogger(PropertyFileManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        log = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/brailleblaster/utils/PropertyFileManager$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "utils"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

